% Create a bifacial convex GRIN lens with parallel/reshaped shells
% Expects
%	Nothing
% Creates
%	Nothing
% Clears
%	All
:RESTART
.new_text
This script will create a gradient index element in the form of
a bifacial convex lens.


Proceed?
.yes_no SKIP
.grid_snap 0
.enable_undo 1
.unselect_all
% Get parameters for the GRIN lens
% -----------------------------------------------------
% Define some variables
% -----------------------------------------------------
.=> CENTREX
.=> CENTREY
.=> R1
.=> R2
.=> HEIGHT
.=> CHORD
% -----------------------------------------------------
% First get design values
% -----------------------------------------------------
.enable_undo 0
.grid_snap 0
:NEWVALUES
% -----------------------------------------------------
% Get a height for the lens
% -----------------------------------------------------
.new_text
Enter the height of the lens aperture.

Values between 50 and 500 please.
.input_limits 50 500
.default_input 300
.userinput
./ 2
.=> HEIGHT
% -----------------------------------------------------
% Get the radii of curvature for the faces
% -----------------------------------------------------
.input_limits HEIGHT 10000
.default_input 200
.new_text
Enter the radius of curvature of the first (left side) surface.
.R1 userinput
.R1
.default_input
.new_text
Enter the radius of curvature of the second surface.


Enter a positive number - the surface will be convex automatically.
.userinput
.abs
.+/-
.=> R2
% -----------------------------------------------------
% Get a central thickness for the lens
% -----------------------------------------------------
.call findthck.rsc
.THICK
.=> MINTHICK
.new_text
Enter the central thickness of the lens.


The default value is the minimum allowed thickness for the lens.
.default_input 100
.input_limits THICK 500
.THICK userinput
% -----------------------------------------------------
% Get the user to choose a centre point
% -----------------------------------------------------
.new_text
Click where you want the lens centred.


Remember that you can use an absolute coordinate snap or
other snap to specify coordinates exactly by clicking on
the secondary mouse button and choosing from the popup menu.
.user_click
.CENTREX lastclick.x
.CENTREY lastclick.y
% -----------------------------------------------------
% Check the users values before proceeding
% -----------------------------------------------------
.new_text
You have entered the values:

    Lens centre coordinates:
.printf %5.2f CENTREX
,
.printf %5.2f CENTREY

    Radius of first surface:
.printf %5.2f R1

    Radius of second surface:
.printf %5.2f R2

    Lens thickness:
.printf %4.2f THICK

    Lens height:
.printf %4.2f HEIGHT


Ok? Click on No to go back and reenter the values.
.yes_no OKVALUES NEWVALUES
:OKVALUES
% Create the outer shape of the lens and check it is Ok.
.painting 0
.call mklens.rsc
.unselect_all
.painting 1
.new_text
The outer shape of the lens has been constructed. Is it Ok?


Click on no restart.
.yes_no SHAPEOK REMOVE
:REMOVE
.painting 0
.unselect_all
.select_object LENS
.delete
.painting 1
.goto RESTART
:SHAPEOK
% Get the distance to move the left and right edges for the
% parallel shells
.THICK
./ 10
.default_input
.new_text
Enter the distance to move the left surface for each shell.
.userinput
.abs
.=> MOVELEFT
.default_input MOVELEFT
.new_text
Enter the distance to move the right surface for each shell.
.userinput
.abs
.=> MOVERIGHT
% Now get the refractive index of the outer shell and the index increment
.input_limits 1 5
.default_input 1.3
.new_text
Enter the refractive index of the outer shell.
.userinput
.=> OUTINDEX
.input_limits 0.001 0.5
.default_input 0.05
.new_text
Enter the increment in refractive index for each shell.
.userinput
.+ 1
.=> INDEXINC
.painting 0
.select_object LENS
.refractive_index OUTINDEX OUTINDEX OUTINDEX
.unselect_all
.painting 1
.new_text
Creating shells. Please wait.
% Create the parallel shells
.1
.=> SHELLNUM
:PLLLOOP
.THICK
.- MOVELEFT
.- MOVERIGHT
.=> THICK
.THICK
.MOVELEFT
.- MOVERIGHT
./ 2
.+ CENTREX
.=> CENTREX
.THICK
.if< MINTHICK NOMOREPLL
.painting 0
.call mklens.rsc
.select_object LENS
.refractive_index INDEXINC INDEXINC INDEXINC
.unselect_all
.painting 1
.SHELLNUM
.+ 1
.=> SHELLNUM
.goto PLLLOOP
:NOMOREPLL
.new_text
Do you want to add more shells within the ones already made? If so
you will have to specify the radii of curvature to use for each shell
as they are created.
.yes_no DONE
:MORELOOP
.new_text
Enter the radius of curvature of the left surface of the next shell.
.R1
.* 2
.default_input
.userinput
.=> R1
.new_text
Enter the radius of curvature of the right surface of the next shell.
.R2
.abs
.* 2
.default_input
.userinput
.abs
.+/-
.=> R2
.new_text
Please wait.
.call findthck.rsc
.painting 0
.call mklens.rsc
.select_object LENS
.refractive_index INDEXINC INDEXINC INDEXINC
.unselect_all
.painting 1
.new_text
Is this shell Ok? Click on no to remove it and try again.
.yes_no DOMORE REMOVEIT
:REMOVEIT
.painting 0
.select_object LENS
.delete
.painting 1
:DOMORE
.new_text
Add another shell?
.yes_no MORELOOP DONE
:DONE
.unselect_all
.painting 1
.new_text
After this script exits you may wish to select all the shells and
group them using the Modify -- Element > Group menu item.
.pause
.enable_undo 1
.return
