% Create a gradient index lens with scaled shells
% Expects
%	Nothing
% Creates
%	Nothing
% Clears
%	All
.new_text
This script will create a gradient index element starting from
a region element that you select.


It is best if you zoom in on the element of interest before using
this script. It is also best if you use this script before you add
rays to your diagram.


Proceed?
.yes_no SKIP
.grid_snap 0
.enable_undo 1
:GETREGION
.new_text
Select a region element now by clicking on its outline.


You will obtain best results from this script if you click on a
point on the region which will not be close to the edges of any
of the inner shells.
.unselect_all
.user_click
% Remember where to click to select the region.
.lastclick.x
.=> HITX
.lastclick.y
.=> HITY
.selected_element
.=> REGION
.if!= -1 CHECK2
:NOTREGION
.new_text
You have not selected a region element. Do you want to try again?


If you click on no then the script will exit.
.yes_no GETREGION SKIP
:CHECK2
.object_type REGION
.if!= 1 NOTREGION
.unselect_object REGION
.selected_element
.if== -1 ONLYONE
.new_text
You have selected more than one element. Please try again and click
at a point which only selects the element you require.
.pause
.goto GETREGION
:ONLYONE
% Now have the handle of a region. Compute the "centre"
.segment_count REGION
.+ 1
.=> SEGS
.=> COUNTER
.0
.=> CENX
.=> CENY
.1
.=> SEG
.new_text
Locating scaling centre. Please wait.
:SEGLOOP
.object_coordinates REGION SEG end
.CENX
.+ X
.=> CENX
.CENY
.+ Y
.=> CENY
.SEG
.+ 1
.=> SEG
.--if!=0 COUNTER SEGLOOP
.CENX
./ SEGS
.=> CENX
.CENY
./ SEGS
.=> CENY
% Mark the centre and ask the user to decide if it is OK
.annotation "Centre"
.fc CENX CENY
.fcr 20 20
.=> CENANN
% Don't want undo from here on in
.enable_undo 0
.new_text
The "centre" of the region has been located as shown. The GRIN region
will be created by scaling the selected region about this point.


Is this point Ok? Click on no to select the scaling centre yourself.
.yes_no CHOOSECEN
:GOTCEN
.painting 0
.unselect_all
.select_object CENANN
.delete
% Get the number of shells to use
.input_limits 2 10
.default_input 5
.new_text
Enter the number of shells to use in the GRIN region.

(Minimum of 2, maximum of 10)
.userinput
.=> SHELLS
% Now get the refractive indices of the outer shell and the inner shell.
.input_limits 1 5
.default_input 1.3
.new_text
Enter the refractive index of the outer shell.
.userinput
.=> OUTINDEX
.default_input 1.5
.new_text
Enter the refractive index of the inner shell.
.userinput
.=> ININDEX
% Calculate the index step at each shell
.SHELLS
.- 1
.=> COUNTER
.ININDEX
.- OUTINDEX
./ COUNTER
% Raytrace subtracts 1 when accumulating refractive indices so add it here
.+ 1
.=> INDEXSTEP
% Set the index of the existing element
.unselect_all
.select_object REGION
.refractive_index OUTINDEX OUTINDEX OUTINDEX
% Calculate the change in scale factor between shells and the first
% scale factor
.SHELLS
.1/
.=> SCALESTEP
.1
.- SCALESTEP
.=> SCALEBY
% Create the scaled shells
% Take a copy of the selected region
.copy
.fc 0 0
.1
.=> SHELLNUM
:SHELLLOOP
% Scale the existing region and set its refractive index to step
.new_text
Creating shell number
.printf %g SHELLNUM


Please wait.
.scale SCALEBY
.fc CENX CENY
.refractive_index INDEXSTEP INDEXSTEP INDEXSTEP
% Paste back a copy of original an reselect it
.unselect_all
.paste
.fc 0 0
.fc HITX HITY
.call onlyelem.rsc
.SCALEBY
.- SCALESTEP
.=> SCALEBY
.SHELLNUM
.+ 1
.=> SHELLNUM
.--if!=0 COUNTER SHELLLOOP
.unselect_all
.painting 1
.new_text
The GRIN region has been created. Is it as you expected?


If you click on no then the diagram will be returned to its
original state and the script will exit.
.yes_no OK UNDOIT
:UNDOIT
.undo
:OK
.new_text
After this script exits you may wish to select all the shells and
group them using the Modify -- Element > Group menu item.
.pause
.enable_undo 1
.return
% Let the user choose the centre point
:CHOOSECEN
.new_text
Click now where you want the scaling centre to be located.
.user_click
.CENX lastclick.x
.CENY lastclick.y
.goto GOTCEN
:SKIP
.return
