% Script routine that finds the radii of a lens given its focal
% length and shape factor
% Expects variables
% 	FLEN       containing desired focal length
%   RINDEX     containing the refractive index
%   SHAPEFACT  has the desired shape factor
% Creates variables
%   R1  radius of first surface (on the left)
%   R2  radius of the second surface (on the right)
%   Sign convention for radii applies
% Uses and clears
%   TEMP
.SHAPEFACT
.if== -1 R1INF
.if== 1 R2INF
.SHAPEFACT
.+ 1
.=> TEMP
.RINDEX
.- 1
.* FLEN
.* 2
./ TEMP
.=> R1
.SHAPEFACT
.- 1
.=> TEMP
.SHAPEFACT
.+ 1
.* R1
./ TEMP
.=> R2
.clear_var TEMP
.return
:R1INF
.0
.=> R1
.1
.- RINDEX
.* FLEN
.=> R2
.return
:R2INF
.0
.=> R2
.RINDEX
.- 1
.* FLEN
.=> R1
.return
