% This script shows how chromatic aberration can be reduced using
% a doublet lens
.new_text
This script shows how chromatic aberration can be reduced using
a doublet lens.


Do you want to proceed?
.yes_no SKIP
.file_new
.enable_undo 0
.quiet_snap 1
.grid_snap 0
.new_text
Please wait while the ray diagram is constructed
.painting 0
.refractive_index 1.4 1.6 1.8
.create_region
.arcseg
.chord_tan
.fc 0 60
.fc 0 -60
.fc 60 -60
.fc 0 60
.fc -40 60
.end_element
.create_region
.=> LENS1
.fc 100 60
.fc 80 60
.arcseg
.fc 80 -60
.fc 140 -60
.lineseg
.fc 100 -60
.end_element
.=> LENS2
.link_move
.link_segments
.object_coordinates LENS1 1 middle
.fc X Y
.object_coordinates LENS2 2 middle
.fc X Y
% Create the white rays striking the doublet
.20
.=> HEIGHT
.source_ray_count 3
.plane_source
.fc -120 HEIGHT
.fc -40 HEIGHT
.fc -40 HEIGHT
.=> SRC1
.HEIGHT
.+/-
.=> HEIGHT
.plane_source
.fc -120 HEIGHT
.fc -40 HEIGHT
.fc -40 HEIGHT
.=> SRC2
% Select the source rays
.fc -100 HEIGHT
.HEIGHT
.+/-
.=> HEIGHT
.control_key 1
.fc -100 HEIGHT
.control_key 0
.white_ray
.unselect_all
.painting 1
.zoom_in
.fc -120 195
.fc 520 -230
.new_text
Here you see a cemented doublet lens. At the moment both lenses have
the same refractive indices so there is no change in the ray direction
at the intermediate boundary.


The dispersive power of these lenses has been exagerated to make the
the longitudinal chromatic aberration clearly visible.
.pause
.painting 0
.ray_of_source SRC1 0
.=> RAY
.child_by RAY refraction refraction refraction
.=> RRAY1
.ray_of_source SRC1 2
.=> RAY
.child_by RAY refraction refraction refraction
.=> BRAY1
.ray_of_source SRC2 0
.=> RAY
.child_by RAY refraction refraction refraction
.=> RRAY2
.ray_of_source SRC2 2
.=> RAY
.child_by RAY refraction refraction refraction
.=> BRAY2
.unselect_all
.tapemeasure
.select_object BRAY1 BRAY2
.intersect_snap
.control_key 1
.fc 1e5 1e5
.control_key 0
.unselect_all
.select_object RRAY1 RRAY2
.intersect_snap
.control_key 1
.fc 1e5 1e5
.=> TAPE
.control_key 0
.select_object TAPE
.tapemeasure_options 2 1 leader distance
.object_coordinates TAPE lead_to
.fc X Y
.object_coordinates TAPE middle
.Y
.+ 50
.=> Y
.fc X Y
.unselect_all
.painting 1
.new_text
A tape measure has now been added to show the distance between the focal
point for red and blue rays.
.pause
.new_text
If both lenses were made from a real glass such as a light flint then
the chromatic aberration would be small but still present.
.painting 0
.select_object LENS1 LENS2
.material light flint
.unselect_all
.painting 1
.pause
.new_text
To reduce the chromatic aberration between the two colours red and blue
the doublet must be made from two different types of glass.


The second section of the lens will now be changed to heaviest flint
glass. Because the second lens is diverging and heaviest flint has a
relatively high refractive index, this will greatly reduce the
power of the lens.
.pause
.painting 0
.select_object LENS2
.material heaviest flint
.unselect_all
.painting 1
.new_text
By changing the radius of curvature of the interface between the two
sections of the doublet lens the chromatic aberration can be
reduced to zero (for the red and blue wavelengths).
.pause
.new_text
Drag the mouse now to see how changing the radius affects the
chromatic aberration and see if you can find a minimum.
.select_object LENS1
.object_coordinates LENS1 1 tangent
.fc X Y
.mouse_limits -17 -175 88 -85
.fast_move 19 -90 
.allow_drag
.new_text
The red-blue longitudinal chromatic aberration is very close to zero
when the lens is shaped as
shown now.
.fast_move 73.769381 -349.570684
.fc 73.769381 -349.570684
.unselect_all
.pause
.new_text
That's all for this script.
.pause
.new_text
.enable_undo 1
.quiet_snap 0
:SKIP
.return
