% Demonstrate "bending" a lens to minimise spherical aberration
% -------------------------------------------------------------
% Define some parameters
.clear_var
.zoom_reset
.400
.=> FLEN
.1.5
.=> RINDEX
.0
.=> SHAPEFACT
.150
.=> HEIGHT
.-150
.=> CENTREX
.0
.=> CENTREY
.6
.=> SRCCOUNT
.grid_snap 0
% -------------------------------------------------------------
% Get the radii of curvature of the surfaces
.call findrad.rsc
.call findthck.rsc
.file_new
.enable_undo 0
.quiet_snap 1
.new_text
This script demonstrates how the radii of curvature of a lens can
be chosen to minimise spherical aberrations. You should look up the
definition of the "Shape factor" for a thin lens before proceeding.


Do you wish to continue?
.yes_no DOIT END
:DOIT
.new_text
Please wait while the script constructs the ray diagram.
% -------------------------------------------------------------
% Turn off painting to speed setup
.painting 0
% -------------------------------------------------------------
% Create the initial lens and set it to have no chromatic ab
.call mklens.rsc
.select_object LENS
.refractive_index RINDEX RINDEX RINDEX
.unselect_all
% -------------------------------------------------------------
% Create a plane source to show aberration
.reflect_if_no_refract 0
.reflect 0
.childray_fertility
.arrow_none
.childray_arrow
.arrow_middle
.source_ray_count SRCCOUNT
.HEIGHT
./ 2
.+ CENTREY
.=> TEMPY
.CENTREX
.- 200
.=> TEMPX
.plane_source
.fast_click TEMPX TEMPY
.object_coordinates LENS 0 end
.end_snap
.fast_click X Y
.object_coordinates LENS 1 end
.end_snap
.fast_click X Y
.=> SOURCE
% ------------------------------------------------------------
% Create a tape measure to show the aberration size
.recalc 0
.ray_of_source SOURCE 0
.=> TOPRAY
.child_by TOPRAY refraction refraction
.=> TOPRAYT
.ray_of_source SOURCE 5
.=> BOTRAY
.child_by BOTRAY refraction refraction
.=> BOTRAYT
.ray_of_source SOURCE 2
.=> TMRAY
.child_by TMRAY refraction refraction
.=> TMRAYT
.ray_of_source SOURCE 3
.=> BMRAY
.child_by BMRAY refraction refraction
.=> BMRAYT
.unselect_all
.tapemeasure
.intersect_snap
.select_object TOPRAYT BOTRAYT
.control_key 1
.fast_click -100 -200
.unselect_all
.intersect_snap
.select_object TMRAYT BMRAYT
.fast_click -100 -200
.=> TMEAS1
.control_key 0
.unselect_all
.select_object TMEAS1
.tapemeasure_options 2 0 leader distance
.object_coordinates TMEAS1 lead_to
.fast_click X Y
.fast_click_rel -20 50
.unselect_all
% --------------------------------------------------------------
% Create a tape measure that indicates the principle plane of interest
.tapemeasure
.intersect_snap
.select_object TMRAY TMRAYT
.control_key 1
.fast_click -1000 -1000
.unselect_all
.intersect_snap
.select_object BMRAY BMRAYT
.fast_click -1000 -1000
.=> TMEAS2
.unselect_all
.control_key 0
.select_object TMEAS2
.tapemeasure_options 1 1 noleader none
.unselect_all
.red_rays 0
.annotation Principle plane
.mid_snap
.object_coordinates TMEAS2 middle
.fast_click X Y
.fast_click_rel -20 100
.red_rays 1
.unselect_all
% ----------------------------------------------------------------
% Create a tape measure to show the focal length of the par-axial rays
.tapemeasure
.object_coordinates TMEAS2 middle
.mid_snap
.fast_click X Y
.intersect_snap
.select_object TMRAYT BMRAYT
.control_key 1
.fast_click -1000 -1000
.=> TMEAS3
.control_key 0
.unselect_all
.select_object TMEAS3
.tapemeasure_options 1 1 leader distance
.object_coordinates TMEAS3 lead_to
.fast_click X Y
.fast_click_rel -20 50
.unselect_all
.red_rays 1
% --------------------------------------------------------------
% Need a couple of values for setting concave and convex arcs
.CENTREX
.- 10
.=> LEFT
.CENTREX
.+ 10
.=> RIGHT
% --------------------------------------------------------------
% Turn painting back on
.recalc 1
.painting 1
% --------------------------------------------------------------
% Some messages before proceeding
.new_text
Note that the focal length of the lens (indicated by the tapemeasure
readout of about 400 units) is measured from what is called the
principle plane of the lens. This is a term
usually used with thick lenses. It is defined as the plane in
which the incident and transmitted par-axial rays intersect. For
the thin symmetrical lens shown here it is close to the central
plane of the lens. For lenses with higher shape factors it can lie
outside the lens as you may see later.
.pause
% --------------------------------------------------------------
.new_text
The spherical aberration of about 16 units is indicated by the
tapemeasure on the
right of the diagram. It shows the distance between the focal
points for the two rays close to the axis and the two rays passing
through the outer edges of the lens.
.pause
.goto TRYNEW?
% --------------------------------------------------------------
% Now bend the lens to a selected shape factor
:TOOSMALL
.new_text
This value of the shape factor leads to radii of curvature
that are too small for this lens height.


Click on Continue to try again.
.pause
:CHANGE
.new_text
The lens shape factor is currently
.printf %g SHAPEFACT


Enter a new shape factor for the lens.


Values are limited to between +/-3. Values larger than this lead
to a break down in the thin lens approximations and a radical
departure from the nominal focal length of the lens.
.input_limits -3 3
.default_input SHAPEFACT
.SHAPEFACT userinput
.call findrad.rsc
.R1
.if== 0 TESTR2
.abs
.* 2
.if< HEIGHT TOOSMALL
:TESTR2
.R2
.if== 0 RSOK
.abs
.* 2
.if< HEIGHT TOOSMALL
:RSOK
.painting 0
.recalc 0
.red_rays 0
.show_annotations 0
.show_tapemeasures 0
.select_object LENS
.object_coordinates LENS 1 tangent
.fast_click X Y
.R1
.if< 0 CONCAVE1
.fast_move LEFT CENTREY
.goto DOARC1 
:CONCAVE1
.fast_move RIGHT CENTREY
:DOARC1
.set_radius R1
.object_coordinates LENS 3 tangent
.fast_click X Y
.R2
.if< 0 CONCAVE2
.fast_move LEFT CENTREY
.goto DOARC2
:CONCAVE2
.fast_move RIGHT CENTREY
:DOARC2 
.set_radius R2
.unselect_all
.red_rays 1
.show_annotations 1
.show_tapemeasures 1
.recalc 1
.painting 1
:TRYNEW?
.new_text
The lens shape factor is currently
.printf %g SHAPEFACT


Select one of the options by clicking on the appropriate button.


A - Try a different shape factor?

B - Zoom in to see the spherical aberration in more detail.

C - Exit the script.
.choose 3 CHANGE ZOOM END
:ZOOM
.zoom_in
.click 80 60
.click 250 -60
.new_text
Click on continue to zoom back.
.pause
.zoom_previous
.goto TRYNEW?
:END
.new_text

.clear_var
.return
