{ PRIMES.PAS - Get prime factors of a positive 32 bit integer

  Title   : PRIMES
  Language: Borland Pascal v5.0 and higher
  Version : 1.3
  Date    : Feb 15, 2000
  Author  : J R Ferguson
  Usage   : refer procedure Help
  Download: http://hello.to/ferguson
  E-mail  : j.r.ferguson@iname.com

This program and its source may be used and copied freely without charge,
but  only  for non-commercial purposes. The author is not responsible for
any damage or loss of data that may be caused by using it.
}


program Primes(input,output);
uses Crt;

var number, power, factor : longint;
    continue, ready: boolean;

procedure return; begin write(chr(13)) end;

procedure ask(var number: longint; var ready: boolean);
  begin
    repeat
      return; write ('? '); read(number)
    until (number = 0) or (number >= 2);
    ready:= number=0
  end;

procedure display(var continue: boolean; factor, power: longint);
  begin
    if continue then write(' . ');
    write (factor);
    if power > 1 then write('^',power);
    continue := true
  end;

procedure separate {non-recursive version}
{(global var continue: boolean;global var number,factor: longint)};
  begin
    while (number > 1) and (factor <= number) do
      begin
        power := 0;
        while (number mod factor) = 0 do
          begin
            power := power + 1;
            number := number div factor
          end;
        if power > 0 then display(continue, factor, power);
        if factor=2 then factor:= 3 else factor:= factor+2;
      end
  end;

begin
  ClrScr;
  writeln ('** SEPARATE PRIME FACTORS **');
  writeln ('Integer numbers >= 2,  stop with 0');
  writeln;
  repeat
    ask(number, ready);
    if not ready then
      begin
        write(' = ');
        factor:= 2; continue:= false;
        separate;
        writeln;
      end
  until ready
end.
