// 
//	MoonPhase.cpp
//
//	Simple program to show the current moon phase on the taskbar.
//
//	Copyright (c) 1996 Barefoot Productions
//
//	Author: Don Metzler
//

#include "stdafx.h"
#include "MainWnd.h"
#include "MoonPhase.h"
#include "MoonPhaseDlg.h"
#include "AboutDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define	IDI_MoonPhase		4817

CAboutDlg*	pAboutDlg = NULL ;

/////////////////////////////////////////////////////////////////////////////
// CMoonPhaseApp

BEGIN_MESSAGE_MAP(CMoonPhaseApp, CWinApp)
	//{{AFX_MSG_MAP(CMoonPhaseApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMoonPhaseApp construction

CMoonPhaseApp::CMoonPhaseApp()
{
	m_pMainWnd = NULL ;
	m_hIcon = NULL ;

	m_iMonth = 0 ;
	m_iDay = 0 ;
	m_iYear = 0 ;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMoonPhaseApp object

CMoonPhaseApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMoonPhaseApp initialization

BOOL CMoonPhaseApp::InitInstance()
{
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	char	szAppWndTitle[] = "MoonPhase" ;

	m_pMainWnd = &m_hAppWnd ;
	if (!m_hAppWnd.CreateEx(0, AfxRegisterWndClass(0), szAppWndTitle, WS_POPUP, 0, 0, 100, 40, NULL, 0, NULL))
	{
		::MessageBox(NULL, "Could not create main window", "DEBUG", MB_OK) ;
		return (FALSE) ;
	}

	m_hAppWnd.StartTimer() ;

	GetMoonIcon() ;
	InitTray() ;

	return (TRUE) ;
}

int CMoonPhaseApp::ExitInstance() 
{
	RemoveTrayIcon() ;

	return CWinApp::ExitInstance();
}

void CMoonPhaseApp::AboutBox(void)
{
	// Show the about box.
	CAboutDlg	dlg ;

	if (pAboutDlg != NULL)
	{
		pAboutDlg->SetForegroundWindow() ;
		pAboutDlg->BringWindowToTop() ;
		return ;
	}

	pAboutDlg = &dlg ;

	dlg.DoModal() ;

	pAboutDlg = NULL ;
}

void CMoonPhaseApp::InitTray(void)
{
	// Load Tray icons and tips
	GetMoonIcon() ;

	AddTrayIcon() ;
}

void CMoonPhaseApp::AddTrayIcon(void)
{
	TrayMessage(NIM_ADD) ;
}

void CMoonPhaseApp::RemoveTrayIcon(void)
{
	TrayMessage(NIM_DELETE) ;
}

void CMoonPhaseApp::ModifyTrayState(void)
{
	TrayMessage(NIM_MODIFY) ;
}

void CMoonPhaseApp::AppTrayCallback(WPARAM wParam, LPARAM lParam)
{
    UINT	uID ;
	UINT	uMouseMsg ;

// called from (in main app notification for TRAY_CALLBACK):
//			case TRAY_CALLBACK:
//				TrayCallback(wParam, lParam);
//				break ;

    uID = (UINT) wParam ;
    uMouseMsg = (UINT) lParam ;

    if (uMouseMsg == WM_LBUTTONDOWN)
    {
		if (uID == (UINT) IDI_MoonPhase)
		{
			AboutBox() ;			
		}
    }
	else
	if (uMouseMsg == WM_RBUTTONDOWN)
	{
		// If the right mouse button is pressed over the
		// taskbar icon, show the context menu.

		CMenu	pMenu ;
		POINT	pt ;
		POINTS	pts ;
		HWND	hTaskbar ;

		pts = MAKEPOINTS(lParam) ;
		pt.x = pts.x ;
		pt.y = pts.y ;

		hTaskbar = ::FindWindow("Shell_TrayWnd", (LPCTSTR) NULL) ;
		if (hTaskbar)
			::ClientToScreen(hTaskbar, &pt) ;

        ::GetCursorPos(&pt) ;

		pMenu.CreatePopupMenu() ;

		pMenu.AppendMenu(MF_STRING, IDM_ABOUT, (LPSTR) "&About MoonPhase...") ;
		pMenu.AppendMenu(MF_SEPARATOR, 0, (LPSTR) NULL) ;
		pMenu.AppendMenu(MF_STRING, IDM_REMOVE, (LPSTR) "&Remove") ;

		// Callbacks go to m_hAppWnd.
		pMenu.TrackPopupMenu(TPM_LEFTALIGN | TPM_LEFTBUTTON, pt.x, pt.y, &m_hAppWnd) ;
	}
}

void CMoonPhaseApp::TrayMessage(UINT message)
{
   	NOTIFYICONDATA tnd ;

	// This is the popup message the user will
	// see when they drag the mouse over the taskbar icon.

	strcpy(tnd.szTip, m_Description) ;

    switch (message)
    {
        case NIM_ADD:
            tnd.uFlags = NIF_MESSAGE | NIF_ICON | NIF_TIP ;
            break ;

        case NIM_MODIFY:
            tnd.uFlags = NIF_TIP | NIF_ICON ;
            break ;

        case NIM_DELETE:
            tnd.uFlags = 0 ;
            break ;
    }

	// Set the parameters for the taskbar Shell_NotifyIcon() API call.

	// Callback messages go to m_hAppWnd.m_hWnd, which
	// is the code contained in MainWnd.cpp.  The callback
	// to that window then passes a message to CMoonPhaseApp.

    tnd.uID 				= (UINT) IDI_MoonPhase ;
    tnd.cbSize				= sizeof(NOTIFYICONDATA) ;
	tnd.hWnd				= (HWND) m_hAppWnd.m_hWnd ;
    tnd.uCallbackMessage 	= TRAY_CALLBACK ;
	tnd.hIcon				= m_hIcon ;

    ::Shell_NotifyIcon(message, &tnd) ;
}

int CMoonPhaseApp::GetMoonPhase(void)
{
	int			iMoonAge, iPhase ;
	SYSTEMTIME	st ;

	::GetLocalTime(&st) ;

	iMoonAge = GetMoonAge((int) st.wMonth, (int) st.wDay, (int) st.wYear) ;

	// Set member variables to track date.
	m_iMonth = st.wMonth ;
	m_iDay = st.wDay ;
	m_iYear = st.wYear ;

	// Set iPhase to the icon to display.

	if (iMoonAge == 0)
	{
		// New moon
		iPhase = 1 ;
	}
	else
	if (iMoonAge <= 4)
	{
		iPhase = 2 ;
	}
	else
	if (iMoonAge <= 8)
	{
		iPhase = 3 ;
	}
	else
	if (iMoonAge <= 11)
	{
		iPhase = 4 ;
	}
	else
	if (iMoonAge <= 15)
	{
		// Full moon.
		iPhase = 5 ;
	}
	else
	if (iMoonAge <= 20)
	{
		iPhase = 6 ;
	}
	else
	if (iMoonAge <= 24)
	{
		iPhase = 7 ;
	}
	else
		iPhase = 8 ;

	return (iPhase) ;
}

int CMoonPhaseApp::GetMoonAge(int month, int day, int year)
{      
	static short int ages[] = {18, 0, 11, 22, 3, 14, 25, 6, 17, 28, 9, 20, 1, 12, 23, 4, 15, 26, 7} ;
	static short int offsets[] = {-1, 1, 0, 1, 2, 3, 4, 5, 7, 7, 9, 9} ;

	if (day == 31)            
		day = 1 ;

	// Returns 0 for a new moon, 15 for a full moon, 29 the day before new, etc.
    return ((ages[(year + 1) % 19] + ((day + offsets[month-1]) % 30) + (year < 1900)) % 30) ;
}

void CMoonPhaseApp::CheckDateChange()
{
	SYSTEMTIME	st ;

	::GetLocalTime(&st) ;

	if ((m_iMonth != st.wMonth) || (m_iDay != st.wDay) || (m_iYear != st.wYear))
	{
		GetMoonIcon() ;
		ModifyTrayState() ;
	}
}

void CMoonPhaseApp::GetMoonIcon()
{
	int		iPhase ;
	char	szIconName[32] ;
	char	buffer[20] ;

	if (m_hIcon)
		DestroyIcon(m_hIcon) ;

	iPhase = GetMoonPhase() ;

	sprintf(szIconName, "IDR_MOON%d", iPhase) ;

	m_hIcon = (HICON) ::LoadImage(AfxGetResourceHandle(), szIconName, IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR) ;

	::LoadString(AfxGetResourceHandle(), IDS_MOONPHASE + iPhase, buffer, sizeof(buffer)) ;

	sprintf(m_Description, "Moon Phase: %s", buffer) ;
}

