//
//	MainWnd.cpp
//
//	Copyright (c) 1996 Barefoot Productions
//
//	Author: Don Metzler
//


#include "stdafx.h"
#include "MainWnd.h"
#include "MoonPhase.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern	CMoonPhaseApp theApp;

#define	CALLBACK_TIMER_ID		6
#define	TIMER_INTERVAL_MS		2400

/////////////////////////////////////////////////////////////////////////////
// CMainWnd

CMainWnd::CMainWnd()
{
}

CMainWnd::~CMainWnd()
{
}


BEGIN_MESSAGE_MAP(CMainWnd, CWnd)
	//{{AFX_MSG_MAP(CMainWnd)
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
	ON_MESSAGE(TRAY_CALLBACK, OnTrayCallback)
	ON_COMMAND(IDM_ABOUT, OnAbout)
	ON_COMMAND(IDM_REMOVE, OnRemove)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMainWnd message handlers

LRESULT CMainWnd::OnTrayCallback(WPARAM wParam, LPARAM lParam)
{
	// Now call the CTrayCalcApp::AppTrayCallback()

	theApp.AppTrayCallback(wParam, lParam) ;
	return (0) ;
}

void CMainWnd::OnAbout(void)
{
	theApp.AboutBox() ;
}

void CMainWnd::OnRemove(void)
{
	AfxGetMainWnd()->DestroyWindow() ;
}

BOOL CMainWnd::DestroyWindow() 
{
	// Remove icon from the taskbar.
	theApp.RemoveTrayIcon() ;
	
	return CWnd::DestroyWindow();
}

void CMainWnd::OnTimer(UINT nIDEvent)
{
	theApp.CheckDateChange() ;
}

void CMainWnd::StartTimer(void)
{
	SetTimer(CALLBACK_TIMER_ID, TIMER_INTERVAL_MS, NULL) ;
}

