//---------------------------------------------------------------------------
/*
	MainForm.cpp (LotkaVolt)

	Copyright (c) 1998 Hendrik J. Blok
	    blok@physics.ubc.ca
	    http://www.physics.ubc.ca/~blok/

    Revisions:
	    v1.0b	Nov 6, 1998
        	- replaced component TSavePosition with TFormStorage
            - added CheckBox*->Checked and DFSColorButton*->Color
            	to FormStorage1
            - added component TFixLabelAutoSize

	    v1.0	May 8, 1998
    		- initial release
*/
#include <vcl\vcl.h>
#include <vcl\inifiles.hpp>	// TIniFile
#pragma hdrstop

#include "MainForm.h"

#define VERSION "1.0b"
//---------------------------------------------------------------------------
#pragma link "xyGraph"
#pragma link "atimer"
#pragma link "Grids"
#pragma link "FlEdit"
#pragma link "Parser10"
#pragma link "DFSClrBn"
#pragma link "Placemnt"
#pragma link "fixlabelautosize"
#pragma resource "*.dfm"
TForm1 *Form1;

double   t=0,	 dt=1;	// time and time step
double  N1=1,	 N2=1;	// population density
double *P1N1,*P2N1,*P1N2,*P2N2;
//---------------------------------------------------------------------------
AnsiString RemoveBlanks(AnsiString s)
{
	for (int i = s.Pos(" "); i>0; i = s.Pos(" "))
    	s.Delete(i,1);
    return s;
}
//---------------------------------------------------------------------------
void GraphTitle(AnsiString fn)
// converts an .ini filename to a title and attaches to graph
{
	fn = ExtractFileName(fn);
    fn.SetLength(fn.Length() - ExtractFileExt(fn).Length());
	Form1->xyGraph1->Appearance->GraphTitle = fn;

}
//---------------------------------------------------------------------------
void ReadIni(AnsiString fn)
// loads configuration from an .ini file
{
	TIniFile *ini = new TIniFile(fn);
//	t = ini->ReadString("Time",     	"Time",     	  t).ToDouble();
	dt= ini->ReadString("Time",     	"Step",     	 FloatToStr(dt)).ToDouble();
	N1= ini->ReadString("Species 1",	"Density",  	 FloatToStr(N1)).ToDouble();
    N2= ini->ReadString("Species 2",	"Density",  	 FloatToStr(N2)).ToDouble();
    Form1->Rate1->Text=ini->ReadString("Species 1",	"Rate",	"0");
    Form1->Rate2->Text=ini->ReadString("Species 2",	"Rate",	"0");

    Form1->N1Edit->Value = N1; 	Form1->N2Edit->Value = N2;
	Form1->dtEdit->Text = dt;

    // parameters
	for (int i=1; i<Form1->StringGrid1->RowCount; i++) {
       	AnsiString si = IntToStr(i);
    	Form1->StringGrid1->Cells[1][i]=ini->ReadString("Parameters",	"Name"+si,	"");
		Form1->StringGrid1->Cells[2][i]=ini->ReadString("Parameters",	"Value"+si,	"");
        Form1->StringGrid1->Cells[3][i]=ini->ReadString("Parameters",	"Description"+si,"");
    }

	GraphTitle(fn);
}
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
    t += dt;
	N1 += dt * MathParser1->Value;
    N2 += dt * MathParser2->Value;
    *P1N1 = *P2N1 = N1;
    *P1N2 = *P2N2 = N2;
    xyGraph1->Series[1]->Add(t,N1);
    xyGraph1->Series[2]->Add(t,N2);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonExitClick(TObject *Sender)
{
	Application->Terminate();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonStartPauseClick(TObject *Sender)
{
	if (Timer1->Enabled) {
    	Start1->Caption = "&Continue";
    	ButtonStartPause->Caption = "&Continue";
    } else {
    	Start1->Caption = "&Pause";
    	ButtonStartPause->Caption = "&Pause";

	    // parse expression
		N1 = N1Edit->Value;
   		N2 = N2Edit->Value;
	   	MathParser1->ClearVariables();
    	MathParser2->ClearVariables();
	    P1N1 = MathParser1->SetVariable("N1",N1);
    	P2N1 = MathParser2->SetVariable("N1",N1);
	    P1N2 = MathParser1->SetVariable("N2",N2);
    	P2N2 = MathParser2->SetVariable("N2",N2);
	    // get parameters
    	for (int i=1; i<StringGrid1->RowCount; i++)
	    	if (!StringGrid1->Cells[1][i].IsEmpty()) {
		    	MathParser1->SetVariable(StringGrid1->Cells[1][i],
    		    						 StringGrid1->Cells[2][i].ToDouble());
	    		MathParser2->SetVariable(StringGrid1->Cells[1][i],
	    	    						 StringGrid1->Cells[2][i].ToDouble());
                StringGrid1->Cells[2][i] = FloatToStr(MathParser1->GetVariable(StringGrid1->Cells[1][i]));
		    }
	    // parse
    	MathParser1->Expression = RemoveBlanks(Rate1->Text);
	    MathParser2->Expression = RemoveBlanks(Rate2->Text);
    }

    Timer1->Enabled = !Timer1->Enabled;
    Running1->Checked = Timer1->Enabled;
    Timer2->Enabled = Timer1->Enabled;

    // update graph (if withholding data)
	xyGraph1->Series[1]->HoldUpdates = false;
   	xyGraph1->Series[2]->HoldUpdates = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
	Caption = Application->Title;
    // try to read command-line file (else use defaults)
    AnsiString fn = ParamStr(1);
    if (!fn.IsEmpty()) {
	    // first search in current folder, if found prepend ".\\"
    	TSearchRec sr;
        if (FindFirst(fn,faAnyFile,sr) == 0)
        	fn = ".\\" + fn;
    }

    // fill StringGrid headers
    StringGrid1->Cells[1][0] = "Name";
    StringGrid1->Cells[2][0] = "Value";
    StringGrid1->Cells[3][0] = "Description";

    ReadIni(fn);

    // graph
    DFSColorButton1ColorChange(Sender);
    DFSColorButton2ColorChange(Sender);
	CheckBox1Click(Sender);
    CheckBox2Click(Sender);
    CheckBox3Click(Sender);
    CheckBox4Click(Sender);
    ButtonClearClick(Sender);
    xyGraph1->Series[1]->SeriesName = "N1";
    xyGraph1->Series[2]->SeriesName = "N2";
    xyGraph1->Series[1]->LegendStatus = lsAll;
    xyGraph1->Series[2]->LegendStatus = lsAll;

    Application->ShowHint = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ButtonClearClick(TObject *Sender)
{
	xyGraph1->Series[1]->Clear();
    xyGraph1->Series[2]->Clear();
    t=0;
    xyGraph1->XAxis->Min=t;
    xyGraph1->XAxis->Max=t+10*dt;
    xyGraph1->XAxis->AutoSizing=true;
    xyGraph1->YAxis->Min=min(N1,N2);
    xyGraph1->YAxis->Max=max(N1,N2);
    xyGraph1->YAxis->AutoSizing=true;
	if (!Timer1->Enabled) {
    	Start1->Caption = "&Start";
    	ButtonStartPause->Caption = "&Start";
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
	int interval = 1000;
    // TrackBar must have positions 0..10
    for (int loop=0; loop < TrackBar1->Position; loop++)
    	interval >>= 1;
    Timer1->Interval = interval;
    // Timer2 controls HoldUpdates if interval==0
	xyGraph1->Series[1]->HoldUpdates = false;
   	xyGraph1->Series[2]->HoldUpdates = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Pause(TObject *Sender)
{
	if (Timer1->Enabled)	ButtonStartPauseClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
	if (Timer1->Enabled)	ButtonStartPauseClick(Sender);
	if (OpenDialog1->Execute()) {
     	ReadIni(OpenDialog1->FileName);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SpeedButton2Click(TObject *Sender)
{
	if (Timer1->Enabled)	ButtonStartPauseClick(Sender);
	if (SaveDialogIni->Execute()) {
		TIniFile *ini = new TIniFile(SaveDialogIni->FileName);
//		ini->WriteString("Time",    	"Time",     	 t);
		ini->WriteString("Time",    	"Step",     	dt);
		ini->WriteString("Species 1",	"Density",  	N1);
        ini->WriteString("Species 2",	"Density",  	N2);
        ini->WriteString("Species 1",	"Rate",			Rate1->Text);
		ini->WriteString("Species 2",	"Rate",			Rate2->Text);

		for (int i=1; i<StringGrid1->RowCount; i++) {
        	AnsiString si = IntToStr(i);
    		ini->WriteString("Parameters",	"Name"+si,	StringGrid1->Cells[1][i]);
			ini->WriteString("Parameters",	"Value"+si,	StringGrid1->Cells[2][i]);
	        ini->WriteString("Parameters",	"Description"+si,
        											StringGrid1->Cells[3][i]);
	    }
		GraphTitle(SaveDialogIni->FileName);
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Clip1Click(TObject *Sender)
{
	xyGraph1->CopyToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Print1Click(TObject *Sender)
{
	if (Timer1->Enabled)	ButtonStartPauseClick(Sender);
    xyGraph1->Legend->visible = true;
	xyGraph1->Print();
    xyGraph1->Legend->visible = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Running1Click(TObject *Sender)
{
	ButtonStartPauseClick(Sender);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Bitmap1Click(TObject *Sender)
{
	if (Timer1->Enabled)	ButtonStartPauseClick(Sender);
	if (SaveDialogBmp->Execute())
    	xyGraph1->SaveToBitmap(SaveDialogBmp->FileName);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::xyGraph1TooManyPoints(TObject *sender, int index)
{
	if (Timer1->Enabled)	ButtonStartPauseClick(sender);
	if (Application->MessageBox("A great deal of data has accumulated.  "
	    	"To avoid an error and improve performance, clear the data now?",
    	    "Too Many Points",MB_YESNO+MB_ICONWARNING) == IDYES)
    	// yes, reset data
		ButtonClearClick(sender);
    else {
    	// no, keep data and don't warn again
        xyGraph1->Series[1]->PointWarningLimit = 0;
        xyGraph1->Series[2]->PointWarningLimit = 0;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Timer2Timer(TObject *Sender)
// don't update this as often, it slows things down
{
	N1Edit->Value = N1;
    N2Edit->Value = N2;
    // if trying to run quickly then update graph less frequently
    // (trade-off because it causes flicker)
    if (Timer1->Interval<1) {
    	// update now
		xyGraph1->Series[1]->HoldUpdates = false;
    	xyGraph1->Series[2]->HoldUpdates = false;
        // don't update
		xyGraph1->Series[1]->HoldUpdates = true;
    	xyGraph1->Series[2]->HoldUpdates = true;
    }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::dtEditExit(TObject *Sender)
{
	dt = dtEdit->Value;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::N1EditExit(TObject *Sender)
{
	N1 = N1Edit->Value;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::N2EditExit(TObject *Sender)
{
	N2 = N2Edit->Value;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DFSColorButton2ColorChange(TObject *Sender)
{
	xyGraph1->Series[2]->LineColor = DFSColorButton2->Color;
    xyGraph1->Series[2]->PointColor = DFSColorButton2->Color;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DFSColorButton1ColorChange(TObject *Sender)
{
	xyGraph1->Series[1]->LineColor = DFSColorButton1->Color;
    xyGraph1->Series[1]->PointColor = DFSColorButton1->Color;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
	xyGraph1->Series[1]->DrawLine = CheckBox1->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox3Click(TObject *Sender)
{
	xyGraph1->Series[1]->DrawPoints = CheckBox3->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox2Click(TObject *Sender)
{
	xyGraph1->Series[2]->DrawLine = CheckBox2->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckBox4Click(TObject *Sender)
{
	xyGraph1->Series[2]->DrawPoints = CheckBox4->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::About2Click(TObject *Sender)
{
	AnsiString s = AnsiString("LotkaVolt v") + VERSION + "\n"
    	+ Application->Title + "\n\n"
        + "Copyright (c) 1998 Hendrik J. Blok\n"
        + "    blok@physics.ubc.ca\n"
        + "    http://www.physics.ubc.ca/~blok/";
	Application->MessageBox(s.c_str(),Application->Title.c_str(),MB_OK);
}
//---------------------------------------------------------------------------
