{ About box }
unit gjmatd2;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Dialogs, ShellAPI;

type
  TAboutBox = class(TForm)
    Panel: TPanel;
    ProgIcon: TImage;
    ProgTitle: TLabel;
    ProgIdn: TLabel;
    ProgTarget: TLabel;
    Copyright: TLabel;
    Email: TLabel;
    Website: TLabel;
    OKButton: TButton;
    procedure EmailClick(Sender: TObject);
    procedure WebsiteClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

implementation

Uses gjmatd0;

{$R *.DFM}

procedure TAboutBox.EmailClick(Sender: TObject);
var cmd: string;
begin if GC_LinkEmail then begin
  cmd:= 'mailto:'  + GC_Email +
        '?subject=' + S(SI_About)+' '+GC_ProgIdn+' '+GC_ProgVers;
  if ShellExecute(GetDesktopWindow,nil,PChar(cmd),nil,nil,SW_NORMAL) <= 32
  then ShowMessage(S(SI_ErrEmail));
end end;

procedure TAboutBox.WebsiteClick(Sender: TObject);
var cmd: string;
begin if GC_LinkWebsite then begin
  cmd:= GC_Website;
  if ShellExecute(GetDesktopWindow,nil,PChar(cmd),nil,nil,SW_NORMAL) <= 32
  then ShowMessage(S(SI_ErrURL));
end end;

procedure TAboutBox.FormShow(Sender: TObject);
begin
  ProgIcon.Picture.Icon := Application.Icon;
  ProgIdn.Caption       := GC_ProgIdn+' '+GC_ProgVers+' - '+S(SI_ProgDate);
  ProgTitle.Caption     := S(SI_ProgTitle);
  ProgTarget.Caption    := GC_ProgTarget;
  Copyright.Caption     := GC_Copyright;
  Email.Caption         := GC_Email;
  Website.Caption       := GC_Website;
  if GC_LinkEmail then with Email.Font do begin
    Color:= clBlue;
    Style:= Style + [fsUnderline];
  end;
  if GC_LinkWebsite then with Website.Font do begin
    Color:= clBlue;
    Style:= Style + [fsUnderline];
  end;
end;

end.

