{ Main Window }
unit gjmatd1;

interface

uses
  gjmatd0,
  ExtCtrls, Menus, Dialogs, StdCtrls, Controls, Buttons, Classes,
  Windows, Messages, SysUtils, Graphics, Forms, ComCtrls, Grids, Spin;

type
  TMainWindow = class(TForm)
    ToolBar: TPanel;
    BtnExit: TSpeedButton;
    BtnFileNew: TSpeedButton;
    BtnFileOpen: TSpeedButton;
    BtnFileSave: TSpeedButton;
    BtnHints: TSpeedButton;
    BtnFont: TSpeedButton;
    BtnHelp: TSpeedButton;
    BtnLngUS: TSpeedButton;
    BtnLngNL: TSpeedButton;
    MainMenu: TMainMenu;
    MnuFile: TMenuItem;
    MnuFileNew: TMenuItem;
    MnuFileOpen: TMenuItem;
    MnuFileSave: TMenuItem;
    MnuFileSaveAs: TMenuItem;
    N1: TMenuItem;
    MnuFileExit: TMenuItem;
    MnuOptions: TMenuItem;
    MnuOptToolBar: TMenuItem;
    MnuOptHints: TMenuItem;
    MnuOptFont: TMenuItem;
    MnuOptLanguage: TMenuItem;
    MnuOptLngUS: TMenuItem;
    MnuOptLngNL: TMenuItem;
    MnuHelp: TMenuItem;
    MnuHelpAbout: TMenuItem;
    DlgFileOpen: TOpenDialog;
    DlgFileSave: TSaveDialog;
    DlgFont: TFontDialog;
    PnlData: TPanel;
    HSplitter: TSplitter;
    PnlButton: TPanel;
    BtnSolve: TBitBtn;
    GrpRowCount: TGroupBox;
    EditRowCount: TSpinEdit;
    GrpDecSep: TRadioGroup;
    StatusBar: TStatusBar;
    PnlInput: TPanel;
    GrpInpMatrix: TGroupBox;
    GridInpMatrix: TStringGrid;
    GrpInpVector: TGroupBox;
    GridInpVector: TStringGrid;
    PnlResult: TPanel;
    GrpInverse: TGroupBox;
    GridInverse: TStringGrid;
    GrpSolution: TGroupBox;
    GridSolution: TStringGrid;
    GrpNumDisplay: TRadioGroup;
    GrpPrecision: TGroupBox;
    EditPrecision: TSpinEdit;
    GrpDigits: TGroupBox;
    EditDigits: TSpinEdit;
    InpSplitter: TSplitter;
    OutSplitter: TSplitter;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure MnuFileClick(Sender: TObject);
    procedure MnuFileNewClick(Sender: TObject);
    procedure MnuFileOpenClick(Sender: TObject);
    procedure MnuFileSaveClick(Sender: TObject);
    procedure MnuFileSaveAsClick(Sender: TObject);
    procedure MnuFileExitClick(Sender: TObject);
    procedure MnuOptionsClick(Sender: TObject);
    procedure MnuOptToolBarClick(Sender: TObject);
    procedure MnuOptHintsClick(Sender: TObject);
    procedure MnuOptFontClick(Sender: TObject);
    procedure MnuOptLanguageClick(Sender: TObject);
    procedure MnuOptLngNLClick(Sender: TObject);
    procedure MnuOptLngUSClick(Sender: TObject);
    procedure MnuHelpClick(Sender: TObject);
    procedure MnuHelpAboutClick(Sender: TObject);
    procedure DlgFontApply(Sender: TObject; Wnd: Integer);
    procedure EditRowCountChange(Sender: TObject);
    procedure GridInpMatrixGetEditText(Sender: TObject; ACol, ARow: Integer;
      var Value: String);
    procedure GridInpMatrixSetEditText(Sender: TObject; ACol, ARow: Integer;
      const Value: String);
    procedure GridInpVectorGetEditText(Sender: TObject; ACol,
      ARow: Integer; var Value: String);
    procedure GridInpVectorSetEditText(Sender: TObject; ACol,
      ARow: Integer; const Value: String);
    procedure GrpDecSepClick(Sender: TObject);
    procedure HSplitterMoved(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure BtnSolveClick(Sender: TObject);
    procedure GrpNumDisplayClick(Sender: TObject);
    procedure EditPrecisionChange(Sender: TObject);
    procedure EditDigitsChange(Sender: TObject);
    procedure InpSplitterMoved(Sender: TObject);
    procedure OutSplitterMoved(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure StatusBarDrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
  private
    EdtActive : boolean;
    NeedAdjS  : boolean;
    procedure WMGetMinMaxInfo(var V_Msg: Tmessage); message WM_GetMinMaxInfo;
    procedure AdjustPaneWidth;
    procedure OnIdle(Sender: TObject; var Done: Boolean);
  public
    FileName  : String;
    NRow      : integer;
    InputMat  : T_InputMatrix;
    SolveMat  : T_SolveMatrix;
    Determnt  : T_MatElm;
    Solved    : boolean;
    NumFormat : TFloatFormat;
    procedure ApplyFont;
    function  NumberStr(V_Value: Extended): String;
    procedure SetLanguage(V_Language: T_Language);
    procedure InitInputMatrix;
    procedure AdjustControls;
    procedure AdjustSizes;
    procedure AdjustData;
    procedure DoFileSave;
    procedure DisplayInput;
    procedure DisplayResult;
    procedure GaussJordan;
  end;

var
  MainWindow: TMainWindow;

implementation

uses gjmatd2, gjmatdnl, gjmatdus;

{$R *.DFM}


{ Private }

procedure TMainWindow.WMGetMinMaxInfo(var V_Msg: Tmessage);
begin with PMinMaxInfo(V_Msg.lparam)^.ptMinTrackSize do begin
  x:= GC_MinWinWidth;
  y:= GC_MinWinHeight;
  AdjustPaneWidth;
end; end;

procedure TMainWindow.AdjustPaneWidth;
begin if GV_FormReady then begin
  if PnlInput.Height  < GC_MinInpHeight then
     PnlInput.Height := GC_MinInpHeight;
  if PnlInput.Height  > PnlData.Height-HSplitter.Height-GC_MinResHeight then
     PnlInput.Height := PnlData.Height-HSplitter.Height-GC_MinResHeight;
  if GrpInpVector.Width  < GC_MinVecWidth then
     GrpInpVector.Width := GC_MinVecWidth;
  if GrpInpVector.Width  > PnlInput.Width - InpSplitter.Width - GC_MinMatWidth then
     GrpInpVector.Width := PnlInput.Width - InpSplitter.Width - GC_MinMatWidth;
  GrpSolution.Width:= GrpInpVector.Width;
end end;

procedure TMainWindow.OnIdle(Sender: TObject; var Done: Boolean);
begin if NeedAdjS then begin
  AdjustSizes;
  NeedAdjS:= false;
end; end;


{ Public }

procedure TMainWindow.ApplyFont;
begin
  GridInpMatrix.Font:= DlgFont.Font;
  GridInpVector.Font:= DlgFont.Font;
  GridInverse.Font  := DlgFont.Font;
  GridSolution.Font := DlgFont.Font;
end;

function  TMainWindow.NumberStr(V_Value: Extended): String;
var SignChr: char;
begin
  if V_Value < 0 then begin SignChr:= '-'; V_Value:= -V_Value end
                      else  SignChr:= ' ';
  Result:= SignChr+FloatToStrF(V_Value,NumFormat,
    EditPrecision.Value,EditDigits.Value);
end;

procedure TMainWindow.SetLanguage(V_Language: T_Language);
begin
  GV_Language:= V_Language;
  case V_Language of
    lng_US: SetLangUS;
    lng_NL: SetLangNL;
  end;
  Application.Title       := S(SI_ProgTitle   );
  MainWindow.Caption      := S(SI_ProgTitle   );
  MnuFile.Caption         := S(SI_MnuFile     );
  MnuOptions.Caption      := S(SI_MnuOptions  );
  MnuHelp.Caption         := S(SI_MnuHelp     );
  BtnFileNew.Hint         := S(SI_HintNew     );
  BtnFileOpen.Hint        := S(SI_HintOpen    );
  BtnFileSave.Hint        := S(SI_HintSave    );
  BtnExit.Hint            := S(SI_HintExit    );
  BtnHints.Hint           := S(SI_HintHints   );
  BtnFont.Hint            := S(SI_HintFont    );
  BtnHelp.Hint            := S(SI_HintHelp    );
  BtnLngUS.Hint           := S(SI_HintLngUS   );
  BtnLngNL.Hint           := S(SI_HintLngNL   );
  DlgFileOpen.Title       := S(SI_TtlOpen     );
  DlgFileOpen.Filter      := S(SI_FileFilt1   )+' (*.dat)|*.dat|'+
                             S(SI_FileFilt2   )+' (*.*)|*.*';
  DlgFileSave.Title       := S(SI_TtlSaveAs   );
  DlgFileSave.Filter      := S(SI_FileFilt1   )+' (*.dat)|*.dat|'+
                             S(SI_FileFilt2   )+' (*.*)|*.*';
  GrpInpMatrix.Caption    := S(SI_TtlInpMatrix);
  GrpInpVector.Caption    := S(SI_TtlInpVector);
  GrpInverse.Caption      := S(SI_TtlResMatrix);
  GrpSolution.Caption     := S(SI_TtlResVector);
  StatusBar.Panels[0].Text:= S(SI_TtlDeterm   );
  StatusBar.Panels[2].Text:= S(SI_TtlFileName );
  BtnSolve.Caption        := S(SI_LblSolve    );
  GrpRowCount.Caption     := S(SI_LblRowCount );
  with GrpNumDisplay do begin
    Caption               := S(SI_LblNumDispl );
    Items[0]              := S(SI_NumDGeneral );
    Items[1]              := S(SI_NumDExponent);
    Items[2]              := S(SI_NumDFixed   );
  end;
  GrpPrecision.Caption    := S(SI_LblPrecision);
  with GrpDecSep do begin
    Caption               := S(SI_LblDecPt    );
    Items[0]              := S(SI_DecPtDot    );
    Items[1]              := S(SI_DecPtCommma );
  end;
  AdjustControls;
end;

procedure TMainWindow.InitInputMatrix;
var r,c: integer;
begin
  for r:= 1 to GC_MaxRow do for c:= 1 to GC_MaxInpCol do
    InputMat[r,c]:= 0.0;
  DisplayInput;
  DisplayResult;
end;

procedure TMainWindow.DoFileSave;
var f: TextFile; r,c: integer; ok: boolean;
begin if FileName <> '' then begin
  ok:= false;
  SetCursor(crHourGlass);
  try
    AssignFile(f,FileName); Rewrite(f);
    try
      writeln(f,NRow);
      for r:= 1 to NRow do for c:= 1 to NRow do
        writeln(f,InputMat[r,c]);
      for r:= 1 to NRow do writeln(f,InputMat[r,NRow+1]);
      ok:= true;
    finally CloseFile(f); end;
  finally RestoreCursor; end;
  if not ok then ShowMessage(S(SI_ErrSave));
end end;

procedure TMainWindow.DisplayInput;
var r,c: integer;
begin
  with GridInpMatrix do begin
    RowCount:= NRow+1; ColCount:= NRow+1;
    for r:= 1 to NRow do for c:= 1 to NRow do
      Cells[c,r]:= NumberStr(InputMat[r,c]);
  end;
  with GridInpVector do begin
    RowCount:= NRow+1;
    for r:= 1 to NRow do
      Cells[1,r]:= NumberStr(InputMat[r,NRow+1]);
  end;
  NeedAdjS:= true;
end;

procedure TMainWindow.DisplayResult;
var r,c: integer;
begin
  with GridInverse do begin
    RowCount:= NRow+1; ColCount:= NRow+1;
    for r:= 1 to NRow do for c:= 1 to NRow do
      if Solved then Cells[c,r]:= NumberStr(SolveMat[r,NRow+1+c])
                else Cells[c,r]:= '';
  end;
  with GridSolution do begin
    RowCount:= NRow+1;
    for r:= 1 to NRow do
      if Solved then Cells[1,r]:= NumberStr(SolveMat[r,NRow+1])
                else Cells[1,r]:= '';
  end;
  with StatusBar.Panels[1] do begin
    if Solved then Text:= NumberStr(Determnt)
              else Text:= '';
  end;
  NeedAdjS:= true;
end;

procedure TMainWindow.AdjustControls;
begin if GV_FormReady then begin
  BtnFileSave.Enabled := FileName <> '';
  BtnHints.Down       := ShowHint;
  BtnLngUS.Down       := GV_Language = lng_US;
  BtnLngNL.Down       := GV_Language = lng_NL;
  MnuOptLngUS.Checked := GV_Language = lng_US;
  MnuOptLngNL.Checked := GV_Language = lng_NL;
  if GrpNumDisplay.ItemIndex = 2 then begin
    GrpDigits.Caption := S(SI_LblDecDigits);
    with EditDigits do begin
      MinValue := GC_MinDecDigits;
      MaxValue := GC_MaxDecDigits;
      Value    := GC_DflDecDigits;
    end;
  end
  else begin
    GrpDigits.Caption := S(SI_LblExpDigits);
    with EditDigits do begin
      MinValue := GC_MinExpDigits;
      MaxValue := GC_MaxExpDigits;
      Value    := GC_DflExpDigits;
    end;
  end;
  GrpDecSep.ItemIndex := ord(DecimalSeparator=',');
  StatusBar.Panels[3].Text:= FileName;
  if Solved then StatusBar.Panels[1].Text:= NumberStr(Determnt);
end end;

procedure TMainWindow.AdjustSizes;
var WMax,HMax: integer; c,r: integer;
  function imax(a,b: integer): integer;
  begin if a>b then imax:= a else imax:= b end;
begin if GV_FormReady then begin
  WMax:= GC_MinCellWidth;
  for r:= 0 to NRow do begin
    with GridInpMatrix do WMax:= imax(WMax,Canvas.TextWidth(Cells[0,r])+10);
    with GridInverse   do WMax:= imax(WMax,Canvas.TextWidth(Cells[0,r])+10);
  end;
  GridInpMatrix.ColWidths[0] := WMax;
  GridInverse.ColWidths[0]   := WMax;

  WMax:= GC_MinCellWidth;
  HMax:= GC_MinSBHeight;
  with GridInpMatrix do
    for c:= 1 to NRow do for r:= 0 to NRow do begin
      WMax:= imax(WMax,Canvas.TextWidth(Cells[c,r])+10);
      HMax:= imax(HMax,Canvas.TextHeight(Cells[c,r])+4);
    end;
  with GridInverse do
    for c:= 1 to NRow do for r:= 0 to NRow do begin
      WMax:= imax(WMax,Canvas.TextWidth(Cells[c,r])+10);
      HMax:= imax(HMax,Canvas.TextHeight(Cells[c,r])+4);
    end;
  for c:= 1 to NRow do begin
    GridInpMatrix.ColWidths[c] := WMax;
    GridInverse.ColWidths[c]   := WMax;
  end;
  for r:= 0 to NRow do begin
    GridInpMatrix.RowHeights[r]:= HMax;
    GridInverse.RowHeights[r]  := HMax;
  end;

  WMax:= GC_MinCellWidth;
  for r:= 0 to NRow do begin
    with GridInpVector do WMax:= imax(WMax,Canvas.TextWidth(Cells[0,r])+10);
    with GridSolution  do WMax:= imax(WMax,Canvas.TextWidth(Cells[0,r])+10);
  end;
  GridInpVector.ColWidths[0] := WMax;
  GridSolution.ColWidths[0]  := WMax;

  WMax:= GC_MinCellWidth;
  with GridInpVector do for r:= 0 to NRow do
    WMax:= imax(WMax,Canvas.TextWidth(Cells[1,r])+10);
  with GridSolution  do for r:= 0 to NRow do
    WMax:= imax(WMax,Canvas.TextWidth(Cells[1,r])+10);
  GridInpVector.ColWidths[1] := WMax;
  GridSolution.ColWidths[1]  := WMax;
  for r:= 0 to NRow do begin
    GridInpVector.RowHeights[r]:= HMax;
    GridSolution.RowHeights[r]  := HMax;
  end;

  with StatusBar do begin
    HMax:= GC_MinSBHeight;
    for c:= 0 to 3 do begin
      Panels[c].Width := imax(
        GC_MinSBPanelW,Canvas.TextWidth(Panels[c].Text)+10);
      HMax:= imax(HMax,Canvas.TextHeight(Panels[c].Text)+6);
    end;
    StatusBar.Height:= HMax;
  end;
end end;

procedure TMainWindow.AdjustData;
begin if GV_FormReady then begin
  EdtActive          := false;
  EditRowCount.Value := NRow;
  EdtActive          := true;
  case GrpNumDisplay.ItemIndex of
    0 : NumFormat    := ffGeneral;
    1 : NumFormat    := ffExponent;
    2 : NumFormat    := ffNumber;
  end;
  DisplayInput;
  DisplayResult;
end end;

procedure TMainWindow.GaussJordan;
var r,s,t: integer; c,h,j: integer; d,q: T_MatElm;
begin
  Solved:= false;
  { copy the input data into the left part of the solve matrix }
  for r:= 1 to NRow do for c:= 1 to NRow+1 do
    SolveMat[r,c]:= InputMat[r,c];
  { initialize the inverse as an identity matrix}
  j:= Succ(NRow);
  for r:= 1 to NRow do begin
    Inc(j);
    for c:= NRow+2 to 2*NRow+1 do
    if c=j then SolveMat[r,c]:= 1.0 else SolveMat[r,c]:= 0.0;
  end;
  { solve }
  Determnt:= 1.0; Solved:= true;
  for r:= 1 to NRow do if Solved then begin
    { -- pivot r normalization -- }
    j:= 2*NRow+1;
    d:= SolveMat[r,r]; if d = 0.0 then Solved:= false;
    if Solved then begin
      Determnt:= Determnt * d;
      for h:= 1 to j do SolveMat[r,h]:= SolveMat[r,h] / d;
      { -- non-pivot r reduction -- }
      for s:= 1 to NRow do begin
        q:= SolveMat[s,r];
        if s<>r then for t:= 1 to j do
           SolveMat[s,t]:= SolveMat[s,t] - q*SolveMat[r,t];
      end;
    end;
  end;
end;


{ Generated }

procedure TMainWindow.FormCreate(Sender: TObject);
begin
  GridInverse.Selection  := TGridRect(Rect(-1,-1,-1,-1));
  GridSolution.Selection := TGridRect(Rect(-1,-1,-1,-1));
  SL:= TStringList.Create;
  Icon:= Application.Icon;
  Application.OnIdle:= OnIdle;
  ApplyFont;
end;

procedure TMainWindow.FormShow(Sender: TObject);
var i: integer;
begin
  NRow     := GC_DflRow;
  Solved   := false;
  EdtActive:= true;
  GV_SettingFnm:= ChangeFileExt(Application.ExeName,GC_SettingExt);
  ReadOptions;
  SetLanguage(GV_Language);
(*
  GridInpMatrix.ColWidths[0]  := 20;
  GridInverse.ColWidths[0]    := 20;
  GridInpVector.ColWidths[0]  := 40;
  GridSolution.ColWidths[0]   := 40;
*)
  for i:= 1 to GC_MaxRow do begin
    if i = NRow then
      GridInpMatrix.Cells[i,0]:= '* X'+IntToStr(i)
    else
      GridInpMatrix.Cells[i,0]:= '* X'+IntToStr(i)+' +';
    GridInpMatrix.Cells[0,i]  := IntToStr(i);
    GridInpVector.Cells[0,i]  := ' =';
    GridInverse.Cells[i,0]    := IntToStr(i);
    GridInverse.Cells[0,i]    := IntToStr(i);
    GridSolution.Cells[0,i]   := 'X'+IntToStr(i)+'=';
  end;
  GV_FormReady:= true;
  InitInputMatrix;
  AdjustControls;
  AdjustData;
end;

procedure TMainWindow.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  CanClose:= WriteOptions;
end;

procedure TMainWindow.MnuFileClick(Sender: TObject);
begin
  MnuFileNew.Caption    := S(SI_MnuFNew     );
  MnuFileOpen.Caption   := S(SI_MnuFOpen    );
  MnuFileSave.Caption   := S(SI_MnuFSave    );
  MnuFileSaveAs.Caption := S(SI_MnuFSaveAs  );
  MnuFileExit.Caption   := S(SI_MnuFExit    );
  MnuFileSave.Enabled   := FileName <> '';
end;

procedure TMainWindow.MnuFileNewClick(Sender: TObject);
begin
  InitInputMatrix;
  FileName:= '';
  GaussJordan;
  AdjustControls;
  AdjustData;
end;

procedure TMainWindow.MnuFileOpenClick(Sender: TObject);
var f: TextFile; r,c,n: integer; ok: boolean;
begin
  DlgFileOpen.FileName := FileName;
  if DlgFileOpen.Execute then begin
    ok:= false;
    SetCursor(crHourGlass);
    try
      AssignFile(f,DlgFileOpen.FileName); Reset(f);
      try
        Read(f,n);
        if (n >= 2) and (n <= GC_MaxRow) then begin
          NRow:= n;
          for r:= 1 to n do for c:= 1 to n do
            Read(f,InputMat[r,c]);
          for r:= 1 to n do Read(f,InputMat[r,n+1]);
          ok:= true;
        end;
      finally CloseFile(f); end;
    finally RestoreCursor; end;
    if ok then begin
      FileName:= DlgFileOpen.FileName;
      GaussJordan; if not Solved then ShowMessage(S(SI_NotSolved));
      AdjustControls;
      AdjustData;
    end
    else ShowMessage(S(SI_ErrData));
  end;
end;

procedure TMainWindow.MnuFileSaveClick(Sender: TObject);
begin DoFileSave; end;

procedure TMainWindow.MnuFileSaveAsClick(Sender: TObject);
begin
  DlgFileSave.FileName := FileName;
  if DlgFileSave.Execute then begin
    FileName:= DlgFileSave.FileName;
    DoFileSave;
  end;
end;

procedure TMainWindow.MnuFileExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainWindow.MnuOptionsClick(Sender: TObject);
begin
  MnuOptToolBar.Caption  := S(SI_MnuOToolbar );
  MnuOptHints.Caption    := S(SI_MnuOHints   );
  MnuOptFont.Caption     := S(SI_MnuOFont    );
  MnuOptLanguage.Caption := S(SI_MnuOLanguage);
  MnuOptToolbar.Checked  := Toolbar.Visible;
  MnuOptHints.Enabled    := Toolbar.Visible;
  if MnuOptHints.Enabled then
    MnuOptHints.Checked  := ShowHint
  else
    MnuOptHints.Checked  := false;
end;

procedure TMainWindow.MnuOptToolBarClick(Sender: TObject);
begin
  Toolbar.Visible:= not Toolbar.Visible;
end;

procedure TMainWindow.MnuOptHintsClick(Sender: TObject);
begin
  ShowHint:= not ShowHint;
  AdjustControls;
end;

procedure TMainWindow.MnuOptFontClick(Sender: TObject);
begin
  if DlgFont.Execute then begin ApplyFont; AdjustData; end;
end;

procedure TMainWindow.MnuOptLanguageClick(Sender: TObject);
begin
  MnuOptLngUS.Caption    := S(SI_MnuOLngUS   );
  MnuOptLngNL.Caption    := S(SI_MnuOLngNL   );
end;

procedure TMainWindow.MnuOptLngNLClick(Sender: TObject);
begin
  DecimalSeparator:= ',';
  SetLanguage(lng_NL);
end;

procedure TMainWindow.MnuOptLngUSClick(Sender: TObject);
begin
  DecimalSeparator:= '.';
  SetLanguage(lng_US);
end;

procedure TMainWindow.MnuHelpClick(Sender: TObject);
begin
  MnuHelpAbout.Caption   := S(SI_MnuHAbout   );
end;

procedure TMainWindow.MnuHelpAboutClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainWindow.DlgFontApply(Sender: TObject; Wnd: Integer);
begin ApplyFont; AdjustData; end;

procedure TMainWindow.EditRowCountChange(Sender: TObject);
begin if EdtActive then begin
  NRow                := EditRowCount.Value;
  GridInpMatrix.RowCount  := NRow+1;
  GridInpMatrix.ColCount  := NRow+2;
  GridInverse.RowCount:= NRow+1;
  GridInverse.ColCount:= NRow+1;
  DisplayInput;
  DisplayResult;
end end;

procedure TMainWindow.GridInpMatrixGetEditText(Sender: TObject; ACol,
  ARow: Integer; var Value: String);
begin
  Value:= NumberStr(InputMat[ARow,ACol]);
end;

procedure TMainWindow.GridInpMatrixSetEditText(Sender: TObject; ACol,
  ARow: Integer; const Value: String);
begin
  try InputMat[Arow,ACol]:= StrToFloat(Value);
  except on EConvertError do {PM} end;
end;

procedure TMainWindow.GridInpVectorGetEditText(Sender: TObject; ACol,
  ARow: Integer; var Value: String);
begin
  Value:= NumberStr(InputMat[ARow,NRow+1]);
end;

procedure TMainWindow.GridInpVectorSetEditText(Sender: TObject; ACol,
  ARow: Integer; const Value: String);
begin
  try InputMat[Arow,NRow+1]:= StrToFloat(Value);
  except on EConvertError do {PM} end;
end;

procedure TMainWindow.GrpDecSepClick(Sender: TObject);
const DecimalSepStr = '.,'; ThousandSepStr = ',.';
begin with GrpDecSep do begin
  if ItemIndex > -1 then begin
    DecimalSeparator  := DecimalSepStr [ItemIndex+1];
    ThousandSeparator := ThousandSepStr[ItemIndex+1];
  end;
  DisplayInput;
  DisplayResult;
end end;

procedure TMainWindow.HSplitterMoved(Sender: TObject);
begin
  AdjustPaneWidth;
end;

procedure TMainWindow.FormResize(Sender: TObject);
begin
  AdjustPaneWidth;
end;

procedure TMainWindow.BtnSolveClick(Sender: TObject);
begin
  GaussJordan; if not Solved then ShowMessage(S(SI_NotSolved));
  AdjustData;
end;

procedure TMainWindow.GrpNumDisplayClick(Sender: TObject);
begin
  AdjustControls;
  AdjustData;
end;

procedure TMainWindow.EditPrecisionChange(Sender: TObject);
begin
  AdjustData;
end;

procedure TMainWindow.EditDigitsChange(Sender: TObject);
begin
  AdjustData;
end;

procedure TMainWindow.InpSplitterMoved(Sender: TObject);
begin
  GrpSolution.Width:= GrpInpVector.Width;
end;

procedure TMainWindow.OutSplitterMoved(Sender: TObject);
begin
  GrpInpVector.Width:= GrpSolution.Width;
end;

procedure TMainWindow.FormDestroy(Sender: TObject);
begin
  Application.OnIdle:= nil;
end;

procedure TMainWindow.StatusBarDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
var W,X: Integer;
begin
  W:= StatusBar.Canvas.TextWidth(Panel.Text);
  if W+10 > Panel.Width then Panel.Width:= W+10;
  with Rect do case panel.Alignment of
    taCenter       : X:= (Panel.Width-W) div 2;
    taRightJustify : X:= Right - W;
    else             X:= Left;
  end;
  StatusBar.Canvas.TextOut(X,Rect.Top,Panel.Text);
end;

end.
