{ General }
unit gjmatd0;

interface

uses
  SysUtils, WinProcs, Classes, Controls, Graphics, Forms, Dialogs,
  IniFiles;

const
  { global constants : general }
  GC_ProgIdn     = 'GJMATD';
  GC_ProgVers    = 'v1.0';
  GC_ProgTarget  = 'Windows 95';
  GC_Copyright   = 'Copyright  2000, J.R. Ferguson';
  GC_Email       = 'j.r.ferguson@iname.com';
  GC_Website     = 'http://hello.to/ferguson';
  GC_LinkEmail   = true;
  GC_LinkWebsite = true;
  GC_SettingExt  = '.ini';
  GC_MinWinWidth = 600;
  GC_MinWinHeight= 388;
  GC_MinInpHeight= 144;
  GC_MinResHeight= 144;
  GC_MinVecWidth = 120;
  GC_MinMatWidth = 144;
  GC_MinCellWidth=  20;
  GC_MinSBHeight =  19;
  GC_MinSBPanelW =  50;

  GC_DflRow      = 3;
  GC_MaxRow      = 25;
  GC_MaxInpCol   = GC_MaxRow+1;
  GC_MaxSlvCol   = 2*GC_MaxRow+1;
  GC_MinExpDigits= 1; GC_MaxExpDigits=  3; GC_DflExpDigits= 2;
  GC_MinDecDigits= 0; GC_MaxDecDigits= 18; GC_DflDecDigits= 4;

type
  T_Language     = (lng_US,lng_NL);
  T_MatElm       = Extended;
  T_InputMatrix  = array[1..GC_MaxRow,1..GC_MaxInpCol] of T_MatElm;
  T_SolveMatrix  = array[1..GC_MaxRow,1..GC_MaxSlvCol] of T_MatElm;

  { String list indexes for language dependant texts }
  T_SL_Index     = (
    SI_ProgDate    ,
    SI_ProgTitle   ,
    SI_About       ,
    SI_ErrEmail    ,
    SI_ErrURL      ,
    SI_ErrData     ,
    SI_ErrSave     ,
    SI_NotSolved   ,
    SI_MnuFile     ,
    SI_MnuFNew     ,
    SI_MnuFOpen    ,
    SI_MnuFSave    ,
    SI_MnuFSaveAs  ,
    SI_MnuFExit    ,
    SI_MnuOptions  ,
    SI_MnuOToolbar ,
    SI_MnuOHints   ,
    SI_MnuOFont    ,
    SI_MnuOLanguage,
    SI_MnuOLngUS   ,
    SI_MnuOLngNL   ,
    SI_MnuHelp     ,
    SI_MnuHAbout   ,
    SI_HintNew     ,
    SI_HintOpen    ,
    SI_HintSave    ,
    SI_HintExit    ,
    SI_HintHints   ,
    SI_HintFont    ,
    SI_HintHelp    ,
    SI_HintLngUS   ,
    SI_HintLngNL   ,
    SI_TtlOpen     ,
    SI_TtlSaveAs   ,
    SI_TtlInpMatrix,
    SI_TtlInpVector,
    SI_TtlResMatrix,
    SI_TtlResVector,
    SI_TtlDeterm   ,
    SI_TtlFileName ,
    SI_LblSolve    ,
    SI_LblRowCount ,
    SI_LblNumDispl ,
    SI_NumDGeneral ,
    SI_NumDExponent,
    SI_NumDFixed   ,
    SI_LblPrecision,
    SI_LblExpDigits,
    SI_LblDecDigits,
    SI_LblDecPt    ,
    SI_DecPtDot    ,
    SI_DecPtCommma ,
    SI_FileFilt1   ,
    SI_FileFilt2   );

const
  GV_Language    : T_Language = lng_US;
  GV_FormReady   : boolean = false;

var
  GV_SettingFnm  : String;
  SL             : TStringList;

procedure SetCursor(V_NewCursor: TCursor);
procedure RestoreCursor;
procedure ReadOptions;
function  WriteOptions: boolean;
function  S(V_Index: T_SL_Index): String;


implementation

Uses gjmatd1;

var
  OldCursor: TCursor;


procedure SetCursor(V_NewCursor: TCursor);
begin OldCursor:= Screen.Cursor; Screen.Cursor:= V_NewCursor; end;

procedure RestoreCursor;
begin Screen.Cursor:= OldCursor; end;

procedure ReadOptions;
var Bold, Italic: boolean; IniFile: TIniFile;
begin
  SetCursor(crHourglass); IniFile:= TIniFile.Create(GV_SettingFnm);
  if IniFile <> nil then with IniFile, MainWindow do try
    Left   := ReadInteger     ('Position','Left'     ,Left);
    Top    := ReadInteger     ('Position','Top'      ,Top);
    Width  := ReadInteger     ('Position','Width'    ,Width);
    Height := ReadInteger     ('Position','Height'   ,Height);
    with PnlInput do
     Height:= ReadInteger     ('Position','InpHeight',Height);
    with DlgFont.Font do begin
      Name    := ReadString   ('Font'    ,'Name'     ,Name);
      Size    := ReadInteger  ('Font'    ,'Size'     ,Size);
      Color   := ReadInteger  ('Font'    ,'Color'    ,Color);
      Bold    := ReadBool     ('Font'    ,'Bold'     ,fsBold   in Style);
      Italic  := ReadBool     ('Font'    ,'Italic'   ,fsItalic in Style);
      Style   := [];
      if Bold   then Style := Style + [fsBold];
      if Italic then Style := Style + [fsItalic];
      ApplyFont;
    end;
    with Toolbar do
      Visible :=   ReadBool   ('Options' ,'Toolbar'  ,Visible);
    with MainWindow do
      ShowHint :=  ReadBool   ('Options' ,'Hints'    ,ShowHint);
    GV_Language:=
      T_Language(  ReadInteger('Options' ,'Language' ,ord(GV_Language)));
    EditRowCount.Value:=
                   ReadInteger('Options' ,'RowCount' ,EditRowCount.Value);
    GrpNumDisplay.ItemIndex:=
                   ReadInteger('Options' ,'NumDispl' ,GrpNumDisplay.ItemIndex);
    EditPrecision.Value:=
                   ReadInteger('Options' ,'Precision',EditPrecision.Value);
    EditDigits.Value:=
                   ReadInteger('Options' ,'Digits'   ,EditDigits.Value);
    DecimalSeparator:=
                   ReadString ('Options' ,'DecSep'   ,DecimalSeparator)[1];
  finally IniFile.Free; RestoreCursor; end;
end;

function  WriteOptions: boolean;
var IniFile: TIniFile;
begin
  Result:= true;
  SetCursor(crHourglass); IniFile:= TIniFile.Create(GV_SettingFnm);
  if IniFile <> nil then with IniFile, MainWindow do try try
    WriteInteger  ('Position','Left'     ,Left);
    WriteInteger  ('Position','Top'      ,Top);
    WriteInteger  ('Position','Width'    ,Width);
    WriteInteger  ('Position','Height'   ,Height);
    with PnlInput do
      WriteInteger('Position','InpHeight',Height);
    with DlgFont.Font do begin
      WriteString ('Font'    ,'Name'     ,Name);
      WriteInteger('Font'    ,'Size'     ,Size);
      WriteInteger('Font'    ,'Color'    ,Color);
      WriteBool   ('Font'    ,'Bold'     ,fsBold   in Style);
      WriteBool   ('Font'    ,'Italic'   ,fsItalic in Style);
    end;
    WriteBool     ('Options' ,'Toolbar'  ,Toolbar.Visible);
    WriteBool     ('Options' ,'Hints'    ,MainWindow.ShowHint);
    WriteInteger  ('Options' ,'Language' ,ord(GV_Language));
    WriteInteger  ('Options' ,'RowCount' ,EditRowCount.Value);
    WriteInteger  ('Options' ,'NumDispl' ,GrpNumDisplay.ItemIndex);
    WriteInteger  ('Options' ,'Precision',EditPrecision.Value);
    WriteInteger  ('Options' ,'Digits'   ,EditDigits.Value);
    WriteString   ('Options' ,'DecSep'   ,DecimalSeparator);
  finally IniFile.Free; RestoreCursor; end;
  except on E: Exception do
    Result:= MessageDlg(E.Message,mtError,mbOKCancel,0) = mrOk; end;
end;

function  S(V_Index: T_SL_Index): String;
begin Result:= SL[ord(V_Index)]; end;

end.

