program Fortune_for_Dos; { 10,111 Kbytes }
{      Ŀ                         }
{       This program was created by Bartha Istvn     Email: bico@k.ro     }
{                               }
{                                                                            }
{ To run this program correctly you will need *.for files wich are actually  }
{ simple ascii files ( messages have to be separated with the '%' sign );    }
{                                                                            }
{ This is FREEWARE. No guarantees whatsoever. You may change it, use it,     }
{ copy it, anything you like;                                                }

uses Dos,Crt;                     { Basic units: they don't need much memory }

var  for_file:file;                       { Fortune file (*.for) variable  }
     for_vec:array[1..100]of string[12];  { Vector of the fortune files    }
     data:array[1..32000] of byte;        { Vector of the input data       }
     numread:word;                        { Number of read bytes variable  }
     cnt:integer;                         { Counter in some simple cycles  }
     for_name:SearchRec;                  { Fortune file's name variable   }
     fortune_file:string[100];            { Fortune file's real name & ext }
     for_cnt:integer;                     { Fortune file counter variable  }
     chk_file:text;                       { Fortune file checker variable  }
     log_file:text;                       { Fortune message entry file     }
     let0,let1:char;                      { The in/output letter variables }
     msg_cnt:string[20];                  { Fortune message counter string }
     message_cnt:integer;                 { Fortune message counter        }
     read_cnt:longint;                    { Counter of the reading cycle   }
     message_pos:longint;                 { Message position variable      }
     chosen_nr:integer;                   { Chosen fortune message number  }
     y:integer;                           { The y coordinate variable      }
     create:integer;                      { Create *.log switch 0=off 1=on }
     verbose:integer;                     { Verbose mode switch 0=off 1=on }
     nologf:integer;                      { No log file 0=false 1=true     }
     dir:DirStr;nm:NameStr;ext:ExtStr;    { *.for file directory,name,ext. }


procedure PARAMCHECK; { ->>> Analyze command line parameters............... }
begin
for_cnt:=0;verbose:=0;create:=0;          { - reset variables for new usage }

  if(Paramstr(1)='/?')or(Paramstr(1)='?')or(Paramstr(1)='h')then
  begin
    writeln;
    writeln(' Fortune version 1.1 (for Dos) by Bartha Istvn ');   { - Help }
    writeln(' USAGE: fortune -create -verbose < filenm.for > ');
    writeln('        Note: if you run it without a filename, ');
    writeln('        then it will search for  fortune files, ');
    writeln('        and it will randomly choose one.        ');
    writeln(' TIPS:  Insert ''fortune'' into your autoexec.bat ');
    writeln('        Create your own fortune files (*.for) ! ');
    writeln;HALT;
  end;

if(ParamCount=1)or(ParamCount=2)or(ParamCount=3)then    { - too complicated }
begin
  if(Paramstr(1)='-verbose')or(Paramstr(2)='-verbose')then verbose:=1;
  if(Paramstr(1)='-create')or(Paramstr(2)='-create')then create:=1;
  if(Paramstr(1)<>'-verbose')and(Paramstr(1)<>'-create')then
                                            fortune_file:=Paramstr(1);
  if(ParamCount=2)or(ParamCount=3)then
  begin
    if(Paramstr(2)<>'-verbose')and
      (Paramstr(2)<>'-create')then fortune_file:=Paramstr(2);
  end;
  if Paramstr(3)<>''then fortune_file:=Paramstr(3);
end;

if ParamCount>3 then
begin
  writeln('This is not your ''lucky'' day:  Invalid nr. of parameters !');HALT;
end;
end;

procedure IO; begin If IOresult<>0 then delay(0); end;


procedure CHKFORFILE; { ->>> Check the fortune file (*.for)................ }
label 1;
begin
Fsplit(fortune_file,dir,nm,ext);            { - getting the file components }

if nm='' then                               { - if no filename or just path }
begin
  FindFirst(dir+'*.for',Archive,for_name);         { - find the *.FOR files }
  while DosError=0 do                          { - if it found a *.FOR file }
  begin
    for_cnt:=for_cnt+1;
    for_vec[for_cnt]:=for_name.name;               { - put file into vector }
    FindNext(for_name);                  { - search for the next *.FOR file }
  end;
  fortune_file:=dir+for_vec[random(for_cnt)+1];     { - choose fortune file }
  if fortune_file='' then
  begin
    writeln('This is not your ''lucky'' day:  No fortune file found !');HALT;
  end else goto 1;
end;

{$I-}Close(chk_file);{$I+}IO;
assign(chk_file,fortune_file);
{$I-}reset(chk_file);{$I+}if IOresult<>0 then       { - check if file exist }
begin
  writeln('This is not your ''lucky'' day:  Fortune file not found !');HALT;
end;
1:
end;


procedure CHKLOGFILE; { ->>> Check for the *.log file ..................... }
var code:integer;
begin nologf:=0;

Fsplit(fortune_file,dir,nm,ext);            { - getting the file components }

{$I-}Close(chk_file);{$I+}IO;
assign(chk_file,nm+'.LOG');
{$I-}reset(chk_file);{$I+}if IOresult<>0 then nologf:=1;

if nologf=0 then                    { - if there's a logfile then read data }
begin
{ Verbose } if verbose=1 then writeln('Reading: ',nm,'.LOG');{}
  readln(chk_file,msg_cnt);val(msg_cnt,message_cnt,code);
end;
end;


procedure COUNTFM; { ->>> Procedure for Counting the Fortune Messages...... }
label 1;
begin

{ Verbose } if verbose=1 then
            begin
              writeln('Reading: ',fortune_file);
              write('Nr of entries: '); y:=WhereY;
            end;

if nologf=0 then begin if verbose=1 then write(message_cnt);goto 1; end;

{$I-}Close(for_file);{$I+}IO;
assign(for_file,fortune_file);
{$I-}reset(for_file,1);{$I+}IO;                               { - open file }

message_cnt:=0;cnt:=0;                    { - reset variables for new usage }
repeat
  Blockread(for_file,data,sizeof(data),numread);         { - read some data }
  for cnt:=1 to numread do
  if(data[cnt]=37)and(data[cnt+1]=13)then { - if '%' sign and newline found }
  begin
    inc(message_cnt);                          { - increase message counter }
{ Verbose } if verbose=1 then begin gotoxy(16,y);write(message_cnt); end;
  end;
until numread=0;     { - spin this cycle until there's nothing more to read }

{$I-}Close(for_file);{$I+}IO;

1:
if message_cnt=0 then
begin
  writeln('This is not your ''lucky'' day:  Not fortune type file !');HALT;
end;

if(nologf=1)and(create=1)then
begin
  {$I-}Close(log_file);  {$I+}IO;
  assign(log_file,nm+'.log');
  {$I-}rewrite(log_file);{$I+}IO;                   { - create the log-file }
  {$I-}append(log_file); {$I+}IO;
  writeln(log_file,message_cnt);              { - write message_cnt to file }
  {$I-}Close(log_file);  {$I+}IO;
end;

end;


procedure SHUFFLE; { ->>> Procedure for choosing a single fortune message.. }
begin
chosen_nr:=random(message_cnt)+1;
{ Verbose } if verbose=1 then
            begin writeln;write('Chosen number: ');y:=WhereY;end;{}
end;


procedure DISPLAY; { ->>> Procedure for Displaying the fortune message..... }
label 1;
begin

{$I-}Close(for_file);{$I+}IO;
assign(for_file,fortune_file);
{$I-}reset(for_file,1);{$I+}IO;                               { - open file }

message_cnt:=0;read_cnt:=0;               { - reset variables for new usage }
repeat
  read_cnt:=read_cnt+1;
  Blockread(for_file,data,sizeof(data),numread);         { - read some data }
  for cnt:=1 to numread do
  if(data[cnt]=37)and(data[cnt+1]=13)then { - if '%' sign and newline found }
  begin
    inc(message_cnt);                          { - increase message counter }
{ Verbose } if verbose=1 then begin gotoxy(16,y);write(message_cnt); end;
    if message_cnt=chosen_nr then goto 1;
  end;
1:
until(message_cnt=chosen_nr)or(numread=0);
                     { - until it gets to the chosen message or end of file }

message_pos:=(read_cnt-1)*sizeof(data)+cnt+1;{ - calculate message position }
{ Verbose } if verbose=1 then writeln;
Seek(for_file,message_pos);   { - jump back to the beginning of the message }

let1:=#0;                                  { - reset variable for new usage }
repeat
{ delay(70);             { - if you want a little extra then uncomment this }

  let0:=let1;                        { - save the old value of let1 to let0 }
  BlockRead(for_file,let1,1,numread);             { - read letter by letter }
  if(let0='%')and(let1=#13)then break;  { - exit if next message is reached }
  if let0<>#0 then
  asm
    MOV   AH,2
    MOV   DL,[let0]                  { - this almost equal to: write(let1); }
    INT   21H
  end;

{      NOTE:       I'm using these asm codes because the 'writeln' procedure
                   doesn't take care of the tab-sign(?), the nr 9 ASCII code,
                   and a correct procedure in pascal is quite long ( messy ),
                   so instead of using that method I will use this one which
                   will display the text correctly }

until numread=0;                         { - exit if end of file is reached }

writeln;
{$I-}Close(for_file);{$I+}IO;                    { - close the fortune file }
end;



begin

Randomize;       { For correct random calls - It has to be called only once }

PARAMCHECK;      { Analyze command line parameters }
CHKFORFILE;      { Check the fortune file ( *.for) }
CHKLOGFILE;      { Look for the *.log file ....... }

COUNTFM;         { Count the fortune messages..... }
SHUFFLE;         { Random seletion of a fortune message }
DISPLAY;         { Read file & display  the randomly chosen fortune message }

end.                                                              { THE END }
