VERSION 4.00
Begin VB.Form Logo 
   Appearance      =   0  'Flat
   AutoRedraw      =   -1  'True
   BackColor       =   &H80000005&
   Caption         =   "Virtual Logo"
   ClientHeight    =   4920
   ClientLeft      =   1605
   ClientTop       =   450
   ClientWidth     =   5820
   BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Height          =   5325
   Left            =   1545
   LinkTopic       =   "Form1"
   ScaleHeight     =   328
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   388
   Top             =   105
   Width           =   5940
   Begin VB.Line turtle 
      Index           =   0
      Visible         =   0   'False
      X1              =   104
      X2              =   104
      Y1              =   152
      Y2              =   168
   End
   Begin VB.Line turtle 
      Index           =   1
      X1              =   96
      X2              =   104
      Y1              =   160
      Y2              =   144
   End
   Begin VB.Line turtle 
      Index           =   4
      X1              =   104
      X2              =   112
      Y1              =   144
      Y2              =   160
   End
   Begin VB.Line turtle 
      Index           =   2
      X1              =   96
      X2              =   104
      Y1              =   160
      Y2              =   156
   End
   Begin VB.Line turtle 
      Index           =   3
      X1              =   104
      X2              =   112
      Y1              =   156
      Y2              =   160
   End
End
Attribute VB_Name = "Logo"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'================================================
'      Visual Basic VIRTUAL LOGO

'        (c) 1995 Tom Hollander
'         tholland@pcug.org.au
'    http://www.pcug.org.au/~tholland

' This code may be freely distributed and
' used in your own programs.

'             - PROVIDED -
' * you keep in this comment section, and
' * you add my name and e-mail to your credit
'   box / documentation to acknowledge my work!
'
' - November 1995
'==============================================

Dim x, y As Single
Dim heading As Single
Dim col, bgcol As Long
Const pi = 3.14159265358
Dim xcentre, ycentre As Integer

Sub Eyes(x!)
    Dim i!
    For i = 10 To x Step 10
        CIRCR i
        CIRCL i
    Next
End Sub

Private Sub ARCL(r!, t!)

' Draws an arc to the left of radius r pixels
' through t degrees of the circle

    For i! = 1 To t! / 5
        FD (2 * pi * r!) / 72
        LT 5
    Next
End Sub

Private Sub ARCR(r!, t!)

' Draws an arc to the right of radius r pixels
' through t degrees of the circle
    
   
    For i! = 1 To t! / 5
        FD (2 * pi * r!) / 72
        RT 5
    Next
End Sub

Private Sub BACK(n!)

' moves the turtle back n pixels

    BACK n!
End Sub


Private Sub BK(n!)

' moves the turtle back n pixels

    FD -n!
End Sub

Private Sub CIRCL(r!)

' draws a circle to the left of radius r pixels

    For i! = 1 To 36
        FD (2 * pi * r!) / 36
        LT 10
    Next
End Sub

Private Sub CIRCR(r!)

' draws a circle to the right of radius r pixels

    For i! = 1 To 36
        FD (2 * pi * r!) / 36
        RT 10
    Next
End Sub

Private Sub CS()

' clears the screen, recentres and homes the turtle

    Logo.Cls
    Logo.Picture = LoadPicture("")
    recentre
    HOME
End Sub


Private Function deg(rad As Single) As Single

' converts degrees to radians (keeping origin the same)

    deg = (180 * rad / pi)
End Function

Private Sub FD(n!)

' moves the turtle forward n pixels

    newx! = x + n! * Cos(rad(heading))
    newy! = y - n! * Sin(rad(heading))
    Line (xcentre + x, ycentre - y)-(xcentre + newx!, ycentre - newy!), col
    SETPOS newx!, newy!
    x = newx!
    y = newy!
End Sub

Private Sub Form_Load()
    col = QBColor(0)
    bgcol = QBColor(15)
    recentre
    HOME
    Logo.Show
    Salami = Eggplant / 0   ' <----
' This crash is deliberate!
' You must run Virtual logo from the Debug window.
' Hide this window and have fun!

End Sub

Private Sub FORWARD(n!)

' moves the turtle forward n pixels
    
    FD n!
End Sub

Private Sub HOME()

' moves the turtle to 0, 0 without drawing

    SETPOS 0, 0
    heading = 0

    turtle(0).X1 = xcentre + 0
    turtle(0).Y1 = ycentre + 0

    turtle(1).X1 = xcentre + 0: turtle(1).Y1 = ycentre - 10
    turtle(2).X1 = xcentre - 10: turtle(2).Y1 = ycentre + 10
    turtle(3).X1 = xcentre + 0: turtle(3).Y1 = ycentre + 5
    turtle(4).X1 = xcentre + 10: turtle(4).Y1 = ycentre + 10

    turtle(4).X2 = xcentre + 0: turtle(4).Y2 = ycentre - 10

    For i = 1 To 3
        turtle(i).X2 = turtle(i + 1).X1
        turtle(i).Y2 = turtle(i + 1).Y1
    Next

End Sub

Private Sub HT()

' hideturtle: makes the turtle invisible

    For i = 1 To 4
        turtle(i).Visible = False
    Next
 
End Sub

Private Sub LINETO(newx, newy As Single)

' moves the turtle to newx, newy

    xdist! = (newx - x)
    ydist! = (newy - y)

    If ydist! <> 0 Then
        angle! = Atn(xdist! / ydist!)
    Else
        angle! = Sgn(xdist!) * pi / 2
    End If
    If ydist! < 0 Then angle! = angle! + pi

    SETH deg(angle!)

    dist! = Sqr(xdist! ^ 2 + ydist! ^ 2)
    FD dist!
End Sub

Private Sub LOADPIC(file As String)

' loads the picture 'file'

    Logo.Picture = LoadPicture(file)
End Sub

Private Sub LT(t!)

' Left: rotates the turtle t degrees to the left

    Do While (heading - t!) > 360
        heading = heading - 360
    Loop
    Do While (heading - t!) < 0
        heading = heading + 360
    Loop
    SETH heading - t!
End Sub

Private Sub PD()

' Pendown: makes the turtle draw in the current colour

    Logo.DrawMode = 13
End Sub

Private Sub PE()
    
' Penerase: makes the turtle erase

    Logo.DrawMode = 16
End Sub

Private Sub PU()

' PenUp: makes the turtle do nothing when it moves

    Logo.DrawMode = 11
End Sub

Private Sub PX()

' PenReverse: makes the turtle invert the current colour

    Logo.DrawMode = 6
End Sub

Private Function rad(deg As Single) As Single

' converts degrees to radians

    rad = (deg - 90) * pi / 180
End Function

Private Sub recentre()

' resets (0,0) to the middle of the form

    xcentre = Int(Logo.Width / screen.TwipsPerPixelX) / 2
    ycentre = Int(Logo.Height / screen.TwipsPerPixelY) / 2
End Sub

Private Sub RT(t!)

' Right: turns the turtle t degrees to the right

    Do While (heading + t!) > 360
        heading = heading - 360
    Loop
    Do While (heading + t!) < 0
        heading = heading + 360
    Loop
    SETH heading + t!
End Sub

Private Sub SAVEPIC(file As String)

' saves the picture as a bitmap

    HT
    Logo.Refresh
    SavePicture image, file
    ST

End Sub

Private Sub SETBG(c%)

' sets the background colour to c (0 <= c <= 15)

    Logo.BackColor = QBColor(c%)
    bgcol = QBColor(c%)
    If col = bgcol Then
        linestyle = 3
        If c% < 15 Then tcol = QBColor(c% + 1) Else tcol = 0
    Else
        linestyle = 1
        tcol = col
    End If

    For i% = 1 To 4
        turtle(i%).BorderColor = tcol
        turtle(i%).BorderStyle = linestyle
    Next
End Sub

Private Sub SETH(t!)

' Setheading: makes the turtle face t degrees
' clockwise from straght up

    change! = -(heading! - t! - 90)
    For i = 4 To 0 Step -1
        a1! = (turtle(i).X1 - turtle(0).X1)
        a2! = (turtle(i).X2 - turtle(0).X1)
        b1! = (turtle(i).Y1 - turtle(0).Y1)
        b2! = (turtle(i).Y2 - turtle(0).Y1)
        
        newx1! = (a1! * Cos(rad(change!)) - b1! * Sin(rad(change!))) + turtle(0).X1
        newx2! = (a2! * Cos(rad(change!)) - b2! * Sin(rad(change!))) + turtle(0).X1
        newy1! = (a1! * Sin(rad(change!)) + b1! * Cos(rad(change!))) + turtle(0).Y1
        newy2! = (a2! * Sin(rad(change!)) + b2! * Cos(rad(change!))) + turtle(0).Y1

        turtle(i).X1 = newx1!
        turtle(i).X2 = newx2!
        turtle(i).Y1 = newy1!
        turtle(i).Y2 = newy2!
    Next

    heading = t!
 
End Sub

Private Sub SETPC(c%)

' SetPenColour - makes the turtle draw in the colour
' c (0 <= c <= 15)

    col = QBColor(c%)
    If col = bgcol Then
        linestyle = 3
        If c% < 15 Then tcol = QBColor(c% + 1) Else tcol = 0
    Else
        linestyle = 1
        tcol = col
    End If
    For i = 1 To 4
        turtle(i).BorderColor = tcol
        turtle(i).BorderStyle = linestyle
    Next
End Sub

Private Sub SETPOS(newx!, newy!)

' moves the turtle to (newx, newy) without drawing.

    For i = 4 To 0 Step -1
        turtle(i).X1 = xcentre + newx! + (turtle(i).X1 - turtle(0).X1)
        turtle(i).X2 = xcentre + newx! + (turtle(i).X2 - turtle(0).X1)
        turtle(i).Y1 = ycentre - newy! + (turtle(i).Y1 - turtle(0).Y1)
        turtle(i).Y2 = ycentre - newy! + (turtle(i).Y2 - turtle(0).Y1)
    Next
    x = newx!
    y = newy!
    Logo.Refresh
End Sub

Private Sub SETW(n%)

' setwidth: sets the turtle's drawing width to n pixels

    Logo.DrawWidth = n%
End Sub

Private Sub sq(t!)

' sample procedure Squiral
' draws a 'Squiral' with angles of t degrees

    For i! = 1 To 200
        FD i!
        RT t!
    Next
End Sub

Private Sub ST()

' ShowTurtle: makes the turtle visible

    For i = 1 To 4
        turtle(i).Visible = True
    Next
End Sub

Private Sub tree(n As Integer)

' sample recursive Tree procedure
' draws a tree of degree n

    If n = 0 Then Exit Sub
    LT 45
    FD 10
    tree (n - 1)
    BK 10
    RT 90
    FD 10
    tree (n - 1)
    BK 10
    LT 45
End Sub

Private Sub VANISH()

' Clears the screen without disturbing the turtle

    Logo.Picture = LoadPicture("")
    Logo.Cls
End Sub

