/* EASTER.C
 * This program was serendipitously stumbled upon in
 * "informal Introduction to ALGOL 68" by C. H. Lindsey
 * and S. G. Van Der Meulen, North-Holland, 1981. Pages
 * 287-291. Quotations in comments are from these pages
 * too. I have translated it to C and added error checking.
 * Deborah Pollard    May 1992
 */

 /*
  * "The Gregorian Calendar, insofar as it determines upon
  * which day each year shall start, is universally accepted
  * throughout the world. It also fixes the date of Easter
  * as being the next Sunday after the Paschall Full Moon,
  * which is intended to be the first full moon occurring on
  * or after the Vernal Equinox (March 21st). The rules given
  * for computing this are not so widely accepted. For example,
  * the Jewish Passover and the Orthodox Easter are determined
  * from different (and probably more accurate) calendars."
  *
  * "The defining document for these rules was written by one
  * Clavius under a commission from Pope Gregory XIII [1].
  * Absolute accuracy was not a prime consideration. The Full
  * Moon is considered to occur on the fourteenth day of the
  * lunar month (which commences with the new moon). The rule
  * was carefully devised so that the date predicted for its
  * new moon always fell on, or one or two days after, the
  * true mean new moon of the astronomers - but never before it.
  * This was to ensure that never, under any circumstances,
  * would the Christian Easter fall on the same day as the
  * Jewish Passover (notwithstanding which, this terrible
  * circumstance does occasionally arise, as in 1903)."
  *
  * "For further explanations, see [3] and [4]."
  *
  * [1] Christophorus Clavius. Kalendarium Gregorianum Perpetuum.
  *     Cum Privilegio Summi Pontificis Et Aliorum Principum.
  *     Rome, Ex Officina Dominicae Basae. MDLXXXII. Cum Licentia
  *     Superiorum.
  *
  *"A companion volume was also prepared, and published in 1603:"
  * [2] Christophorus Clavius. Romani Calendarii a Gregorio XIII.
  *     Pontifice Maximo restituti Explicato.
  *
  * [3] A. de Morgan. A Budget of Paradoxes. Longmans, Green & Co.
  *     1872.
  * [4] Sir Harris Nicolas. The Chronology of History, containing
  *     Tables, Calculations and Statements, indespensable for
  *     ascertaining the dates of Historical Events, and of Public
  *     and Private Documents from the earliest periods to the
  *     present time. Longman, Brown, Green and Longman's, 1838.
  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

static char *getmonth(), *getweekday();

main(argc, argv)
int argc;
char *argv[];
{
     char month[10], weekday[10];
     int century, clavius, *date, dominic, *easter, epact, golden;
     int leap, lilius, moon, *p, paschal, year;

/*"Reckon dates by the number of days since the start of the year"*/
     int march21st = 31 + 28 + 21;

/*"The Gregorian calendar was introduced into various parts of the
 * world at different dates. In the UK the year was 1752."        */
     int gregorystart = 1752;

     if (argc < 2)
     {
        printf("This program determines the date of Easter.\n\
\nInput the year of interest: ");
        scanf("%d", &year);
     }
     else
        sscanf(argv[1], "%d", &year);

CHECK:
     if (year < gregorystart)
     {
        printf("\nThe Gregorian calendar was not introduced until \
%d.\n\nPlease input a year between 1752 and 10000 AD: ", gregorystart);
        scanf("%d", &year);
        goto CHECK;
     }

     if (year > 10000)
     {
        printf("Please input a year between 1752 and 10000 AD: ");
        scanf("%d", &year);
        goto CHECK;
     }

     century = year / 100;
     /*"set leap = 1 for a leap year, and 0 otherwise:"*/
     leap = abs(!(year % 4) && (year % 100) || !(year % 400));


     if (leap)
        printf("\nThe year %d is a leap year.\n", year);
     else
        printf("\nThe year %d is not a leap year.\n", year);


/*"To calculate the day of the week corresponding to any date, we */
/* associate a Dominical Letter with each year, whose position    */
/* in the alphabet gives the date of the first Sunday in January."*/

     dominic = 7 - (year+year/4-century+century/4-1-leap)%7;
     switch (dominic)
     {
            case 1: printf("\nThe Dominical Letter is: A"); break;
            case 2: printf("\nThe Dominical Letter is: B"); break;
            case 3: printf("\nThe Dominical Letter is: C"); break;
            case 4: printf("\nThe Dominical Letter is: D"); break;
            case 5: printf("\nThe Dominical Letter is: E"); break;
            case 6: printf("\nThe Dominical Letter is: F"); break;
            case 7: printf("\nThe Dominical Letter is: G"); break;
            default: puts("Something's wrong!");
     }

     if (leap == 1)
     {
        switch ((dominic-2)%7+1)
        {
            case 1: puts("|A"); break;
            case 2: puts("|B"); break;
            case 3: puts("|C"); break;
            case 4: puts("|D"); break;
            case 5: puts("|E"); break;
            case 6: puts("|F"); break;
            case 7: puts("|G"); break;
            default: puts("Something's wrong!");
        }
     }

/*"The moon revolves around the earth once every 29.530588 days      */
/* 235 such lunations last just 1.5 hours less than 19 Julian years. */
/* The calendar is therefore based on a "Metonic" cycle of 19 years, */
/* each year in a cycle being allotted a "Golden Number" in the      */
/* range 1 to 19."                                                   */

   golden = year % 19 + 1;
   printf("\nThe Golden Number is %d.", golden);

/*"However, following this cycle indefinitely would introduce an    */
/* error of approximately 0.43 days per century. There is therefore */
/* a correction which, for convenience, is only allowed to change   */
/* at the end of a century."                                        */

   lilius = (century - century/4  /* for leap years omitted
            at the start of some centuries */

            - (century -(century-17)/25)/3 /* the 1.5 hours error   */

            -8) % 30;

/*"On the 1st of January of any year, the number of days since the  */
/* last new moon is given by the 'Epact'".                          */

   epact = (11 * (golden - 1) - lilius) % 30;
   printf("  The Epact is %d.\n", epact);

/* "If successive new moons were to occur every 30 days, then we   */
/* should be able to associate with each date a unique epact, one  */
/* less for each day modulo 30 (then that date would be a new moon */
/* in years with that epact). In fact, six times in the year (and  */
/* (once extra at the end of 19 years) we must have a lunation of  */
/* only 29 days, whereupon the sequence of epacts slips back a day */
/* and some date will have two epacts listed against it. These     */
/* dates have been carefully chosen (it is alleged) so as to       */
/* minimise the deviation from the true moon. One of them occurs   */
/* in February and so happenings in March occur exactly 59 days    */
/* after those in January (or 60 in a leap year, since the         */
/* intercalary day, if any, in February is automatically added to  */
/* the lunation in which it occurs). Therefore, there is a new     */
/* moon on:"                                                       */

   moon = 31 - epact + 59 + leap;

   if ((paschal = moon+13) < march21st+leap)
   {
      clavius = (golden > 11) ? 26 : 25;
      moon    = moon + ((epact >= clavius) ? 30 : 29);
      paschal = moon + 13;
   }

   date      = (int *) calloc(1, sizeof(int));
   easter    = (int *) calloc(1, sizeof(int));
   *date     = paschal;
   strcpy(weekday, getweekday(date, dominic));
   strcpy(month, getmonth(date, leap));
   printf("\nThe Paschal Full Moon falls upon %s %s %d.\n",
          weekday, month, *date);
   *easter = paschal+7-(paschal-dominic)%7;
   strcpy(month, getmonth(easter, leap));

   printf("\nEaster day, being the next Sunday after the \
Paschal Full Moon,\ntherefore falls upon %s %d.\n", month, *easter);

}
/********************************************************/
static char *getmonth(date, leap)  int *date, leap;

{
     if (*date <= 31)
        return("January");
     
     *date = *date-31;
     if ( *date <= (28 + leap))
            return("February");

     *date = *date -28 -leap;
     if (*date <= 31)
        return("March");

     *date = *date - 31;
     if (*date <= 30)
        return("April");

     *date = *date - 30;
     if (*date <= 31)
        return("May");

     *date = *date -31;
     if (*date <= 30)
        return("June");

     *date = *date -30;
     if (*date <= 31)
         return("July");

     *date = *date - 31;
     if (*date <= 31)
        return("August");

     *date = *date -31;
     if (*date <= 30)
        return("September");

     *date = *date - 30;
     if (*date <= 31)
        return("October");

     *date = *date - 31;
     if (*date <= 30)
        return("November");

     *date = *date - 30;
     return("December");
}
/***********************************************************/
static char *getweekday(date, dominic)  int *date, dominic;
{
   int dd;
   dd = *date;

       switch ((dd-dominic)%7+1)
       {      case 1: return("Sunday");
              case 2: return("Monday");
              case 3: return("Tuesday");
              case 4: return("Wednesday");
              case 5: return("Thursday");
              case 6: return("Friday");
              case 7: return("Saturday");
        }
}

