// TworesDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "TworesDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTworesDlg dialog


CTworesDlg::CTworesDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTworesDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTworesDlg)
	m_i = _T("");
	m_i1 = _T("");
	m_i2 = _T("");
	m_r = _T("");
	m_r1 = _T("");
	m_r2 = _T("");
	m_select = -1;
	m_serpar = -1;
	m_u = _T("");
	m_u1 = _T("");
	m_u2 = _T("");
	//}}AFX_DATA_INIT
}


void CTworesDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTworesDlg)
	DDX_Text(pDX, IDC_2RES_I, m_i);
	DDX_Text(pDX, IDC_2RES_I1, m_i1);
	DDX_Text(pDX, IDC_2RES_I2, m_i2);
	DDX_Text(pDX, IDC_2RES_R, m_r);
	DDX_Text(pDX, IDC_2RES_R1, m_r1);
	DDX_Text(pDX, IDC_2RES_R2, m_r2);
	DDX_Radio(pDX, IDC_2RES_RADIO1, m_select);
	DDX_Radio(pDX, IDC_2RES_SERPAR1, m_serpar);
	DDX_Text(pDX, IDC_2RES_U, m_u);
	DDX_Text(pDX, IDC_2RES_U1, m_u1);
	DDX_Text(pDX, IDC_2RES_U2, m_u2);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTworesDlg, CDialog)
	//{{AFX_MSG_MAP(CTworesDlg)
	ON_BN_CLICKED(ID_2RES_OK, On2resOk)
	ON_BN_CLICKED(ID_2RES_HELP, On2resHelp)
	ON_BN_CLICKED(IDC_2RES_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_2RES_RADIO2, Calcul)
	ON_BN_CLICKED(IDC_2RES_SERPAR1, Calcul)
	ON_BN_CLICKED(IDC_2RES_SERPAR2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CTworesDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CTworesDlg message handlers

void CTworesDlg::On2resOk() 
{
	CDialog::OnOK();	
}

void CTworesDlg::On2resHelp() 
{
	WinHelp(HPC_2RES,HELP_CONTEXT);	
}

void CTworesDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double r1,r2,r,u1,u2,u,i1,i2,i;

	// Read current values
	UpdateData(TRUE);
	r1=fabs(ToDouble(m_r1));
	r2=fabs(ToDouble(m_r2));
	r=fabs(ToDouble(m_r));
	u1=fabs(ToDouble(m_u1));
	u2=fabs(ToDouble(m_u2));
	u=fabs(ToDouble(m_u));
	i1=fabs(ToDouble(m_i1));
	i2=fabs(ToDouble(m_i2));
	i=fabs(ToDouble(m_i));

	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r1 & r2
		GetDlgItem(IDC_2RES_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_2RES_R2)->EnableWindow(TRUE);
		GetDlgItem(IDC_2RES_R)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_U1)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_U2)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_U)->EnableWindow(TRUE);
		GetDlgItem(IDC_2RES_I1)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_I2)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_I)->EnableWindow(FALSE);
		break;
	case 1:	// r & r1
		GetDlgItem(IDC_2RES_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_2RES_R2)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_R)->EnableWindow(TRUE);
		GetDlgItem(IDC_2RES_U1)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_U2)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_U)->EnableWindow(TRUE);
		GetDlgItem(IDC_2RES_I1)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_I2)->EnableWindow(FALSE);
		GetDlgItem(IDC_2RES_I)->EnableWindow(FALSE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r1&r2
		if (m_serpar==0)
		{ // Serial
			r=r1+r2;
			if (r>1e-12)
			{
				i1=i2=i=u/r;
				u1=i*r1;
				u2=i*r2;
			}
			else
				i1=i2=i=u1=u2=FLOATERR;
		}
		else
		{ // Parallel
			if ((r1>1e-12) && (r2>1e-12))
			{
				r=(r1*r2/(r1+r2));
				u1=u2=u;
				if (r>1e-12)
				{
					i1=u/r1;
					i2=u/r2;
					i=i1+i2;
				}
				else
					i1=i2=i=u1=u2=FLOATERR;
			}
			else
				r=i1=i2=i=u1=u2=FLOATERR;
		};
		break;
	case 1:	// r1&r
		if (m_serpar==0)
		{ // Serial
			if (r-r1>1e-12)
			{
				r2=r-r1;
				i1=i2=i=u/r;
				u1=i*r1;
				u2=i*r2;
			}
			else
				r2=i1=i2=i=u1=u2=FLOATERR;
		}
		else
		{ // Parallel
			if ((r1>1e-12) && (r1-r>1e-12))
			{
				r2=r1*r/(r1-r);
				u1=u2=u;
				if (r2>1e-12)
				{
					i1=u/r1;
					i2=u/r2;
					i=i1+i2;
				}
				else
					i1=i2=i=u1=u2=FLOATERR;
			}
			else
				r2=i1=i2=i=u1=u2=FLOATERR;
		};
		break;
	}

	// Put back calculated values
	m_r1=ToCString(r1);
	m_r2=ToCString(r2);
	m_r=ToCString(r);
	m_u1=ToCString(u1);
	m_u2=ToCString(u2);
	m_u=ToCString(u);
	m_i1=ToCString(i1);
	m_i2=ToCString(i2);
	m_i=ToCString(i);
	UpdateData(FALSE);
}

BOOL CTworesDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r1="2.2K";
	m_r2="1K";
	m_r="0";
	m_u1="0";
	m_u2="0";
	m_u="10";
	m_i1="0";
	m_i2="0";
	m_i="0";
	m_select=0;
	m_serpar=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
