// OhmslawDlg.cpp : implementation file
//

#include "stdafx.h"
#include "math.h"
#include "dynamicschem.h"
#include "OhmslawDlg.h"
#include "hlp/dynhlp.h"

#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COhmslawDlg dialog


COhmslawDlg::COhmslawDlg(CWnd* pParent /*=NULL*/)
	: CDialog(COhmslawDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(COhmslawDlg)
	m_i = _T("");
	m_p = _T("");
	m_r = _T("");
	m_select = -1;
	m_u = _T("");
	//}}AFX_DATA_INIT
}


void COhmslawDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COhmslawDlg)
	DDX_Text(pDX, IDC_OHMSLAW_I, m_i);
	DDX_Text(pDX, IDC_OHMSLAW_P, m_p);
	DDX_Text(pDX, IDC_OHMSLAW_R, m_r);
	DDX_Radio(pDX, IDC_OHMSLAW_RADIO1, m_select);
	DDX_Text(pDX, IDC_OHMSLAW_U, m_u);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COhmslawDlg, CDialog)
	//{{AFX_MSG_MAP(COhmslawDlg)
	ON_BN_CLICKED(IDHELP, OnHelp)
	ON_BN_CLICKED(ID_OHMSLAW_OK, OnOk)
		ON_BN_CLICKED(ID_OHMSLAW_HELP, OnHelp)
	ON_BN_CLICKED(IDC_OHMSLAW_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_OHMSLAW_RADIO2, Calcul)
	ON_BN_CLICKED(IDC_OHMSLAW_RADIO3, Calcul)
	ON_BN_CLICKED(IDC_OHMSLAW_RADIO4, Calcul)
	ON_BN_CLICKED(IDC_OHMSLAW_RADIO5, Calcul)
	ON_BN_CLICKED(IDC_OHMSLAW_RADIO6, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL COhmslawDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// COhmslawDlg message handlers

/////////////////////////////////////////////////////////////////////////////
// COhmslawDlg private procedures

void COhmslawDlg::Calcul()
{
	double r,u,i,p;

	// Read current values
	UpdateData(TRUE);
	r=fabs(ToDouble(m_r));
	u=fabs(ToDouble(m_u));
	i=fabs(ToDouble(m_i));
	p=fabs(ToDouble(m_p));

	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// R&I CWnd CDialog
		GetDlgItem(IDC_OHMSLAW_I)->EnableWindow(TRUE);
		GetDlgItem(IDC_OHMSLAW_U)->EnableWindow(FALSE);
		GetDlgItem(IDC_OHMSLAW_R)->EnableWindow(TRUE);
		GetDlgItem(IDC_OHMSLAW_P)->EnableWindow(FALSE);
		break;
	case 1:	// R&U
		GetDlgItem(IDC_OHMSLAW_I)->EnableWindow(FALSE);
		GetDlgItem(IDC_OHMSLAW_U)->EnableWindow(TRUE);
		GetDlgItem(IDC_OHMSLAW_R)->EnableWindow(TRUE);
		GetDlgItem(IDC_OHMSLAW_P)->EnableWindow(FALSE);
		break;
	case 2:	// R&P
		GetDlgItem(IDC_OHMSLAW_I)->EnableWindow(FALSE);
		GetDlgItem(IDC_OHMSLAW_U)->EnableWindow(FALSE);
		GetDlgItem(IDC_OHMSLAW_R)->EnableWindow(TRUE);
		GetDlgItem(IDC_OHMSLAW_P)->EnableWindow(TRUE);
		break;
	case 3:	// I&U
		GetDlgItem(IDC_OHMSLAW_I)->EnableWindow(TRUE);
		GetDlgItem(IDC_OHMSLAW_U)->EnableWindow(TRUE);
		GetDlgItem(IDC_OHMSLAW_R)->EnableWindow(FALSE);
		GetDlgItem(IDC_OHMSLAW_P)->EnableWindow(FALSE);
		break;
	case 4:	// I&P
		GetDlgItem(IDC_OHMSLAW_I)->EnableWindow(TRUE);
		GetDlgItem(IDC_OHMSLAW_U)->EnableWindow(FALSE);
		GetDlgItem(IDC_OHMSLAW_R)->EnableWindow(FALSE);
		GetDlgItem(IDC_OHMSLAW_P)->EnableWindow(TRUE);
		break;
	case 5:	// U&P
		GetDlgItem(IDC_OHMSLAW_I)->EnableWindow(FALSE);
		GetDlgItem(IDC_OHMSLAW_U)->EnableWindow(TRUE);
		GetDlgItem(IDC_OHMSLAW_R)->EnableWindow(FALSE);
		GetDlgItem(IDC_OHMSLAW_P)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// R&I
		u=r*i;
		p=r*i*i;
		break;
	case 1:	// R&U
		if (r<1e-12)
			i=p=FLOATERR;
		else
		{
			i=u/r;
			p=u*u/r;
		};
		break;
	case 2:	// R&P
		if (r<1e-12)
			i=FLOATERR;
		else
			i=sqrt(p/r);
		u=sqrt(r*p);
		break;
	case 3:	// I&U
		p=u*i;
		if (i<1e-12)
			r=FLOATERR;
		else
			r=u/i;
		break;
	case 4:	// I&P
		if (i<1e-12)
			u=r=FLOATERR;
		else
		{
			r=p/(i*i);
			u=p/i;
		}
		break;
	case 5:	// U&P
		if (p<1e-12)
			r=FLOATERR;
		else
			r=u*u/p;
		if (u<1e-12)
			i=FLOATERR;
		else
			i=p/u;
		break;
	}

	// Put back calculated values
	m_r=ToCString(r);
	m_u=ToCString(u);
	m_i=ToCString(i);
	m_p=ToCString(p);
	UpdateData(FALSE);
}


BOOL COhmslawDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_i="10m";
	m_p="0";
	m_r="1.2K";
	m_u="0";
	m_select=0;
	UpdateData(FALSE);
	Calcul();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}


void COhmslawDlg::OnHelp() 
{
	WinHelp (HPC_OHMSLAW,HELP_CONTEXT);
}

void COhmslawDlg::OnOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}
