// Convert.cpp : convert between float and engineering
// format CStrings ("123.45K")

#include "stdafx.h"
#include "math.h"
#include "Convert.h"

double ToDouble(CString s)
{
	double f=0.0;
	float ff=(float)0.0;
	double mult=1.0;
	char *ss;

	// Suppress ending blanks
	while ((s.GetLength() > 1) && (s[s.GetLength()-1]==' '))
			s=s.Left(s.GetLength()-1);
			
	if (s.IsEmpty())
		return 0.0;
	else
	{
		if (s.GetLength() > 1)
			switch(s[s.GetLength()-1])
		{
			case 'k':
			case 'K':
				mult=1e3;
				s=s.Left(s.GetLength()-1);
				break;
			case 'M':
				mult=1e6;
				s=s.Left(s.GetLength()-1);
				break;
			case 'm':
				mult=1e-3;
				s=s.Left(s.GetLength()-1);
				break;
			case '':
				mult=1e-6;
				s=s.Left(s.GetLength()-1);
				break;
			case 'n':
				mult=1e-9;
				s=s.Left(s.GetLength()-1);
				break;
			case 'p':
				mult=1e-12;
				s=s.Left(s.GetLength()-1);
				break;
			default :
				break;
		};
		ss=s.GetBuffer(20);
		sscanf(ss,"%f",&ff);
	}

	return ((double)ff*mult);
}

CString ToCString(double f)
{
	int n;
	CString s;

	if (f==FLOATERR)
	{
		return("Error");
	}
	else if (fabs(f)<1e-12)
		return ("0  ");
	else
	{
		n=(int)log10(fabs(f));
		if (fabs(f)<1.0-1e-12)
			n=n-1;
		n=3*((n+300)/3)-300;
		if (n<-12)
			n=(-12);
		if (n>6)
			n=6;
		f=f/pow(10.0,n);

		s.Format("%3.2f",f);
		switch (n)
		{
		case -12 :
			s=s+" p";
			break;
		case -9 :
			s=s+" n";
			break;
		case -6 :
			s=s+" ";
			break;
		case -3 :
			s=s+" m";
			break;
		case 0 :
			s=s+"  ";
			break;
		case 3 :
			s=s=s+" K";
			break;
		case 6 :
			s=s+" M";
			break;
		default :
			s=s+" ?";
			break;
		}

		return (s);
	};
};
