// CapfiltDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "CapfiltDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCapfiltDlg dialog


CCapfiltDlg::CCapfiltDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCapfiltDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCapfiltDlg)
	m_c = _T("");
	m_deltau = _T("");
	m_i = _T("");
	m_select = -1;
	m_rectmode = -1;
	//}}AFX_DATA_INIT
}


void CCapfiltDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCapfiltDlg)
	DDX_Text(pDX, IDC_CAPFILT_C, m_c);
	DDX_Text(pDX, IDC_CAPFILT_DELTAU, m_deltau);
	DDX_Text(pDX, IDC_CAPFILT_I, m_i);
	DDX_Radio(pDX, IDC_CAPFILT_RADIO1, m_select);
	DDX_Radio(pDX, IDC_CAPFILT_RECT1, m_rectmode);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCapfiltDlg, CDialog)
	//{{AFX_MSG_MAP(CCapfiltDlg)
	ON_BN_CLICKED(ID_CAPFILT_HELP, OnCapfiltHelp)
	ON_BN_CLICKED(ID_CAPFILT_OK, OnCapfiltOk)
	ON_BN_CLICKED(IDC_CAPFILT_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_CAPFILT_RADIO2, Calcul)
	ON_BN_CLICKED(IDC_CAPFILT_RADIO3, Calcul)
	ON_BN_CLICKED(IDC_CAPFILT_RECT1, Calcul)
	ON_BN_CLICKED(IDC_CAPFILT_RECT2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CCapfiltDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CCapfiltDlg message handlers

void CCapfiltDlg::OnCapfiltHelp() 
{
	WinHelp(HPC_CAPFILT,HELP_CONTEXT);	
}

void CCapfiltDlg::OnCapfiltOk() 
{
	CDialog::OnOK();	
}

void CCapfiltDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double c,i,deltau,k;

	// Read current values
	UpdateData(TRUE);
	c=fabs(ToDouble(m_c));
	i=fabs(ToDouble(m_i));
	deltau=fabs(ToDouble(m_deltau));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// deltau,i
		GetDlgItem(IDC_CAPFILT_C)->EnableWindow(FALSE);
		GetDlgItem(IDC_CAPFILT_I)->EnableWindow(TRUE);
		GetDlgItem(IDC_CAPFILT_DELTAU)->EnableWindow(TRUE);
		break;
	case 1:	// c,i
		GetDlgItem(IDC_CAPFILT_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_CAPFILT_I)->EnableWindow(TRUE);
		GetDlgItem(IDC_CAPFILT_DELTAU)->EnableWindow(FALSE);
		break;
	case 2:	// deltau,c
		GetDlgItem(IDC_CAPFILT_C)->EnableWindow(TRUE);
		GetDlgItem(IDC_CAPFILT_I)->EnableWindow(FALSE);
		GetDlgItem(IDC_CAPFILT_DELTAU)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	k=((m_rectmode==0) ? 4.5e-3 : 1.5e-3);
	switch(m_select)
	{
	case 0:	// u,deltau,i
		if((deltau>1e-12))
			c=k*i/deltau;
		else
			c=FLOATERR;
		break;
	case 1:	// u,c,i
		if((c>1e-12))
			deltau=k*i/c;
		else
			deltau=FLOATERR;
		break;
	case 2: // u,deltau,c
		i=deltau*c/k;
		break;
	}

	// Put back calculated values
	m_deltau=ToCString(deltau);
	m_c=ToCString(c);
	m_i=ToCString(i);
	UpdateData(FALSE);
}

BOOL CCapfiltDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_c="0";
	m_i="2";
	m_deltau="1";
	m_select=0;
	m_rectmode=1;
	UpdateData(FALSE);
	Calcul();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
