// AopsubDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "AopsubDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAopsubDlg dialog


CAopsubDlg::CAopsubDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAopsubDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAopsubDlg)
	m_g1 = _T("");
	m_g2 = _T("");
	m_r1 = _T("");
	m_r2 = _T("");
	m_r3 = _T("");
	m_select = -1;
	//}}AFX_DATA_INIT
}


void CAopsubDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAopsubDlg)
	DDX_Text(pDX, IDC_AOPSUB_G1, m_g1);
	DDX_Text(pDX, IDC_AOPSUB_G2, m_g2);
	DDX_Text(pDX, IDC_AOPSUB_R1, m_r1);
	DDX_Text(pDX, IDC_AOPSUB_R2, m_r2);
	DDX_Text(pDX, IDC_AOPSUB_R3, m_r3);
	DDX_Radio(pDX, IDC_AOPSUB_RADIO1, m_select);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAopsubDlg, CDialog)
	//{{AFX_MSG_MAP(CAopsubDlg)
	ON_BN_CLICKED(ID_AOPSUB_HELP, OnAopsubHelp)
	ON_BN_CLICKED(ID_AOPSUB_OK, OnAopsubOk)
	ON_BN_CLICKED(IDC_AOPSUB_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_AOPSUB_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CAopsubDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CAopsubDlg message handlers

void CAopsubDlg::OnAopsubHelp() 
{
	// TODO: Add your control notification handler code here
	WinHelp(HPC_AOPSUB,HELP_CONTEXT);
}

void CAopsubDlg::OnAopsubOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();
}

void CAopsubDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double r1,r2,r3,g1,g2;

	// Read current values
	UpdateData(TRUE);
	r1=fabs(ToDouble(m_r1));
	r2=fabs(ToDouble(m_r2));
	r3=fabs(ToDouble(m_r3));
	g1=fabs(ToDouble(m_g1));
	g2=fabs(ToDouble(m_g2));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r1,r2,r3
		GetDlgItem(IDC_AOPSUB_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSUB_R2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSUB_R3)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSUB_G1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AOPSUB_G2)->EnableWindow(FALSE);
		break;
	case 1:	// g1,g2,r2
		GetDlgItem(IDC_AOPSUB_R1)->EnableWindow(FALSE);
		GetDlgItem(IDC_AOPSUB_R2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSUB_R3)->EnableWindow(FALSE);
		GetDlgItem(IDC_AOPSUB_G1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPSUB_G2)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r1,r2,r3
		if ((r1>1e-12) && (r2>1e-12) && (r3>1e-12))
		{
			g1=(r1+r2)*r2/((r2+r3)*r1);
			g2=r2/r1;
		}
		else
			g1=g2=FLOATERR;
		break;
	case 1:	// g1,g2,r2
		if ((g1>1e-12) && (g2>1e-12) && (r2>1e-12))
		{
			r1=r2/g1;
			r3=(r1+r2)*r2/(g2*r1)-r2;
		}
		else
			r1=r3=FLOATERR;
		break;
	}

	// Put back calculated values
	m_r1=ToCString(r1);
	m_r2=ToCString(r2);
	m_r3=ToCString(r3);
	m_g1=ToCString(g1);
	m_g2=ToCString(g2);
	UpdateData(FALSE);

}

BOOL CAopsubDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r1="2.2k";
	m_r3="2.2k";
	m_r2="4.7k";
	m_g1="1";
	m_g2="1";
	m_select=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
