// AopnoninvDlg.cpp : implementation file
//

#include "stdafx.h"
#include "dynamicschem.h"
#include "AopnoninvDlg.h"
#include "math.h"
#include "hlp/dynhlp.h"
#include "Convert.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAopnoninvDlg dialog


CAopnoninvDlg::CAopnoninvDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAopnoninvDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAopnoninvDlg)
	m_g = _T("");
	m_r1 = _T("");
	m_r2 = _T("");
	m_select = -1;
	//}}AFX_DATA_INIT
}


void CAopnoninvDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAopnoninvDlg)
	DDX_Text(pDX, IDC_AOPNONINV_G, m_g);
	DDX_Text(pDX, IDC_AOPNONINV_R1, m_r1);
	DDX_Text(pDX, IDC_AOPNONINV_R2, m_r2);
	DDX_Radio(pDX, IDC_AOPNONINV_RADIO1, m_select);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CAopnoninvDlg, CDialog)
	//{{AFX_MSG_MAP(CAopnoninvDlg)
	ON_BN_CLICKED(ID_AOPNONINV_OK, OnAopnoninvOk)
	ON_BN_CLICKED(ID_AOPNONINV_HELP, OnAopnoninvHelp)
	ON_BN_CLICKED(IDC_AOPNONINV_RADIO1, Calcul)
	ON_BN_CLICKED(IDC_AOPNONINV_RADIO2, Calcul)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// Trick to eat returns in dialogs (see codeguru.com)
// Adapted for our needs...
BOOL CAopnoninvDlg::PreTranslateMessage(MSG *pMsg)
{
	// Update calculated fields if TAB is pressed
	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_TAB)
		Calcul();

	if (pMsg->message==WM_KEYDOWN && pMsg->wParam==VK_RETURN)
	{
		DWORD def_id=GetDefID();
		if (def_id != 0)
		{
			CWnd *wnd=FromHandle(pMsg->hwnd);
			char class_name[16];
			if (GetClassName(wnd->GetSafeHwnd(),class_name,sizeof(class_name)))
			{
				if (strnicmp(class_name,"edit",5)==0)
				{
					// Calculate the new values
					Calcul();

					// GetDlgItem(LOWORD(def_id))->SetFocus();
					return TRUE;
					// Discard the message !
				}
			}
		}
	}
	// be a good citizen - call the base class
	return CDialog::PreTranslateMessage(pMsg);
}

/////////////////////////////////////////////////////////////////////////////
// CAopnoninvDlg message handlers

void CAopnoninvDlg::OnAopnoninvOk() 
{
	// TODO: Add your control notification handler code here
	CDialog::OnOK();	
}

void CAopnoninvDlg::OnAopnoninvHelp() 
{
	// TODO: Add your control notification handler code here
	WinHelp(HPC_AOPNONINV,HELP_CONTEXT);	
}

void CAopnoninvDlg::Calcul() 
{
	// TODO: Add your control notification handler code here
	double r1,r2,g;

	// Read current values
	UpdateData(TRUE);
	r1=fabs(ToDouble(m_r1));
	r2=fabs(ToDouble(m_r2));
	g=fabs(ToDouble(m_g));
	
	// Put calculated fields unaccessible
	switch(m_select)
	{
	case 0:	// r1,r2
		GetDlgItem(IDC_AOPNONINV_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPNONINV_R2)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPNONINV_G)->EnableWindow(FALSE);
		break;
	case 1:	// r1,g
		GetDlgItem(IDC_AOPNONINV_R1)->EnableWindow(TRUE);
		GetDlgItem(IDC_AOPNONINV_R2)->EnableWindow(FALSE);
		GetDlgItem(IDC_AOPNONINV_G)->EnableWindow(TRUE);
		break;
	};

	// Calculate
	switch(m_select)
	{
	case 0:	// r1,r2
		if((r1>1e-12))
			g=(r1+r2)/r1;
		else
			g=FLOATERR;
		break;
	case 1:	// r1,g
		if (g>1)
		{
			r2=(g-1)*r1;
		}
		else
			r1=r2=FLOATERR;
		break;
	}

	// Put back calculated values
	m_r1=ToCString(r1);
	m_r2=ToCString(r2);
	m_g=ToCString(g);
	UpdateData(FALSE);

}

BOOL CAopnoninvDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_r1="2.2k";
	m_r2="4.7k";
	m_g="1";
	m_select=0;
	UpdateData(FALSE);
	Calcul();

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
