; wash2prg.asm
;
;Loc Obj        Source code
;==========================
;            ;  WASHING MACHINE (Version 2)
;            ; name and date
;            
;            ; constants
;              PORTA    EQU 6         
;              PORTB    EQU 7         
;              CONTROLPORT EQU 9      
;              START    EQU 1         
;              EMPTY    EQU 4         
;              FULL     EQU 8         
;               
00: 3A 83 09 ;          OUT CONTROLPORT,131 ; sets up 8255 i/o chip
03: 1B 3A    ; OUTERLOOP MOV B,DATA   ; address of data
05: 13       ; INNERLOOP MOV A,(B)    ; get data
06: 38 06    ;          OUT PORTA,A   ; send data to lights
;               
08: 61       ;          INC B         ; point to terminator
09: 13       ;          MOV A,(B)     ; get terminator
0A: 61       ;          INC B         ; point to next data
0B: FA 01    ;          CMP A,1       ; finished sequence?
0D: 56 03    ;          JE OUTERLOOP  
0F: FA 02    ;          CMP A,2       ; waiting for start?
11: 56 20    ;          JE WAITSTART  
13: FA 03    ;          CMP A,3       ; waiting for full?
15: 56 2A    ;          JE WAITFULL   
17: FA 04    ;          CMP A,4       ; waiting for empty?
19: 56 32    ;          JE WAITEMPTY  
;               
1B: 64       ; DELAY    DEC A         
1C: 5C 1B    ;          JNE DELAY     
1E: 50 05    ;          JMP INNERLOOP 
;               
20: 40 07    ; WAITSTART IN A,PORTB   
22: CA 03    ;          AND A,3       ; start + door closed
24: FA 01    ;          CMP A,START   
26: 5C 20    ;          JNE WAITSTART 
28: 50 05    ;          JMP INNERLOOP 
;               
2A: 40 07    ; WAITFULL IN A,PORTB    
2C: CA 08    ;          AND A,FULL    
2E: 55 2A    ;          JZ WAITFULL   
30: 50 05    ;          JMP INNERLOOP 
;               
32: 40 07    ; WAITEMPTY IN A,PORTB   
34: CA 04    ;          AND A,EMPTY   
36: 55 32    ;          JZ WAITEMPTY  
38: 50 05    ;          JMP INNERLOOP 
;               
;            ;                  outputs    step ended by
;            ;                  -------    -------------
3A: 00 02    ; DATA     DB 0,2        ; none              start
3C: 0A 03    ;          DB 10,3       ; go, water         full
3E: 23 04    ;          DB 35,4       ; rev, go, drain    empty
40: 1A 03    ;          DB 26,3       ; go, water, soap   full
42: 43 05    ;          DB 67,5       ; rev, go, heat     delay
44: 02 05    ;          DB 2,5        ; go                delay
46: 43 05    ;          DB 67,5       ; rev, go, heat     delay
48: 02 05    ;          DB 2,5        ; go                delay
4A: 22 04    ;          DB 34,4       ; go, drain         empty
4C: 0B 03    ;          DB 11,3       ; rev, go, water    full
4E: 02 05    ;          DB 2,5        ; go                delay
50: 23 04    ;          DB 35,4       ; rev, go, drain    empty
52: 26 05    ;          DB 38,5       ; go, fast, drain   delay
54: 00 01    ;          DB 0,1        ; none       end of cycle
;            ;  wash 2  -  disk A26
;
;  0 errors detected
;
;   SYMBOL TABLE: symbols = 13
;   ------------
; 06: PORTA                07: PORTB                09: CONTROLPORT
; 01: START                04: EMPTY                08: FULL
; 03: OUTERLOOP            05: INNERLOOP            1B: DELAY
; 20: WAITSTART            2A: WAITFULL             32: WAITEMPTY
; 3A: DATA                 
;
