; times.asm
;
;Loc Obj        Source code
;==========================
;            ; program to get two numbers from the keyboard
;            ; and print the product on the 'screen'
;            ; david stonebanks  5 april 91
;            
;              SCREEN   EQU $56       
;              KEYCOUNT EQU $57       
;              KEYCHAR  EQU $58       
;              SENTINEL EQU 0         
;              CR       EQU 13        
;               
00: 1B 6E    ; START    MOV B,MSG1    ; address of msg1
02: 5E 1C    ;          CALL PRINTMSG 
04: 5E 27    ;          CALL GETNUM   ; gets digit (0-9) from keyboard
06: 1C 96    ;          MOV FIRSTNUM,A 
08: 3A 2A 56 ;          OUT SCREEN,'*' 
0B: 5E 27    ;          CALL GETNUM   
0D: 1C 97    ;          MOV SECONDNUM,A 
0F: 3A 3D 56 ;          OUT SCREEN,'=' 
12: 5E 40    ;          CALL TIMES    
14: 3B 98 56 ;          OUT SCREEN,(TENS) ; print it
17: 3B 99 56 ;          OUT SCREEN,(UNITS) 
1A: 50 00    ;          JMP START     
;               
;              PRINTMSG ; writes to screen from mem address in B reg
;            ; ends with zero byte
1C: 13       ; READCHAR MOV A,(B)     
1D: 61       ;          INC B         ; address
1E: FA 00    ;          CMP A,SENTINEL ; end marker?
20: 5C 23    ;          JNE WRITE     
22: 5F       ;          RET           ; done message
23: 38 56    ; WRITE    OUT SCREEN,A  ; write char
25: 50 1C    ;          JMP READCHAR  
;               
;              GETNUM ;  gets number 0-9 from keyboard and validates it
27: 40 57    ;          IN A,KEYCOUNT 
29: FA 00    ;          CMP A,0       
2B: 56 27    ;          JE GETNUM     
2D: 40 58    ;          IN A,KEYCHAR  
2F: 38 56    ;          OUT SCREEN,A  
31: AA 30    ;          SUB A,'0'     ; remove ASCII offset
33: 54 3A    ;          JS NOGOOD     ; gone negative?
35: FA 0A    ;          CMP A,10      
37: 5A 3A    ;          JNS NOGOOD    
39: 5F       ;          RET           ; good num
;               
3A: 1B 80    ; NOGOOD   MOV B,DUFFMSG 
3C: 5E 1C    ;          CALL PRINTMSG 
3E: 50 27    ;          JMP GETNUM    
;               
;              TIMES ; expects 2 digits 0-9 in firstnum and secondnum
;            ; and returns result as ASCII in 'tens' and 'units'
40: 1E 00 98 ;          MOV TENS,0    ; intialise result
43: 1E 00 99 ;          MOV UNITS,0   
46: 1E 01 95 ;          MOV MASK,1    
49: 18 97    ; TIMES2   MOV A,(SECONDNUM) 
4B: C8 95    ;          AND A,(MASK)  
4D: 55 5E    ;          JZ SHIFT      
4F: 8F 96 99 ;          ADD UNITS,(FIRSTNUM) 
52: FE 09 99 ; TRYAGAIN CMP UNITS,9   
55: 54 5E    ;          JS SHIFT      ; result1>9 if not sign flag
57: AE 0A 99 ;          SUB UNITS,10  
5A: 62 98    ;          INC TENS      
5C: 50 52    ;          JMP TRYAGAIN  
;               
5E: 6A 96    ; SHIFT    SHL FIRSTNUM  
60: 6A 95    ; NOINC    SHL MASK      
62: FE 10 95 ;          CMP MASK,16   
65: 5C 49    ;          JNE TIMES2    
67: 8E 30 98 ;          ADD TENS,'0'  ; to ASCII
6A: 8E 30 99 ;          ADD UNITS,'0' 
6D: 5F       ;          RET           
;               
6E: 0D 45 6E ; MSG1     DB CR,'Enter 2 digits ',CR,0 
71: 74 65 72 20 32 20 64 69 67 69 74 73 20 0D 00 
80: 0D 4E 6F ; DUFFMSG  DB CR,'Not 0-9, try again ',0 
83: 74 20 30 2D 39 2C 20 74 72 79 20 61 67 61 69 6E 
93: 20 00 
95: 00       ; MASK     DS 1          
96: 00       ; FIRSTNUM DS 1          
97: 00       ; SECONDNUM DS 1         
98: 00       ; TENS     DS 1          
99: 00       ; UNITS    DS 1          
;
;  0 errors detected
;
;   SYMBOL TABLE: symbols = 23
;   ------------
; 56: SCREEN               57: KEYCOUNT             58: KEYCHAR
; 00: SENTINEL             0D: CR                   00: START
; 1C: PRINTMSG             1C: READCHAR             23: WRITE
; 27: GETNUM               3A: NOGOOD               40: TIMES
; 49: TIMES2               52: TRYAGAIN             5E: SHIFT
; 60: NOINC                6E: MSG1                 80: DUFFMSG
; 95: MASK                 96: FIRSTNUM             97: SECONDNUM
; 98: TENS                 99: UNITS                
;
