; program to get two numbers from the keyboard
; and print the product on the 'screen'
; david stonebanks  5 april 91

screen equ $56
keycount equ $57
keychar equ $58
sentinel equ 0
cr equ 13

start mov b,msg1     ; address of msg1
      call printmsg
      call getnum    ; gets digit (0-9) from keyboard
      mov  firstnum, a
      out  screen , '*'
      call getnum
      mov secondnum, a
      out screen, '='
      call times
      out screen, (tens)  ; print it
      out screen,( units )
      jmp start

printmsg      ; writes to screen from mem address in B reg
              ; ends with zero byte
readchar mov a,(b)
      inc b         ; address
      cmp a, sentinel   ; end marker?
      jne write
      ret           ; done message
write  out screen, a ; write char
      jmp readchar

getnum;  gets number 0-9 from keyboard and validates it
      in a, keycount
      cmp a,0
      je getnum
      in a,keychar
      out screen,a
      sub a,'0'    ; remove ASCII offset
      js nogood    ; gone negative?
      cmp a,10
      jns nogood
      ret         ; good num

nogood mov b,duffmsg
       call printmsg
       jmp getnum

times ; expects 2 digits 0-9 in firstnum and secondnum
      ; and returns result as ASCII in 'tens' and 'units'
      mov tens,0 ; intialise result
      mov units,0
      mov mask,1
times2 mov a,(secondnum)
      and a,( mask )
      jz shift
      add units,(firstnum)
tryagain cmp units,9
      js shift        ; result1>9 if not sign flag
      sub units,10
      inc tens
      jmp tryagain

shift shl firstnum
noinc shl mask
      cmp mask,16
      jne times2
      add tens,'0' ; to ASCII
      add units,'0'
      ret

msg1 db cr,'Enter 2 digits ',cr,0
duffmsg db cr,'Not 0-9, try again ',0
mask ds 1
firstnum ds 1
secondnum ds 1
tens ds 1
units ds 1