; 7segprg.asm
;
;Loc Obj        Source code
;==========================
;            ; 4 DIGIT, 7 SEGMENT DISPLAY DRIVER
;            
;            ; This program outputs a scrolling
;            ; sequence of characters
;            ; to the four digit displays.
;            
;            ; The assembler code to drive the display might be:
;            
;            ; name and date
;            ; constants
;              PORTA    EQU 6         
;              PORTC    EQU 8         
;              CONTROLPORT EQU 9      
;               
00: 3A 83 09 ;          OUT CONTROLPORT,131 ; sets up 8255 i/o chip
03: 1E 00 49 ;          MOV CHAR1,0   ; clear bytes initially
06: 1E 00 4A ;          MOV CHAR2,0   
09: 1E 00 4B ;          MOV CHAR3,0   
0C: 1B 4C    ; START1   MOV B,DATA    ; puts ADDRESS of first
;            ;  data byte into B reg.
0E: 13       ;          MOV A,(B)     ; get segment data
0F: 1C 48    ; START2   MOV CHAR0,A   ; and write to mem
;               
11: 3B 4B 06 ;          OUT PORTA,(CHAR3) 
14: 3A 70 08 ;          OUT PORTC,112 ; strobe digit 3
17: 3A 30 08 ;          OUT PORTC,48  ; address 3, no strobe
;               
1A: 3B 4A 06 ;          OUT PORTA,(CHAR2) 
1D: 3A 60 08 ;          OUT PORTC,96  ; strobe digit 2
20: 3A 20 08 ;          OUT PORTC,32  ; address 2, no strobe
;               
23: 3B 49 06 ;          OUT PORTA,(CHAR1) 
26: 3A 50 08 ;          OUT PORTC,80  ; strobe digit 1
29: 3A 10 08 ;          OUT PORTC,16  ; address 1, no strobe
;               
2C: 3B 48 06 ;          OUT PORTA,(CHAR0) 
2F: 3A 40 08 ;          OUT PORTC,64  ; strobe digit 0
32: 3A 00 08 ;          OUT PORTC,0   ; address 0, no strobe
;               
35: 1F 4A 4B ;          MOV CHAR3,(CHAR2) ; shift digits
38: 1F 49 4A ;          MOV CHAR2,(CHAR1) 
3B: 1F 48 49 ;          MOV CHAR1,(CHAR0) 
;               
3E: 61       ;          INC B         ; to address of next data
3F: 13       ;          MOV A,(B)     ; get segment data byte
40: FA 00    ;          CMP A,0       ; terminating byte?
42: 5B 0F    ;          JNZ START2    
44: 1C 48    ;          MOV CHAR0,A   ; write char to mem
46: 50 0C    ;          JMP START1    ; start again
;               
48: 00       ; CHAR0    DS 1          ; temp store for characters
49: 00       ; CHAR1    DS 1          
4A: 00       ; CHAR2    DS 1          
4B: 00       ; CHAR3    DS 1          
;            ;                segments
;            ;                --------
4C: 3F       ; DATA     DB 63         ; 0
4D: 06       ;          DB 6          ; 1
4E: 5B       ;          DB 91         ; 3
4F: 66       ;          DB 102        ; 4
50: 77       ;          DB 119        ; A
51: 7C       ;          DB 124        ; b
52: 39       ;          DB 57         ; C
53: 5E       ;          DB 94         ; d
54: 00       ;          DB 0          ; terminator
;            ; 7segprg.asm  -  disk A26
;            
;
;  0 errors detected
;
;   SYMBOL TABLE: symbols = 10
;   ------------
; 06: PORTA                08: PORTC                09: CONTROLPORT
; 0C: START1               0F: START2               48: CHAR0
; 49: CHAR1                4A: CHAR2                4B: CHAR3
; 4C: DATA                 
;
