; 4 DIGIT, 7 SEGMENT DISPLAY DRIVER

; This program outputs a scrolling
; sequence of characters
; to the four digit displays.

; The assembler code to drive the display might be:

; name and date
; constants
portA    equ    6
portC    equ    8
controlport equ 9

        out controlport,131 ; sets up 8255 i/o chip
        mov char1,0 ; clear bytes initially
        mov char2,0
        mov char3,0
start1  mov b, data ; puts ADDRESS of first
                               ;  data byte into B reg.
        mov a,(b)   ; get segment data
start2  mov char0,a ; and write to mem

        out portA,(char3)
        out portC,112 ; strobe digit 3
        out portC,48 ; address 3, no strobe

        out portA,(char2)
        out portC,96 ; strobe digit 2
        out portC,32 ; address 2, no strobe

        out portA,(char1)
        out portC,80 ; strobe digit 1
        out portC,16 ; address 1, no strobe

        out portA,(char0)
        out portC,64 ; strobe digit 0
        out portC, 0 ; address 0, no strobe

        mov char3,(char2) ; shift digits
        mov char2,(char1)
        mov char1,(char0)

        inc b     ; to address of next data
        mov a,(b) ; get segment data byte
        cmp a,0   ; terminating byte?
        jnz start2
        mov char0,a ; write char to mem
        jmp start1 ; start again

char0   ds 1 ; temp store for characters
char1   ds 1
char2   ds 1
char3   ds 1
;                segments
;                --------
data  db 63   ; 0
      db 6    ; 1
      db 91   ; 3
      db 102  ; 4
      db 119  ; A
      db 124  ; b
      db 57   ; C
      db 94   ; d
      db 0    ; terminator
; 7segprg.asm  -  disk A26

