{ BARRELW.PAS - Pouring Barrels : Windows game

  Title    : BARRELW
  Language : Borland Pascal v7.0 met Object Windows
  Version  : 1.2
  Date     : Feb 10, 2000
  Author   : J R Ferguson
  Download : http://hello.to/ferguson
  E-mail   : j.r.ferguson@iname.com
  Usage    : MS-Windows 3.1 application

This program and its source may be used and copied freely whithout
charge, but only for non-commercial purposes. In no way the author
can be held responsible for any damage or loss of data that may be
caused by using this software.

To compile this source file, you wil need some units from the JRFPAS
Pascal routine library by the same author, which can be downloaded
from the Internet address mentioned above.
}

{$B-} { short-circuit boolean expression evaluation }
{$X+} { extended syntax }

program BARRELW;
uses Objects, OWindows, ODialogs, WinTypes, WinProcs, NumLib;

{$R BARRELW.RES}
{$I BARRELW.INC}

type
  T_Figure      = (Fig_Background,Fig_NormalBarrel,Fig_SelectedBarrel,Fig_Air,Fig_Liquid);

type
  P_DrawSet     = ^T_DrawSet;
  P_DrawUtils   = ^T_DrawUtils;
  P_GameObject  = ^T_GameObject;
  P_BackGround  = ^T_BackGround;
  P_Air         = ^T_Air;
  P_Liquid      = ^T_Liquid;
  P_Barrel      = ^T_Barrel;
  P_Barrels     = ^T_Barrels;
  P_MainWindow  = ^T_MainWindow;
  P_Application = ^T_Application;

  T_DrawSet     = object(TObject)
    Pen         : HPen;
    Brush       : HBrush;
    constructor Init(V_PenWidth: integer; V_PenColor, V_BrushColor: longint);
    destructor  Done; virtual;
  end;

  T_DrawUtils   = object(TObject)
    DrawSet     : array[T_Figure] of P_DrawSet;
    constructor Init;
    destructor  Done; virtual;
    procedure   Select(V_Context: HDC; V_Figure: T_Figure);
  end;

  T_GameObject  = object(TObject)
    Rect        : TRect;
    Figure      : T_Figure;
    constructor Init(V_Figure: T_Figure);
    procedure   Draw(V_Context: HDC; V_Rect: TRect); virtual;
    function    Contains(V_X,  V_Y: integer): boolean; virtual;
  end;

  T_BackGround  = object(T_GameObject)
    constructor Init;
  end;

  T_Air         = T_GameObject;

  T_Liquid      = object(T_GameObject)
    DrawBarrel       : integer;
    constructor Init(V_Level: integer);
  end;

  T_Barrel      = object(T_GameObject)
    Capacity    : integer;
    Air         : P_Air;
    Liquid      : P_Liquid;
    constructor Init(V_Capacity, V_Level: integer);
    destructor  Done; virtual;
    function    PourInto(V_Barrel: P_Barrel): boolean; virtual;
    procedure   Draw(V_Context: HDC; V_Rect: TRect); virtual;
  end;

  T_Barrels     = object(TCollection)
    function    Locate(V_X, V_Y: integer): P_Barrel;
    procedure   Draw(V_Context: HDC; V_Rect: TRect); virtual;
    function    Finished: boolean; virtual;
  end;

  T_MainWindow  = Object(TWindow)
    BackGround  : P_BackGround;
    Barrels     : P_Barrels;
    Barrel      : P_Barrel;
    constructor Init(V_Parent: PWindowsObject; V_Title: PChar);
    destructor  Done; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var V_WndClass: TWndClass); virtual;
    procedure   Paint(V_Context: HDC; var V_PaintInfo: TPaintStruct); virtual;
    procedure   InitGame;
    procedure   ClearGame;
    procedure   WMLButtonDown(var V_Msg: TMessage); virtual wm_First + wm_LButtonDown;
    procedure   DoGameNew    (var V_Msg: TMessage); virtual cm_First + cm_GameNew;
    procedure   DoHelpRules  (var V_Msg: TMessage); virtual cm_First + cm_HelpRules;
    procedure   DoHelpAbout  (var V_Msg: TMessage); virtual cm_First + cm_HelpAbout;
  end;

  T_Application = Object(TApplication)
    DrawUtils   : P_DrawUtils;
    constructor Init(V_Title: PChar);
    destructor  Done; virtual;
    procedure   InitMainWindow; virtual;
    procedure   InitInstance; virtual;
  end;


{ --- T_DrawSet --- }

constructor T_DrawSet.Init(V_PenWidth: integer; V_PenColor, V_BrushColor: longint);
begin
  inherited Init;
  Pen   := CreatePen(ps_solid,V_PenWidth,V_PenColor);
  Brush := CreateSolidBrush(V_BrushColor);
end;

destructor  T_DrawSet.Done;
begin
  DeleteObject(Pen); DeleteObject(Brush);
  inherited Done;
end;


{ --- T_DrawUtils --- }

constructor T_DrawUtils.Init;
begin
  inherited Init;
  New(DrawSet[Fig_Background    ], Init(0,RGB(255,255,255),RGB(255,255,255)));
  New(DrawSet[Fig_NormalBarrel  ], Init(4,RGB(127,127,127),RGB(127,127,127)));
  New(DrawSet[Fig_SelectedBarrel], Init(4,RGB(255,000,000),RGB(255,000,000)));
  New(DrawSet[Fig_Air           ], Init(0,RGB(255,251,240),RGB(255,251,240)));
  New(DrawSet[Fig_Liquid        ], Init(0,RGB(000,255,255),RGB(000,255,255)));
end;

destructor  T_DrawUtils.Done;
begin
  Dispose(DrawSet[Fig_Background    ],Done);
  Dispose(DrawSet[Fig_NormalBarrel  ],Done);
  Dispose(DrawSet[Fig_SelectedBarrel],Done);
  Dispose(DrawSet[Fig_Air           ],Done);
  Dispose(DrawSet[Fig_Liquid        ],Done);
  inherited Done;
end;

procedure   T_DrawUtils.Select(V_Context: HDC; V_Figure: T_Figure);
begin
  SelectObject(V_Context,DrawSet[V_Figure]^.Pen);
  SelectObject(V_Context,DrawSet[V_Figure]^.Brush);
end;


{ --- T_GameObject --- }

constructor T_GameObject.Init(V_Figure: T_Figure);
begin
  inherited Init;
  with Rect do begin Left:= 0; Top:= 0; Right:= 0; Bottom:= 0; end;
  Figure:= V_Figure;
end;

procedure   T_GameObject.Draw(V_Context: HDC; V_Rect: TRect);
begin
  Rect:= V_Rect;
  P_Application(Application)^.DrawUtils^.Select(V_Context,Figure);
  with Rect do case Figure of
    Fig_NormalBarrel,
    Fig_SelectedBarrel: begin
                          MoveTo(V_Context,Left,Top);
                          LineTo(V_Context,Left,Bottom);
                          LineTo(V_Context,Right,Bottom);
                          LineTo(V_Context,Right,Top);
                        end;
    Fig_Background,
    Fig_Air,
    Fig_Liquid        : Rectangle(V_Context,Left,Top,Right,Bottom);
  end;
end;

function    T_GameObject.Contains(V_X,  V_Y: integer): boolean;
begin with Rect do begin
  Contains:= (V_X >= Left) and (V_X <= Right) (* and (V_Y >= Top) and (V_Y <= Bottom) *)
end end;


{ --- T_BackGround --- }

constructor T_BackGround.Init;
begin inherited Init(Fig_Background); end;


{ --- T_Liquid --- }

constructor T_Liquid.Init(V_Level: integer);
begin
  Inherited Init(Fig_Liquid);
  DrawBarrel:= V_Level;
end;


{ --- T_Barrel --- }

constructor T_Barrel.Init(V_Capacity, V_Level: integer);
begin
  inherited Init(Fig_NormalBarrel);
  Capacity := V_Capacity;
  New(Air,Init(Fig_Air));
  New(Liquid,Init(V_Level));
end;

destructor  T_Barrel.Done;
begin
  Dispose(Air,Done);
  Dispose(Liquid,Done);
  inherited Done;
end;

function    T_Barrel.PourInto(V_Barrel: P_Barrel): boolean;
var quantity: integer;
begin
  quantity:= IMin(Liquid^.DrawBarrel, V_Barrel^.Capacity - V_Barrel^.Liquid^.DrawBarrel);
  if Liquid^.DrawBarrel = 0 then PourInto:= false
  else begin
    Dec(Liquid^.DrawBarrel,quantity); Figure:= Fig_NormalBarrel;
    Inc(V_Barrel^.Liquid^.DrawBarrel,quantity);
    PourInto:= true;
  end;
end;

procedure   T_Barrel.Draw(V_Context: HDC; V_Rect: TRect);
var s: array[0..2] of char;
begin with V_Rect do begin
  Top:= Bottom - (LongInt(Bottom-Top) * Capacity) div 21;
  inherited Draw(V_Context,V_Rect);
  WVSPrintF(s,'%2d',Capacity);
  TextOut(V_Context,Left + (Right - Left) div 2 - 10, Bottom + 5, s, 2);
  Inc(Left,2); Dec(Right,2); Dec(Bottom);
  Top:= Bottom - (LongInt(Bottom-Top) * LongInt(Liquid^.DrawBarrel)) div Capacity;
  Liquid^.Draw(V_Context,V_Rect);
  Bottom:= Top; Top:= Rect.Top;
  Air^.Draw(V_Context,V_Rect);
  if Liquid^.DrawBarrel > 0 then begin
    WVSPrintF(s,'%2d',Liquid^.DrawBarrel);
    TextOut(V_Context,Left + (Right - Left) div 2 - 10, Bottom + 1 , s, 2);
  end;
end end;


{ --- T_Barrels --- }

function    T_Barrels.Locate(V_X, V_Y: integer): P_Barrel;
  function ContainsXY(Item: Pointer): boolean; far;
  begin ContainsXY:= P_Barrel(Item)^.Contains(V_X,V_Y); end;
begin Locate:= FirstThat(@ContainsXY); end;

procedure   T_Barrels.Draw(V_Context: HDC; V_Rect: TRect);
var i: integer; R: TRect; dx: integer;
  procedure DrawBarrel(Item: Pointer); far;
  begin
    P_Barrel(Item)^.Draw(V_Context,R);
    Inc(R.Left,dx); Inc(R.Right,dx);
  end;
begin {Draw}
  R:= V_Rect; dx:= (R.Right - R.Left) div Count;
  Inc(R.Left,dx div 10); R.Right:=  R.Left + (dx * 8) div 10;
  ForEach(@DrawBarrel);
end;

function    T_Barrels.Finished: boolean;
var level: integer;
  function NotEqual(Item: Pointer): boolean; far;
  begin NotEqual:= P_Barrel(Item)^.Liquid^.DrawBarrel <> level end;
begin
  if Count = 0 then Finished:= false
  else begin
    level:= P_Barrel(At(0))^.Liquid^.DrawBarrel;
    Finished:= FirstThat(@NotEqual) = At(3);
  end;
end;

{ --- T_MainWindow --- }

constructor  T_MainWindow.Init(V_Parent: PWindowsObject; V_Title: PChar);
begin
  inherited Init(V_Parent,V_Title);
  Attr.Menu:= LoadMenu(HInstance,MakeIntResource(MENU_MAIN));
  New(BackGround,Init);
  New(Barrels,Init(4,0));
  InitGame;
end;

destructor   T_MainWindow.Done;
begin ClearGame; Dispose(Barrels,Done); Dispose(BackGround,Done); inherited Done; end;

function     T_MainWindow.GetClassName: PChar;
begin GetClassName:= 'BARRELW'; end;

procedure    T_MainWindow.GetWindowClass(var V_WndClass: TWndClass);
begin
  inherited GetWindowClass(V_WndClass);
  V_WndClass.hIcon:= LoadIcon(HInstance,MakeIntResource(ICON_MAIN));
end;

procedure    T_MainWindow.Paint(V_Context: HDC; var V_PaintInfo: TPaintStruct);
var Rect: TRect; dx,dy: integer;
begin
  GetClientRect(HWindow,Rect);
  with Rect do begin
    BackGround^.Draw(V_Context,Rect);
    dx:= (Right - Left) div 40; dy:= 30;
    Inc(Left,dx); Dec(Right,dx); Inc(Top,dy); Dec(Bottom,dy);
  end;
  Barrels^.Draw(V_Context,Rect);
end;

procedure    T_MainWindow.InitGame;
begin
  with Barrels^ do begin
    Insert(New(P_Barrel,Init(21,21)));
    Insert(New(P_Barrel,Init(13, 0)));
    Insert(New(P_Barrel,Init(11, 0)));
    Insert(New(P_Barrel,Init( 5, 0)));
  end;
  Barrel:= nil;
end;

procedure    T_MainWindow.ClearGame;
begin Barrels^.FreeAll; Barrel:= nil; end;

procedure    T_MainWindow.WMLButtonDown(var V_Msg: TMessage);
var dst: P_Barrel;
begin
  if Barrel = nil then begin { select }
    Barrel:= Barrels^.Locate(integer(V_Msg.LParamLo),integer(V_Msg.LParamHi));
    if (Barrel <> nil) and (Barrel^.Liquid^.DrawBarrel > 0) then begin
      Barrel^.Figure:= Fig_SelectedBarrel;
      InvalidateRect(HWindow,@Barrel^.Rect,false);
    end
    else Barrel:= nil;
  end
  else begin { pour }
    dst:= Barrels^.Locate(integer(V_Msg.LParamLo),integer(V_Msg.LParamHi));
    if (dst <> nil) and ((dst = Barrel) or (Barrel^.PourInto(dst))) then begin
      InvalidateRect(HWindow,@Barrel^.Rect,false);
      InvalidateRect(HWindow,@dst^.Rect,false);
      Barrel^.Figure:= Fig_NormalBarrel; Barrel:= nil;
      if Barrels^.Finished then begin
        Application^.ExecDialog((New(PDialog,Init(@Self,MakeIntResource(DLG_GAMEOVER)))));
        ClearGame; InitGame; InvalidateRect(HWindow,nil,false);
      end;
    end;
  end;
end;

procedure    T_MainWindow.DoGameNew(var V_Msg: TMessage);
begin ClearGame; InitGame; InvalidateRect(HWindow,nil,false); end;

procedure    T_MainWindow.DoHelpRules(var V_Msg: TMessage);
begin
  MessageBox(HWindow,
  'You have to see to it that the liquid in the three leftmost barrels gets at ' +
  'the same level.'#13#13+
  'You can pour liquid from one barrel into the other, ' +
  'either by emptying it altogether or by filling the other one up to the ' +
  'rim. ',
  'Rules of the game',
  mb_IconInformation or mb_OK);
end;

procedure    T_MainWindow.DoHelpAbout(var V_Msg: TMessage);
begin
  MessageBox(HWindow,
  'Pouring Barrels'#13 +
  'BARRELW v1.2 (MS-Windows)'#13#13 +
  '(c) 1996-2000, J.R. Ferguson'#13 +
  'j.r.ferguson@iname.com'#13 +
  'http://hello.to/ferguson',
  'Information',
  mb_IconInformation or mb_OK);
end;


{ --- T_Application --- }

constructor T_Application.Init(V_Title: PChar);
begin
  inherited Init(V_Title);
  New(DrawUtils,Init);
end;

destructor  T_Application.Done;
begin
  Dispose(DrawUtils,Done);
  inherited Done;
end;

procedure   T_Application.InitMainWindow;
begin MainWindow:= New(P_MainWindow, Init(nil,'Pouring Barrels')); end;

procedure   T_Application.InitInstance;
begin
  inherited InitInstance;
  HAccTable:= LoadAccelerators(HInstance,MakeIntResource(ACC_KEYS));
end;

{ --- Hoofdprogramma --- }

begin
  Application:= New(P_Application, Init('BARRELW'));
  Application^.Run;
  Dispose(Application,Done);
end.
