unit sb;
{uses
  crt;}
interface
uses dos;

const
  TimerSpeed:word = 50000;
  on     = true;
  off    = false;
  maxreg = $F5;
  maxch  = 10;
  SBSpeed:integer=3;

{  note_table : array [0..12] of word =
    ($000,$16b,$181,$198,$1b0,$1ca,$1e5,$202,$220,$241,$263,$287,$2ae);}
{$I notes.inc}

var Songs:string;

procedure InitSB;
procedure DoneSB;

implementation
var
  OldInt1c:pointer;
  Counter:integer;

procedure writeaddr(b : byte); assembler;
asm
  mov  al, b
  mov  dx, 388h
  out  dx, al
  mov  cx, 6

 @wait:
  in   al, dx
  loop @wait
end;

procedure writedata(b : byte); assembler;
asm
  mov  al, b
  mov  dx, 389h
  out  dx, al
  mov  cx, 35h
  dec  dx

 @wait:
  in   al, dx
  loop @wait
end;

procedure sb_reset;
var
  i : byte;
begin
  for i := 1 to maxreg do
  begin
    writeaddr(i);
    writedata(0);
  end;
end;

procedure sb_off;
begin
  writeaddr($b0);
  writedata($0);
end;

{ r=register,d=data }
procedure sb_out(r, d : byte);
begin
  writeaddr(r);
  writedata(d);
end;

procedure sb_setup;
begin
  sb_out($20, $21);
  sb_out($40, $10);
  sb_out($60, $00);
  sb_out($80, $00);
  sb_out($23, $01);
  sb_out($43, $00);
  sb_out($63, $00);
  sb_out($83, $00);

  sb_out($A0, $91);
  sb_out($C0, $00);
  sb_out($BD, $8f);
  sb_out($E0, $00);
end;

procedure sb_note({channel : byte; } note : word; on : boolean);
begin
  sb_out($a0{ + channel}, lo(note));
  sb_out($b0{ + channel}, ($20 * byte(on)) or $10 or hi(note));
end;

{$F+}
procedure SBInt1c;interrupt;
var i:integer;
    p:char;
begin
   dec(Counter);if Counter<0 then begin
     COunter:=SBSpeed;
     if songs[0]<>'' then begin
       p:=songs[1];
       case p of
         '0'..'9':begin
                 sb_note(0,off);
                 sb_note(notes[23+byte(p)-byte('0')],on);
               end;
         'A'..'Z':begin
                 sb_note(0,off);
                 sb_note(notes[36+byte(p)-byte('@')],on);
               end;
         'a'..'z':begin
                 sb_note(notes[36+byte(p)-byte('a')-1],on);
               end;
         '#':begin
                 sb_note(0,off);
               end;
         '!':begin songs:=''; end;
       end;
       delete(songs,1,1);
       if p<>'!' then songs:=songs+p;
     end;
   end;
end;
{$F-}

procedure InitSB;
var i:integer;
begin
  for i:=0 to MaxCh do
    sb_note(0,off);
  sb_reset;
  sb_out(1, $10);
  sb_setup;
  GetIntVec($1c,OldInt1c);
  SetIntVec($1c,@SBInt1c);
  Counter:=SbSpeed;
  asm
    mov al,34h
    out 43h,al
    mov ax,TimerSpeed
    out 40h,al
    xchg al,ah
    out 40h,al
  end;
end;

procedure DoneSB;
var i:integer;
begin
  SetIntVec($1c,OldInt1c);
  sb_reset;
  sb_off;
  asm
    mov al,34h
    out 43h,al
    mov ax,0
    out 40h,al
    xchg al,ah
    out 40h,al
  end;
end;

begin
end.

