{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T+,V+,X+,Y+}
{$M 16384,0,655360}

{$define Points}
unit objs;

interface

uses data,glib,complex,objtype,effects;


function DoBFP(var a:tBall;var b:tPoint):boolean;
function DoBP(var a:tBall;var b:tPoint):boolean;
function DoBFW(var a:tBall;var w:tWall):boolean;
function DoBW(var a:tBall;var w:tWall):boolean;
procedure MoveB(var a:tBall);
procedure SetBall(var a:tBall;x,y,vx,vy:real;r:integer;w:real);

implementation

function DoBFP;
var r:tcomplex;
    l,alpha,w1,w2:real;
    t1,t2:tComplex;
begin
    DoBFP:=false;
    r:=b.position;cSub(r,a.position);
    Totri(r,l,alpha);
    if l<a.radius then begin
      alpha:=3*pi/2-alpha;
      FromTri(r,1,alpha);
      t1:=a.speed;
      t2:=b.speed;
      cMul(t1,r);
      cMul(t2,r);
      if t1.i>t2.i then exit;
      a.speed.i:=-t1.i;
      a.speed.r:=t1.r;
      FromTri(r,1,-alpha);
      cMul(a.speed,r);
      cMul(b.speed,r);
{$ifdef Points}
      AddP2(round(b.position.r),round(b.position.i));
{$endif}
      DoBFP:=true;
    end;
end;

function DoBP;
var r:tcomplex;
    l,alpha:real;
    w1,w2,vy1,vy2:real;
    t1,t2:tComplex;
begin
    DoBP:=false;
    r:=b.position;cSub(r,a.position);
    Totri(r,l,alpha);
    if l<a.radius then begin
      alpha:=pi/2-alpha;
      FromTri(r,1,alpha);
      cMul(t1,r);
      cMul(t2,r);
      vy1:=t1.i;w1:=a.Weight;
      vy2:=t2.i;w2:=b.Weight;
      if vy1>vy2 then exit;
      a.speed.r:=t1.r;
      a.speed.i:=(2*w2*vy2+vy1*(w1-w2))/(w1+w2);
      b.speed.r:=t2.r;
      b.speed.i:=(2*w1*vy1+vy2*(w2-w1))/(w1+w2);
      FromTri(r,1,-alpha);
      cMul(a.speed,r);
      cMul(b.speed,r);
{$ifdef Points}
      AddP2(round(b.position.r),round(b.position.i));
{$endif}
      DoBP:=true;
    end;
end;

function DoBFW;
begin
    DoBFW:=false;
    if abs(w.X1-w.X2)<CalcErr then begin {vertical wall}
      if (a.position.i>=w.y1) and (a.position.i<=w.y2) then
        if abs(a.position.r-w.x1)<a.radius then
          if ((a.position.r<w.x1) and (a.speed.r>0)) or
             ((a.position.r>w.x1) and (a.speed.r<0)) then begin
               a.speed.r:=w.speed.r-a.speed.r;
               DoBFW:=true;
             end;
    end else
    if abs(w.Y1-w.Y2)<CalcErr then begin {horizontal wall}
      if (a.position.r>=w.x1) and (a.position.r<=w.x2) then
        if abs(a.position.i-w.y1)<a.radius then
          if ((a.position.i<w.y1) and (a.speed.i>0)) or
             ((a.position.i>w.y1) and (a.speed.i<0)) then begin
               a.speed.i:=w.speed.i-a.speed.i;
               DoBFW:=true;
             end;
    end;
end;

function DoBW;
begin
    DoBW:=false;
    if abs(w.X1-w.X2)<CalcErr then begin {vertical wall}
      if (a.position.i>=w.y1) and (a.position.i<=w.y2) then
        if abs(a.position.r-w.x1)<a.radius then
          if ((a.position.r<w.x1) and (a.speed.r>0)) or
             ((a.position.r>w.x1) and (a.speed.r<0)) then begin
               a.speed.r:=w.speed.r-a.speed.r;
               DoBW:=true;
             end else begin
               a.speed.r:=w.speed.r+a.speed.r;
               DoBW:=true;
             end;
    end else
    if abs(w.Y1-w.Y2)<CalcErr then begin {horizontal wall}
      if (a.position.r>=w.x1) and (a.position.r<=w.x2) then
        if abs(a.position.i-w.y1)<a.radius then
          if ((a.position.i<w.y1) and (a.speed.i>0)) or
             ((a.position.i>w.y1) and (a.speed.i<0)) then begin
               a.speed.i:=w.speed.i-a.speed.i;
               DoBW:=true;
             end else begin
               a.speed.i:=w.speed.i+a.speed.i;
               DoBW:=true;
             end;
    end;
end;

procedure MoveB;
var xx,yy:integer;
begin
   cAdd(a.Position,a.Speed);
end;

procedure SetBall;
begin
   with a do begin
     Position.r:=x;
     Position.i:=y;
     Speed.r:=vx;
     Speed.i:=vy;
     Weight:=w;
     Radius:=r;
   end;
end;

begin
end.




