{$G+}
uses glib;

type tmapitem=array[0..7,0..7] of byte;
var m_x,m_y,mb,ox,oy,ob:integer;
    Pic:pointer;
    maps:array[0..255] of tmapitem;
    mapnr:integer;
    l1,l3,mapdir:string;
    blocks:array[0..255] of pointer;
    mbl:array[0..19] of pointer;
    ppal:^tPalette;

const vx=5*16;
      vy=11*16;
const d_x=1*16;
      d_y=10*16;

    maxmy=200;
    minmy=192;
    Col0=$68;
    Col1=$13;
    Col2=$3f;

procedure Data0;external;
{$L data0.obj}
procedure MEdit0;external;
{$L medit0.obj}

procedure INitData0;
var i,j:integer;
begin
    for i:=0 to 2 do
      for j:=0 to 19 do
        blocks[i*20+j]:=AddPtr(@data0,i*320*16+j*16+800);
    pPal:=AddPtr(@data0,32);
    SetPalette(pPal^);
    for j:=0 to 19 do
      mbl[j]:=AddPtr(@medit0,j*16+800);
end;

procedure m_init;assembler;
asm
   xor ax,ax;int 33h
   xor ax,ax
   mov m_x,ax
   mov m_y,ax
   mov mb,ax
   mov ox,ax
   mov oy,ax
   mov ob,ax
   mov ax,2; int 33h
end;
procedure m_move;
begin
  asm
     mov ax,11;int 33h
     add m_x,cx
     add m_y,dx
     mov ax,3;int 33h
     mov mb,bx
  end;
  if m_x<0 then m_x:=0;
  if m_x>=320 then m_x:=319;
  if m_y<0 then m_y:=0;
  if m_y>=maxmy then m_y:=maxmy-1;
end;
procedure m_event;
begin
   ox:=m_x;oy:=m_y;ob:=mb;
   repeat
     m_move
   until keypressed or (m_x<>ox) or (m_y<>oy) or (mb<>ob);
end;

procedure init;
var f:file;
    t:text;
    l:longint;
    s:string;p:integer;
begin
   asm
     mov ax,013h
     int 10h
   end;
   m_init;
   assign(f,'mapitems.dat');reset(f,1);
   l:=filesize(f);mapnr:=l div 64;
   blockread(f,maps,l);
   close(f);
   assign(t,'maxitem.inc');reset(t);
   readln(t,l1);
   readln(t);
   readln(t,l3);
   mapdir:='';
   while not eof(t) do begin
     readln(t,s);
     p:=pos('''',s);
     if p>0 then begin
       delete(s,1,p);
       p:=pos('''',s);
       if p>0 then s:=copy(s,1,p-1);
       mapdir:=mapdir+s;
     end;
   end;
   close(t);
   InitData0;
   for p:=0 to 127 do begin
     PutPixel(ScreenPtr,p,9*16,15);
     PutPixel(ScreenPtr,8*16,p+16,15);
   end;
   for p:=0 to 59 do begin
     PutPic(160+(p mod 10)*16,(p div 10)*16,16,16,0,0,Blocks[p],ScreenPtr);
   end;
   for p:=0 to 15 do begin
     PutPixel(ScreenPtr,vx+p,vy-1,15);
     PutPixel(ScreenPtr,vx+16+p,vy-1,15);
     PutPixel(ScreenPtr,vx+p,vy+16,15);
     PutPixel(ScreenPtr,vx+16+p,vy+16,15);
     PutPixel(ScreenPtr,vx-1,vy+p,15);
     PutPixel(ScreenPtr,vx+32,vy+p,15);

     PutPixel(ScreenPtr,d_x-1,d_y-16+p,15);
     PutPixel(ScreenPtr,d_x+16,d_y-16+p,15);
     PutPixel(ScreenPtr,d_x-1,d_y+16+p,15);
     PutPixel(ScreenPtr,d_x+16,d_y+16+p,15);
     PutPixel(ScreenPtr,d_x-17,d_y+p,15);
     PutPixel(ScreenPtr,d_x+32,d_y+p,15);
     PutPixel(ScreenPtr,d_x-16+p,d_y-1,15);
     PutPixel(ScreenPtr,d_x+16+p,d_y-1,15);
     PutPixel(ScreenPtr,d_x-16+p,d_y+16,15);
     PutPixel(ScreenPtr,d_x+16+p,d_y+16,15);
     PutPixel(ScreenPtr,d_x+p,d_y+32,15);
   end;
end;

procedure save;
var f:file;t:text;s:string;
begin s:=mapdir;
   assign(f,'mapitems.dat');rewrite(f,1);
   blockwrite(f,maps,mapnr*64);
   close(f);
   assign(t,'maxitem.inc');rewrite(t);
   writeln(t,l1);
   writeln(t,mapnr-1,';');
   writeln(t,l3);
   while length(mapdir)>0 do begin
     if length(mapdir)>64 then begin
         writeln(t,'''',copy(mapdir,1,64),'''+');
         delete(mapdir,1,64);
       end else begin
         MapDir:=MapDir+''';';
         writeln(t,'''',mapdir);
         mapdir:='';
       end;
   end;
   close(t);
   mapdir:=s;
end;

procedure done;
begin
   asm mov ax,0;int 10h; end;
   donevideo;
   Writeln;
   Write('Save changes (y/n) ?');
   if lo(getkey)=byte('y') then save;
end;

const dirs:string[16]='ѳöű';
      cmap:integer=2;
      MouseCol=12;
      Bll:byte=0;
      Blr:byte=1;

var ccan:integer;

procedure XorPixel(x,y:integer);assembler;
asm
   xor di,di
   mov ax,0a000h
   mov es,ax
   mov ax,x
   cmp ax,320
   jae @@out
   add di,ax
   mov ax,y
   cmp ax,200
   jae @@out
   shl ax,6
   add di,ax
   shl ax,2
   add di,ax
   mov al,byte ptr es:[di]
   xor al,MouseCol
   stosb
@@out:
end;

procedure PutMouse(x,y:integer);
var i:integer;
begin
    if y<minmy then begin
      x:=x and $fff0;
      y:=y and $fff0;
      for i:=0 to 15 do begin
        XorPixel(x+i,y);
        XorPixel(x+i,y+15);
        XorPixel(x,y+i);
        XorPixel(x+15,y+i);
      end;
    end else begin
      for i:=0 to 7 do
        XorPixel(x,192+i);
    end;
end;

procedure PutSel;
begin
   PutPic(vx,vy,16,16,0,0,Blocks[Bll],ScreenPtr);
   PutPic(vx+16,vy,16,16,0,0,Blocks[Blr],ScreenPtr);
end;

procedure PutCan;
begin
   ccan:=pos(MapDir[CMap+1],Dirs) mod 16;
   if (ccan and 1)=1 then PutPic(d_x,d_y-16,16,16,0,0,mbl[8],SCreenPtr)
                     else PutPic(d_x,d_y-16,16,16,0,0,mbl[19],SCreenPtr);
   if (ccan and 2)=2 then PutPic(d_x+16,d_y,16,16,0,0,mbl[9],SCreenPtr)
                     else PutPic(d_x+16,d_y,16,16,0,0,mbl[19],SCreenPtr);
   if (ccan and 4)=4 then PutPic(d_x,d_y+16,16,16,0,0,mbl[10],SCreenPtr)
                     else PutPic(d_x,d_y+16,16,16,0,0,mbl[19],SCreenPtr);
   if (ccan and 8)=8 then PutPic(d_x-16,d_y,16,16,0,0,mbl[11],SCreenPtr)
                     else PutPic(d_x-16,d_y,16,16,0,0,mbl[19],SCreenPtr);
end;

procedure PutPos;
begin
  asm
    push 0a000h
    pop es
    mov di,320*192
    cld
    mov dx,8
    mov si,MapNr
    shl si,1
@@l1:
    xor bl,bl
    mov cx,si
    mov al,Col0
    mov ah,Col2
@@l2:
    mov bh,bl
    shr bh,1
    cmp bh,byte ptr cmap
    jne @@l3
    xchg al,ah
    stosb
    xchg al,ah
    jmp @@l4
@@l3:
    stosb
@@l4:
    inc bl
    loop @@l2
    mov cx,320
    sub cx,si
    mov al,Col1
    rep stosb
    dec dx
    jne @@l1
  end;
end;

procedure PutMap;
var i,j:integer;
begin
   putpic(0,0,6*16,16,0,0,mbl[0],ScreenPtr);
   if Cmap=0 then PutPic(0,0,16,16,0,0,mbl[6],SCreenPtr);
   if Cmap=MapNr-1 then PutPic(16,0,16,16,0,0,mbl[7],SCreenPtr);
   for i:=0 to 7 do
     for j:=0 to 7 do
       putpic(j*16,16+i*16,16,16,0,0,Blocks[maps[cmap][i,j]],ScreenPtr);
   ccan:=pos(mapdir[cmap+1],dirs) mod 16;
   PutSel;
   PutCan;
   PutPos;
end;

function get_event:integer;{0 - nothing; 1-left; 2-right; 3:key }
begin
   repeat
     PutMouse(m_x,m_y);
     m_event;
     PutMouse(ox,oy);
   until keypressed or (mb<>ob);
   get_event:=0;
   if keypressed then get_event:=3 else begin
     if (mb and 1)=1 then if (ob and 1)<>1 then get_event:=1;
     if (mb and 2)=2 then if (ob and 2)<>2 then get_event:=2;
   end;
end;

procedure SetDir(b:integer);
var p:integer;
begin
    p:=pos(MapDir[CMap+1],dirs);
    if p=0 then exit;
    p:=p mod 16;
    p:=p xor b;
    if p=0 then p:=16;
    MapDir[CMap+1]:=Dirs[p];
    PutCan;
end;

procedure DoIt;
var ev:integer;
    endit:boolean;
    xx,yy,p:integer;
begin endit:=false;
   PutMap;
   repeat
     ev:=get_event;
     if ev=3 then begin
       ev:=getkey;
       if hi(ev)=1 then endit:=true;
     end else if ev<>0 then begin
       xx:=m_x div 16;yy:=m_y div 16;
       if (yy=0) and (xx<6) then case xx of
         0:if cmap>0 then begin dec(cmap);PutMap;end;
         1:if cmap<MapNr-1 then begin inc(cmap);PutMap;end;
         2:if cmap=MapNr-1 then begin
             if cmap<>0 then begin dec(cmap);dec(mapnr);PutMap;end;
           end else begin
             MapDir[cmap+1]:=MapDir[MapNr];
             dec(byte(MapDir[0]));
             Maps[cmap]:=Maps[MapNr-1];
             Dec(MapNr);
             PutMap;
           end;
         3:if MapNr<160 then begin
             Maps[MapNr]:=Maps[CMap];
             MapDir:=MapDir+' ';
             MapDir[MapNr+1]:=MapDir[CMap+1];
             Inc(MapNr);
             CMap:=MapNr-1;
             PutMap;
           end;
         4:save;
         5:endit:=true;
       end else
       if (xx>=10) then begin
         p:=(xx-10)+(yy*10);
         if p<60 then begin
           case ev of
             1:Bll:=p;
             2:Blr:=p;
           end;
           PutSel;
         end;
       end else
       if (xx=1) and (yy=9) then SetDir(1) else
       if (xx=2) and (yy=10) then SetDir(2) else
       if (xx=1) and (yy=11) then SetDir(4) else
       if (xx=0) and (yy=10) then SetDir(8) else
       if (xx<8) and (yy>=1) and (yy<=8) then begin
         case ev of
           1:Maps[CMap][yy-1,xx]:=Bll;
           2:Maps[CMap][yy-1,xx]:=Blr;
         end;
         PutMap;
       end;
       if (m_y>=minmy) then begin
         xx:=m_x div 2;
         if xx>=MapNr then xx:=MapNr-1;
         cmap:=xx;PutMap;
       end;
     end;

   until endit;
end;

begin
   INit;
   DoIt;
   Done;
end.