{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T+,V+,X+,Y+}
{$M 16384,0,655360}
unit map;

interface

uses ObjType,MapItem;

type tMap16=array[0..15,0..15] of char;
     tMap=array[0..127,0..127] of byte;

var  Map16:tMap16;
     BMap:tMap;
     WhereMap:pointer;
     Ox,Oy:integer;
     Level:longint;

procedure DoMap;
procedure ClrMap;
procedure PutMap;
procedure PutMap16(const b:tBall);
procedure BuildMap(var Level:longint;NewLevel:boolean);
procedure PutBall(const B:tBall);
procedure PutMapItem(x,y,it:integer);

implementation

uses GLib,Data;

const
    chars:string[20]='xĿxxxѶ';
    dirs:string[16]=' ѳö';

var i,j:integer;
    state:integer;

procedure AddChar(x,y,d:integer);
var p,b:integer;
begin
    d:=(d+2)mod 4;
    b:=1 shl d;
    p:=pos(Map16[y,x],Dirs)-1;
    p:=p or b;
    Map16[y,x]:=Dirs[p+1];
end;

procedure FindWay(x,y,d:integer);
begin
   if Map16[y,x]<>'' then begin
     state:=1;
     AddChar(x,y,d);
   end else
   while state=0 do case random(5) of
     0:if (d<>2) and (y<14) then begin
       Map16[y,x]:=chars[d*4+0+1];
       FindWay(x,y+1,0);
       if state=0 then Map16[y,x]:='';
     end;
     1:if (d<>3) and (x<14) then begin
       Map16[y,x]:=chars[d*4+1+1];
       FindWay(x+1,y,1);
       if state=0 then Map16[y,x]:='';
     end;
     2:if (d<>0) and (y>0) then begin
       Map16[y,x]:=chars[d*4+2+1];
       FindWay(x,y-1,2);
       if state=0 then Map16[y,x]:='';
     end;
     3:if (d<>1) and (x>1) then begin
       Map16[y,x]:=chars[d*4+3+1];
       FindWay(x-1,y,3);
       if state=0 then Map16[y,x]:='';
     end;
     4:exit;
   end;
end;

procedure FindExit(x,y,d:integer);
var c:integer;
begin
   c:=0;
   if (x=14) and (y=14) then begin
     state:=1;
     Map16[y,x]:=chars[d*4+1+1];
   end else
     while state=0 do begin case random(5) of
       0:if (d<>2) and (y<14) and (Map16[y+1,x]='') then begin
         Map16[y,x]:=chars[d*4+0+1];
         FindExit(x,y+1,0);
         if state=0 then Map16[y,x]:='';
       end;
       1:if (d<>3) and (x<14) and (Map16[y,x+1]='') then begin
         Map16[y,x]:=chars[d*4+1+1];
         FindExit(x+1,y,1);
         if state=0 then Map16[y,x]:='';
       end;
       2:if (d<>0) and (y>0) and (Map16[y-1,x]='') then begin
         Map16[y,x]:=chars[d*4+2+1];
         FindExit(x,y-1,2);
         if state=0 then Map16[y,x]:='';
       end;
       3:if (d<>1) and (x>1) and (Map16[y,x-1]='') then begin
         Map16[y,x]:=chars[d*4+3+1];
         FindExit(x-1,y,3);
         if state=0 then Map16[y,x]:='';
       end;
       4:exit;
     end;
     c:=c+1;
     if c>2 then exit;
   end;
end;

procedure DoMap;
begin
   for i:=0 to 15 do
     for j:=0 to 15 do
       Map16[i,j]:='';
   Map16[0,0]:='';
   Map16[14,15]:='';
   state:=0;
   while state=0 do
     FindExit(1,0,1);
   for i:=0 to 14 do begin
     for j:=1 to 14 do
       while Map16[i,j]='' do begin
         State:=0;
         FindWay(j,i,4);
       end;
   end;
end;

procedure ClrMap;
var i,j:integer;
begin
   for i:=0 to 127 do
     for j:=0 to 127 do
       BMap[i,j]:=0;
end;

procedure PutArrow2(xx,yy,cell:integer);
var y:integer;
begin
   y:=GlobalCounter and 1023;
   y:=y div 16;
   if y>=32 then y:=63-y;
   y:=y-16;
   if y>0 then
     case cell of
       0:PutPicT(xx,yy+15-y,16,y,0,0,Blocks[cell+24],WhereMap);
       1:PutPicT(xx+15-y,yy,y,16,0,0,Blocks[cell+24],WhereMap);
       2:PutPicT(xx,yy,16,y,0,15-y,Blocks[cell+24],WhereMap);
       3:PutPicT(xx,yy,y,16,15-y,0,Blocks[cell+24],WhereMap);
     end;
end;

procedure PutMap;
var i,j,xx,yy,dx,dy:integer;
    cell:byte;
begin
    xx:=(Ox div 16);
    yy:=(Oy div 16);
    dx:=xx*16-Ox;
    dy:=yy*16-oy;
    for i:=0 to 13 do
      for j:=0 to 20 do begin
        cell:=BMap[yy+i,xx+j];
        if cell in [17..18,28..29] then
          if (GlobalCounter and 512)=0 then cell:=0;
        if cell in [24..27] then begin
          PutArrow2(dx+j*16,184-(dy+i*16),cell-24);
          cell:=0;
        end;
        if cell<>0 then
          PutPicT(dx+j*16,184-(dy+i*16),16,16,0,0,Blocks[cell],WhereMap);
      end;
end;

procedure PutMap16;
var bx,by,i,j,p,sx,sy:integer;
begin
   bx:=round(b.Position.r) div 128;
   by:=round(b.Position.i) div 128;
   for i:=0 to 15 do
     for j:=0 to 15 do begin
       p:=pos(Map16[i,j],Dirs);
       p:=p-1;if p=-1 then p:=0;
       sx:=p mod 4;sy:=p div 4;
       if (bx=j) and (by=i)
         then PutPicT(j*4,80-i*4,4,4,sx*4,sy*4,Blocks[47],WhereMap)
         else PutPicT(j*4,80-i*4,4,4,sx*4,sy*4,Blocks[46],WhereMap);
     end;
end;

procedure PutBall;
var xx:integer;
    yy:integer;
begin
    with B.Position do begin
      xx:=round(r-B.Radius)-Ox;
      yy:=round(i-B.Radius)-Oy;
      if BackCount=0 then PutPicT(xx,184-yy,16,16,0,0,Blocks[41],WhereMap)
                     else PutPicT(xx,184-yy,16,16,0,0,Blocks[42],WhereMap);
    end;
end;

procedure PutMapItem;
var i,j:integer;
begin
   for j:=0 to 7 do
     for i:=0 to 7 do
       BMap[y*8+7-j,x*8+i]:=MapItems[it][j,i];
end;

procedure BuildMap;
var i,j,p:integer;
    ch:char;
    cell:byte;
begin
   if NewLevel then Level:=RandSeed
               else RandSeed:=Level;
   DoMap;
   ClrMap;
   for j:=0 to 15 do
     for i:=0 to 15 do
       begin
         ch:=Map16[j,i];
         repeat
           p:=random(MaxMapItem+1);
           cell:=p+1;
         until (ItemsType[cell]=ch);
         PutMapItem(i,j,p);
       end;
{   putmapitem(0,0,2);}
end;

begin
end.