{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T+,V+,X+,Y+}
{$M 16384,0,655360}

unit glib;

interface

type tPalette=array[0..767] of byte;
     tScreen=array[0..199,0..319] of byte;
     pScreen=^tScreen;

var  ScreenPtr:pScreen;           { Screen pointer }
     VirtualPtr:pointer;          { Virtual screen pointer }
     Palette:tPalette;
     RndNumber:longint;           { For soften }

     KeyBuffHead:integer absolute $40:$1a;
     KeyBuffTail:integer absolute $40:$1c;

procedure ClearScr(Scr:pointer);
procedure ClearScrXY(x,y,w,h:integer;Scr:pointer);
procedure DecScrXY(y:integer);
{procedure DecScrXY(x,y,w,h:integer;Scr:pointer);}
procedure Swap;
procedure WVR;
procedure Soften(scr:pointer);
procedure Soften2(scr:pointer);
procedure MotionBlure(scr:pointer);
procedure PutPic(x,y,w,h,sx,sy:integer;src,dst:pointer);
procedure PutPicT(x,y,w,h,sx,sy:integer;src,dst:pointer);
procedure SetRgb(n,r,g,b:byte);
procedure SetPalette(const Palette:tPalette);
procedure PutPixel(Scr:pointer;x,y,c:integer);
function  GetPixel(Scr:pointer;x,y:integer):integer;
procedure InitVideo;
procedure DoneVideo;
function  AddPtr(p:pointer;d:longint):pointer;
function  GetKey:word;
function  KeyPressed:boolean;

implementation

procedure ClearScr;assembler;
asm
   les di,Scr
   cld
   mov cx,16000
   db 66h; xor ax,ax
   rep
   db 66h; stosw
end;

procedure ClearScrXY;assembler;
asm
   les di,Scr
   cld
   add di,x
   mov ax,y
   shl ax,6
   add di,ax
   shl ax,2
   add di,ax
   mov dx,h
   xor ax,ax
@@LoopY:
   mov cx,w
   rep stosb
   add di,320
   sub di,w
   dec dx
   jne @@LoopY
end;

procedure DecScrXY;assembler;
asm
   les di,VirtualPtr{scr}
   cld
   add di,0{x}
   mov ax,y
   shl ax,6
   add di,ax
   shl ax,2
   add di,ax
   mov dx,24{h}
   xor ax,ax
@@LoopY:
   mov cx,320{w}
@@LoopX:
   mov al,es:[di]
   mov bl,al
   and bl,0fh
   jz @@Skip
   dec al
@@Skip:
   mov es:[di],al
   inc di
   loop @@LoopX
{   add di,320
   sub di,w}
   dec dx
   jne @@LoopY
end;

procedure Swap;assembler;
asm
   push ds
   les di,ScreenPtr
   lds si,VirtualPtr
   cld
   mov cx,16000
   rep
   db 66h; movsw
   pop ds
end;

procedure WVR;assembler;
asm
   mov dx,3dah
@@loop1:
   in al,dx
   test al,8
   jne @@loop1
@@loop2:
   in al,dx
   test al,8
   je @@loop1
end;

procedure MotionBlure;assembler;
asm
   les di,Scr
   cld
   mov cx,64000
@@Loop:
   mov al,es:[di]
   cmp al,0e0h
   jae @@RG
   mov bl,al
   and al,0f0h
   and bl,0fh
   or  bl,bl
   jz  @@Skip
   dec bl
   jnz @@SkipZ
   or al,al
@@SkipZ:
   add al,bl
   mov es:[di],al
   jmp @@Skip
@@RG:
   dec al
   cmp al,0eh
   jne @@RGok
   xor al,al
@@RGok:
   mov es:[di],al
@@Skip:
   inc di
   loop @@Loop
end;

procedure MakeRandom;assembler;
asm
   push ax
   push bx
   push cx
   xor ax,dx
   rol dx,2
   mov cx,dx
   and cl,7
   rol dx,cl
   xor dx,ax
   pop cx
   pop bx
   pop ax
end;

procedure Soften;assembler;
asm
   les di,Scr
   cld
   add di,321
   mov si,197
   db 66h;mov dx,word ptr ds:[RndNumber]
@@LoopY:
   mov cx,318
@@LoopX:
   mov al,es:[di]
   or al,al
   jz @@Start
@@Start:
   xor bx,bx
   mov bl,es:[di]
   and bl,0fh
   add bh,bl
   mov bl,es:[di+319]
   and bl,0fh
   add bh,bl
   mov bl,es:[di+321]
   and bl,0fh
   add bh,bl
   mov bl,es:[di+320]
   and bl,0fh
   add bh,bl
   mov bl,dl
   and bl,7
   cmp bh,0
   je @@SkipZ
   add bh,bl
@@SkipZ:
   shr bh,2
   mov al,1*16
   add al,bh
   mov es:[di],al
@@Skip:
   inc di
   call MakeRandom
   loop @@LoopX
   add di,2
   dec si
   jne @@LoopY
end;

procedure Soften2;assembler;
asm
   les di,Scr
   cld
   add di,0
   mov si,200
   db 66h;mov dx,word ptr ds:[RndNumber]
@@LoopY:
   mov cx,320
@@LoopX:
   mov al,es:[di]
   or al,al
   jz @@Start
@@Start:
   xor bx,bx
   mov bl,es:[di]
   and bl,0fh
   add bh,bl
   mov bl,es:[di+319]
   and bl,0fh
   add bh,bl
   mov bl,es:[di+321]
   and bl,0fh
   add bh,bl
   mov bl,es:[di+320]
   and bl,0fh
   add bh,bl
   mov bl,dl
   and bl,7
   cmp bh,0
   je @@SkipZ
   add bh,bl
@@SkipZ:
   shr bh,2
   cmp bh,15
   jbe @@ColOk
   mov bh,15
@@ColOk:
   mov al,1*16
   add al,bh
   mov es:[di],al
@@Skip:
   inc di
   call MakeRandom
   loop @@LoopX
   dec si
   jne @@LoopY
end;

procedure PutPic;
begin
   if x+w<=0 then exit;
   if y+h<=0 then exit;
   if x>=320 then exit;
   if y>=200 then exit;
   if x<0 then begin w:=w+x;sx:=sx-x;x:=0;end;
   if y<0 then begin h:=h+y;sy:=sy-y;y:=0;end;
   if x+w>320 then w:=320-x;
   if y+h>200 then h:=200-y;
   if w<=0 then exit;
   if h<=0 then exit;
   asm
     push ds
     les di,Dst; lds si,Src; cld
     mov ax,sy
     add si,sx
     shl ax,6
     add si,ax
     shl ax,2
     add si,ax
     add di,x
     mov ax,y
     shl ax,6
     add di,ax
     shl ax,2
     add di,ax
     mov dx,h
     mov bx,320
     sub bx,w
@@LoopY:
     mov cx,w
     rep movsb
     add di,bx
     add si,bx
     dec dx
     jne @@LoopY
     pop ds
@@out:
   end;
end;

procedure PutPicT;
begin
   if x+w<=0 then exit;
   if y+h<=0 then exit;
   if x>=320 then exit;
   if y>=200 then exit;
   if x<0 then begin w:=w+x;sx:=sx-x;x:=0;end;
   if y<0 then begin h:=h+y;sy:=sy-y;y:=0;end;
   if x+w>320 then w:=320-x;
   if y+h>200 then h:=200-y;
   if w<=0 then exit;
   if h<=0 then exit;
   asm
     push ds
     les di,Dst; lds si,Src; cld
     mov ax,sy
     add si,sx
     shl ax,6
     add si,ax
     shl ax,2
     add si,ax
     add di,x
     mov ax,y
     shl ax,6
     add di,ax
     shl ax,2
     add di,ax
     mov dx,h
     mov bx,320
     sub bx,w
@@LoopY:
     mov cx,w
@@LoopX:
     lodsb
     or al,al
     jz @@Skip
     mov es:[di],al
@@Skip:
     inc di
     loop @@LoopX
     add di,bx
     add si,bx
     dec dx
     jne @@LoopY
     pop ds
   end;
end;

procedure SetRGB;assembler;
asm
   mov dx,3c8h
   mov al,n
   out dx,al
   inc dx
   mov al,r
   out dx,al
   mov al,g
   out dx,al
   mov al,b
   out dx,al
end;

procedure SetPalette;
var i:integer;
begin
   for i:=0 to 255 do
     SetRGB(i,Palette[i*3],Palette[i*3+1],Palette[i*3+2]);
end;

procedure PutPixel;assembler;
asm
   les di,Scr
   mov ax,x
   cmp ax,320
   jae @@out
   add di,ax
   mov ax,y
   cmp ax,200
   jae @@out
   shl ax,6
   add di,ax
   shl ax,2
   add di,ax
   mov ax,c
   stosb
@@out:
end;

function GetPixel;
var col:integer;
begin
   asm
     les di,Scr
     add di,x
     mov ax,y
     shl ax,6
     add di,ax
     shl ax,2
     add di,ax
     mov al,byte ptr es:[di]
     xor ah,ah
     mov col,ax
   end;
   GetPixel:=col;
end;


procedure InitVideo;
begin
   ScreenPtr:=Ptr(SegA000,0);
   getmem(VirtualPtr,64000);
end;

procedure DoneVideo;
begin
   asm mov ax,3 ;int 10h;end;
   freemem(VirtualPtr,64000);
end;

function AddPtr;
begin
   Addptr:=pointer(longint(p)+d);
end;

function GetKey;
var w:word;
begin
   asm
     xor ax,ax
     int 16h
     mov w,ax
   end;
   GetKey:=w;
end;

function KeyPressed;
begin
   KeyPressed:=KeyBuffHead<>KeyBuffTail;
end;

{ Initialization }

begin
   If MaxAvail<128000 then begin
     WriteLn('Not enough memory !');
     halt(8);
   end;
   InitVideo;
   Randomize;
   RndNumber:=RandSeed;
end.