{$G+}
unit effects;

interface
uses GLib,Data,Complex,Map;

type tEPoint=record
       x,y:real;
       z,c:integer;
     end;
     tP=record
       x,y,vx,vy,c:integer;
     end;

var  CurPalette:tPalette;
     FPalette:tPalette;
     Points:array[0..255] of tEPoint;
     Points2:array[0..255] of tP;
     FlashCount:integer;
     StartCount:integer;
const P2Count=16;
      P2MaxCol=16;
      P2Col=16*13;
      MaxFlash=63*4;

procedure RotatePalette;
procedure MakePalette(nr:integer);
procedure InitStars;
procedure MoveStars;
procedure InitRain;
procedure MoveRain;
procedure InitP2;
procedure MoveP2(mx,my:integer);
procedure AddP2(xx,yy:integer);

implementation

const MaxCol=4;

procedure RotatePalette;
var r,g,b,n:byte;i:integer;
begin
{   r:=CurPalette[224*3];
   g:=CurPalette[224*3+1];
   b:=CurPalette[224*3+2];
   for i:=0 to 92 do
     CurPalette[224*3+i]:=CurPalette[225*3+i];
   CurPalette[255*3]:=r;
   CurPalette[255*3+1]:=g;
   CurPalette[255*3+2]:=b;}
   asm push ds;pop es
       lea di,CurPalette
       add di,224*3
       mov si,di
       add si,3
       mov bx,word ptr [di]
       mov al,byte ptr [di+2]
       mov cx,93;cld
       rep movsb
       mov [di],bx
       mov [di+2],al
   end;
   if FlashCount>0 then begin
     dec(FlashCount);
     asm
       push ds
       pop es
       lea di,FPalette
       lea si,CurPalette
       mov cx,768
       mov bx,FlashCount
       shr bx,2
@@l1:  lodsb
       add al,bl
       cmp al,63
       jbe @@OK
       mov al,63
@@OK:  stosb
       loop @@l1
     end;
     Setpalette(FPalette);
   end else
   SetPalette(CurPalette);
end;

procedure MakePalette;
var i:integer;
begin
   Curpalette:=Palette;
{   for i:=0 to 191 do
     CurPalette[i]:=Palette[nr*3*64+i];}
   asm push ds;pop es
       lea di,CurPalette
       mov si,di
       mov ax,nr;shl ax,6;add si,ax;shl ax,1;add si,ax
       mov cx,192;cld
       rep movsb
   end;
   SetPalette(CurPalette);
end;

procedure InitStars;
var xx,yy,i:integer;
begin
   for i:=0 to 255 do
     with points[i] do begin
       xx:=random(320)-160;
       yy:=random(200)-100;
       x:=xx;y:=yy;
       z:=i;
       c:=random(MaxCol)*16;
     end;
end;

procedure MoveStars;
const zOff=512;
var i:integer;
    xx,yy,col:integer;
begin
   for i:=0 to 255 do
     with points[i] do begin
       xx:=round(x*zOff/(z+zOff))+160;
       yy:=round(y*zOff/(z+zOff))+100;
       col:=c+7-(z div 32);
       PutPixel(WhereMap,xx,yy,col);
       z:=z-2;
       if z<0 then begin
         xx:=random(320)-160;
         yy:=random(200)-100;
         x:=xx;y:=yy;
         z:=255;
         c:=random(MaxCol)*16;
       end;
     end;
end;

procedure InitRain;
var xx,yy,i:integer;
begin
   for i:=0 to 255 do
     with points[i] do begin
       xx:=random(320);
       yy:=random(200);
       z:=random(8)+1;
       x:=xx;y:=yy;
       c:=random(32)+12*16;
     end;
end;

procedure MoveRain;
var xx,yy,i:integer;
begin
   for i:=0 to 255 do
     with points[i] do if c>=0 then begin
       x:=x-(z/8);
       y:=y+z;
       if x<0 then x:=x+320;
       if y>=200 then y:=y-200;
       xx:=round(x)+(ox div 16);
       xx:=xx mod 320;
       yy:=round(y);
       PutPixel(WhereMap,xx,yy,c);
     end;
end;

procedure InitP2;
var i:integer;
begin for i:=0 to 255 do with Points2[i] do begin c:=-1;end;
end;

procedure MoveP2(mx,my:integer);
var i:integer;
begin for i:=0 to 255 do with Points2[i] do if c>=0 then begin
    PutPixel(WhereMap,x+mx-ox,199-(y+my-oy),c+P2Col);
    x:=x+vx;y:=y+vy;
    if StartCount<0 then begin vy:=vy-1;c:=c-1;end;
  end;
end;

procedure AddP2;
var i,j:integer;
begin j:=P2Count;i:=0;
    While (i<=255) and (j>=0) do with Points2[i] do begin
      if c=-1 then begin
        c:=Random(P2MaxCol);
        x:=xx;y:=yy;vx:=random(9)-4;vy:=random(9)-4;
        dec(j);
      end;
      inc(i);
    end;

end;

begin
   MakePalette(0);
end.
