{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T+,V+,X+,Y+}
{$M 16384,0,655360}

unit Complex;

interface

type tComplex=record
                R,I:real;
              end;

const CalcErr:real=0.01;

procedure cAdd(var a,b:tComplex);
procedure cSub(var a,b:tComplex);
procedure cMul(var a,b:tComplex);
{procedure cDiv(var a,b:tComplex);
procedure cAddS(var a:tComplex;x,y:real);
procedure cSubS(var a:tComplex;x,y:real);
procedure cMulS(var a:tComplex;s:real);
procedure cDivS(var a:tComplex;s:real);}
procedure ToTri(var c:tcomplex;var a,b:real);
procedure FromTri(var c:tcomplex;a,b:real);
function  ATan(dx,dy:real):real;

implementation

procedure cAdd;
begin
   a.r:=a.r+b.r;
   a.i:=a.i+b.i;
end;

procedure cSub;
begin
   a.r:=a.r-b.r;
   a.i:=a.i-b.i;
end;

procedure cMul;
var c:tComplex;
begin
   c.r:=a.r*b.r-a.i*b.i;
   c.i:=a.i*b.r+a.r*b.i;
   a:=c;
end;
{
procedure cDiv;
var t:real;
    c:tComplex;
begin
   t:=sqr(b.r)+sqr(b.i);
   if t=0 then RunError(0);
   c.r:=(a.r*b.r+a.i*b.i)/t;
   c.i:=(b.r*a.i-a.r*b.i)/t;
   a:=c;
end;

procedure cAddS;
begin
   a.r:=a.r+x;
   a.i:=a.i+y;
end;

procedure cSubS;
begin
   a.r:=a.r-x;
   a.i:=a.i-y;
end;

procedure cDivS;
begin
   a.r:=a.r/s;
   a.i:=a.i/s;
end;

procedure cMulS;
begin
   a.r:=a.r*s;
   a.i:=a.i*s;
end;
}
function ATan;
var b:real;
begin
   if (dx=0) and (dy=0) then b:=0      else
   if (dx=0) and (dy>0) then b:=pi/2   else
   if (dx=0) and (dy<0) then b:=3*pi/2 else
   if (dy=0) and (dx>0) then b:=0      else
   if (dy=0) and (dx<0) then b:=pi     else
   begin
     b:=ArcTan(dy/dx);
     if (dx<0) then b:=b+pi;
     if (dx>0) and (dy<0) then b:=b+pi*2;
   end;
   ATan:=b;
end;

procedure ToTri;
begin
   a:=sqrt(sqr(c.r)+sqr(c.i));
   if a=0 then b:=0
          else b:=ATan(c.r,c.i);
end;

procedure FromTri;
begin
   c.r:=a*cos(b);
   c.i:=a*sin(b);
end;

end.