{$A+,B-,D+,E+,F-,G+,I+,L+,N-,O-,P-,Q-,R-,S+,T-,V+,X+,Y+}
{$M 16384,0,655360}
unit CharGen;

interface

var Characters:pointer;
    BiosFont:pointer;
const
    WriteCol=1;
    BordTbl:array[0..15] of byte=(0,6,6,6,14,10,4,4,14,4,10,4,14,4,4,4);
    FillTbl:array[0..15] of byte=(9,10,11,12,13,14,15,0,2,4,6,8,10,12,14,15);

procedure InitCharGen;
procedure DoneCharGen;
procedure PutChar(x,y,col:integer;chr:char;Scr:pointer);
procedure PutString(x,y,col:integer;const s:string;Scr:pointer);
function  GetString(x,y,max:integer;var s:string):boolean;

implementation
uses GLib;

procedure MakeFont;assembler;
asm
   { Get Bios Font Table }
   push bp
   mov ax,1130h
   mov bh,3
   int 10h
   mov word ptr [BiosFont],bp
   mov word ptr [BiosFont+2],es
   pop bp

   { Clear Characters }
   push ds
   les di,Characters
   mov cx,128*20*20/4
   db 66h; xor ax,ax
   cld
   rep
   db 66h; stosw

   { Scale Characters }
   les di,Characters
   lds si,BiosFont
   mov ch,80h
@loop1:     
   mov cl,08   
   add di,42   
@loop3:
   mov bl,ds:[si]
   inc si      
   mov dx,8    
@loop2:         
   xor al,al   
   shl bl,1    
   adc al,0    
   mov es:[di+20],al
   stosb       
   mov es:[di+20],al
   stosb       
               
   dec dx      
   jne @loop2
   add di,24
            
   dec cl
   jne @loop3
            
   add di,38
   dec ch   
   jne @loop1
             
   pop ds   

   { Make Border to Characters }
   les di,Characters
   add di,21
   mov cx,128*20*20-42
@mb@loop1:
   cmp byte ptr es:[di],0
   jne @mb@next
   xor bx,bx
   cmp byte ptr es:[di+20],writecol
   jne @mb@s0
   or bl,1
@mb@s0:
   shl bl,1     
   cmp byte ptr es:[di+1],writecol
   jne @mb@s1
   or bl,1      
@mb@s1:
   shl bl,1     
   cmp byte ptr es:[di-1],writecol
   jne @mb@s2
   or bl,1      
@mb@s2:
   shl bl,1     
   cmp byte ptr es:[di-20],writecol
   jne @mb@s3
   or bl,1    
@mb@s3:
   mov al,byte ptr [bx+offset bordtbl]
   mov es:[di],al
@mb@next:
   inc di        
   dec cx      
   jne @mb@loop1

   { Fill Characters }
   les di,Characters
   add di,40
   mov cx,128     
@ff2@loop1:
   mov dh,16
   mov bx,0
@ff2@loop2:
   mov dl,20      
   mov al,byte ptr[bx+offset filltbl]
@ff2@loop3:
   cmp byte ptr es:[di],writecol
   jne @ff2@skip
   mov es:[di],al
@ff2@skip:
   inc di
   dec dl
   jne @ff2@loop3
   inc bx
   and bx,0fh
   dec dh
   jne @ff2@loop2
   add di,80
   dec cx
   jne @ff2@loop1
end;

procedure InitCharGen;
begin
   GetMem(Characters,51200);
   MakeFont;
end;

procedure DoneCharGen;
begin
   FreeMem(Characters,51200);
end;

procedure PutChar;assembler;
asm
   push ds
   les di,Scr
   lds si,Characters
   mov ax,y
   add di,x
   shl ax,6
   add di,ax
   shl ax,2
   add di,ax
   xor ax,ax
   mov al,chr
   mov bx,20*20
   mul bx
   add si,ax
   mov dx,20
   mov bx,col
@@LoopY:
   mov cx,20
@@LoopX:
   lodsb
   or al,al
   je @@Skip
   add ax,bx
   mov es:[di],al
@@Skip:
   inc di
   loop @@LoopX
   add di,300
   dec dx
   jne @@LoopY
   pop ds
end;

procedure PutString;
var i:integer;
begin
   col:=col*16;
   if s<>'' then
     for i:=1 to byte(s[0]) do begin
       PutChar(x,y,col,s[i],Scr);
       x:=x+20;
     end;
end;

function GetString;
var ch:char;
begin
   GetString:=false;
   s:='';
   repeat
     ch:=chr(GetKey);
     if ch in['0'..'9','-'] then begin
       s:=s+ch;
       PutChar(x,y,12*16,ch,ScreenPtr);
       x:=x+20;
     end;
     if ch=#13 then GetString:=true;
   until (not (ch in['0'..'9','-'])) or (byte(s[0])>=Max);
end;

begin
   InitCharGen;
end.
