{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T+,V+,X+,Y+}
{$M 16384,0,128000}

program Ball32k_Main_Program;

uses GLib, CharGen, Map, Data, Complex, Objs, ObjType, Effects, SB;

var   { Main Variables }
   MBall           :tBall;
   Score           :Longint;
   GameState       :integer;
   HasKey          :integer;
   Lives           :integer;
   MessageCount    :integer;
   Message         :string;
   CheatParam      :boolean;
   NoSound         :boolean;
{ SubGames }
   SubMap          :array[0..11,0..11] of byte;
   Coords          :array[0..255,0..1] of byte;

const { Predefined variables }
   BallWidth     =7;
   BallHeight    =7;
   Gravity:real  =0.02;     { Gravitci }
   PullDown:real =0.05;     { Mr nem emlkszem }
   MaxSpeedY:real=1.8;      { Fggleges max. sebessg }
   MaxSpeedX:real=0.6;      { Vzszintes max. sebessg }
   DrawSpeed:byte=3;        { A szmtsok szma kpenknt }
   WVRCount:byte =0;        { A vrakozsok szma kpenknt }
   DecSpeedX:real=0.003;    { A vzszintes sebessg cskkents }
   IncSpeedX:real=0.1;      { A sebessg nvelse }
   SpeedUp:real  =1.5;
   SpeedDown:real=0.95;
   BackCountMax:integer=256;
   MsgCountMax:integer=1024;{ A felirat kijelzsnek ideje }
   ShowBackCount:boolean=true;
   StartX=24;               { Kezd pozici }
   StartY=64;               { Kezd pozici }
   MaxStartCount:byte=64;   { Visszaszmlls }

{   BSong='C C C G   C G   C G         #!';}
   DSongs:array[1..3] of string=(
               'OQONLNLJH C H J L JLNLJHG   G   '+
               'OQONLNLJH C H J L JHGHJGH   #   '+
               'HGHJL J HGHJL J H J L N L   J   '+
               'HGHJL J HGHJL J H J L N L   J   #   ',
             'E J   L H   E J   L H   E Q   N L o S J n L J   E '+
               'N   O L   Q N   O L   Q N   J G   C A e C A   E '+
               'E   E E   E E   E E   E 5   A C   7 E   E   5   #   ',
               'L  JH   C OO   L  HH G J N   #   '+
               'C  CC   H  LL  JL  JH   G   #   '+
               'L  JH   C  OO   L  HH G J N   #   '+
               'C  CC H L O N J H   G L J H       #   '+
               'L  LJ   N L J H   L J H G  HJ   #   '+
               'L  NO   N  LL J H L J H G  EC       #   '+
               'L  H   C  OO   L  HH G J N   #   '+
               'C  CC H L O N J H   G L J H       #   ');


{-------------------------------------------------------------}

procedure Init; { Grafika belltsa }
begin
   asm mov ax,13h; int 10h;
   les di,DPalette;cld;mov cx,768;lea si,Palette
   @@l:mov al,es:[di];mov ds:[si],al;inc di;inc si;loop @@l
   end;
   SetPalette(Palette);
end;

procedure SendMessage(const s:string);               { Uzenet kldse }
begin
   MessageCount:=MsgCountMax;
   Message:=copy(s,1,16);
end;

procedure PutMessage;                          { Uzenet kirsa }
var l:integer;
begin
   if MessageCount=0 then exit;
   if Message='' then exit;
{   l:=byte(Message[0]);
   l:=(320-l*20) div 2;}
   asm xor ax,ax
       mov al,byte ptr [Message]
       mov bx,20
       mul bx
       mov cx,320
       sub cx,ax
       shr cx,1
       mov l,cx
   end;
   PutString(l,180,14,Message,WhereMap);
end;

{-------------------------------------------------------------}

procedure Wait;                                { Vrakozs }
begin
   Repeat
     RotatePalette;
     WVR;
   Until KeyPressed;
   GetKey;
end;

procedure FadeOut(Scr:pointer);                { Elsttts }
var c:integer;
begin
   for c:=0 to 15 do begin
     MotionBlure(Scr);
     WVR;
   end;
end;

procedure GameInit;                            { Uj jtk belltsa }
begin
   SetBall(MBall,StartX,StartY,0,0,BallWidth,BallHeight); { Labdacs init. }
   MakePalette(random(3));                     { Random palette }
   Effect:=random(3);                          { Random effekt }
   BackCount:=0;GameState:=0;
   WhereMap:=VirtualPtr;                       { Virtulis kperny }
   DrawCounter:=0;
   GlobalCounter:=0;
end;

procedure CheckSpeed(var b:tBall);             { Labda sebessg ellenrzse }
begin
   with b.speed do begin
     if r<-MaxSpeedX then r:=-MaxSpeedX;
     if r> MaxSpeedX then r:= MaxSpeedX;
     if i<-MaxSpeedY then i:=-MaxSpeedY;
     if i> MaxSpeedY then i:= MaxSpeedY;
     if abs(r)<DecSpeedX then r:=0 else
        if r>0 then r:=r-DecSpeedX
               else r:=r+DecSpeedX;
   end;
end;

procedure CheckPosition(var b:tBall);          { Labdacs pozici ell. }
var rr,ii:integer;
begin
   with b.position do begin
     rr:=round(r);ii:=round(i);
     if ii<0 then Lives:=0;
     if rr<0 then GameState:=1;
     if rr>=128*16 then GameState:=2;
     if (rr-Ox)>240 then Ox:=rr-240;
     if (rr-Ox)<80  then Ox:=rr-80;
     if (ii-Oy)>150 then Oy:=ii-150;
     if (ii-Oy)<50  then Oy:=ii-50;
     if (Ox<0) then Ox:=0;
     if (Oy<0) then Oy:=0;
     if (Ox>128*16-320) then Ox:=128*16-320;
     if (Oy>128*16-200) then Oy:=128*16-200;
   end;
end;

procedure DoFPoint(var b:tBall;xx,yy,vx,vy:integer);
var p:tPoint;                  { Labdacs + Fiz pont }
begin
   with p do begin
     position.r:=xx;
     position.i:=yy;
     speed.r:=vx;
     speed.i:=vy;
     weight:=100000;
   end;
   DoBFP(b,p);
end;

function DoBallCell1(var b:tBall;xx,yy,ww,hh:integer):boolean;
var corners:array[0..3] of boolean; { Labdacs + fix kocka }
    bx,by,i:integer;
    p:tPoint;
    w:tWall;
begin
    bx:=round(b.position.r);
    by:=round(b.position.i);
    for i:=0 to 3 do
      corners[i]:=false;
    with w do begin { top }
      Speed.r:=0;Speed.i:=0;
      x1:=xx   ;x2:=xx+ww;
      y1:=yy+hh;y2:=yy+hh;
    end;
    if by>=yy+hh then if DoBFW(b,w) then begin
      corners[0]:=true;corners[1]:=true;
{      if b.Speed.i>0 then
        if b.Speed.i<1 then
          b.Speed.i:=1;}
    end;
    with w do begin { left }
      Speed.r:=0;Speed.i:=0;
      x1:=xx   ;x2:=xx   ;
      y1:=yy   ;y2:=yy+hh;
    end;
    if bx<=xx then if DoBFW(b,w) then begin
      corners[0]:=true;corners[3]:=true;
    end;
    with w do begin { bottom }
      Speed.r:=0;Speed.i:=0;
      x1:=xx   ;x2:=xx+ww;
      y1:=yy   ;y2:=yy   ;
    end;
    if by<=yy then if DoBFW(b,w) then begin
      corners[3]:=true;corners[2]:=true;
    end;
    with w do begin { right }
      Speed.r:=0;Speed.i:=0;
      x1:=xx+ww;x2:=xx+ww;
      y1:=yy   ;y2:=yy+hh;
    end;
    if bx>=xx+ww then if DoBFW(b,w) then begin
      corners[1]:=true;corners[2]:=true;
    end;
    if (bx>=xx) and (by>=yy) and (bx<xx+ww) and (by<yy+hh) then
      begin
        exit;
        DoBallCell1:=false;
      end;
    if not corners[0] then begin { top-left corner }
      with p do begin
        position.r:=xx   ;position.i:=yy+hh;
        speed.r:=0;speed.i:=0;
      end;
      corners[0]:=DoBFP(b,p);
    end;
    if not corners[3] then begin { bottom-left corner }
      with p do begin
        position.r:=xx   ;position.i:=yy   ;
        speed.r:=0;speed.i:=0;
      end;
      corners[3]:=DoBFP(b,p);
    end;
    if not corners[1] then begin { top-right corner }
      with p do begin
        position.r:=xx+ww;position.i:=yy+hh;
        speed.r:=0;speed.i:=0;
      end;
      corners[1]:=DoBFP(b,p);
    end;
    if not corners[2] then begin { bottom-right corner }
      with p do begin
        position.r:=xx+ww;position.i:=yy   ;
        speed.r:=0;speed.i:=0;
      end;
      corners[2]:=DoBFP(b,p);
    end;
   DoBallCell1:=corners[0] or corners[1] or corners[2] or corners[3];
end;

function DoBallCell3(var b:tBall;xx,yy:integer;vx,vy:real):boolean;
var corners:array[0..3] of boolean;
    i:integer;
    p:tPoint;
    w:tWall;
begin
    for i:=0 to 3 do
      corners[i]:=false;
    xx:=xx*16;yy:=yy*16;
    with w do begin { top }
      Speed.r:=vx;Speed.i:=vy;
      x1:=xx   ;x2:=xx+16;
      y1:=yy+16;y2:=yy+16;
    end;
    if (vy<>0) and DoBW(b,w) then begin
      corners[0]:=true;corners[1]:=true;
    end;
    with w do begin { left }
      Speed.r:=vx;Speed.i:=vy;
      x1:=xx   ;x2:=xx   ;
      y1:=yy   ;y2:=yy+16;
    end;
    if (vx<>0) and DoBW(b,w) then begin
      corners[0]:=true;corners[3]:=true;
    end;
    with w do begin { bottom }
      Speed.r:=vx;Speed.i:=vy;
      x1:=xx   ;x2:=xx+16;
      y1:=yy   ;y2:=yy   ;
    end;
    if (vy<>0) and DoBW(b,w) then begin
      corners[3]:=true;corners[2]:=true;
    end;
    with w do begin { right }
      Speed.r:=vx;Speed.i:=vy;
      x1:=xx+16;x2:=xx+16;
      y1:=yy   ;y2:=yy+16;
    end;
    if (vx<>0) and DoBW(b,w) then begin
      corners[1]:=true;corners[2]:=true;
    end;
   DoBallCell3:=corners[0] or corners[1] or corners[2] or corners[3];
end;

procedure Game1;{BreakOut}
const
    Cells:array[0..15] of byte=(0,1,2,3,4,5,6,1,2,3,4,5,6,13,14,15);
    XStep=4;

var i,j:integer;
    ball:tBall;
    XPos:integer;
    KeyCode:byte;
   procedure PutMap;
   var i,j:integer;
       wrt:string;
   begin
     if MotionOn>0 then
       MotionBlure(WhereMap);
     if MotionOn>0 then begin
       for i:=0 to 11 do
         for j:=0 to 11 do
           if SubMap[i,j]<>0 then
             PutPicT(j*16,184-i*16,16,16,0,0,Blocks[SubMap[i,j]],WhereMap)
         end
       else for i:=0 to 11 do
         for j:=0 to 11 do
           PutPic(j*16,184-i*16,16,16,0,0,Blocks[SubMap[i,j]],WhereMap);
     i:=round(ball.position.r);
     j:=round(ball.position.i);
     PutPicT(i-8,192-j,16,16,0,0,Blocks[41],WhereMap);
     PutPicT(16+XPos,184,16,16,0,0,Blocks[18],WhereMap);
     PutPicT(32+XPos,184,16,16,0,0,Blocks[18],WhereMap);
     PutString(220, 0,0,'Bonus',WhereMap);
     PutString(230,20,0,'Game',WhereMap);
     PutPicT(200,64,16,16,0,0,Blocks[15],WhereMap);
     Str(Score:3,Wrt);
     PutString(216,64,0,Wrt,VirtualPtr);
     PutPicT(200,80,16,16,0,0,Blocks[43],WhereMap);
     Str(HasKey:3,Wrt);
     PutString(216,80,0,Wrt,VirtualPtr);
     PutPicT(200,96,16,16,0,0,Blocks[41],WhereMap);
     Str(Lives:3,Wrt);
     PutString(216,96,0,Wrt,VirtualPtr);
   end;
   procedure DoSubBallCell(xx,yy:integer);
   var cell:byte;
   begin
     if (xx<0) or (yy<0) or (xx>11) or (yy>11) then exit;
     cell:=SubMap[yy,xx];
     if cell<>0 then
      if DoBallCell1(ball,xx*16,yy*16,16,16) then begin
       if (xx>0) and (xx<11) and (yy>0) and (yy<11) then begin
         SubMap[yy,xx]:=0;
         Case cell of
           13:Inc(Lives);
           14:Inc(HasKey);
           15:Inc(Score);
         end;
       end;
     end;
   end;
begin
   Randomize;
    for i:=0 to 11 do
      for j:=0 to 11 do
        SubMap[i,j]:=6;
    for i:=0 to 10 do
      for j:=1 to 10 do
        if i>=4 then SubMap[i,j]:=Cells[Random(16)]
                else SubMap[i,j]:=0;
    XPos:=64;SetBall(ball,96,24,0,0,8,8);
    if MotionOn>0 then ClearScrXY(0,8,192,192,WhereMap)
                  else ClearScr(WhereMap);
    repeat
      PutMap;
      Swap;
      if WVRCount>0 then for i:=0 to WVRCount-1 do WVR;
      KeyCode:=port[$60];
      if KeyCode=77 then if XPos+XStep<160-32 then
        XPos:=XPos+XStep;
      if KeyCode=75 then if XPos>=XStep then
        XPos:=XPos-XStep;
      while KeyPressed do begin
        KeyCode:=GetKey shr 8;
        if KeyCode=1 then Ball.Position.i:=0;
        if KeyCode in[57,28,80] then
          if (Ball.Speed.r=0) and (Ball.Speed.i=0) then
            SetBall(ball,96,24,1,3,8,8);
      end;
      with ball do begin
        i:=round(Position.r-8) div 16;
        j:=round(Position.i-8) div 16;
        DoSubBallCell(i  ,j  );
        DoSubBallCell(i+1,j  );
        DoSubBallCell(i  ,j+1);
        DoSubBallCell(i+1,j+1);
        DoBallCell1(ball,16+XPos,0,32,16);
        cAdd(Position,Speed);
      end;
      RotatePalette;
    until Ball.Position.i<=8;
end;

procedure Game2;{Fall Down}
const
    Cells:array[0..15] of byte=(22,22,22,26,26,26,28,22,26,28,3,2,1,13,14,15);
    XStep=4;
type tGift=record
       x,y,s,tip:integer;
     end;
var i,j:integer;
    XPos:integer;
    KeyCode:byte;
    Gifts:array[0..7] of tGift;
    StartGame:boolean;
    EndGame:boolean;
   procedure PutMap;
   var i,j:integer;
       wrt:string;
   begin
     if MotionOn>0 then
       MotionBlure(WhereMap);
     if MotionOn>0 then begin
       for i:=0 to 11 do
         for j:=0 to 11 do
           if SubMap[i,j]<>0 then
             PutPicT(j*16,184-i*16,16,16,0,0,Blocks[SubMap[i,j]],WhereMap)
         end
       else for i:=0 to 11 do
         for j:=0 to 11 do
           PutPic(j*16,184-i*16,16,16,0,0,Blocks[SubMap[i,j]],WhereMap);
     for i:=0 to 7 do with gifts[i] do begin
       PutPicT(16+x,184-y,16,16,0,0,Blocks[Tip],WhereMap);
     end;
     PutPicT(16+XPos,184,16,16,0,0,Blocks[18],WhereMap);
     PutPicT(32+XPos,184,16,16,0,0,Blocks[18],WhereMap);
     PutString(220, 0,0,'Bonus',WhereMap);
     PutString(230,20,0,'Game',WhereMap);
     PutPicT(200,64,16,16,0,0,Blocks[15],WhereMap);
     Str(Score:3,Wrt);
     PutString(216,64,0,Wrt,VirtualPtr);
     PutPicT(200,80,16,16,0,0,Blocks[43],WhereMap);
     Str(HasKey:3,Wrt);
     PutString(216,80,0,Wrt,VirtualPtr);
     PutPicT(200,96,16,16,0,0,Blocks[41],WhereMap);
     Str(Lives:3,Wrt);
     PutString(216,96,0,Wrt,VirtualPtr);
   end;
   procedure MakeGift(i:integer);
   begin
     With gifts[i] do begin
       x:=random(144);
       y:=160;
       s:=random(3)+1;
       tip:=cells[random(16)];
     end;
   end;
   procedure DoSubBallCell;
   var cell:byte;
       i:integer;
   begin
     for i:=0 to 7 do with gifts[i] do if y<16 then
       if (x+12>=Xpos) and (x+4<Xpos+32) then begin
         Case tip of
           13:Inc(Lives);
           14:Inc(HasKey);
           15:Inc(Score);
       20..29:EndGame:=true;
         end;
         MakeGift(i);
       end;
   end;
begin
   Randomize;
    for i:=0 to 11 do
      for j:=0 to 11 do
        SubMap[i,j]:=6;
    for i:=0 to 10 do
      for j:=1 to 10 do SubMap[i,j]:=0;
    for i:=0 to 7 do begin
      MakeGift(i);
      Gifts[i].y:=random(160);
    end;
    XPos:=64;
    EndGame:=false;StartGame:=false;
    if MotionOn>0 then ClearScrXY(0,8,192,192,WhereMap)
                  else ClearScr(WhereMap);
    repeat
      PutMap;
      if WVRCount>0 then for i:=0 to WVRCount-1 do WVR;
      Swap;
      KeyCode:=port[$60];
      if KeyCode=77 then if XPos+XStep<160-32 then
        XPos:=XPos+XStep;
      if KeyCode=75 then if XPos>=XStep then
        XPos:=XPos-XStep;
      while KeyPressed do begin
        KeyCode:=GetKey shr 8;
        if KeyCode=1 then EndGame:=true;
        if KeyCode in[57,28,80] then
          if StartGame=false then StartGame:=true;
      end;
      if StartGame then begin
        for i:=0 to 7 do with gifts[i] do begin
          y:=y-s;
          if (y<-16)
            then MakeGift(i);
        end;
        DoSubBallCell;
      end;
      RotatePalette;
    until EndGame;
end;

procedure Game3;{Nibble}
const
    Cells:array[0..2] of byte=(13,14,15);
    NibbleDirs:array[0..3,0..1] of integer=((0,2),(2,0),(0,-2),(-2,0));
    XStep=4;
type tItem=record
       x,y,d:integer;
     end;

var i,j:integer;
    KeyCode:byte;
    Items:array[0..31] of tItem;
    Len:integer;
    StartGame:boolean;
    EndGame:boolean;
   procedure PutMap;
   var i,j:integer;
       wrt:string;
   begin
     if MotionOn>0 then
       MotionBlure(WhereMap);
     if MotionOn>0 then begin
       for i:=0 to 11 do
         for j:=0 to 11 do
           if SubMap[i,j]<>0 then
             PutPicT(j*16,184-i*16,16,16,0,0,Blocks[SubMap[i,j]],WhereMap)
         end
       else for i:=0 to 11 do
         for j:=0 to 11 do
           PutPic(j*16,184-i*16,16,16,0,0,Blocks[SubMap[i,j]],WhereMap);
     for i:=len-1 downto 0 do with Items[i] do
       if i=0
         then PutPicT(x-8,184-y+8,16,16,0,0,Blocks[42],WhereMap)
         else PutPicT(x-8,184-y+8,16,16,0,0,Blocks[41],WhereMap);
     PutString(220, 0,0,'Bonus',WhereMap);
     PutString(230,20,0,'Game',WhereMap);
     PutPicT(200,64,16,16,0,0,Blocks[15],WhereMap);
     Str(Score:3,Wrt);
     PutString(216,64,0,Wrt,VirtualPtr);
     PutPicT(200,80,16,16,0,0,Blocks[43],WhereMap);
     Str(HasKey:3,Wrt);
     PutString(216,80,0,Wrt,VirtualPtr);
     PutPicT(200,96,16,16,0,0,Blocks[41],WhereMap);
     Str(Lives:3,Wrt);
     PutString(216,96,0,Wrt,VirtualPtr);
   end;
   procedure MoveFirst;
   begin
     with Items[0] do begin
       Coords[0,0]:=x;
       Coords[0,1]:=y;
       x:=x+NibbleDirs[d,0];
       y:=y+NibbleDirs[d,1];
       if x<24 then EndGame:=true;
       if y<24 then EndGame:=true;
       if x>=168 then EndGame:=true;
       if y>=168 then EndGame:=true;
     end;
   end;
   procedure Shift;
   var i:integer;
   begin
     for i:=255 downto 1 do begin
       Coords[i,0]:=Coords[i-1,0];
       Coords[i,1]:=Coords[i-1,1];
     end;
   end;
   procedure MoveNibble(i:integer);
   var Dx,Dy:integer;
   begin
     with Items[i] do begin
       x:=Coords[i*8,0];
       y:=Coords[i*8,1];
       dx:=x-Items[0].x;
       dy:=y-Items[0].y;
       if abs(dx)<8 then
         if abs(dy)<8 then
           EndGame:=true;
     end;
   end;
   procedure Add;
   begin
     if len=30 then begin
       EndGame:=true;
       exit;
     end;
     Items[len]:=Items[len-1];
     with Items[len] do begin
       x:=x-NibbleDirs[d,0]*8;
       y:=y-NibbleDirs[d,1]*8;
     end;
     inc(len);
   end;
   procedure CheckCell;
   var xx,yy:integer;
   begin
     xx:=Items[0].x div 16;
     yy:=Items[0].y div 16;
     if SubMap[yy,xx]<>0 then begin
       case SubMap[yy,xx] of
         13:Inc(Lives);
         14:Inc(HasKey);
         15:Inc(Score);
       end;
       SubMap[yy,xx]:=0;
       SubMap[random(10)+1,random(10)+1]:=cells[random(3)];
       for xx:=0 to random(3) do
         Add;
     end;
   end;
begin
   Randomize;
    for i:=0 to 11 do
      for j:=0 to 11 do
        SubMap[i,j]:=6;
    for i:=1 to 10 do
      for j:=1 to 10 do SubMap[i,j]:=0;
    StartGame:=false;
    EndGame:=false;
    Items[0].x:=96;
    Items[0].y:=24;
    Items[0].d:=0;
    Len:=1;
    if MotionOn>0 then ClearScrXY(0,8,192,192,WhereMap)
                  else ClearScr(WhereMap);
    SubMap[random(10)+1,random(10)+1]:=cells[random(3)];
    repeat
      PutMap;
      Swap;
      if WVRCount>0 then for i:=0 to WVRCount-1 do WVR;
      KeyCode:=port[$60];
      while KeyPressed do begin
        KeyCode:=GetKey shr 8;
        if KeyCode=72 then Items[0].d:=0;
        if KeyCode=75 then Items[0].d:=3;
        if KeyCode=77 then Items[0].d:=1;
        if KeyCode=80 then Items[0].d:=2;
        if KeyCode=1 then EndGame:=true;
        if KeyCode in[57,28,80] then
          StartGame:=true;
      end;
      if StartGame then begin
        CheckCell;
        Shift;
        MoveFirst;
        if len>1 then
          for i:=1 to len-1 do
            MoveNibble(i);
      end;
      RotatePalette;
    until EndGame;
end;

function DoBallCell4(var b:tBall;xx,yy,tip:integer):boolean;
begin
   if DoBallCell1(b,xx*16,yy*16,16,16) then begin
     if tip<20 then BMap[yy,xx]:=2;
     case tip of
       0:begin Inc(Lives);SendMessage('+1 Ball');end;
       1:begin Inc(HasKey);SendMessage('+1 Key');end;
       2:begin Inc(Score);SendMessage('+1 Point');end;
       3:begin Game1; end;
       4:begin Game2; end;
       5:begin Game3; end;
       6:begin
           Randomize;
           case random(3) of
             0:Game1;
             1:Game2;
             2:Game3;
           end;
         end;
      27:FlashCount:=MaxFlash;
     end;
   end;
end;

function IsBallInCell(var b:tball;xx,yy:integer):boolean;
begin
   xx:=xx*16;
   yy:=yy*16;
   with b.position do
     IsBallInCell:=(r>=xx-8) and (r<xx+24) and (i>=yy-8) and (i<yy+24);
end;

procedure DecLives;
begin
   if BackCount>0 then exit;
   if not Cheat then
     Lives:=Lives-1;
   BackCount:=BackCountMax;
   SendMessage('Ouch !!!');
{   Songs[2]:='HGFEDCBA#!';}
end;

procedure DoArrow1(var b:tBall;xx,yy,tip:integer);
var p:tPoint;
begin
   xx:=xx*16;yy:=yy*16;
   case tip of
     0:begin xx:=xx+ 7;yy:=yy+15;end;
     1:begin xx:=xx+ 0;yy:=yy+ 7;end;
     2:begin xx:=xx+ 7;yy:=yy+ 0;end;
     3:begin xx:=xx+15;yy:=yy+ 7;end;
   end;
   with p do begin
     Position.r:=xx;Position.i:=yy;
     Speed.r:=0;Speed.i:=0;
     if DoBFP(b,p)
       then DecLives;
   end;
end;

procedure DoArrow2(var b:tBall;xx,yy,tip:integer);
var p:tPoint;
    y:integer;
begin
   y:=GlobalCounter and 1023;
   y:=y div 16;
   if y>=32 then y:=63-y;
   y:=y-16;
   if y<=0 then exit;
   xx:=xx*16;yy:=yy*16;
   case tip of
     0:begin xx:=xx+ 7  ;yy:=yy+ y  ;end;
     1:begin xx:=xx+15-y;yy:=yy+ 7  ;end;
     2:begin xx:=xx+ 7  ;yy:=yy+15-y;end;
     3:begin xx:=xx+ y  ;yy:=yy+ 7  ;end;
   end;
   with p do begin
     Position.r:=xx;Position.i:=yy;
     Speed.r:=0;Speed.i:=0;
     if DoBFP(b,p)
       then DecLives;
   end;
end;

procedure DoArrow3(var b:tBall;xx,yy,tip:integer);
const coord:array[0..1,0..3,0..1] of integer=
       (((0,7),(7,15),(15,7),(7,0)),((0,0),(0,15),(15,15),(15,0)));
var p:tPoint;
    i:integer;
begin
   xx:=xx*16;yy:=yy*16;
   for i:=0 to 3 do
     with p do begin
       Position.r:=xx+coord[0,i,0];Position.i:=yy+coord[0,i,1];
       Speed.r:=0;Speed.i:=0;
       if DoBFP(b,p)
         then begin
           DecLives;
           exit;
         end;
     end;
   if tip=0 then exit;
   for i:=0 to 3 do
     with p do begin
       Position.r:=xx+coord[tip,i,0];Position.i:=yy+coord[tip,i,1];
       Speed.r:=0;Speed.i:=0;
       if DoBFP(b,p)
         then begin
           DecLives;
           exit;
         end;
     end;
end;

procedure DoSpeedH(var b:tBall;xx,yy:integer);
begin
   DoBallCell1(b,xx*16,yy*16+10,16,6);
   DoBallCell1(b,xx*16,yy*16-16,16,6);
   if IsBallInCell(b,xx,yy) or IsBallInCell(b,xx,yy-1) then
     begin
       b.Speed.r:=b.Speed.r*SpeedUp;
     end;
end;

procedure DoSpeedV(var b:tBall;xx,yy:integer);
begin
   DoBallCell1(b,xx*16,yy*16,6,16);
   DoBallCell1(b,xx*16+26,yy*16,6,16);
   if IsBallInCell(b,xx,yy) or IsBallInCell(b,xx+1,yy) then
     begin
       b.Speed.i:=b.Speed.i*SpeedUp;
     end;
end;

procedure DoBallCell(var b:tBall;xx,yy:integer);
const px:array[9..12] of integer=(-1,0,1,0);
      py:array[9..12] of integer=(0,1,0,-1);
var cell:byte;
    p:tPoint;
begin
   if (xx<0) or (yy<0) or (xx>=128) or (yy>=128) then exit;
   cell:=BMap[yy,xx];
   case cell of
1..6,52,53,32,33:DoBallCell1(b,xx*16,yy*16,16,16);
        7:DoBallCell1(b,xx*16,yy*16,16,8);
    9..12:DoBallCell3(b,xx,yy,px[cell],py[cell]);
13..15,40:DoBallCell4(b,xx,yy,cell-13);
       16:if HasKey=0 then DoBallCell1(b,xx*16,yy*16,16,16)
                      else begin
                        Dec(HasKey);
                        BMap[yy,xx]:=8;
                      end;
   17..18:if (GlobalCounter and 512)<>0 then DoBallCell1(b,xx*16,yy*16,16,16);
   28..29:if (GlobalCounter and 512)<>0 then
            if IsBallInCell(b,xx,yy) then DecLives;
   20..23:DoArrow1(b,xx,yy,cell-20);
   24..27:DoArrow2(b,xx,yy,cell-24);
   30..31:DoArrow3(b,xx,yy,cell-30);
   48..51:DoBallCell4(b,xx,yy,cell-45);
       34:DoBallCell1(b,xx*16,yy*16+12,16,4);
       54:DoBallCell1(b,xx*16,yy*16,16,4);
       36:DoBallCell1(b,xx*16,yy*16,4,16);
       37:DoBallCell1(b,xx*16+12,yy*16,4,16);
       35:DoSpeedH(b,xx,yy);
       55:DoSpeedH(b,xx,yy+1);
       56:DoSpeedV(b,xx,yy);
       57:DoSpeedV(b,xx-1,yy);
   end;
end;

procedure DoGravity(var b:tBall);
begin
   b.Speed.i:=b.Speed.i-Gravity;
end;

procedure MoveBall(var b:tBall);
var x1,y1,x2,y2:integer;
begin
   if BackCount>0    then Dec(BackCount);
   if MessageCount>0 then Dec(MessageCount);
   with MBall.position do begin
     x1:=(round(r)-MBall.radius) div 16;
     y1:=(round(i)-MBall.radius) div 16;
     x2:=(round(r)+MBall.radius) div 16;
     y2:=(round(i)+MBall.radius) div 16;
   end;
   DoGravity(b);
   DoBallCell(b,x1,y1);
   if y1<>y2 then
     DoBallCell(b,x1,y2);
   if x1<>x2 then
     DoBallCell(b,x2,y1);
   if (y1<>y2) and (x1<>x2) then
     DoBallCell(b,x2,y2);
   CheckSpeed(b);
   MoveB(b);
   CheckPosition(b);
   Inc(GlobalCounter);
end;

procedure DoJump;
var s:string;
    er:integer;
    li:longint;
begin
    ClearScr(ScreenPtr);
    PutString(0,20,14*16,'Current Level:',ScreenPtr);
    str(Level,s);
    PutString(36,60,14*16,s,ScreenPtr);
    PutString(0,100,14*16,'Enter New Level:',ScreenPtr);
    if GetString(36,140,12,s) then begin
      val(s,li,er);
      if er=0 then begin
        Level:=li;
        GameState:=4;
      end;
    end;
end;

procedure DoGoXY;
var s:string;
    er:integer;
    x,y:integer;
begin
    ClearScr(ScreenPtr);
    PutString(0,40,14*16,'Enter X Coord:',ScreenPtr);
    if GetString(36,60,12,s) then begin
      val(s,x,er);
      if er<>0 then exit
    end else exit;
    PutString(0,100,14*16,'Enter Y Coord:',ScreenPtr);
    if GetString(36,120,12,s) then begin
      val(s,y,er);
      if er=0 then begin
        SetBall(MBall,x*16+8,y*16+8,0,0.5,8,8);
      end else exit;
    end else exit;
end;

procedure DoHelp;
const nr=12;
const x:array[0..nr] of integer=(0,144,176,192,208,240,0,0,0,0,0,0,0);
const y:array[0..nr] of integer=(18,18,18,18,18,18,54,90,108,126,144,162,180);
const w:array[0..nr] of integer=(144,32,16,16,32,32,192,48,64,16,64,32,16);
const n:array[0..nr] of integer=(0,36,44,19,38,32,20,13,48,16,9,56,40);
const ss:array[0..32] of string[16]=(#27#26'          Move',
                                     #25'      Pull Down',
                                     'ESC         Quit',
                                     'M     Map On/Off',
                                     'S   Score On/Off',
                                     'C   Cheat On/Off',
                                     'R        Restart',
                                     'J  Jump to Level',
                                     'N           Next',
                                     '+-  Change Speed',
                                     'F Effects On/Off',
                                     'HarmLess Blocks:',
                                     '',
                                     'HarmFull Blocks:',
                                     '',
                                     'Extra Blocks',
                                     '           Bonus',
                                     '      Bonus Game',
                                     '      Need a key',
                                     '     One-Way Blk',
                                     '    Speed-Up Blk',
                                     '     Flash block',
                                     'Other keys:     ',
                                     'F2     Shut Up !',
                                     '1 - 3      Music',
                                     '',
                                     ' INSTRUCTIONS   ',
                                     '',
                                     ' Your Goal is to',
                                     'go in the upper-',
                                     'right corner of ',
                                     'the map.        ',
                                     '  GOOD LUCK !   ');
var i:integer;
begin
   ClearScr(ScreenPtr);
   for i:=0 to 10 do
     PutString(0,i*18,13,ss[i],ScreenPtr);
   Wait;Fadeout(ScreenPtr);
   ClearScr(ScreenPtr);
   for i:=0 to 10 do
     PutString(0,i*18,13,ss[i+22],ScreenPtr);
   Wait;Fadeout(ScreenPtr);
   ClearScr(ScreenPtr);
   for i:=0 to 10 do
     PutString(0,i*18,13,ss[i+11],ScreenPtr);
   for i:=0 to nr do
     PutPic(x[i],y[i],w[i],16,0,0,Blocks[n[i]],ScreenPtr);
   Wait;Fadeout(ScreenPtr);
end;

procedure DoKeys;
var KeyCode:byte;
   i:integer;
begin
   KeyCode:=Port[$60];
   if KeyCode>=128 then exit;
   if KeyCode=77 then MBall.Speed.R:=MBall.Speed.R+IncSpeedX;
   if KeyCode=75 then MBall.Speed.R:=MBall.Speed.R-IncSpeedX;
   if KeyCode=80 then with MBall.Speed do i:=i-PullDown;
   While KeyPressed do begin
     KeyCode:=GetKey shr 8;
     if KeyCode=31 then ShowBackCount:=not ShowBackCount;
     if KeyCode=33 then MotionOn:=(MotionOn +1)mod 4;
     if KeyCode=46 then Cheat:=not Cheat;
     if KeyCode=49 then GameState:=5;
     if KeyCode=50 then ShowMap:=not ShowMap;
     if KeyCode=19 then GameState:=4;
     if KeyCode=36 then DoJump;
     if KeyCode=59 then DoHelp;
     if KeyCode=60 then songs:='#!';
     if KeyCode=68 then FlashCount:=MaxFlash;
     if KeyCode=1  then GameState:=-1;
     if KeyCode=2  then Songs:=DSongs[1];
     if KeyCode=3  then Songs:=DSongs[2];
     if KeyCode=4  then Songs:=DSongs[3];
     if (KeyCode=13) then
       if DrawSpeed<32 then Inc(DrawSpeed);
     if (KeyCode=12) then
       if DrawSpeed>0 then Dec(DrawSpeed);
     if (KeyCode=78) then
       if WVRCount<32 then Inc(WVRCount);
     if (KeyCode=74) then
       if WVRCount>0 then Dec(WVRCount);
     if CheatParam then begin
       if KeyCode=17 then GameState:=2;
       if KeyCode=34 then DoGoXY;
     end;
   end;
end;

procedure DownScreen;
var i:integer;
begin
    for i:=0 to 24 do begin
      Move(SCreenPtr^[i*8],SCreenPtr^[i*8+8],(24-i)*8*320);
      FillChar(SCreenPtr^[i*8],8*320,0);
    end;
end;

procedure PutBStart;
var i,j:integer;
begin
   if StartCount=MaxStartCount then
   for i:=0 to 15 do
     for j:=0 to 15 do with Points2[i*16+j] do begin
       c:=pScreen(Blocks[41])^[i,j];if c=0 then c:=-1 else c:=(c+256-P2col) and $ff;
       x:=j-7;y:=7-i;
       vx:=random(5)-2;
       vy:=random(5)-2;
       x:=x-MaxStartCount*vx;
       y:=y-MaxStartCount*vy;
   end;
   MoveP2(Round(MBall.position.r),Round(MBall.position.i));
   Dec(StartCount);
   if StartCount<0 then InitP2;
end;

procedure Game;
var c:integer;
    wrt:string;
begin StartCount:=MaxStartCount;
   GameInit;
   Str(Level,Wrt);
   ClearScr(ScreenPtr);
   PutString(0,32,64,'    Entering',ScreenPtr);
   PutString(0,64,64,'     Level: ',ScreenPtr);
   PutString(0,96,64,'    '+wrt,ScreenPtr);
   PutString(0,180,64,' Press SPACE !',ScreenPtr);
   repeat
   until (GetKey shr 8)=57;
   ClearScr(VirtualPtr);
   if Effect=1 then InitStars;
   if Effect=2 then InitRain;
   InitP2;
   repeat
     if WVRCount>0 then for c:=0 to WVRCount-1 do WVR;
     RotatePalette;
     if (Effect<>0) or (MotionOn=0) then ClearScr(VirtualPtr)
                  else begin
                    MotionBlure(VirtualPtr);
                  end;
     if MotionOn>0 then if Effect=1 then MoveStars;
     PutMap;
     if StartCount<0 then PutBall(MBall)
        else begin
          PutBStart;
        end;
     for c:=0 to DrawSpeed do begin
       MoveBall(MBall);
       DoKeys;
     end;
     if ShowBackCount then begin
       PutPicT(0,0,16,16,0,0,Blocks[15],WhereMap);
       Str(Score,Wrt);
       PutString(16,0,0,Wrt,VirtualPtr);
       PutPicT(80,0,16,16,0,0,Blocks[43],WhereMap);
       Str(HasKey,Wrt);
       PutString(96,0,0,Wrt,VirtualPtr);
       PutPicT(160,0,16,16,0,0,Blocks[41],WhereMap);
       Str(Lives,Wrt);
       PutString(176,0,0,Wrt,VirtualPtr);
     end;
     if Port[$60]=30 then PutString(0,180,12,'(C)''98 Szasz Pal',WhereMap);
     if Cheat then PutChar(300,0,14*16,#1,VirtualPtr);
     PutMessage;
     If ShowMap then PutMap16(MBall);
     if MotionOn>0 then begin
       if Effect=2 then MoveRain;
       if StartCount<0 then MoveP2(0,0);
     end;
     if MotionOn=2 then Soften2(VirtualPtr);
     Swap;
     if MotionOn=3 then Soften2(VirtualPtr);
     Inc(DrawCounter);
   until (Lives=0) or (GameState<>0);
   DownScreen;
   if Lives=0 then begin
     repeat
       MotionBlure(ScreenPtr);
       PutString(0,64,64,'     GAME',ScreenPtr);
       PutString(0,96,64,'     OVER',ScreenPtr);
       PutString(0,180,64,' Press SPACE !',ScreenPtr);
     until Port[$60]=57;
     GetKey;
   end;
end;

{------------------------------------------------------------------------}

procedure DoIntro;
var i:integer;
begin
   Repeat until Port[$60]>=128;
   ClearScr(VirtualPtr);
   MakePalette(0);
   RndNumber:=4;
   i:=0;
   repeat
     inc(i);
     RndNumber:=Random(3)+2;
     RndNumber:=RandSeed;
     Soften(VirtualPtr);
     PutString(0, 60,13,'   WELCOME to   ',VirtualPtr);
     if i>64 then
       PutString(0,110,14,' 32K Ball Mania ',VirtualPtr);
     if i>128 then
     PutString(0,150,12,'    Code By     ',VirtualPtr);
     if i>128 then
     PutString(0,180,11,'   SZASZ PAL    ',VirtualPtr);
     DecScrXY(0);
     DecScrXY(66);
     DecScrXY(116);
     DecScrXY(156);
{     DecScrXY(0,00,320,24,VirtualPtr);
     DecScrXY(0,66,320,24,VirtualPtr);
     DecScrXY(0,116,320,24,VirtualPtr);
     DecScrXY(0,156,320,24,VirtualPtr);}
     WVR;
     Swap;
     RotatePalette;
   Until Port[$60]<128;
   for i:=0 to 15 do begin
     MotionBlure(VirtualPtr);
     Soften(VirtualPtr);
     MotionBlure(VirtualPtr);
     Swap;
     WVR;
   end;
   Getkey;
   MakePalette(0);
end;

procedure DoEnd;
begin
   DoneVideo;
   writeln('            32K Ball Mania'#13#10#13#10+
           'Programmed by Szsz Pl in 1998'#13#10+
           'If you want to contact me:'#13#10+
           '  My Address:  Szsz Pl'#13#10+
           '               Cl.Republicii 96 ap.2'#13#10+
           '               Marghita cod.3775'#13#10+
           '               Jud. Bihor'#13#10+
           '               ROMANIA'#13#10);
   Writeln('        Tel.:  (059)-361-070'#13#10+
           '      E-mail:  not yet'#13#10+#13#10+
           'HINTS:'#13#10+
           '  If you want to speed up the ball, press the DOWN button, while it comes down.'#13#10+
           '  If you want to slower it, press this button, when it''s going up.'#13#10+
           '(like the real ball)'#13#10+#13#10+
           '                      ! GOOD LUCK !  ( you''ll need it ;->)');
end;

{-------------------------------------------------------------}

var NewMap:boolean;

begin if paramstr(1)='/?' then begin
     WriteLn('Ball32k [/?|/ns|SPACE]'#13#10+
             '         /ns    - No Sound at all !!!'#13#10+
             '         C+4  - Cheat (press G or W in the game) '#13#10+
             '                ( COMMODORE RULEZ !!! :-)))');
     Halt(0);
   end;
   Songs:=DSongs[1];
   CheatParam:=paramstr(1)='C+4';
   NoSound:=paramstr(1)='/ns';
   if not Nosound then InitSB;
   Cheat:=false;
   ShowMap:=true;
   MotionOn:=1;
   GameState:=0;
   Init;
   DoIntro;
   repeat
     NewMap:=true;
     if GameState=4 then NewMap:=false;
     if GameState<>2 then
         begin
           Score:=0;
           HasKey:=0;
           Lives:=10;
         end;
     BuildMap(Level,NewMap);
     Game;
   until GameState=-1;
   DoEnd;
   if not NoSOund then DoneSB;
end.

