unit decoder1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Menus, ComCtrls;

type
  Ppacket = ^Tpacket;
  Tpacket = record
    prev   : Ppacket;
    next   : Ppacket;
    number : word;
    pkt    : ^Char;
    len    : word;
  end;

  TWPDECO = class(TForm)
    MainMenu1: TMainMenu;
    DecodingPanel: TPanel;
    DecoderOutput: TMemo;
    Prev1: TMenuItem;
    Next1: TMenuItem;
    Level1: TMenuItem;
    View1: TMenuItem;
    StatusBar1: TStatusBar;
    Help1: TMenuItem;
    Contents1: TMenuItem;
    About1: TMenuItem;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Compact1: TMenuItem;
    Standard1: TMenuItem;
    Extended1: TMenuItem;
    Headers1: TMenuItem;
    Blanklines1: TMenuItem;
    Datafields1: TMenuItem;
    load1: TMenuItem;
    Edit1: TMenuItem;
    Copy1: TMenuItem;
    SelectAll1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Mode1: TMenuItem;
    Protocol1: TMenuItem;
    Hexdump1: TMenuItem;
    ASCIIdump1: TMenuItem;
    D1: TMenuItem;
    MGSOFThome1: TMenuItem;
    N3: TMenuItem;
    SubscribeToMailingList1: TMenuItem;
    procedure Prev1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Next1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure SelectAll1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure load1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Standard1Click(Sender: TObject);
    procedure Compact1Click(Sender: TObject);
    procedure Extended1Click(Sender: TObject);
    procedure Headers1Click(Sender: TObject);
    procedure Blanklines1Click(Sender: TObject);
    procedure Datafields1Click(Sender: TObject);
    procedure Protocol1Click(Sender: TObject);
    procedure Hexdump1Click(Sender: TObject);
    procedure ASCIIdump1Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure D1Click(Sender: TObject);
    procedure MGSOFThome1Click(Sender: TObject);
    procedure SubscribeToMailingList1Click(Sender: TObject);
  private
    { Private declarations }
    procedure disposePackets;
  public
    { Public declarations }
    procedure doDecode(pkt : Ppacket);
  end;


var
  WPDECO: TWPDECO;

function setURL (page : integer) : dword; stdcall

{$R *.DFM}

implementation

uses about, wpdeco32;

var
  par : TDecoderData;
  pktChain : Ppacket;
  pdl : ^TbufType;
  packetsLoaded : integer;

function setURL; external wpdeco32_dll name 'setURL';

procedure TWPDECO.FormCreate(Sender: TObject);
// startup initialization
begin
  pktChain := nil;

  par.maxLineLen := WPDECO32_MAX_DECODED_LINE_LEN;
  par.maxLines := WPDECO32_MAX_LINES_DECODED;
  par.bufSize := par.maxLines * (par.maxLineLen + 1 + sizeof(dLine));
  GetMem(pdl, par.bufSize);
  par.buf := pdl;
  par.pktData := nil;
  par.pktLength := 0;
  par.linesDecoded := 0;
  par.majVersion := 0;
  par.minVersion := 0;

  par.decodingLevel := PDL_S;
  Compact1.checked := false;
  Standard1.checked := true;
  Extended1.checked := false;

  par.decodingMode := PDL_PROT;
  Protocol1.checked := true;
  Hexdump1.checked := false;
  ASCIIdump1.checked := false;

  Headers1.checked := true;
  par.showHeaders := 1;

  Blanklines1.checked := true;
  par.showBlankLines := 1;

  Datafields1.checked := true;
  par.showData := 1;

  View1.Enabled := false;
  Level1.Enabled := false;
  Mode1.Enabled := false;
  Prev1.Enabled := false;
  Next1.Enabled := false;

  packetsLoaded := 0;
  statusBar1.panels[0].text := 'No packets loaded';
end;

procedure TWPDECO.FormClose(Sender: TObject; var Action: TCloseAction);
// cleanup before termination
begin
  disposePackets;   // dispose of loaded packets
  FreeMem(par.buf);
end;

procedure TWPDECO.load1Click(Sender: TObject);
// load packets from file
var
  FromF: file;
  packets, i: word;
  tmpPkt : Ppacket;
begin
  OpenDialog1.Filter := 'PDM files (*.PDM)|*.PDM|All files (*.*)|*.*';
  if OpenDialog1.Execute then begin
    disposePackets; // dispose previously loaded packets
    AssignFile(FromF, OpenDialog1.FileName);
    Reset(FromF, 1);
    BlockRead(FromF, packets, 2);
    for i:= 1 to packets do begin
      GetMem(tmpPkt, sizeof(Tpacket));
      if (pktChain = nil) then begin  // build the first packet in chain
        tmpPkt.next := tmpPkt;
        tmpPkt.prev := tmpPkt;
      end
      else begin                      // add a packet to existing chain
        tmpPkt.next := pktChain.next;
        tmpPkt.prev := pktChain;
        tmpPkt.prev.next := tmpPkt;
        tmpPkt.next.prev := tmpPkt;
      end;
      pktChain := tmpPkt;
      pktChain.number := i;
      BlockRead(FromF, pktChain.len, 2);
      GetMem(pktChain.pkt, pktChain.len);
      BlockRead(FromF, pktChain.pkt^, pktChain.len);
    end;
    pktChain := pktChain.next;
    CloseFile(FromF);
    View1.Enabled := true;
    Level1.Enabled := true;
    Mode1.Enabled := true;
    Prev1.Enabled := true;
    Next1.Enabled := true;
    packetsLoaded := packets;
  end;
  doDecode(pktChain);
end;

procedure TWPDECO.Exit1Click(Sender: TObject);
begin
  close;
end;

procedure TWPDECO.Copy1Click(Sender: TObject);
begin
  DecoderOutput.CopyToClipboard;
end;

procedure TWPDECO.SelectAll1Click(Sender: TObject);
begin
  DecoderOutput.selectAll;
end;

procedure TWPDECO.Headers1Click(Sender: TObject);
begin
  Headers1.checked := not Headers1.checked;
  if (Headers1.checked) then
    par.showHeaders := 1
  else
    par.showHeaders := 0;
  doDecode(pktChain);
end;

procedure TWPDECO.Blanklines1Click(Sender: TObject);
begin
  Blanklines1.checked := not Blanklines1.checked;
  if (Blanklines1.checked) then
    par.showBlankLines := 1
  else
    par.showBlankLines := 0;
  doDecode(pktChain);
end;

procedure TWPDECO.Datafields1Click(Sender: TObject);
begin
  Datafields1.checked := not Datafields1.checked;
  if (Datafields1.checked) then
    par.showData := 1
  else
    par.showData := 0;
  doDecode(pktChain);
end;

procedure TWPDECO.Compact1Click(Sender: TObject);
begin
  par.decodingLevel := PDL_C;
  Compact1.checked := true;
  Standard1.checked := false;
  Extended1.checked := false;
  doDecode(pktChain);
end;

procedure TWPDECO.Standard1Click(Sender: TObject);
begin
  par.decodingLevel := PDL_S;
  Compact1.checked := false;
  Standard1.checked := true;
  Extended1.checked := false;
  doDecode(pktChain);
end;

procedure TWPDECO.Extended1Click(Sender: TObject);
begin
  par.decodingLevel := PDL_X;
  Compact1.checked := false;
  Standard1.checked := false;
  Extended1.checked := true;
  doDecode(pktChain);
end;

procedure TWPDECO.Protocol1Click(Sender: TObject);
begin
  par.decodingMode := PDL_PROT;
  Protocol1.checked := true;
  Hexdump1.checked := false;
  ASCIIdump1.checked := false;
  doDecode(pktChain);
end;

procedure TWPDECO.Hexdump1Click(Sender: TObject);
begin
  par.decodingMode := PDL_HEX;
  Protocol1.checked := false;
  Hexdump1.checked := true;
  ASCIIdump1.checked := false;
  doDecode(pktChain);
end;

procedure TWPDECO.ASCIIdump1Click(Sender: TObject);
begin
  par.decodingMode := PDL_ASCII;
  Protocol1.checked := false;
  Hexdump1.checked := false;
  ASCIIdump1.checked := true;
  doDecode(pktChain);
end;

procedure TWPDECO.Prev1Click(Sender: TObject);
begin
  if pktChain <> nil then begin
    pktChain := pktChain.prev;
    doDecode(pktChain);
  end;
end;

procedure TWPDECO.Next1Click(Sender: TObject);
begin
  if pktChain <> nil then begin
    pktChain := pktChain.next;
    doDecode(pktChain);
  end;
end;

procedure TWPDECO.Contents1Click(Sender: TObject);
begin
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TWPDECO.D1Click(Sender: TObject);
begin
  if setURL(1) = 0 then
    Application.MessageBox('Can''t find the default WEB browser!' +
    ' Please visit the URL http://www.mg-soft.si/dll-deco.html',
    'Warning from DECODER.EXE', mb_OK);
end;

procedure TWPDECO.SubscribeToMailingList1Click(Sender: TObject);
begin
  if setURL(2) = 0 then
    Application.MessageBox('Can''t find the default WEB browser!' +
    ' Please visit the URL http://www.mg-soft.si/maillist.html',
    'Warning from DECODER.EXE', mb_OK);
end;

procedure TWPDECO.MGSOFThome1Click(Sender: TObject);
begin
  if setURL(0) = 0 then
    Application.MessageBox('Can''t find the default WEB browser!' +
    ' Please visit the URL http://www.mg-soft.si/',
    'Warning from DECODER.EXE', mb_OK);
end;

procedure TWPDECO.About1Click(Sender: TObject);
begin
  AboutBox.show;
end;

procedure TWPDECO.disposePackets;
// dispose of packets from memory
var
  tmpPkt : Ppacket;
begin
  while (pktChain <> nil) do  begin // anything?
    tmpPkt := pktChain;
    if (pktChain.next <> pktChain) then begin // not the last packet
      pktChain := pktChain.next;
      tmpPkt.prev.next := pktChain;
      pktChain.prev := tmpPkt.prev;
    end
    else begin // the last packet in the chain
      pktChain := nil;
    end;
    tmpPkt.next := nil;
    tmpPkt.prev := nil;
    FreeMem(tmpPkt.pkt);
    tmpPkt.pkt := nil;
    dispose(tmpPkt);
    tmpPkt := nil;
  end;
end;

procedure TWPDECO.doDecode(pkt : Ppacket);
var
  i : integer;
  success : dword;
  decodedStrings: TStringList;

begin
  if (pkt <> nil) then begin
    par.pktData := @pkt.pkt^;          // we are programming in Pascal :)
    par.pktLength := pkt.len;

    success := decodePacket(par);  // call to decoder

    if (success > 0) and (par.linesDecoded > 0) then begin
      decodedStrings := TStringList.Create; // create tmp lines
      decodedStrings.clear;
      decodedStrings.append('Protocol decoder by Abit & MG-SOFT');
      decodedStrings.append('More info at http://www.mg-soft.si/dll-deco.html');
      decodedStrings.append(' ');

      for i :=0 to par.linesDecoded - 1 do
        decodedStrings.append(pChar(pdl[i].line));

      DecoderOutput.clear; // clear the old contents
      DecoderOutput.lines.assign(decodedStrings);
      decodedStrings.free; // release tmp lines

      statusBar1.panels[0].text := ExtractFileName(OpenDialog1.FileName);
      statusBar1.panels[1].text := inttostr(pkt.number) +
            '/' + inttostr(packetsLoaded);
      case par.decodingLevel of
        PDL_C : statusBar1.panels[2].text := 'compact level';
        PDL_X : statusBar1.panels[2].text := 'extended level'
        else
            statusBar1.panels[2].text := 'standard level';
      end;
      if (par.showHeaders > 0) then
        statusBar1.panels[3].text := 'headers on'
      else
        statusBar1.panels[3].text := 'headers off';
      if (par.showBlankLines > 0) then
        statusBar1.panels[4].text := 'blank on'
      else
        statusBar1.panels[4].text := 'blank off';
      if (par.showData > 0) then
        statusBar1.panels[5].text := 'data on'
      else
        statusBar1.panels[5].text := 'data off';
    end
    else
      DecoderOutput.lines.add('Call to decoder failed');
  end
  else
    DecoderOutput.lines.add('Packets not loaded');
end;

end.
