/********************************************************
  decodemo.cpp --- DECODEMO.EXE Utility.

  Copyright 1994-1997 by MG-SOFT d.o.o.
  All rights reserved.
    
  E-mail: info@mg-soft.si
  Web URL: http://www.mg-soft.si/
  
    This source file is for demonstration purpose only.
    Check LICENSE.TXT for licensing information.
********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include "..\..\include\wpdeco32.h"
#include "packets.h"

#define DECODEMO_VERSION "V1.0"


struct demoPacket {
  char *pkt;
  unsigned short length;
};

int main(int argc, char *argv[])
{
  int rv = EXIT_SUCCESS;
  demoPacket packets[2];
  decoderData par;
  
  long outBuferSize = (long)
    WPDECO32_MAX_LINES_DECODED * (WPDECO32_MAX_DECODED_LINE_LEN + 1 + sizeof(dLine));
  char *pTmp = (char *) malloc(outBuferSize);
  int i, j;
  
  fprintf(stdout, "DECODEMO Utility %s; C-1996,1997 by MG-SOFT Corporation, Slovenia.\n", DECODEMO_VERSION);
  
  packets[0].pkt = packet1;
  packets[0].length = P1L;
  packets[1].pkt = packet2;
  packets[1].length = P2L;
  
  par.showData = 1;
  par.showHeaders = 1;
  par.showBlankLines = 1;
  par.decodingLevel = PDL_S;
  par.decodingMode = PDL_PROT;
  par.maxLines = WPDECO32_MAX_LINES_DECODED;
  par.maxLineLen = WPDECO32_MAX_DECODED_LINE_LEN;
  par.linesDecoded = 0;
  par.bufSize = outBuferSize;
  par.buf = (struct dLine far *) pTmp;
  
  for (j = 0; j < 2; j++) {
    if (j > 0)
      MessageBox(NULL, "Continue ?", 
      "DECODEMO.EXE", MB_OK | MB_ICONHAND | MB_SYSTEMMODAL);
    
    par.pktData = packets[j].pkt;
    par.pktLength = packets[j].length;
    
    if (decodePacket(&par)) {
      fprintf(stdout, "\n\n");
      for (int i = 0; i < par.linesDecoded; i++)
        fprintf(stdout, "%s\n", par.buf[i].line);
    }
  }
  free(pTmp);
  
  return rv;
}
