{*******************************************************************
  
  File: wpdeco32.pas
  Created:  15/May/1994
  Modified: 2/Feb/1997

  Copyright 1994,97 by MG-SOFT Corporation. All rights reserved.

  Windows Protocol Decoder, 32-bit, Delphi/Pascal header file.
  
  Designed by MG-SOFT Corporation
    E-mail: info@mg-soft.si
    Web URL: http://www.mg-soft.si/

********************************************************************}

unit wpdeco32;

interface

uses windows;

const
  wpdeco32_dll = 'wpdeco32.dll';    // the name of the DLL file

// decoding level constants
  PDL_C      = $01; // compact decoding level
  PDL_S      = $02; // standard decoding level
  PDL_X      = $04; // extended decoding level

// decoding mode constants
  PDL_PROT   = $00; // protocol decoded format
  PDL_HEX    = $01; // HEX dump format
  PDL_ASCII  = $02; // ASCII dump format

  WPDECO32_MAX_LINES_DECODED = 255;
  WPDECO32_MAX_DECODED_LINE_LEN = 55;


type
  dLine = record         // Decoded line header/descriptor
    line   : PChar;      // pointer to the decoded line
    pID    : byte;       // unique protocol layer ID
    off    : word;       // offset in packet used for decoding line
    length : byte;       // length used for decoding line
    mask   : byte;       // bit-mask used for decoding line
  end;

  TbufType = array[0.. WPDECO32_MAX_LINES_DECODED] of dLine; // for pascal only

  TdecoderData = record
// input parameters:
    pktData        : ^Char;   // pointer to the packet to be decoded
    pktLength      : word;    // length of the packet to be decoded
    bufSize        : word;    // size (in octets) of the 'output buffer' buf
    showHeaders    : byte;    // produce header fields in the decode
    showBlankLines : byte;    // produce blank line separators in the decode
    showData       : byte;    // display 'data' fields in the decode
    decodingLevel  : byte;    // decoding level (PDL_C,PDL_S,PDL_X)
    decodingMode   : byte;    // decoding mode (PDL_PROT,PDL_HEX,PDL_ASCII)
    maxLineLen     : byte;    // max decoded line shouldn't be longer than that
    maxLines       : word;    // produce at most that many lines
//output parameters:
    linesDecoded   : word;    // number of lines in the decode
    buf            : Pointer; // pointer to the 'output' buffer buf
    majVersion     : word;    // current major version of WPDECO32.DLL
    minVersion     : word;    // current minor version of WPDECO32.DLL
  end;

  function decodePacket(var par : TdecoderData) : dword; stdcall

implementation

  function decodePacket; external wpdeco32_dll name 'decodePacket';

end.
