/*******************************************************************
  File: wpdeco32.h
  Created:  15/May/1994
  Modified: 2/Feb/1997
  
  Copyright 1994,97 by MG-SOFT Corporation. All rights reserved.
    
  Protocol Decoder in DLL module, 32-bit, C/C++ header file.
      
  MG-SOFT Corporation
    E-mail: info@mg-soft.si
    Web URL: http://www.mg-soft.si/
        
********************************************************************/

#if !defined(__WPDECO32_H)
#define __WPDECO32_H

#include <windows.h>


#define uchar  unsigned char 
#define ushort unsigned short

// decoding level constants
#define PDL_C       0x01   /* compact decoding level */
#define PDL_S       0x02   /* standard decoding level */
#define PDL_X       0x04   /* extended decoding level */

// decoding mode constants
#define PDL_PROT    0x00   /* protocol decoded format */
#define PDL_HEX     0x01   /* HEX dump format */
#define PDL_ASCII   0x02   /* ASCII dump format */

#define WPDECO32_MAX_LINES_DECODED     255
#define WPDECO32_MAX_DECODED_LINE_LEN   55


struct dLine {	   // Decoded line header/descriptor 
  char  *line;	   // pointer to the decoded line (NULL terminated string)
  uchar  pID;      // unique protocol layer ID
  ushort off;      // offset in packet used for decoding line
  uchar  length;   // length used for decoding line
  uchar  mask;     // bit-mask used for decoding line
};


struct decoderData {
// input values:
  char *pktData;         // pointer to the packet to be decoded
  ushort pktLength;      // length of the packet to be decoded
  ushort bufSize;        // the size (in octets) of the 'output buffer' buf
  uchar  showHeaders;    // produce header fields in the decode
  uchar  showBlankLines; // produce blank line separators in the decode
  uchar  showData;       // display 'data' fields in the decode
  uchar  decodingLevel;  // decoding level (PDL_C,PDL_S,PDL_X)
  uchar  decodingMode;   // decoding mode (PDL_PROT,PDL_HEX,PDL_ASCII)
  uchar  maxLineLen;     // max decoded line won't be longer than that
  ushort maxLines;       // produce at most that many lines
// output values:
  ushort linesDecoded;   // number of lines in the decode
  dLine *buf;            // pointer to the 'output' buffer
  ushort majVersion;     // current major version of this DLL
  ushort minVersion;     // current minor version of this DLL
};

#ifdef __cplusplus
extern "C" {
#endif
  
  __declspec(dllexport)
    DWORD WINAPI decodePacket(decoderData *);
  
#ifdef __cplusplus
}
#endif

#endif // __WPDECO32_H
