VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.2#0"; "COMCTL32.OCX"
Begin VB.Form Form1 
   AutoRedraw      =   -1  'True
   BackColor       =   &H00C0C0C0&
   Caption         =   "WinPing"
   ClientHeight    =   3576
   ClientLeft      =   1452
   ClientTop       =   4752
   ClientWidth     =   10080
   LinkTopic       =   "Form1"
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   3576
   ScaleWidth      =   10080
   Begin VB.Frame Frame1 
      BackColor       =   &H00000000&
      Height          =   735
      Left            =   0
      TabIndex        =   1
      Top             =   -120
      Width           =   9852
      Begin VB.CommandButton Command3 
         Caption         =   "Alarm is ON"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   7.8
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   2160
         TabIndex        =   4
         Top             =   240
         Width           =   1575
      End
      Begin VB.CommandButton Command2 
         Caption         =   "Stop "
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   7.8
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   1200
         TabIndex        =   3
         Top             =   240
         Width           =   855
      End
      Begin VB.CommandButton Command1 
         Caption         =   "Start "
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   7.8
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   375
         Left            =   120
         TabIndex        =   2
         Top             =   240
         Width           =   975
      End
      Begin VB.Label Label5 
         BackColor       =   &H00404040&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Label5"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   7.8
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00FFFFFF&
         Height          =   375
         Left            =   6120
         TabIndex        =   6
         Top             =   240
         Width           =   2175
      End
      Begin VB.Label Label4 
         BackColor       =   &H00404040&
         BorderStyle     =   1  'Fixed Single
         Caption         =   "Label4"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   7.8
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         ForeColor       =   &H00FFFFFF&
         Height          =   375
         Left            =   3840
         TabIndex        =   5
         Top             =   240
         Width           =   2175
      End
   End
   Begin VB.Timer Timer1 
      Interval        =   60000
      Left            =   120
      Top             =   2280
   End
   Begin ComctlLib.StatusBar StatusBar1 
      Align           =   2  'Align Bottom
      Height          =   396
      Left            =   0
      TabIndex        =   7
      Top             =   3180
      Width           =   10080
      _ExtentX        =   17780
      _ExtentY        =   699
      SimpleText      =   ""
      _Version        =   327682
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   1
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   2
            TextSave        =   ""
            Key             =   "STATUS"
            Object.Tag             =   ""
         EndProperty
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label1 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Label1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   7.8
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   240
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   1800
      Width           =   1092
   End
   Begin VB.Image Image1 
      Height          =   492
      Index           =   0
      Left            =   120
      Top             =   1320
      Visible         =   0   'False
      Width           =   1092
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mnuRedlog 
         Caption         =   "&View redlog.txt"
      End
      Begin VB.Menu mnuEditMachineNames 
         Caption         =   "Edit &Default Machine Names File         (WINPING1.DAT)"
      End
      Begin VB.Menu mnuDelPing 
         Caption         =   "&Delete ping data files  (*.PNG)"
      End
   End
   Begin VB.Menu mnuControls 
      Caption         =   "&Controls"
      Begin VB.Menu mnuStartPing 
         Caption         =   "&Start Ping"
      End
      Begin VB.Menu mnuStopPing 
         Caption         =   "S&top Ping"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuAbout 
         Caption         =   "&About"
      End
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Program by Anthony S. Napier, 1999
' Dayton, Ohio,  asnapier@juno.com
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Program Description: Monitor the availability of computers
' on a network with an automated, graphical display and an
' audible alarm. WinPing.exe requires the external program
' ping.exe. Ping cycles are set for every 5 minutes.
'
' Language: Visual Basic 5, runtime libraries not distributed
'
' Platforms: Program runs on Windows 95/98 and NT Server 4.0,
' but can ping any computer available on a network.
'
' License:  Freeware, Open Source code, but this original
' comment block should remain in place.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' M O D I F I C A T I O N S
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' April 1999 - Initial release.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' declaration section for all global vars
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Option Explicit                ' force variable declaration
Dim nameOfDatafile As String   ' file name of machine datafile
Dim redlog As String           ' file name of ping error log
Dim datafile() As String       ' dynamic array for machine names
Dim pingfile() As Boolean      ' dynamic array for ping status
Dim datafileSize As Integer    ' number of entries in parm file
Dim i As Integer               ' index control

Dim tempCommand1_Button As String ' gray PING ON button
Dim tempCommand2_Button As String ' gray PING OFF button
Dim tempCommand3_Button As String ' gray alarm button
Dim user_requested_stop As Boolean
Dim tempvar1 As String
Dim pingcntr As Integer           ' ping cycle counter for display
Dim pingcntr2 As Integer          ' RED machine counter for display
Dim DisplayPingData_Status As String  ' check for DOS PING completion

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' seconds between ping cycles (5 minutes)
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Const CYCLE_TIME As Double = 300

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' declaration for sound support
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Declare Function sndPlaySound Lib "WINMM.DLL" Alias _
   "sndPlaySoundA" (ByVal lpszSoundName As String, _
                    ByVal uFlags As Long) As Long

Const SND_SYNC = &H0
Const SND_ASYNC = &H1
Const SND_NODEFAULT = &H2
Const SND_LOOP = &H8
Const SND_NOSTOP = &H10
Dim alarmActive As Boolean    ' sound flag
 

Public Sub Form_Load()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  Form Load
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim msg As String

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  parse command line and get name of machine datafile
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
If Command = "" Then
   nameOfDatafile = CurDir() & "\WinPing1.dat" 'DEFAULT
Else
   nameOfDatafile = Command
End If

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  make sure machine datafile exists
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
On Error Resume Next
i = FileLen(nameOfDatafile)
On Error GoTo 0
If i = 0 Then
   msg = "File " & nameOfDatafile & " not found!"
   ' display error message and exit
   MsgBox msg
   mnuExit_Click
End If

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  load datafile into an array
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Call LoadDatafileArray

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  Setup REDLOG, contains log of ping errors
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
redlog = CurDir() & "\redlog.txt"     'set file name

i = 0
On Error Resume Next
i = FileLen(redlog)                   'check if file exists
On Error GoTo 0

If i = 0 Then
   Open redlog For Output As #1       'if not, create it
   Write #1, "WinPing's redlog.txt contains a list of ping errors"
   Close #1
End If
   

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  set initial form traits
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Form1.Caption = " WinPing V1.0, Network Node Monitor for NT and Win9.x"
Form1.BackColor = &H0&  ' Black

Form1.Top = GetSetting(AppName:="WinPing", _
            Section:="General", _
            Key:="top", _
            Default:="0")
Form1.Left = GetSetting(AppName:="WinPing", _
            Section:="General", _
            Key:="left", _
            Default:="0")
Form1.Height = GetSetting(AppName:="WinPing", _
            Section:="General", _
            Key:="height", _
            Default:=Screen.Height * 0.9)
Form1.Width = GetSetting(AppName:="WinPing", _
            Section:="General", _
            Key:="width", _
            Default:=Screen.Width * 0.95)
            
'set generation counter and red counter
pingcntr = 0
pingcntr2 = 0
Label4.Caption = "Ping Cycle Count = " + CStr(pingcntr)
Label5.Caption = "Red Machine Hits = " + CStr(pingcntr2)

' set audible alarm options
alarmActive = True ' default to ALARM ON
Command3.Caption = "Alarm is ON"

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  load initial machine icons
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
For i = 1 To datafileSize Step 1 ' number of machine names
   Load Label1(i)
   Load Image1(i)
Next i

Call LoadIcons
End Sub


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'
'  e v e n t     d r i v e n     r o u t i n e s
'
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''



Private Sub Command1_Click()

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Command Button : start ping
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' set flag
user_requested_stop = False
'TIMER OFF (timer calls this subroutine, turn off to avoid recursion)
Timer1.Interval = 0    ' time in milliseconds
Timer1.Enabled = False

' set command buttons
Command1.Enabled = False
Command2.Enabled = True

' call routines
Call PingBoxes
Call ReadPingData
Call DisplayPingData

' re-drive if not all pings are complete
Do While (DisplayPingData_Status = "redo")
Call ReadPingData
Call DisplayPingData
Loop

' display status
tempvar1 = Time$()
tempvar1 = tempvar1 & " STATUS:  Waiting for Next Cycle, " _
                    & Str(CYCLE_TIME / 60) _
                    & " minute(s)..."
StatusBar1.Panels("STATUS").Text = tempvar1

' wait
Sleep CYCLE_TIME

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  After our wait routine runs, we turn the Object Timer
'  back on to call main() again.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
If user_requested_stop <> True Then
Timer1.Interval = 1000    ' time in milliseconds
Timer1.Enabled = True
End If
End Sub


Private Sub Command2_Click()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Command Button : stop ping
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' set flag
user_requested_stop = True
' turn off timer
Timer1.Interval = 0    ' time in milliseconds
Timer1.Enabled = False
' set command buttons
Command1.Enabled = True
Command2.Enabled = False
' display status
tempvar1 = Time$()
tempvar1 = tempvar1 & _
           " STATUS:  STOPPED, click on *Start Ping* to resume."
StatusBar1.Panels("STATUS").Text = tempvar1

End Sub


Public Sub Command3_Click()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Command Button : turn alarm on/off
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
If Command3.Caption = "Alarm is ON" Then
' turn sound OFF
alarmActive = False
Command3.Caption = "Alarm is OFF" ' toggle button display
Else
' turn sound ON
alarmActive = True
Command3.Caption = "Alarm is ON"
End If

End Sub




Private Sub Image1_Click(Index As Integer)
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' view ping textfile for selected icon, if clicked upon
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim tempcmd1 As String
Dim retval As Long

tempcmd1 = "notepad.exe " _
           & CurDir() _
           & "\" _
           & Trim(Label1(Index).Caption) _
           & ".png"
retval = Shell(tempcmd1, 1)

End Sub

Private Sub Label1_Click(Index As Integer)
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' view ping textfile for selected icon, if clicked upon
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim tempcmd1 As String
Dim retval As Long

tempcmd1 = "notepad.exe " _
           & CurDir() _
           & "\" _
           & Trim(Label1(Index).Caption) _
           & ".png"
retval = Shell(tempcmd1, 1)

End Sub


Private Sub Form_Unload(Cancel As Integer)
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Form Unload Event
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
SaveSetting AppName:="WinPing", _
            Section:="General", _
            Key:="top", _
            Setting:=Form1.Top
            
SaveSetting AppName:="WinPing", _
            Section:="General", _
            Key:="left", _
            Setting:=Form1.Left
            
SaveSetting AppName:="WinPing", _
            Section:="General", _
            Key:="height", _
            Setting:=Form1.Height
            
SaveSetting AppName:="WinPing", _
            Section:="General", _
            Key:="width", _
            Setting:=Form1.Width
End
End Sub


Private Sub mnuAbout_Click()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Menu Item : ABOUT
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Load Form2
Form2.Show
End Sub



Private Sub mnuDelPing_Click()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Menu Item : cleanup all ping data files upon click
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim tempcmd1 As String
Dim retval As String

tempcmd1 = Environ$("COMSPEC") _
         & " /c del " _
         & Chr(34) _
         & CurDir() _
         & "\*.PNG" _
         & Chr(34)
retval = Shell(tempcmd1, 1)
MsgBox "All *.png files have been deleted"

End Sub


Private Sub mnuRedlog_Click()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Menu Item : view redlog
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim tempcmd1 As String
Dim retval As Long
tempcmd1 = "notepad.exe " & redlog
retval = Shell(tempcmd1, 1)
End Sub


Private Sub mnuEditMachineNames_Click()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Menu Item : edit "machine name" list
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim tempcmd1 As String
Dim retval As Long

tempcmd1 = "notepad.exe WinPing1.dat"
retval = Shell(tempcmd1, 1)
MsgBox "You must restart WinPing.exe to refresh your display"

End Sub



Private Sub mnuExit_Click()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Menu Item : exit program
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Timer1.Interval = 0    ' time in milliseconds
Timer1.Enabled = False
Unload Me
End
End Sub



Private Sub mnuStartPing_Click()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Menu Item : start ping
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Command1_Click
End Sub


Private Sub mnuStopPing_Click()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  Menu Item : stop ping
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Command2_Click
End Sub


Private Sub Timer1_Timer()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'  code for timer object:
'  timer to cycle through pings
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Call Command1_Click
End Sub


Private Sub Form_Resize()
Dim tempbool As Boolean
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' resize event
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Static resize_counter As Integer
resize_counter = resize_counter + 1

If resize_counter > 3 Then
Call LoadIcons
DoEvents

tempbool = alarmActive  ' store current setting
alarmActive = False     ' turn off sound
Call DisplayPingData    ' redisplay icons
alarmActive = tempbool  ' restore setting
End If

End Sub


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'
'  c a l l e d     r o u t i n e s
'
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''


Sub Sleep(Seconds As Double)
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  Object Timers can only wait up to 65535 milliseconds
'  This is where the real waiting is done, make sure
'  the sleep() routine contains a DoEvents.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim TempTime As Double
TempTime = Timer
While Timer - TempTime < Seconds
 DoEvents
 If Timer < TempTime Then
    TempTime = TempTime - 24# * 3600#
 End If
Wend
End Sub


Private Sub PingBoxes()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  issue ping for each machine name
'  Store results in text files(s) called machine_name.png
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim tempcmd1 As String
Dim retval As Long

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' gray out COMMAND BUTTONS while PING is running
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
tempCommand1_Button = Command1.Enabled ' store current settings
tempCommand2_Button = Command2.Enabled ' store current settings
tempCommand3_Button = Command3.Enabled ' store current settings
Command1.Enabled = False               ' turn off
Command2.Enabled = False               ' turn off
Command3.Enabled = False               ' turn off
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' gray out MENU OPTIONS while PING is running
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
mnuExit.Enabled = False
mnuEditMachineNames.Enabled = False
mnuDelPing.Enabled = False
mnuStartPing.Enabled = False
mnuStopPing.Enabled = False
mnuAbout.Enabled = False

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Increment ping cycle counter and display it
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
pingcntr = pingcntr + 1
Label4.Caption = "Ping Cycle Count = " & CStr(pingcntr)

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Loop through machines
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
For i = 0 To datafileSize Step 1
DoEvents
tempvar1 = Time$()
tempvar1 = tempvar1 _
           & " STATUS:  Spawning PING for Machine Name - " _
           & datafile(i)
StatusBar1.Panels("STATUS").Text = tempvar1

' environ() returns cmd.exe for NT and command.com for WIN9x
tempcmd1 = Environ$("COMSPEC") _
            & " /c ping.exe " _
            & datafile(i) _
            & " > " _
            & Chr(34) _
            & CurDir() _
            & "\" _
            & datafile(i) _
            & ".png" _
            & Chr(34)

retval = Shell(tempcmd1, 6)
Sleep 1 ' time in seconds, load balancing pings is an issue
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  color icons as we are pinging to show we are working
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Label1(i).BackColor = &HFFFF& 'yellow

Next i
End Sub



Private Sub ReadPingData()
Dim i As Integer
Dim k As Integer
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  read text files created by ping, store true or false
'  (successful ping or unsuccessful ping) in machine name
'  array.
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim tempvar1 As String

tempvar1 = Time$()
tempvar1 = tempvar1 & " STATUS:  Waiting for PING(s) to complete..."
StatusBar1.Panels("STATUS").Text = tempvar1
If datafileSize < 10 Then
   Sleep (datafileSize * 0.7) 'allow pings to finish
Else
   Sleep (datafileSize * 0.3) 'time in seconds
End If

For i = 0 To datafileSize Step 1 ' number of files
k = 0
DoEvents

On Error Resume Next  ' suppress errors, if timing problem
pingfile(i) = ""      ' wipe previous cycle array value

Open CurDir() & "\" & datafile(i) & ".png" For Input As #1
Do While (Not EOF(1)) And (pingfile(i) <> True)
    k = k + 1
    Line Input #1, tempvar1
    pingfile(i) = tempvar1 Like "Reply from *" ' returns true/false
    If k > 50 Then Exit Do  ' if this triggers, it's a null ping file
Loop
Close #1

Next i

On Error GoTo 0 ' Turn off error trapping.

End Sub

Private Sub DisplayPingData()
Dim msg1 As String
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  read ARRAY of ping results and color icons red or green
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim playSound As Boolean
Dim SoundName As String
Dim wflags As String
Dim x As String

playSound = False
DisplayPingData_Status = ""

tempvar1 = Time$()
tempvar1 = tempvar1 & _
           " STATUS:  Displaying Ping Results for All Machine(s)"
StatusBar1.Panels("STATUS").Text = tempvar1

For i = 0 To datafileSize Step 1 ' number of machine names
DoEvents

Select Case pingfile(i)
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' TRUE = GREEN
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Case True
Label1(i).BackColor = &HFF00& 'green
Image1(i).Picture = LoadPicture("cgreen.bmp")

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' FALSE = RED
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Case False
Label1(i).BackColor = &HFF& 'red
Image1(i).Picture = LoadPicture("cred.bmp")
playSound = True
' Increment RED counter and display it
pingcntr2 = pingcntr2 + 1
Label5.Caption = "RED Machine Hits = " + CStr(pingcntr2)

' WRITE ENTRY TO REDLOG
msg1 = Date _
     & " " _
     & Time _
     & " " _
     & datafile(i)

Open redlog For Append As #1
Write #1, msg1
Close #1

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' ELSE, TRY AGAIN
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Case Else
DisplayPingData_Status = "redo"   ' set flag
Exit Sub                          ' return to main

End Select

Next i

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' restore previous COMMAND BUTTON settings
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
On Error Resume Next
Command1.Enabled = tempCommand1_Button
Command2.Enabled = tempCommand2_Button
Command3.Enabled = tempCommand2_Button
On Error GoTo 0

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' restore MENU OPTIONS
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
mnuExit.Enabled = True
mnuEditMachineNames.Enabled = True
mnuDelPing.Enabled = True
mnuStartPing.Enabled = True
mnuStopPing.Enabled = True
mnuAbout.Enabled = True

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' after loop, see if we sound alarm
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
If (alarmActive = True) And (playSound = True) Then
   SoundName = "WinPing.wav"
   wflags = SND_ASYNC Or SND_NODEFAULT
   x = sndPlaySound(SoundName, wflags)
End If

End Sub


Private Sub LoadDatafileArray()
Dim temp01 As String
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  load datafile into an array
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' first, count number of entries in file
Open nameOfDatafile For Input As #1
i = 0
Do While Not EOF(1)
    Line Input #1, temp01
    ' ignore null lines and comments
    If (temp01 <> "") And (temp01 Like "'*" <> True) Then
    i = i + 1
    End If
Loop
Close #1

' now, dynamically expand array(s)
ReDim datafile(i) As String
ReDim pingfile(i) As Boolean

' now, load datafile into array
Open nameOfDatafile For Input As #1
i = 0
Do While Not EOF(1)
Line Input #1, datafile(i)
  ' eliminate blanks on line
  datafile(i) = Trim(datafile(i))
  ' if null line, use same element for next machine name
  If (datafile(i) <> "") And (datafile(i) Like "'*" <> True) Then
  i = i + 1
  End If
Loop
Close #1

' when done, store number of array entries
datafileSize = i - 1
 
End Sub


Private Sub LoadIcons()
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  initial placement of icons on the desktop
'  color default is gray until ping begins
' &HC0C0C0     'gray
' &HFF&        'red
' &HFF00&      'green
' &H0000FFFF&  'yellow
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim leftPos As Integer         ' X cord. used for graphics placement
Dim topPos As Integer          ' Y cord. used for graphics placement
Dim iconSpHorizontal As Integer   ' gap between machine icons
Dim iconSpVertical As Integer     ' gap between machine icons
Dim iconsInRow As Integer      ' will vary by screen resolution
Dim iconsInCol As Integer      ' will vary by screen resolution
Dim iconWidth As Integer
Dim iconHeight As Integer

' display status
tempvar1 = Time$()
tempvar1 = tempvar1 & " STATUS:  Initializing Machine Icons. "
tempvar1 = tempvar1 & " First PING cycle will begin in "
tempvar1 = tempvar1 & Str(CYCLE_TIME / 60) & " minute(s)"
tempvar1 = tempvar1 & " OR press START to begin NOW."
StatusBar1.Panels("STATUS").Text = tempvar1
 
' actual size of machine icons being used (external .bmp files)
iconWidth = (91 * Screen.TwipsPerPixelX)  ' convert pixels to twips
iconHeight = (38 * Screen.TwipsPerPixelY) ' convert pixels to twips

' set label size
Label1(0).Width = "1092" ' twips
Label1(0).Height = "240" ' twips

' set first icon position
iconSpHorizontal = 300
iconSpVertical = 250

leftPos = iconSpHorizontal
topPos = iconSpVertical + 500


''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'  Setup Icons according to form size
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
iconsInRow = ((Form1.Width * 0.9) / _
              (iconWidth + iconSpHorizontal))
iconsInCol = ((Form1.Height - 1900) / _
              (iconHeight + Label1(0).Height + iconSpVertical))
         
If datafileSize + 1 > iconsInRow * iconsInCol Then
tempvar1 = Time$()
tempvar1 = tempvar1 & " STATUS: "
tempvar1 = tempvar1 & "You have more Machine Icons (" & _
                      CStr(datafileSize + 1) & _
                      ") than will fit on the screen (" & _
                      CStr(iconsInRow * iconsInCol) & _
                      ")."
StatusBar1.Panels("STATUS").Text = tempvar1
End If

' load first icon
Image1(0).Visible = True
Image1(0).Top = topPos
Image1(0).Left = leftPos
Image1(0).Picture = LoadPicture("cgray.bmp")

Label1(0).Visible = True
Label1(0).Top = topPos + Image1(0).Height
Label1(0).Left = leftPos
Label1(0).BackColor = &HC0C0C0 'gray
Label1(0).Caption = datafile(0)

' loop through the rest
For i = 1 To datafileSize Step 1 ' number of machine names

leftPos = leftPos + iconWidth + iconSpHorizontal

' increment icons to next row
Select Case i
Case iconsInRow
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 2
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 3
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 4
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 5
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 6
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 7
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 8
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 9
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 10
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 11
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 12
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 13
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 14
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
Case iconsInRow * 15
 topPos = topPos + iconHeight + Label1(0).Height + iconSpVertical
 leftPos = iconSpHorizontal
     
End Select

Label1(i).Visible = True
Label1(i).Top = topPos + Image1(0).Height
Label1(i).Left = leftPos
Label1(i).BackColor = &HC0C0C0 'gray
Label1(i).Caption = datafile(i)

Image1(i).Top = topPos
Image1(i).Left = leftPos
Image1(i).Visible = True
Image1(i).Picture = LoadPicture("cgray.bmp")

Next i

End Sub



