#include <windows.h>
#include "main.h"

/*
TurnFlash v1.00 (Command-Line Version)
Copyright (c) 2003 Nir Sofer

Web site: http://nirsoft.cjb.net

This utility allows you to easily enable and disable the Macromedia Flash
component in Internet Explorer browser. (Versions 5.x or 6.x)

It does it by writing to the "ActiveX Compatibility" key in the Registry
(HKEY_LOCAL_MACHINE\Software\Microsoft\Internet Explorer\ActiveX Compatibility)

Syntax:
TurnFlash [on | off]

In order to turn on the Flash component, run this utility with 'on' parameter:
TurnFlash on

In order to turn off the Flash component, run this utility with 'off' parameter:
TurnFlash off


*/


void ErrorMessage()
{
	MessageBox(0, "Unable to write to the Registry !", "Error", MB_OK | MB_ICONEXCLAMATION);
}

LONG OpenActiveXRegKey(REGSAM samDesired, PHKEY phkResult)
{
	return RegOpenKeyEx(HKEY_LOCAL_MACHINE, 
						ACTIVEX_REG_KEY, 
						0,
						samDesired,
						phkResult);
}

LONG RegSetValueDWord(HKEY hKey, LPTSTR lpValueName, DWORD dwData)
{
	return RegSetValueEx(hKey, lpValueName, 0, REG_DWORD, (const BYTE *)&dwData, 4);
}

void TurnFlashOnOff(BOOL bTurnOn)
{
	HKEY hActiveXKey, hFlashKey;

	//Open the following key in the Registry: 
	//HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Internet Explorer\ActiveX Compatibility 
	if (OpenActiveXRegKey(KEY_WRITE, &hActiveXKey) == ERROR_SUCCESS)
	{
		//Create or open the Registry key for Flash: {D27CDB6E-AE6D-11cf-96B8-444553540000}
		if (RegCreateKeyEx(	hActiveXKey, 
							FLASH_KEY,
							0,
							NULL,
							0,
							KEY_WRITE,
							NULL,
							&hFlashKey,
							NULL) == ERROR_SUCCESS)


		{
			
			//Write the "Compatibility Flags" value:
			//0x0000 = Enable Flash
			//0x0400 = Disable Flash
			if (RegSetValueDWord(hFlashKey, 
								 FLASH_COMPATIBILITY_FLAGS, 
								 bTurnOn?0x0000:0x0400) != ERROR_SUCCESS)

				ErrorMessage();

			RegCloseKey(hFlashKey);
		}
		else
			ErrorMessage();

		RegCloseKey(hActiveXKey);
	}
	else
		ErrorMessage();
}


void StrTrim(LPSTR lpszDest, LPCSTR lpszSource)
{
	int nIndex = 0;

	while (lpszSource[nIndex] == ' ')
		nIndex++;

	lstrcpy(lpszDest, &lpszSource[nIndex]);

	nIndex = lstrlen(lpszDest) - 1;
	while (nIndex > 0 && lpszDest[nIndex] == ' ')
		nIndex--;

	lpszDest[nIndex + 1] = '\0';
}

int WINAPI WinMain(
  HINSTANCE hInstance,      // handle to current instance
  HINSTANCE hPrevInstance,  // handle to previous instance
  LPSTR lpCmdLine,          // command line
  int nCmdShow              // show state
)
{
	const MAX_COMMAND_LINE = 10;
	
	char szTrimCommandLine[MAX_COMMAND_LINE];
	if (lstrlen(lpCmdLine) > MAX_COMMAND_LINE) return 0;

	//Remove leading spaces and the trailing spaces from the command-line string.
	StrTrim(szTrimCommandLine, lpCmdLine); 
	
	if (lpCmdLine[0] == '\0')
		MessageBox(0, START_TEXT, "TurnFlash", MB_OK | MB_ICONINFORMATION);
	else if (lstrcmpi(szTrimCommandLine, "on") == 0)
		//Turn Flash on
		TurnFlashOnOff(TRUE);
	else if (lstrcmpi(szTrimCommandLine, "off") == 0)
		//Turn Flash off
		TurnFlashOnOff(FALSE);


	return 0;
}