Program TC_Color;

{ *FREEWARE by Bo Bendtsen 1997 }

Type

  AddrRecord = Record
    Zone,Net,
    Node,Point : Word;
  End;

  ConfigType = Record
        C_Information,
        C_InformationBold,
        C_StatusLine,
        C_StatusHigh,
        C_Menus,
        C_MenuLine,
        C_MenuHead,
        C_MenuText,
        C_MenuTextHigh,
        C_MenuTextBold,
        C_Edit,
        C_MenuBar            : Byte;
        StartUpLength        : Byte;
        SwapMethod           : Byte;
        BlindSupport         : Boolean;
        CS_Tast              : Array[1..12] of Record
                                 Id : String[4];
                                 s  : String[60];
                               End;
        HowToSort,
        HowToSort2           : Byte;
        Window2,
        ShowBoth             : Boolean;
        Path,
        Path2                : String[60];
        WarnDiskFree         : LongInt;
        FileCPS              : Word;
        BlindInfo            : Boolean;
        TagChar              : Char;
        FindDrives,
        ScanDrives           : Longint;
        EditorName,
        ListName             : String[74];
        Allow4DOS            : Boolean;
        UseMouse             : Boolean;
        Users                : AddrRecord;
        Filler               : Array[1..292] of Byte;
      End;



Function StrToInt(S: String) : LongInt;
Var
  Kode : Integer;
  i    : LongInt;
  R    : Real;
Begin
  If s='' Then
  Begin
    StrToInt:=0;
    Exit;
  End;
  i:=1; While s[i] in ['-','0'..'9'] Do Inc(i);
  Delete(s,i,255);
  If Length(S) = 0 Then StrToInt := 0 Else Begin
    Val(S,i,Kode);
    If Kode = 0 Then StrToInt := i Else
    Begin
      Val(S,R,Kode);
      If (Kode = 0) And (R<MaxLongint) Then StrToInt := Trunc(R) Else StrToInt:=0;
    End;
  End;
End;


Var
  C  : ConfigType;
  CF : File of ConfigType;

Begin

  WriteLn(' Terminate Commander color configuration tool');

  If Paramcount<>12 Then
  Begin
    WriteLn(' Colors:'#10);
    WriteLn('   1: Information          2: InformationBold');
    WriteLn('   3: StatusLine           4: StatusHigh');
    WriteLn('   5: Menus                6: MenuLine');
    WriteLn('   7: MenuHead             8: MenuText');
    WriteLn('   9: MenuTextHigh        10: MenuTextBold');
    WriteLn('  11: Edit                12: MenuBar'#10);

    WriteLn('  Terminate  : TC-COL 25 23 23 31 11 1 30 7 3 14 11 113');
    WriteLn('  Terminate  : TC-COL 48 59 48 62 10 4 30 7 3 14 11 112');
    WriteLn('  Ala Norton : TC-COL 59 62 112 127 48 59 62 63 59 62 14 112');
    WriteLn('  Novell     : TC-COL 25 30 23 31 30 27 30 31 27 30 31 113');
    WriteLn('  Telix      : TC-COL 25 30 78 79 31 27 31 30 31 31 31 79');
    WriteLn('  Turbo 5.5  : TC-COL 112 127 48 79 112 123 15 112 127 116 15 15');
    WriteLn('  LCD/B&W    : TC-COL 7 15 112 15 15 7 112 7 15 112 112 112');
    WriteLn('  Monochrome : TC-COL 112 127 112 127 112 112 15 112 127 127 112 15');
    WriteLn('  Flashy     : TC-COL 93 94 76 78 42 8 47 32 42 46 11 79');
    WriteLn('  Purple     : TC-COL 80 93 93 94 87 8 92 80 94 92 80 71');

    Halt;

  End;

  WriteLn(' Reading TC.CFG');

  Assign(CF,'TC.CFG');
  {$I-} Reset(CF); {$I+}
  If IOResult<>0 Then
  Begin
    WriteLn(' Error reading TC.CFG');
    Halt;
  End;

  Read(CF,C);

  With C Do
  Begin

    C_Information        := StrToInt(ParamStr(1));
    C_InformationBold    := StrToInt(ParamStr(2));
    C_StatusLine         := StrToInt(ParamStr(3));
    C_StatusHigh         := StrToInt(ParamStr(4));
    C_Menus              := StrToInt(ParamStr(5));
    C_MenuLine           := StrToInt(ParamStr(6));
    C_MenuHead           := StrToInt(ParamStr(7));
    C_MenuText           := StrToInt(ParamStr(8));
    C_MenuTextHigh       := StrToInt(ParamStr(9));
    C_MenuTextBold       := StrToInt(ParamStr(10));
    C_Edit               := StrToInt(ParamStr(11));
    C_MenuBar            := StrToInt(ParamStr(12));

  End;

  Seek(CF,0);
  Write(CF,C);
  Close(CF);

  WriteLn(' Done');

End.
