{
ͻ
 NAME      : CONVERTP.PAS: CONVASC and CONVHEX routines.                     
 VERSION   : v 1.0                                                           
 FILE TYPE : Use TURBO.EXE to make the executable file...                    
 FUNCTION  : Shows how to use the ASCII <--> HEXA transcoding routines       
           : from the PASCAL language.                                       
           : Their main goal is to permit to a SERIAL MANAGER application    
           : using the Xon/Xoff protocol to transmit binary informations     
           : without any interferences with the soft hand-shaking...         
           : ATTENTION: Each binary code is associated to 2 ASCII codes.     
           : Therefore, the efficiency of an ASCII transmission is less      
           : than for a binary transmission ! ONLY USE THESE PROCEDURES      
           : IF YOU CAN NOT DO OTHERWISE...                                  
 SYNTAX    : CONVERTP                                                        
 COPYRIGHT : HETRU Fabrice 1991.                                             
ͼ
}



USES Dos, Crt;



TYPE CHAR2 = string[2];


VAR
  fin    : BOOLEAN ;
  caract : CHAR    ;
  dest   : CHAR2   ;


PROCEDURE ConvAscii(VAR pte: CHAR; VAR pts: CHAR2);
{ Makes 2 ASCII codes from pte (hexa.) into pts...                            }
  VAR
    car: CHAR;
    cr : BYTE absolute car;
    val: CHAR;
    vl : BYTE absolute val;
  BEGIN
    (* Storing the hexa. number. *)
    val := pte;
    (* Converting the left half-byte *)
    cr := (vl shr 4) + $30;
    pts[2] := car;
    (* Converting the right half-byte *)
    cr := (vl AND $0F) + $30;
    (* Returning the result *)
    pts[1] := car;
  END;


PROCEDURE ConvHexa(VAR pte: CHAR2; VAR pts: CHAR);
{ Converts, into 1 HEXA, the 2 ASCII codes from pte into pts.                 }
  VAR
    car : CHAR;
    cr  : BYTE absolute car;
    car1: CHAR;
    cr1 : BYTE absolute car1;
    car2: CHAR;
    cr2 : BYTE absolute car2;
  BEGIN
    car1 := pte[1];
    car2 := pte[2];
    (* Converting the left half-byte *)
    cr := (cr2 - $30) shl 4;
    (* Converting the right half-byte *)
    cr := cr + (cr1 - $30);
    (* Returning the result *)
    pts := car;
  END;


BEGIN
  fin := FALSE;
  WRITELN('CONVERTP: A demostration of the HEXA <--> ASCII trancoding.');
  WRITELN('            (Press 'Esc' to end this program).');
  WHILE NOT FIN DO
  BEGIN
    (* Get the byte to transcode *)
    WRITELN;
    WRITE('Character: ');
    WHILE NOT KeyPressed DO;
    caract := ReadKey;
    if (caract<>chr($0d)) THEN WRITE(caract)
      ELSE WRITE(' ');
    if (caract=chr($1b)) THEN fin := TRUE;

    (* HEXA-->ASCII transcoding *)
    ConvAscii(caract,dest);
    (* Write the resulting code on screen *)
    WRITE(' --ConvAscii--> ',dest[1],dest[2]);

    (* IN THAT POINT, THE ASCII BYTES MAY BE TRANSMITED WITHOUT ANY RISK
       TO INTERFER WITH THE Xon/Xoff HAND-SHAKING
       (whose codes are included between 0 and 29h...).
       INCONVENIENT from this method: For each byte to send, 2 bytes have
       to be transmited !... *)

    (* ASCII-->HEXA transcoding *)
    ConvHexa(dest,caract);
    (* Write the restituted byte into screen (=Primary byte si O.K.) *)
    WRITE(' --ConvHexa-->   ');
    if (caract<>chr($0d)) THEN WRITE(caract)
      ELSE WRITE(' ')
  END;
  WRITELN;
  WRITELN('CONVERTP has ended --- (C)HETRU Fabrice.')
END.
