;ͻ
; NAME         : CONVERTA.ASM: CONVASC and CONVHEX routines.                 
; VERSION      : v 1.0                                                       
; FILE TYPE    : COMmand file type (Use the EXE2BIN.COM DOS utilite).        
; FUNCTION     : Shows how to use the ASCII <--> HEXA transcoding routines   
;              : from the assembler language.                                
;              : Their main goal is to permit to a SERIAL MANAGER application
;              : using the Xon/Xoff protocol to transmit binary informations 
;              : without any interferences with the soft hand-shaking...     
;              : ATTENTION: Each binary code is associated to 2 ASCII codes. 
;              : Therefore, the efficiency of an ASCII transmission is less  
;              : than for a binary transmission ! ONLY USE THESE PROCEDURES  
;              : IF YOU CAN NOT DO OTHERWISE...                              
; SYNTAX       : CONVERTA                                                    
; COPYRIGHT    : HETRU Fabrice 1991.                                         
;ͼ



name        CONVERTA
title       Programm using the ASCII <--> HEXA transcoding procedures.
page        60,80



if1
%out 
%out    TRANSCODING PROCEDURES ARE BEEING ASSEMBLED  
%out 
endif



code     segment
         assume cs:code,ds:code
         org    100h

start:   jmp     main

hello    db   "CONVERTA: A demostration of the HEXA <--> ASCII trancoding."
         db   0dh,0ah
         db   "            (Press 'Esc' to end this program).",0dh,0ah,'$'
get      db   0dh,0ah,'Character: $'
car0     db   ?,' --CONVASC-->'
car1     db   ?,?,' --CONVHEX-->'
car2     db   ?,'$'
byebye   db   0dh,0ah,"CONVERTA has ended --- (C)HETRU Fabrice.",0dh,0ah,'$'

main     proc   near
         mov    dx,offset hello
         mov    ah,9
         int    21h
         next:
         mov    dx,offset get
         mov    ah,9
         int    21h
         mov    ah,0
         int    16h
         push   ax
         mov    car0,al
         cmp    al,0dh
         jne    car_ok
         mov    car0,' '
         car_ok:
         mov    di,offset car1 ;Destination
         call   convasc
         mov    di,offset car1 ;Source
         call   convhex
         mov    car2,al
         mov    dx,offset car0
         mov    ah,9
         int    21h
         pop    ax
         cmp    al,1bh
         jne    next
         ;End of the program.
         mov    dx,offset byebye
         mov    ah,9
         int    21h
         mov    ax,4c00h
         int    21h
main     endp

convasc  proc   near
;Converte the hexa. byte in AL into 2 ASCII bytes (stored into [DI] string).
         mov    ah,al
         mov    cl,4
         shr    ah,cl
         add    ah,30h
         inc    di
         mov    [di],ah
         dec    di
         and    al,0fh
         add    al,30h
         mov    [di],al
         ret
convasc  endp

convhex  proc   near
;Return 1 HEXA byte (in AL) from 2 given ASCII bytes.
         inc    di
         mov    al,[di]
         dec    di
         sub    al,30h
         mov    cl,4
         shl    al,cl
         mov    ah,[di]
         sub    ah,30h
         add    al,ah
         ret
convhex  endp

code     ends
         end    start
