//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
#include <windows.h>
#include <shellapi.h>

#define MWM_NOTIFYICON	(WM_APP+100)
#define MWM_OPWSTAT		(WM_USER+233)
#define IDM_PAUSE			1
#define IDC_NOTIFY			2
#define IDM_SHOW			3
#define IDM_HIDE			4
#define IDM_LAUNCH			5
#define IDM_CLOSE			6
#define IDM_EXIT			7
#define IDM_OPCFG			8
#define IDM_PKILL			20

/*---------------------------------------------------------------------------*/
// Global to everybody...
HINSTANCE	g_hinst;
HICON		hIcon;
BOOL		OPWlaunch;
char		szCL[MAX_PATH+130],szCFL[MAX_PATH],szTest[64],szTip[64],
			szLnc[]="Launch OpWiC";

//---------------------------------------------------------------------------
BOOL TrayMessage(HWND, DWORD);
BOOL TrayMessage(HWND hwnd, DWORD dwMessage)
	{
	NOTIFYICONDATA tnd;

	tnd.cbSize		= sizeof(NOTIFYICONDATA);
	tnd.hWnd		= hwnd;
	tnd.uID			= IDC_NOTIFY;
	tnd.uFlags		= NIF_MESSAGE|NIF_ICON|NIF_TIP;
	tnd.uCallbackMessage	= MWM_NOTIFYICON;
	tnd.hIcon		= hIcon;
	lstrcpy (tnd.szTip,szTip);

	return (Shell_NotifyIcon(dwMessage, (PNOTIFYICONDATA)&tnd));
	}

LRESULT CALLBACK OWTWndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
	{
	LPDRAWITEMSTRUCT lpdi;
	HMENU hMenu;
	POINT pt;
	UINT  uF;
	LRESULT OPWstat;
	HWND hwOPW = FindWindow("OpWiCWindow",NULL);

	switch (uMsg)
		{
		case WM_CREATE:
			hIcon = (HICON)LoadImage(g_hinst, "OPWIC", IMAGE_ICON, 16, 16, 0);
			TrayMessage(hwnd, NIM_ADD);
			if (OPWlaunch) WinExec (szCL, SW_SHOW);
			return 0;

		case WM_SIZE :
			ShowWindow(hwnd, SW_HIDE);
			break;

		case WM_DRAWITEM:
			lpdi = (LPDRAWITEMSTRUCT)lParam;
			DrawIconEx(lpdi->hDC, lpdi->rcItem.left, lpdi->rcItem.top,
										hIcon, 16, 16, 0, NULL, DI_NORMAL);
			break;

/*		case WM_CLOSE:
		case WM_QUERYENDSESSION:
*/
		case WM_DESTROY:
			DestroyIcon (hIcon);
			TrayMessage(hwnd, NIM_DELETE);
			PostQuitMessage(0);
			return 0;

		case MWM_NOTIFYICON:
			switch (lParam)
				{
				DWORD dw;

				case WM_MOUSEMOVE:
					if (!IsWindow(hwOPW)) lstrcpy(szTest,szLnc);
					else
						{
						if (IsWindowVisible(hwOPW)) lstrcpy(szTest,"Hide OpWiC");
						else GetWindowText(hwOPW,szTest,63);
						}
					if (lstrcmp(szTest,szTip))
						{
						lstrcpy(szTip,szTest);
						TrayMessage(hwnd, NIM_MODIFY);
						}
					break;
				case WM_LBUTTONDOWN:
				case WM_LBUTTONDBLCLK:
					if (!IsWindow(hwOPW)) {WinExec (szCL,SW_SHOW); break;}
					if (IsWindowVisible(hwOPW)) ShowWindow(hwOPW,SW_HIDE);
					else {ShowWindow(hwOPW,SW_SHOW); SetForegroundWindow(hwOPW);}
					break;
				case WM_RBUTTONDOWN:
					hMenu = CreatePopupMenu();
					GetCursorPos (&pt);
					// Create context menu from scratch
					if (IsWindow(hwOPW))
						{
						OPWstat = SendMessage(hwOPW,MWM_OPWSTAT,0,0);
						uF = MF_STRING | (IsWindowVisible(hwOPW) ? MF_ENABLED : MF_GRAYED);
						AppendMenu (hMenu, uF, IDM_HIDE, "&Hide OpWiC");
						uF = MF_STRING | (IsWindowVisible(hwOPW) ? MF_GRAYED : MF_ENABLED);
						AppendMenu (hMenu, uF, IDM_SHOW, "&Show OpWiC");
						AppendMenu (hMenu, MF_STRING, IDM_CLOSE, "&Close OpWiC");
						AppendMenu (hMenu, MF_SEPARATOR, 0, 0);
						uF = MF_STRING | MF_ENABLED | ((OPWstat&32) ? MF_CHECKED : MF_UNCHECKED);
						AppendMenu (hMenu, uF, IDM_PAUSE, "&Pause OpWiC");
						if (OPWstat&64)
							{
							uF = MF_STRING | MF_ENABLED | ((OPWstat&128) ? MF_CHECKED : MF_UNCHECKED);
							AppendMenu (hMenu, uF, IDM_PKILL, "&Kill Popups");
							}
						AppendMenu (hMenu, MF_SEPARATOR, 0, 0);
						}
					AppendMenu (hMenu, MF_STRING, IDM_LAUNCH, "&Launch OpWiC");
					AppendMenu (hMenu, MF_SEPARATOR, 0, 0);
					if (-1L != (dw = GetFileAttributes(szCFL)))
						{
						AppendMenu (hMenu, MF_STRING, IDM_OPCFG, "&Open OpConfig");
						AppendMenu (hMenu, MF_SEPARATOR, 0, 0);
						}
					AppendMenu (hMenu, MF_STRING, IDM_EXIT, "E&xit OpWiTray");
					// This is the first part of a hack necessary for Win95 to
					// display context menus from the tray
					SetForegroundWindow(hwnd);
					// Display menu between hacks...
					TrackPopupMenu (hMenu,TPM_LEFTALIGN | TPM_LEFTBUTTON |
									TPM_RIGHTBUTTON, pt.x, pt.y, 0, hwnd, NULL);
					// This is the second part of a hack necessary for Win95 to
					// display context menus from the tray.  This is just
					// a dummy message to the window.
					PostMessage (hwnd, WM_USER + 10, 0, 0);
					break;
				}
			return 0;

		case WM_COMMAND :
			switch (LOWORD(wParam))
				{
				case IDM_EXIT :
					PostMessage(hwnd,WM_DESTROY,0,0); break;
				case IDM_OPCFG :
					WinExec (szCFL,SW_SHOW); break;
				case IDM_LAUNCH :
					WinExec (szCL,SW_SHOW); break;
				case IDM_SHOW :
					ShowWindow(hwOPW,SW_SHOW); break;
				case IDM_HIDE :
					ShowWindow(hwOPW,SW_HIDE); break;
				case IDM_PAUSE :
					PostMessage(hwOPW,WM_SYSCOMMAND,IDM_PAUSE,-1); break;
				case IDM_PKILL :
					PostMessage(hwOPW,WM_SYSCOMMAND,IDM_PKILL,-1); break;
				case IDM_CLOSE :
					PostMessage(hwOPW,WM_CLOSE,0,0); break;
				}
			return 0;
		}

	return DefWindowProc(hwnd,uMsg,wParam,lParam);
	}


//---------------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
	{
	LPSTR 	lpstr1,lpstr2;
	HWND w;
	MSG  msg;
	WNDCLASSEX wc;
	char szCap[]="OpWiTray",szIco[]="OPWIC";
	g_hinst = hInstance;

	if (w=FindWindow(NULL,szCap)) SendMessage(w,WM_CLOSE,0,0);

	lstrcpy(szTip,szLnc);
	for (lpstr1 = lpCmdLine; *lpstr1 == ' '; lpstr1 = CharNext(lpstr1));
	OPWlaunch = (*lpstr1=='z' || *lpstr1=='Z') ? FALSE : TRUE;
		// build OpWiC & OpConfig commandlines
	GetModuleFileName(NULL,szCL,MAX_PATH);
	for (lpstr1 = szCL; *lpstr1 != '\0'; lpstr1 = CharNext(lpstr1))
		{if (*lpstr1 == '\\') lpstr2 = CharNext(lpstr1);}
	lstrcpy(lpstr2,"OPCONFIG.EXE");
	lstrcpy(szCFL,szCL);
	lstrcpy(lpstr2,"OPWIC.EXE ");
	lstrcat(szCL, lpCmdLine);

	wc.cbSize			=sizeof(wc);
	wc.style			=0;
	wc.lpfnWndProc		=OWTWndProc;
	wc.cbClsExtra		=0;
	wc.cbWndExtra		=0;
	wc.hInstance		=hInstance;
	wc.hIcon			=LoadIcon(hInstance,szIco);
	wc.hCursor			=LoadCursor(NULL,IDC_ARROW);
	wc.hbrBackground	=(HBRUSH)GetStockObject (WHITE_BRUSH);
	wc.lpszMenuName		=NULL;
	wc.lpszClassName	=szCap;
	wc.hIconSm			=LoadIcon(hInstance,szIco);

	RegisterClassEx(&wc);

	w=CreateWindow(szCap,szCap,WS_OVERLAPPEDWINDOW,
					3333,3333,0,0,
					NULL,NULL,hInstance,NULL);
	ShowWindow(w,nCmdShow);
	while(GetMessage(&msg,NULL,0,0))
		{TranslateMessage(&msg); DispatchMessage(&msg);}
	return msg.wParam;
	}

