
(*=========================================================================*)
(*                                                                         *)
(*  Odyssey Script Include File, for scripts which access the Windows API  *)
(*                                                                         *)
(*                                                                         *)
(*  Don Milne, October 1994                                                *)
(*=========================================================================*)

#ifndef WINDOWS_H
#define WINDOWS_H

/* General Windows messages */
CONST WM_NULL          = 0;
      WM_USER          = $0400;
      WM_QUIT          = $0012;
      WM_SETREDRAW     = $000B;
      WM_ENABLE        = $000A;
      WM_SETTEXT       = $000C;
      WM_GETTEXT       = $000D;
      WM_GETTEXTLENGTH = $000E;
      WM_QUERYOPEN     = $0013;
      WM_CLOSE         = $0010;
      WM_KEYDOWN       = $0100;
      WM_KEYUP         = $0101;
      WM_CHAR          = $0102;
      WM_DEADCHAR      = $0103;
      WM_SYSKEYDOWN    = $0104;
      WM_SYSKEYUP      = $0105;
      WM_SYSCHAR       = $0106;
      WM_SYSDEADCHAR   = $0107;
      WM_COMMAND       = $0111;
      WM_SETFONT       = $0030;
      WM_GETFONT       = $0031;


/* Keyboard message range */
CONST WM_KEYFIRST      = $0100;
      WM_KEYLAST       = $0108;

/* Dialog notification messages */
CONST WM_INITDIALOG    = $0110;
      WM_NEXTDLGCTL    = $0028;
      WM_PARENTNOTIFY  = $0210;
      WM_ENTERIDLE     = $0121;

/* Mouse input messages */
CONST WM_MOUSEMOVE     = $0200;
      WM_LBUTTONDOWN   = $0201;
      WM_LBUTTONUP     = $0202;
      WM_LBUTTONDBLCLK = $0203;
      WM_RBUTTONDOWN   = $0204;
      WM_RBUTTONUP     = $0205;
      WM_RBUTTONDBLCLK = $0206;
      WM_MBUTTONDOWN   = $0207;
      WM_MBUTTONUP     = $0208;
      WM_MBUTTONDBLCLK = $0209;

/* Mouse message wParam key states */
CONST MK_LBUTTON       = $0001;
      MK_RBUTTON       = $0002;
      MK_SHIFT         = $0004;
      MK_CONTROL       = $0008;
      MK_MBUTTON       = $0010;

/* Virtual key codes */
#ifdef INCVKEYCODES
CONST VK_LBUTTON       = $01;
      VK_RBUTTON       = $02;
      VK_CANCEL        = $03;
      VK_MBUTTON       = $04;
      VK_BACK          = $08;
      VK_TAB           = $09;
      VK_CLEAR         = $0C;
      VK_RETURN        = $0D;
      VK_SHIFT         = $10;
      VK_CONTROL       = $11;
      VK_MENU          = $12;
      VK_PAUSE         = $13;
      VK_CAPITAL       = $14;
      VK_ESCAPE        = $1B;
      VK_SPACE         = $20;
      VK_PRIOR         = $21;
      VK_NEXT          = $22;
      VK_END           = $23;
      VK_HOME          = $24;
      VK_LEFT          = $25;
      VK_UP            = $26;
      VK_RIGHT         = $27;
      VK_DOWN          = $28;
      VK_SELECT        = $29;
      VK_PRINT         = $2A;
      VK_EXECUTE       = $2B;
      VK_SNAPSHOT      = $2C;
      VK_INSERT        = $2D;
      VK_DELETE        = $2E;
      VK_HELP          = $2F;
      VK_NUMPAD0       = $60;
      VK_NUMPAD1       = $61;
      VK_NUMPAD2       = $62;
      VK_NUMPAD3       = $63;
      VK_NUMPAD4       = $64;
      VK_NUMPAD5       = $65;
      VK_NUMPAD6       = $66;
      VK_NUMPAD7       = $67;
      VK_NUMPAD8       = $68;
      VK_NUMPAD9       = $69;
      VK_MULTIPLY      = $6A;
      VK_ADD           = $6B;
      VK_SEPARATOR     = $6C;
      VK_SUBTRACT      = $6D;
      VK_DECIMAL       = $6E;
      VK_DIVIDE        = $6F;
      VK_F1            = $70;
      VK_F2            = $71;
      VK_F3            = $72;
      VK_F4            = $73;
      VK_F5            = $74;
      VK_F6            = $75;
      VK_F7            = $76;
      VK_F8            = $77;
      VK_F9            = $78;
      VK_F10           = $79;
      VK_F11           = $7A;
      VK_F12           = $7B;
      VK_F13           = $7C;
      VK_F14           = $7D;
      VK_F15           = $7E;
      VK_F16           = $7F;
      VK_F17           = $80;
      VK_F18           = $81;
      VK_F19           = $82;
      VK_F20           = $83;
      VK_F21           = $84;
      VK_F22           = $85;
      VK_F23           = $86;
      VK_F24           = $87;
      VK_NUMLOCK       = $90;
      VK_SCROLL        = $91;

/* VK_A thru VK_Z are the same as their ASCII equivalents: 'A' thru 'Z' */
/* VK_0 thru VK_9 are the same as their ASCII equivalents: '0' thru '0' */

#endif  /* INCVKEYCODES */

/* System Menu messages and wParam Values */
CONST WM_SYSCOMMAND    = $0112;
      SC_MINIMIZE      = $F020;
      SC_MAXIMIZE      = $F030;
      SC_NEXTWINDOW    = $F040;
      SC_PREVWINDOW    = $F050;
      SC_CLOSE         = $F060;
      SC_RESTORE       = $F120;
      SC_TASKLIST      = $F130;
      SC_SCREENSAVE    = $F140;
      SC_HOTKEY        = $F150;


/* MDI messages */
CONST WM_MDICREATE        = $0220;
      WM_MDIDESTROY       = $0221;
      WM_MDIACTIVATE      = $0222;
      WM_MDIRESTORE       = $0223;
      WM_MDINEXT          = $0224;
      WM_MDIMAXIMIZE      = $0225;
      WM_MDITILE          = $0226;
      WM_MDICASCADE       = $0227;
      WM_MDIICONARRANGE   = $0228;
      WM_MDIGETACTIVE     = $0229;
      WM_MDISETMENU       = $0230;
      MDITILE_VERTICAL    = $0000;
      MDITILE_HORIZONTAL  = $0001;
      MDITILE_SKIPDISABLED = $0002;
      WM_CHILDACTIVATE    = $0022;

/* Edit control messages */
CONST EM_GETSEL        = (WM_USER+0);
      EM_SETSEL        = (WM_USER+1);
      EM_GETRECT       = (WM_USER+2);
      EM_SETRECT       = (WM_USER+3);
      EM_SETRECTNP     = (WM_USER+4);
      EM_LINESCROLL    = (WM_USER+6);
      EM_GETMODIFY     = (WM_USER+8);
      EM_SETMODIFY     = (WM_USER+9);
      EM_GETLINECOUNT  = (WM_USER+10);
      EM_LINEINDEX     = (WM_USER+11);
      EM_LINELENGTH    = (WM_USER+17);
      EM_REPLACESEL    = (WM_USER+18);
      EM_GETLINE       = (WM_USER+20);
      EM_LIMITTEXT     = (WM_USER+21);
      EM_CANUNDO       = (WM_USER+22);
      EM_UNDO          = (WM_USER+23);
      EM_FMTLINES      = (WM_USER+24);
      EM_LINEFROMCHAR  = (WM_USER+25);
      EM_SETTABSTOPS   = (WM_USER+27);
      EM_SETPASSWORDCHAR = (WM_USER+28);
      EM_EMPTYUNDOBUFFER = (WM_USER+29);
      EM_GETFIRSTVISIBLELINE = (WM_USER+30);
      EM_SETREADONLY   = (WM_USER+31);
      EM_GETPASSWORDCHAR = (WM_USER+34);
      EN_SETFOCUS      = $0100;
      EN_KILLFOCUS     = $0200;
      EN_CHANGE        = $0300;
      EN_UPDATE        = $0400;
      EN_ERRSPACE      = $0500;
      EN_MAXTEXT       = $0501;
      EN_HSCROLL       = $0601;
      EN_VSCROLL       = $0602;

/* List box messages */
CONST LB_ADDSTRING     = (WM_USER+1);
      LB_INSERTSTRING  = (WM_USER+2);
      LB_DELETESTRING  = (WM_USER+3);
      LB_RESETCONTENT  = (WM_USER+5);
      LB_SETSEL        = (WM_USER+6);
      LB_SETCURSEL     = (WM_USER+7);
      LB_GETSEL        = (WM_USER+8);
      LB_GETCURSEL     = (WM_USER+9);
      LB_GETTEXT       = (WM_USER+10);
      LB_GETTEXTLEN    = (WM_USER+11);
      LB_GETCOUNT      = (WM_USER+12);
      LB_SELECTSTRING  = (WM_USER+13);
      LB_DIR           = (WM_USER+14);
      LB_GETTOPINDEX   = (WM_USER+15);
      LB_FINDSTRING    = (WM_USER+16);
      LB_GETSELCOUNT   = (WM_USER+17);
      LB_GETSELITEMS   = (WM_USER+18);
      LB_SETTABSTOPS   = (WM_USER+19);
      LB_GETHORIZONTALEXTENT = (WM_USER+20);
      LB_SETHORIZONTALEXTENT = (WM_USER+21);
      LB_SETCOLUMNWIDTH = (WM_USER+22);
      LB_SETTOPINDEX   = (WM_USER+24);
      LB_GETITEMRECT   = (WM_USER+25);
      LB_GETITEMDATA   = (WM_USER+26);
      LB_SETITEMDATA   = (WM_USER+27);
      LB_SELITEMRANGE  = (WM_USER+28);
      LB_SETCARETINDEX = (WM_USER+31);
      LB_GETCARETINDEX = (WM_USER+32);
      LB_SETITEMHEIGHT = (WM_USER+33);
      LB_GETITEMHEIGHT = (WM_USER+34);
      LB_FINDSTRINGEXACT = (WM_USER+35);
      LBN_ERRSPACE     = -2;
      LBN_SELCHANGE    = 1;
      LBN_DBLCLK       = 2;
      LBN_SELCANCEL    = 3;
      LBN_SETFOCUS     = 4;
      LBN_KILLFOCUS    = 5;

/* Combo-listbox messages and notification codes */
CONST CB_GETEDITSEL    = (WM_USER+0);
      CB_LIMITTEXT     = (WM_USER+1);
      CB_SETEDITSEL    = (WM_USER+2);
      CB_ADDSTRING     = (WM_USER+3);
      CB_DELETESTRING  = (WM_USER+4);
      CB_DIR           = (WM_USER+5);
      CB_GETCOUNT      = (WM_USER+6);
      CB_GETCURSEL     = (WM_USER+7);
      CB_GETLBTEXT     = (WM_USER+8);
      CB_GETLBTEXTLEN  = (WM_USER+9);
      CB_INSERTSTRING  = (WM_USER+10);
      CB_RESETCONTENT  = (WM_USER+11);
      CB_FINDSTRING    = (WM_USER+12);
      CB_SELECTSTRING  = (WM_USER+13);
      CB_SETCURSEL     = (WM_USER+14);
      CB_SHOWDROPDOWN  = (WM_USER+15);
      CB_GETITEMDATA   = (WM_USER+16);
      CB_SETITEMDATA   = (WM_USER+17);
      CB_GETDROPPEDCONTROLRECT = (WM_USER+18);
      CB_SETITEMHEIGHT = (WM_USER+19);
      CB_GETITEMHEIGHT = (WM_USER+20);
      CB_SETEXTENDEDUI = (WM_USER+21);
      CB_GETEXTENDEDUI = (WM_USER+22);
      CB_GETDROPPEDSTATE = (WM_USER+23);
      CB_FINDSTRINGEXACT = (WM_USER+24);
      CBN_ERRSPACE     = -1;
      CBN_SELCHANGE    = 1;
      CBN_DBLCLK       = 2;
      CBN_SETFOCUS     = 3;
      CBN_KILLFOCUS    = 4;
      CBN_EDITCHANGE   = 5;
      CBN_EDITUPDATE   = 6;
      CBN_DROPDOWN     = 7;
      CBN_CLOSEUP      = 8;
      CBN_SELENDOK     = 9;
      CBN_SELENDCANCEL = 10;


/* DlgDirList, DlgDirListComboBox flags values */
CONST DDL_READWRITE    = $0000;
      DDL_READONLY     = $0001;
      DDL_HIDDEN       = $0002;
      DDL_SYSTEM       = $0004;
      DDL_DIRECTORY    = $0010;
      DDL_ARCHIVE      = $0020;
      DDL_DRIVES       = $4000;
      DDL_EXCLUSIVE    = $8000;

      
/* Standard dialog button IDs */
CONST IDOK             = 1;
      IDCANCEL         = 2;
      IDABORT          = 3;
      IDRETRY          = 4;
      IDIGNORE         = 5;
      IDYES            = 6;
      IDNO             = 7;
      IDHELP           = 998;


/* WinHelp() commands */
CONST HELP_CONTEXT     = $0001;
      HELP_QUIT        = $0002;
      HELP_INDEX       = $0003;
      HELP_CONTENTS    = $0003;
      HELP_HELPONHELP  = $0004;
      HELP_SETINDEX    = $0005;
      HELP_SETCONTENTS = $0005;
      HELP_CONTEXTPOPUP = $0008;
      HELP_FORCEFILE   = $0009;
      HELP_KEY         = $0101;
      HELP_COMMAND     = $0102;
      HELP_PARTIALKEY  = $0105;
      HELP_MULTIKEY    = $0201;
      HELP_SETWINPOS   = $0203;

/* MessageBox() values */
CONST MB_OK               = $0000;
      MB_OKCANCEL         = $0001;
      MB_ABORTRETRYIGNORE = $0002;
      MB_YESNOCANCEL      = $0003;
      MB_YESNO            = $0004;
      MB_RETRYCANCEL      = $0005;
      MB_TYPEMASK         = $000F;
      MB_ICONHAND         = $0010;
      MB_ICONQUESTION     = $0020;
      MB_ICONEXCLAMATION  = $0030;
      MB_ICONASTERISK     = $0040;
      MB_ICONMASK         = $00F0;
      MB_ICONINFORMATION  = MB_ICONASTERISK;
      MB_ICONSTOP         = MB_ICONHAND;
      MB_DEFBUTTON1       = $0000;
      MB_DEFBUTTON2       = $0100;
      MB_DEFBUTTON3       = $0200;
      MB_DEFMASK          = $0F00;


func MAKELONG(lo,hi:Number):Long; begin return Long(hi)*$10000+lo; end;
func LOWORD(x:Long):Number; begin return Number(x); end;
func HIWORD(x:Long):Number; begin return Number(x/$10000); end;

#endif

