#define TITLE "OpWiC"
/* Opera Window Controller
 * by Joe Segur
 * jsegur@westelcom.com   http://www.westelcom.com/users/jsegur/
 *
 * based on OperaMax by Hugh Allen
 * 
 * NO WARRANTIES, standard disclaimers apply
 * You are welcome to use this program for whatever purposes you see fit.
 */

#include <windows.h>
#include <ddeml.h>

/*	some definitions from windows.h for reference
typedef int		    BOOL;
#define FALSE		    0
#define TRUE		    1
#define LOWORD(l)           ((WORD)(DWORD)(l))
#define HIWORD(l)           ((WORD)((((DWORD)(l)) >> 16) & 0xFFFF))
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#define MAKELONG(low, high) ((LONG)(((WORD)(low)) | (((DWORD)((WORD)(high))) << 16)))
*/

/*-------------------------------------------------------------
Program unique stuff
-------------------------------------------------------------*/
#define XFERCLASS "TRANSFER_WINDOW"
#define HLSTCLASS "HOTLIST_DOCKED_OR_MDI"
#define IDM_PAUSE 1
#define IDM_PKILL 20
#define IDM_GCOMP 21
#define MAXCMD 390
#define _MAX_PATH 260	/* as in stdlib.h */
#define MWM_OPWSTAT		(WM_USER+233)
#define MWM_REPLACE		(WM_USER+234)
#define WINPRESENT		0x0100
#define NORMWIN			0x0200
#define POPWIND			0x0400
#define POPBUMP			0x0800

static struct 
	{
	BOOL ignoreMin;
	BOOL minimize;
	BOOL run;
	int  ddetodo;
	BOOL autoquit;

	int  hlst;
	int  hleft;
	int  htop;
	int  hright;
	int  hbot;
	HWND hwH;

	int  xfer;
	int  xleft;
	int  xtop;
	int  xright;
	int  xbot;
	HWND hwX;

	int  wleft;
	int  wtop;
	int  wid;
	int  high;
	int  wmode;

	int  time;
	int  normw;
	int  normh;
	BOOL normno;
	int	 full;
	int  all;

	int  pops;
	int  pdly;
	int  pwid;
	int  phgt;
	int  pnrm;
	int  pkill;

	int  gact;
	int  vis;
	int  list;
	int  sort;
	int  lFpt;
	int  lFwt;
	int  scrolloff;

	} options = {FALSE, FALSE, FALSE, 0, FALSE,
				 0, 0, 0, 250, 1000, 0,
				 0, 0, 0, 1000, 125, 0,
				 500, 0, 300, 0, 0,
				 324, 1000, 1000, FALSE, 0, 0,
				 0, 1, 0, 0, 0, 0,
				 0, 0, 0, 0, 4, 400, 0};

struct wls {
	HWND hwnd;
	WORD wctrl;
	} WL[128];

char	szRun[MAXCMD],szDDE[_MAX_PATH],szCFG[_MAX_PATH],szFace[LF_FACESIZE];
HWND	window,mainw,mdi,hList,oldchild=0;
HMENU	hMenu;
DWORD	idInst,dwGper,dwGsiz,dwGnxt;
HCONV	hConv ;
int		cyCaption,cyBorder,cyHScroll,cyChar,cyMax,cyFrame,cxFrame,
		cxLwid,ddedelay,nNcnt,nLfill=0,cntL=0,paused=0;
BOOL	hasrun=FALSE,depause=TRUE,firstdone=FALSE,firstList=TRUE,
		actflg=TRUE,wasnone=TRUE;normvis;
WORD	wCntW,woldCntW;
RECT	rcMDI,rcSv;
SIZE	sD,sM,sN,sP;
const char *CLASSNAME = "OpWiCWindow";
HINSTANCE hInst;
LOGFONT	lf;
HFONT	hfont,hfontold=0;
WINDOWPLACEMENT place;
FARPROC lpfnEnum1, lpfnEnum2, lpfnEnum3, lpfnOldList, lpfnDdeCallback;
HGLOBAL hgPL;
char FAR *hpt;

/*---------------------------------------------------------------------------------*/
LPSTR NumSet(short *dest, LPSTR str, short nMin, short nMax)
	{
	short nDig, nVal = 0 ;

	nDig = *str - '0' ;
	for (;;)		/* exit in middle of loop */
		{
		if ((unsigned)nDig > 9) break;
		if (nVal<3276)nVal=nVal*10+nDig;
		nDig = *++str - '0' ;
		}
	*dest = max(nMin,min(nVal,nMax));
	return str;
	}

/*---------------------------------------------------------------------------------*/
void OptSet(LPSTR cmd)
	{	// cmd doesn't include the app filename, may be null
	LPSTR	lpstr1;
	char	cEnd;
	short	n;

	while (*cmd)
		{
		AnsiUpperBuff(cmd,1);
		switch (*cmd++) 
			{
			case 'A':
				cmd=NumSet(&options.all, cmd, 0, 3); break;
			case 'D':
				options.ddetodo=ddedelay=1;
				if (*cmd=='-') {options.ddetodo=0; break;}
				if (*cmd>='0' && *cmd<='9') cmd=NumSet(&options.ddetodo, cmd, 0, 4);
				if (!options.ddetodo) break;
				cEnd=' '; if (*cmd=='\"') {cEnd='\"'; cmd++;}
				szDDE[0]='\"';
				for (lpstr1 = cmd+1; *lpstr1>=' '&& *lpstr1!=cEnd; lpstr1 = AnsiNext(lpstr1));
				if (*lpstr1<=' ') lpstr1--;
				hmemcpy(szDDE+1,cmd,lpstr1-cmd+1); szDDE[lpstr1-cmd+2]='\0';
				cmd=lpstr1+1; break;
			case 'F':
				cmd=NumSet(&options.full,cmd,0,10); break;
			case 'G':
				if (*cmd=='*') {options.gact=-1; cmd++;}
				else cmd=NumSet(&options.gact,cmd,0,1440); if (!options.gact) break;
				if (options.gact>0)
					{dwGper=options.gact*60000;dwGnxt=GetTickCount()+(dwGper>>1);}
				n=0;
				if (*cmd==',') cmd=NumSet(&n, ++cmd, 0, 2047);
				if (!n) dwGsiz=14680064; else dwGsiz=1048576*n;
				break;
			case 'H':
				if (*cmd=='-') {options.hlst=0; break;}
				options.hlst=1;
				cmd=NumSet(&options.hleft, cmd, 0, 900);
				if (*cmd==',') cmd=NumSet(&options.htop, ++cmd, 0, 950);
				if (*cmd==',') cmd=NumSet(&options.hright, ++cmd, 100, 1000);
				if (*cmd==',') cmd=NumSet(&options.hbot, ++cmd, 50, 1000);
				if (*cmd==',') cmd=NumSet(&options.hlst, ++cmd, 1, 3);
				options.hright=max(options.hleft+100,options.hright);
				options.hbot=max(options.htop+50,options.hbot); break;
			case 'I':
				if (*cmd=='-') {options.ignoreMin=FALSE; break;}
				options.ignoreMin = TRUE; break;
			case 'L':
				cmd=NumSet(&options.list, cmd, 0, 20); cntL=options.list;
				if (*cmd==',') cmd=NumSet(&options.sort, ++cmd, 0, 5);
				if (*cmd==',') 
					{
					cmd++;
					for (lpstr1 = cmd; *lpstr1!=',' && *lpstr1>=' '; lpstr1 = AnsiNext(lpstr1));
					hmemcpy(szFace,cmd,min(LF_FACESIZE-1,lpstr1-cmd));
					cmd=lpstr1;
					}
				if (*cmd==',') cmd=NumSet(&options.lFpt, ++cmd, 4, 30);
				if (*cmd==',') cmd=NumSet(&options.lFwt, ++cmd, 100, 900);
				break;
			case 'M':
				if (*cmd=='-') {options.minimize=FALSE; break;}
				options.minimize = TRUE; break;
			case 'N':
				if (*cmd=='-') {options.normno=TRUE; break;}
				options.normno=FALSE; cmd=NumSet(&options.normw, cmd, 100, 1100);
				if (*cmd==',') cmd=NumSet(&options.normh, ++cmd, 10, 1100);
				break;
			case 'P':
				cmd=NumSet(&options.pops, cmd, 0, 4);
				if (*cmd==',') cmd=NumSet(&options.pdly, ++cmd, 0, 50);
				options.pdly++;
				if (*cmd==',') cmd=NumSet(&options.pwid, ++cmd, 0, 5000);
				if (*cmd==',') cmd=NumSet(&options.phgt, ++cmd, 0, 5000);
				if (*cmd==',') cmd=NumSet(&options.pnrm, ++cmd, 0, 20);
				break;
			case 'Q':
				if (*cmd=='-') {options.autoquit=FALSE; break;}
				options.autoquit=TRUE; break;
			case 'R':
				if (*cmd=='-') options.run=FALSE;
				else
					{
					options.run = TRUE; if (*cmd==' ') ++cmd;
					for (lpstr1 = cmd; *lpstr1 != '\0'; lpstr1 = AnsiNext(lpstr1))
						if (*lpstr1 < ' ') {*lpstr1 = '\0'; break;}
					if (lstrlen(cmd)>MAXCMD) *(cmd+MAXCMD)='\0';
					lstrcpy(szRun,cmd);
					}
				*cmd=0; break;
			case 'S':
				cmd=NumSet(&options.scrolloff, cmd, 0, 4);
				break;
			case 'T':
				cmd=NumSet(&options.time, cmd, 1, 59);
				options.time*=54; break;
			case 'V':
				cmd=NumSet(&options.vis, cmd, 0, 4); break;
			case 'W':
				cmd=NumSet(&options.wleft, cmd, 0, 900);
				if (*cmd==',') cmd=NumSet(&options.wtop, ++cmd, 0, 980);
				if (*cmd==',') cmd=NumSet(&options.wid, ++cmd, 100, 1000);
				options.wleft=min(options.wleft,1000-options.wid);
				if (*cmd==',') cmd=NumSet(&options.high, ++cmd, 0, 1000);
				if (options.high && options.high<33) 
					{options.wmode=options.high;options.high=0;}
				else {options.wmode=0; options.wtop=min(options.wtop,980-options.high);}
				break;
			case 'X':
				if (*cmd=='-') {options.xfer=0; break;}
				options.xfer=1;
				cmd=NumSet(&options.xleft, cmd, 0, 900);
				if (*cmd==',') cmd=NumSet(&options.xtop, ++cmd, 0, 950);
				if (*cmd==',') cmd=NumSet(&options.xright, ++cmd, 100, 1000);
				if (*cmd==',') cmd=NumSet(&options.xbot, ++cmd, 50, 1000);
				if (*cmd==',') cmd=NumSet(&options.xfer, ++cmd, 1, 3);
				options.xright=max(options.xleft+100,options.xright);
				options.xbot=max(options.xtop+50,options.xbot); break;
			}	
		}
	}

/*---------------------------------------------------------------------------------*/
void CfgRead(void)
	{
	HFILE	hfCfg;
	HGLOBAL hg;
	DWORD	dwL;
	UINT	uR;
	LPSTR	cmds,lpstr1,lpstr2;

	#define CHUNK 1019
	GetModuleFileName(hInst,szCFG,_MAX_PATH);
	for (lpstr1 = szCFG; *lpstr1 != '\0'; lpstr1 = AnsiNext(lpstr1))
		{if (*lpstr1 == '\\') lpstr2 = AnsiNext(lpstr1);}
	lstrcpy(lpstr2,"OPWIC.CFG");
	if (HFILE_ERROR!=(hfCfg=_lopen(szCFG,READ)))
		{
		dwL=CHUNK;
		hg=GlobalAlloc(GPTR, dwL);
		cmds=(LPSTR)GlobalLock(hg);
		do	{
			if ((uR=_lread(hfCfg, (char __huge *)(cmds+dwL-CHUNK), CHUNK))<CHUNK
				|| uR==HFILE_ERROR) break;
			dwL+=CHUNK;
			hg=GlobalReAlloc(hg,dwL,GPTR);
			} while (dwL<65000-CHUNK);
		_lclose(hfCfg);
		OptSet(cmds);
		GlobalUnlock(hg);
		GlobalFree(hg);
		}
	}
/*---------------------------------------------------------------------------------*/
void setmessage(int n)
	{
	static int current=-1;

	if (n==current) return;
	switch(current=n) 
		{
		case 1:
			SetWindowText(window,TITLE" active");
			break;
		case 2:
			SetWindowText(window,TITLE": Can't find Opera");
			break;
		case 3:
			SetWindowText(window,TITLE": Can't find MDI client");
			break;
		case 4:
			SetWindowText(window,TITLE" paused (rightbutton)");
			break;
		case 5:
			SetWindowText(window,TITLE": running command...");
			break;
		}
	}
/*---------------------------------------------------------------------------------*/
BOOL NotN(LPRECT crc)
	{
	if (crc->right-crc->left!=sN.cx
		|| crc->bottom-crc->top!=sN.cy
		|| crc->left<rcMDI.left
		|| crc->top<rcMDI.top
		|| (options.normw<1001 && crc->right>rcMDI.right)
		|| (options.normh<1001 && crc->bottom>rcMDI.bottom)) return TRUE;
	return FALSE;
	}
/*---------------------------------------------------------------------------------*/
void SetNback(HWND child)
	{
	int i;

	if (!options.normno)
		{
		GetWindowPlacement (child, &place);
		if (NotN(&place.rcNormalPosition))
			{
			if (options.normw<1001) place.rcNormalPosition.left=max(place.rcNormalPosition.left,rcMDI.left);
			place.rcNormalPosition.right=place.rcNormalPosition.left+sD.cx;
			if ((i=place.rcNormalPosition.right-rcMDI.right)>0 && options.normw<1001)
				{place.rcNormalPosition.left-=i; place.rcNormalPosition.right-=i;}
			place.rcNormalPosition.top=max(place.rcNormalPosition.top,rcMDI.top);
			place.rcNormalPosition.bottom=place.rcNormalPosition.top+sD.cy;
			if ((i=place.rcNormalPosition.bottom-rcMDI.bottom)>0 && options.normh<1001)
				{place.rcNormalPosition.top-=i; place.rcNormalPosition.bottom-=i;}
			place.showCmd = SW_SHOWNA;
			SetWindowPlacement(child,&place);
			}
		}
	}
/*---------------------------------------------------------------------------------*/
HDDEDATA FAR PASCAL	_export DdeCallback	(UINT iType, UINT iFmt, HCONV	hConv,
								 HSZ	hsz1, HSZ	hsz2, HDDEDATA	hData,
								 DWORD dwData1, DWORD dwData2)
	{
	switch (iType)
		{
		case XTYP_DISCONNECT :
			hConv = NULL ;
			return NULL ;
		}
	return NULL ;
	}
/*---------------------------------------------------------------------------------*/
WORD popAdj(int iL)
	{
	HWND hmC;
	char szName[30];
	RECT rc1,rc2;
	int  n;

	if (options.pops>2 && options.pkill)
		{PostMessage(WL[iL].hwnd,WM_CLOSE,0,0L); return 0;}

	if (!(WL[iL].wctrl&POPBUMP) && (options.pops==2 || options.pops==4))
		{
		hmC=GetWindow(WL[iL].hwnd,GW_CHILD);
		while (hmC)
			{
			GetClassName(hmC,szName,29); if (!(lstrcmp(szName,"BLD_MDICHILD"))) break;
			hmC=GetWindow(hmC,GW_HWNDNEXT);
			}
		if (hmC)
			{
			WL[iL].wctrl|=POPBUMP;
			n=((GetWindowLong(hmC,GWL_STYLE)&WS_VSCROLL) ? cyHScroll : 0);
			GetWindowRect(WL[iL].hwnd,&rc1); GetWindowRect(hmC,&rc2);
			sD.cx=((rc1.right-rc1.left+cxFrame)<<1)-(rc2.right-rc2.left)+n;
			sD.cy=((rc1.bottom-rc1.top+cyFrame)<<1)-(rc2.bottom-rc2.top)+n;
			return (options.pops);
			}
		}
	return 0;
	}
/*---------------------------------------------------------------------------------*/
void WinAdjust(HWND child)
	{
    RECT crect;
    SIZE sR;
    char szTmp[31] ;
    int i;
    WORD winflgs=0;
    static WORD oldflgs;
	POINT ul;

	if (options.ignoreMin && IsIconic(child)) return;
	GetClassName(child,szTmp,30);

	if (options.hlst && !(lstrcmp(HLSTCLASS,szTmp)))
		{
		options.hwH=child;
		ul.x=rcMDI.left+MulDiv(sM.cx,options.hleft,1000);
		ul.y=rcMDI.top+MulDiv(sM.cy,options.htop,1000);
		sD.cx=MulDiv(sM.cx,options.hright,1000)-ul.x;
		sD.cy=MulDiv(sM.cy,options.hbot,1000)-ul.y;
		winflgs|=16;
		}
	if (options.xfer && !(lstrcmp(XFERCLASS,szTmp)))
		{
		options.hwX=child;
		ul.x=rcMDI.left+MulDiv(sM.cx,options.xleft,1000);
		ul.y=rcMDI.top+MulDiv(sM.cy,options.xtop,1000);
		sD.cx=MulDiv(sM.cx,options.xright,1000)-ul.x;
		sD.cy=MulDiv(sM.cy,options.xbot,1000)-ul.y;
		winflgs|=32;
		}
	if (!winflgs)
		{
		sD.cx=sN.cx; sD.cy=sN.cy;

		if (options.pops && nLfill<128)
			{
			for (i=0;i<nLfill;i++) {if (WL[i].hwnd==child) break;}
			if (i==nLfill) {oldchild=0; return;}
			if (WL[i].wctrl&POPWIND) return;
			if (IsZoomed(child) && ((int)(WL[i].wctrl&0x00FF)<options.pdly))
					WL[i].wctrl|=NORMWIN;
			if (!(WL[i].wctrl&NORMWIN))
				{
				GetWindowPlacement (child, &place);
				sR.cx=place.rcNormalPosition.right-place.rcNormalPosition.left;
				sR.cy=place.rcNormalPosition.bottom-place.rcNormalPosition.top;
				if ((sR.cx!=sP.cx && sR.cx!=(sP.cx+1))
					|| (sR.cy!=sP.cy && sR.cy!=(sP.cy+1)))
					{
					WL[i].wctrl|=POPWIND;
					if (!(winflgs=popAdj(i))) return;
					}
				else 
					{
					if ((int)(WL[i].wctrl&0x00FF)==options.pdly)
					 	{WL[i].wctrl|=NORMWIN;}
					else {oldchild=0; return;}
					}
				}
			}
		}
	if (options.full>=7 && options.full<=10)
		{
		if (((options.full==10 && !winflgs) || (options.full<10 && woldCntW!=wCntW))
			&& wCntW==1 && !IsZoomed(child) 
			&& (!(IsIconic(child) && options.ignoreMin)))
				{SetNback(child);SendMessage(mdi,WM_MDIMAXIMIZE,(WPARAM)child,0); return;}
		if ((options.full==8 || options.full==9) && woldCntW!=wCntW && wCntW>1
			&& !(GetAsyncKeyState(VK_SHIFT)<0 && GetAsyncKeyState(VK_CONTROL)<0)
			&& (!(IsIconic(child) && options.ignoreMin)))
				SendMessage(mdi,WM_MDITILE,
					(options.full==8 ? MDITILE_HORIZONTAL : MDITILE_VERTICAL),0);
		if (!winflgs || ((options.full==8 || options.full==9) && options.all>1)) return;
		}
	if (options.full && !winflgs)
		{
		if (options.full>2 || options.all==3)
			SetNback(child);
		if (child==oldchild
			&& (((options.full & 1) && !firstdone) || !(options.full & 1))
			&& (!(IsIconic(child) && options.ignoreMin)))
			{
			if (!IsZoomed(child) && (options.full<5 || options.normno))
				PostMessage(mdi,WM_MDIMAXIMIZE,(WPARAM)child,0);
			if ((options.full==5 || options.full==6) && !options.normno)
				PostMessage(mdi,WM_MDIRESTORE,(WPARAM)child,0);
			}
		return;
		}
	else
		{
		if (options.normno && !winflgs) return;
		GetWindowPlacement (child, &place);
		switch(place.showCmd) 
			{
			case SW_SHOWNORMAL:	
				GetWindowRect(child,&crect);
				MapWindowPoints(NULL, mdi, (POINT *)&crect, 2);
				if (winflgs>15)
					{
					if (crect.left==ul.x && crect.top==ul.y)
						{
						if (winflgs&16 && options.hlst==2 && crect.bottom-crect.top==sD.cy) break;
						if (winflgs&32 && options.xfer==2 && crect.right-crect.left==sD.cx) break;
						if (crect.right-crect.left==sD.cx && crect.bottom-crect.top==sD.cy) break;
						}
					crect.left=ul.x; crect.top=ul.y;
					}
				else if (!winflgs)
					{
					if (!NotN(&crect)) break;
					if (options.normw<1001) crect.left=max(crect.left,rcMDI.left);
					if ((i=crect.left+sD.cx-rcMDI.right)>0 && options.normw<1001) crect.left-=i;
					if ((i=crect.top+sD.cy-rcMDI.bottom)>0 && options.normh<1001) crect.top-=i;
					}
				SetWindowPos(child, 0, crect.left, crect.top,
					sD.cx, sD.cy, // width & height not right & bottom
					SWP_NOZORDER | SWP_NOACTIVATE);
				break;
	
			case SW_SHOWMINIMIZED:
				if (options.ignoreMin) break;
			case SW_SHOWMAXIMIZED:
				if (options.all==3 && place.showCmd==SW_SHOWMAXIMIZED && options.full!=10)
					break;
				place.flags &= ~WPF_RESTORETOMAXIMIZED;
				if (winflgs>15)
					{
					place.rcNormalPosition.left=ul.x;
					place.rcNormalPosition.top=ul.y;
					}
				place.rcNormalPosition.right=place.rcNormalPosition.left+sD.cx;
				if ((i=place.rcNormalPosition.right-rcMDI.right)>0 && options.normw<1001)
					{place.rcNormalPosition.left-=i; place.rcNormalPosition.right-=i;}
				place.rcNormalPosition.bottom=place.rcNormalPosition.top+sD.cy;
				if ((i=place.rcNormalPosition.bottom-rcMDI.bottom)>0 && options.normh<1001)
					{place.rcNormalPosition.top-=i; place.rcNormalPosition.bottom-=i;}
				place.rcNormalPosition.top=max(0,place.rcNormalPosition.top); // opera 3.21 won't let the window be placed above 0
				place.showCmd = SW_SHOWNOACTIVATE;
				SetWindowPlacement(child,&place);
				break;
			}
		}
	}

/*---------------------------------------------------------------------------------*/
BOOL FAR PASCAL _export OPMEnumProc (HWND hwnd, LONG lParam)
	{
	char	szTemp[90] ;
	int		nI,nL,nU;
	long 	dw1;
	
	if (GetParent (hwnd) == mdi)         // check for document
		{
		if (lParam & 1)
			{
			HDC hdc;
			SIZE size;

			GetWindowText(hwnd,szTemp,75);
			if (lstrlen(szTemp)>70) lstrcpy(szTemp+68,"..");
			hdc=GetDC(hList);
			if (hfontold) SelectObject(hdc,hfont);
			GetTextExtentPoint(hdc,szTemp,lstrlen(szTemp),&size);
			ReleaseDC(hList, hdc);
			cxLwid=max(cxLwid,size.cx);
			if (lParam & 4)
				{
				if (LB_ERR!=(dw1=SendMessage(hList,LB_GETCOUNT,0,0L)))
					{				
					nU=LOWORD(dw1);
					nL=0;
					while (nU>nL)
						{
						nI=(nU+nL)>>1;
						if ((HWND)SendMessage(hList,LB_GETITEMDATA,nI,0L)<hwnd) nL=nI+1;
						else nU=nI;
						}
					SendMessage(hList,LB_INSERTSTRING,nU,(LPARAM)(LPSTR)szTemp);
					SendMessage(hList,LB_SETITEMDATA,nU,MAKELONG(hwnd, 0));
					}
				}
			else
				{
				dw1=SendMessage(hList,LB_ADDSTRING,0,(LPARAM)(LPSTR)szTemp);
				SendMessage(hList,LB_SETITEMDATA,LOWORD(dw1),MAKELONG(hwnd, 0));
				}
			}
		if (lParam & 2) WinAdjust(hwnd);
		}
	return 1 ;
	}

/*---------------------------------------------------------------------------------*/
BOOL FAR PASCAL _export CntEnumProc (HWND hwnd, LONG lParam)
	{
	char szTmp[31];

   	GetClassName(hwnd,szTmp,30) ;
	if (GetParent (hwnd) == mdi && !(IsIconic(hwnd) && options.ignoreMin)
		&& !(options.full == 10
			&& ((options.xfer && !(lstrcmp(XFERCLASS,szTmp)))
			|| (options.hlst && !(lstrcmp(HLSTCLASS,szTmp))))))
		wCntW++;
	return 1 ;
	}
/*---------------------------------------------------------------------------------*/
BOOL FAR PASCAL _export PLEnumProc (HWND hwnd, LONG lParam)
	{
	int nI,nL,nU;
	
	if (GetParent (hwnd) == mdi)
		{
		nL=nI=0;
		if ((nU=nLfill-1)>-1)
			{
			while (nU>=nL)
				{
				nI=(nU+nL)>>1; if (WL[nI].hwnd==hwnd) {nU=nI; nL=nI; break;}
				if (WL[nI].hwnd<hwnd) nL=nI+1; else nU=nI-1;
				}
			if (nU!=nL)
				{
				nU=++nLfill;
				while (nU>nL) {WL[nU]=WL[nU-1]; nU--;}
				if (nNcnt) {WL[nL].wctrl=NORMWIN; nNcnt--;}
				else WL[nL].wctrl=0;
				}
			}
		else {nLfill=1; WL[0].wctrl=0;if (nNcnt) {WL[nL].wctrl=NORMWIN; nNcnt--;}}
		WL[nL].hwnd=hwnd; WL[nL].wctrl|=WINPRESENT;
		if ((int)(WL[nL].wctrl&0x007F)<options.pdly) WL[nL].wctrl++;
		}
	if (nLfill>127) return 0;
	return 1;
	}
/*---------------------------------------------------------------------------------*/
void trimL(void)
	{
	int i;

	for (i=0;i<nLfill;)
		{
		if (WL[i].wctrl&WINPRESENT) i++;
		else
			{
			hmemcpy(&WL[i],&WL[i+1],(nLfill-i)*sizeof(WL[0]));
			nLfill--; WL[nLfill].hwnd=0; WL[nLfill].wctrl=0;
			}
		}
	}
/*---------------------------------------------------------------------------------*/
void DoDDEOpen(void)
	{
	HSZ hszService,hszTopic,hszItem;

	if (DdeInitialize (&idInst, (PFNCALLBACK) lpfnDdeCallback,
				    APPCLASS_STANDARD | APPCMD_CLIENTONLY, 0L)) return;

	hszService = DdeCreateStringHandle (idInst,"Opera",0);
	hszTopic = DdeCreateStringHandle (idInst,"WWW_OpenURL",0);
	hszItem = DdeCreateStringHandle (idInst,szDDE,0);

	if (NULL!=(hConv=DdeConnect(idInst,hszService,hszTopic,NULL)))
		{
		DdeClientTransaction (NULL,0,hConv,hszItem,CF_TEXT,
						  							XTYP_REQUEST,1000,NULL);
		DdeDisconnect(hConv);
		}

	if (options.ddetodo==1 || options.ddetodo==2)
		{
		DdeFreeStringHandle	(idInst, hszTopic) ;
		DdeFreeStringHandle	(idInst, hszItem) ;
		hszTopic = DdeCreateStringHandle (idInst,"WWW_Activate",0);
		hszItem = DdeCreateStringHandle (idInst,"0xFFFFFFFF,0x0",0);
	
		if (NULL!=(hConv=DdeConnect(idInst,hszService,hszTopic,NULL)))
			{
			DdeClientTransaction (NULL,0,hConv,hszItem,CF_TEXT,
							  							XTYP_REQUEST,1000,NULL);
			DdeDisconnect(hConv);
			}
		}

	DdeFreeStringHandle	(idInst, hszService) ;
	DdeFreeStringHandle	(idInst, hszTopic) ;
	DdeFreeStringHandle	(idInst, hszItem) ;

	DdeUninitialize (idInst);
	}
/*---------------------------------------------------------------------------------*/
void DoScrolloff(HWND hwnd)
	{
	static int nOVMx=0,nD=0;
	HWND  hmC,hDlg,hmCB=0;
	RECT rc;
	int nHMx,nHMn,nVMx,nVMn;
	char szName[30];

	hmC=GetWindow(hwnd,GW_CHILD);
	while (hmC)
		{
		GetClassName(hmC,szName,29); if (!(lstrcmp(szName,"BLD_MDICHILD"))) break;
		hmC=GetWindow(hmC,GW_HWNDNEXT);
		}
	if (!hmC) return;
	GetScrollRange(hmC,SB_HORZ,&nHMn,&nHMx);
	if (!nHMx) return;
	hDlg=GetWindow(hwnd,GW_CHILD);
	while (hDlg)
		{
		GetClassName(hDlg,szName,29);                                   
		if (!(lstrcmp(szName,"#32770"))) break;
		hDlg=GetWindow(hDlg,GW_HWNDNEXT);
		}
	if (hDlg)
		{
		hmCB=GetWindow(hDlg,GW_CHILD);
		while (hmCB)
			{
			GetClassName(hmCB,szName,29); if (!(lstrcmp(szName,"ComboBox"))) break;
			hmCB=GetWindow(hmCB,GW_HWNDNEXT);
			}
		}
	if (hmCB && !(GetWindowLong(hmCB,GWL_STYLE)&WS_VISIBLE)) {nD=max(1,330/options.time); return;}
	GetScrollRange(hmC,SB_VERT,&nVMn,&nVMx);
	if (nVMx!=nOVMx) {nOVMx=nVMx; nD=max(1,330/options.time); return;}
	if (nD) {nD--; return;}
	if (options.scrolloff>2)
		{if (nHMx>1) return;}
	else {GetWindowRect(hmC,&rc); if (nHMx>(rc.right-rc.left)) return;}
	SetScrollRange(hmC,SB_HORZ,0,0,TRUE);
	PostMessage(hmC,WM_VSCROLL,SB_THUMBPOSITION,MAKELPARAM(GetScrollPos(hmC,SB_VERT),0));
	}
/*---------------------------------------------------------------------------------*/
void SetHeight(void)
	{
	LRESULT lC=SendMessage(hList,LB_GETCOUNT,0,0L);

	rcSv.bottom=min(cyMax+cyCaption,rcSv.top+(int)lC*cyChar+cyHScroll+cyCaption+2*cyFrame);
	}
/*---------------------------------------------------------------------------------*/
void DoOnTime(void)
	{
    long lActive,lSel;
    UINT uT;
    DWORD dwS;
    int iH;
    WORD w;
    char szTmp[31] ;
	HWND child,hwSel;
	static HWND child2=0;
	LPARAM lP=0;

	if ((options.gact>0) && ((dwS=(0x7FFFFFFF&GetTickCount()))>=dwGnxt || dwS<dwGper))
		{dwGnxt=dwS+dwGper; if (!paused) dwS=GlobalCompact(dwGsiz);}

	if (paused && !(options.list)) return;
	mainw=FindWindow("BLDOPERA", NULL);
	if (!mainw) 
		{
		firstdone=FALSE; wasnone=TRUE; nLfill=0;
		if (hasrun) 
			{
			if (options.list) PostMessage(hList,LB_RESETCONTENT,0,0);
			if (options.autoquit && !paused)
				PostMessage(window,WM_CLOSE,0,0);
			}
		else if (options.run) 
			{
			options.run=FALSE;
			setmessage(5);
			if ((w=WinExec(szRun,SW_SHOWNORMAL)) < 32)
				MessageBox (0,szRun,TITLE": can't execute",MB_ICONINFORMATION);
			return;
			}
		if (options.ddetodo) ddedelay=max(1,1944/options.time);
		if (!paused) setmessage(2);
		return;
		}                                                             
		
	else hasrun=TRUE;

	if (wasnone) {nNcnt=options.pnrm; wasnone=FALSE;}

	if (options.ddetodo)
		if (!--ddedelay) {DoDDEOpen(); options.ddetodo=0; firstList=FALSE;}
    mdi = GetWindow(mainw, GW_CHILD);
    while (mdi)
    	{
    	GetClassName(mdi,szTmp,10) ;
    	if (!lstrcmp(szTmp,"MDIClient")) break ;
    	mdi = GetWindow(mdi, GW_HWNDNEXT) ;
    	}
	if (!mdi)
		{
		if (!paused)setmessage(3);
		if (options.list) PostMessage(hList,LB_RESETCONTENT,0,0);
		firstdone=FALSE;
		return;
		}
    GetClientRect(mdi, &rcMDI);
    if (options.pops)
    	{    
    	sP.cx=options.pwid; sP.cy=options.phgt;
		iH=((rcMDI.bottom-rcMDI.top)/3)/(cyCaption+cyFrame-2);
		if (!sP.cx) sP.cx=rcMDI.right-rcMDI.left-(iH*(cyCaption+cyFrame-2));
		if (!sP.cy) sP.cy=rcMDI.bottom-rcMDI.top-(iH*(cyCaption+cyFrame-2));
    	for (iH=0; iH<nLfill; iH++) WL[iH].wctrl&= ~WINPRESENT;
		EnumChildWindows (mdi, lpfnEnum3, 0); trimL();
    	}
	rcMDI.left-=cxFrame;
	rcMDI.right+=cxFrame;
	rcMDI.bottom+=cyFrame;

	lActive = SendMessage(mdi, WM_MDIGETACTIVE, 0, 0L);
	child = (HWND)LOWORD(lActive);
	GetClassName(child,szTmp,30) ;

	if (!paused)
		{
		setmessage(1);

		if (sM.cx!=rcMDI.right-rcMDI.left || sM.cy!=rcMDI.bottom-rcMDI.top) 
			{oldchild=0; wCntW=0;}
		sM.cx=rcMDI.right-rcMDI.left; sM.cy=rcMDI.bottom-rcMDI.top;
		sN.cx=MulDiv(sM.cx,options.normw,1000);
		sN.cy=max(MulDiv(sM.cy,options.normh,1000),cyCaption);
		if (options.full==5 || options.full==6) sN.cy+=(cyCaption-cyBorder+cyFrame);
		if (options.all>=2 || (options.all==1 && depause)) lP|=2;
		if (options.full>=7 && options.full<=10)
			{
			woldCntW=wCntW; wCntW=0;
			EnumChildWindows (mdi, lpfnEnum2, 0);
			if (lP && (options.all<3 || !IsZoomed(child))) woldCntW=0;
			if (woldCntW!=wCntW) oldchild=0;
			lP=0;
			}
		if ((IsWindow(child))
			&& (GetWindowLong(child, GWL_STYLE) & WS_THICKFRAME))
			{
			if (child!=oldchild)
				{oldchild=child; WinAdjust(child); firstdone=TRUE;}
			if (options.scrolloff==2 || options.scrolloff==4 
				|| (options.scrolloff&1 && IsZoomed(child))) DoScrolloff(child);
			}
		else firstdone=FALSE;

		if (options.hlst>1 && IsWindow(options.hwH)) WinAdjust(options.hwH);
		if (options.xfer>1 && IsWindow(options.hwX)) WinAdjust(options.hwX);
		}
	if (++cntL>=options.list && options.list && !IsIconic(window) && IsWindowVisible(window))
		{
		lP|=1; if (options.sort==2 || options.sort==5) lP|=4;
		uT=(UINT)SendMessage(hList,LB_GETTOPINDEX,0,0);
		lSel=SendMessage(hList,LB_GETCURSEL,0,0);
		hwSel=child;
		if (lSel!=LB_ERR)
			hwSel=(HWND)LOWORD(SendMessage(hList,LB_GETITEMDATA,LOWORD(lSel),0));
		iH=GetScrollPos(hList, SB_HORZ);
		SendMessage(hList,WM_SETREDRAW,FALSE,0);
		SendMessage(hList,LB_RESETCONTENT,0,0);
		}
	if (lP)
		{
		cxLwid=0;
		EnumChildWindows (mdi, lpfnEnum1, lP);
		if (lP&1)
			{
			long l1,l2;

			if ((l2=SendMessage(hList,LB_GETCOUNT,0,0L)) > 0)
				{
				lSel=max(0, min(lSel,l2-1));
				if (options.sort>2 && (child!=child2 ||
					hwSel!=(HWND)LOWORD(SendMessage(hList,LB_GETITEMDATA,LOWORD(lSel),0))))
					{
					child2=child;
					for (l1=0; l1<l2; l1++)
						{
						if (child==(HWND)LOWORD(SendMessage(hList,LB_GETITEMDATA,LOWORD(l1),0)))
							break;
						}
					if (l1<l2)
						{
						SendMessage(hList,LB_SETCURSEL,LOWORD(l1),0);
						SendMessage(hList,LB_SETTOPINDEX,LOWORD(l1),0);
						}
					}
				else
					{
					SendMessage(hList,LB_SETCURSEL,LOWORD(lSel),0);
					uT=min(uT,LOWORD(lSel));
					SendMessage(hList,LB_SETTOPINDEX,uT,0);
					}
				}
			SendMessage(hList,LB_SETHORIZONTALEXTENT,cxLwid+cxFrame,0);
			iH=min(iH,cxLwid);
			SendMessage(hList,WM_HSCROLL,SB_THUMBTRACK,MAKELPARAM(iH,0));
			SendMessage(hList,WM_SETREDRAW,TRUE,0);
			if (firstList && !options.ddetodo)
				{
				GetWindowRect(window,&rcSv);
				if (options.wmode && options.wmode-1 & 1 ) SetHeight();
				MoveWindow(window,rcSv.left,rcSv.top,rcSv.right-rcSv.left,
														rcSv.bottom-rcSv.top,TRUE);
				if (hList)
					{
					SetFocus(hList);
					MoveWindow(hList,cxFrame,0,rcSv.right-rcSv.left-3*cxFrame,
									rcSv.bottom-rcSv.top-cyCaption-2*cyFrame,TRUE);
					}
				}
			firstList=FALSE;
			}
		}
	if (cntL>=options.list) cntL=0;
	if (IsIconic(window) || !IsWindowVisible(window)) cntL=options.list;
	depause=FALSE;
	}

/*---------------------------------------------------------------------------------*/
long FAR PASCAL _export ListProc (HWND hwnd, UINT message, UINT wParam,
                                                           LONG lParam)
	{
	switch (message)
		{
		case WM_KEYDOWN :
			if (wParam!=VK_RETURN) break;
			// else fall into
		case WM_LBUTTONUP :
			SendMessage (GetParent(hwnd),WM_COMMAND,1,MAKELONG(hwnd,LBN_DBLCLK)) ;
		}
	return CallWindowProc (lpfnOldList, hwnd, message, wParam, lParam) ;
	}

/*---------------------------------------------------------------------------------*/
LRESULT __export CALLBACK OpWiCWndProc(
    HWND hwnd,
    UINT uMsg,
    WPARAM wParam,
    LPARAM lParam)
	{
	HWND hw;
	MINMAXINFO FAR* lpmmi;

    switch (uMsg) 
    	{ 
        case WM_CREATE: 
            return 0; 
        case MWM_REPLACE: 
			if (NULL!=(hpt=GlobalLock((HGLOBAL)lParam)))
				{
				hmemcpy(hpt,&nLfill,sizeof(nLfill));
				hmemcpy(hpt+sizeof(nLfill),WL,sizeof(WL));
				GlobalUnlock((HGLOBAL)lParam);
				}
			// fall into
        case WM_CLOSE: 
            DestroyWindow(hwnd) ;
            UnregisterClass(CLASSNAME,hInst);
            return 0; 
        case WM_DESTROY: 
			PostQuitMessage(0);
            return 0; 
		case WM_GETMINMAXINFO:
			lpmmi = (MINMAXINFO FAR*) lParam;
			lpmmi->ptMaxSize.x-=10; lpmmi->ptMaxSize.y-=10;
			lpmmi->ptMaxPosition.x+=5; lpmmi->ptMaxPosition.y+=5;
			break;
		case WM_SIZE :
			if (hList)
				{
				if (wParam==SIZE_RESTORED && !rcSv.right) GetWindowRect(window,&rcSv);
				if (wParam!=SIZE_MINIMIZED)
					MoveWindow(hList,cxFrame,0,LOWORD(lParam)-cxFrame,HIWORD(lParam),TRUE);
				}
			return 0;
		case WM_ACTIVATE :
			if (HIWORD(lParam)) firstList=TRUE;
			break;
		case WM_NCACTIVATE :
			if (options.wmode && hList)
				{
				if (wParam)
					{
					if (options.wmode-1 & 1) SetHeight();
					actflg=TRUE;
					MoveWindow(window,rcSv.left,rcSv.top,rcSv.right-rcSv.left,
																rcSv.bottom-rcSv.top,TRUE);
					}
				else
					{
					if (actflg) GetWindowRect(window,&rcSv);
					actflg=FALSE;
					MoveWindow(window,rcSv.left,rcSv.top,rcSv.right-rcSv.left,
																		cyCaption,TRUE);
					}
				}
			break;
		case WM_SETFOCUS :
			if (hList) SetFocus (hList);
			return 0;
		case WM_COMMAND :
			if (HIWORD(lParam)==LBN_DBLCLK)
				{
				long lS=SendMessage(hList,LB_GETCURSEL,0,0);
				if (lS!=LB_ERR)
					{
					lS=SendMessage(hList,LB_GETITEMDATA,LOWORD(lS),0);
					PostMessage(mdi,WM_MDIACTIVATE,LOWORD(lS),0);
					if (options.wmode && options.wmode-1 & 2)
						SetWindowPos(mainw,HWND_TOP,0,0,0,0,SWP_NOMOVE | SWP_NOSIZE);
					} 
				}
			return 0;
		case WM_SETCURSOR :
			if (options.wmode && options.wmode-1&4 && window!=(hw=GetActiveWindow()))
				{
				SetActiveWindow(window);
				if (options.wmode-1 & 1) SetHeight();
				MoveWindow(window,rcSv.left,rcSv.top,rcSv.right-rcSv.left,
														rcSv.bottom-rcSv.top,TRUE);
				}
			break;
		case WM_SYSCOMMAND :
			if (wParam == IDM_GCOMP && options.gact == -1)
				GlobalCompact(dwGsiz);
			if (wParam == IDM_PKILL && options.pops>2)
				{
				options.pkill^=1;
				if (options.pkill) CheckMenuItem(hMenu,IDM_PKILL,MF_CHECKED);
				else CheckMenuItem(hMenu,IDM_PKILL,MF_UNCHECKED);
				return 0;
				}
			if (wParam != IDM_PAUSE) break;
		case WM_RBUTTONDOWN:
		case WM_NCRBUTTONDOWN:
			paused^=1;
			if (paused) {setmessage(4); CheckMenuItem(hMenu,IDM_PAUSE,MF_CHECKED);}
			else  {CheckMenuItem(hMenu,IDM_PAUSE,MF_UNCHECKED); depause=TRUE;}
			return 0;
		case WM_TIMER:
			DoOnTime();
			return 0;
		case MWM_OPWSTAT :
			return (options.vis + 8*(IsIconic(window)) + 16*normvis + 32*paused
				+ 64*(options.pops>2) + 128*options.pkill + 256*(options.gact == -1));
    	} 
	return DefWindowProc(hwnd, uMsg, wParam, lParam); 
	}

/*---------------------------------------------------------------------------------*/
int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
					LPSTR lpszCmdline, int nCmdShow)
	{
	unsigned int timer;
	MSG msg;
	HDC  hdc;
	HWND w;
	DWORD dwS;
	TEXTMETRIC tm;
	ATOM my_class;
	WNDCLASS myclass = {
		0,				// style
		OpWiCWndProc,	// window proc
		0,				// class extra bytes
		0,				// window extra bytes
		hInstance,		// hinstance
		LoadIcon(hInstance,"OPWIC"),// class icon
		LoadCursor(NULL, IDC_ARROW),// cursor
		(HBRUSH)(COLOR_WINDOW+1),	// background brush
		0,				// resource name of menu
		CLASSNAME
		};
	hInst = hInstance ;
	
	CfgRead();
	OptSet(lpszCmdline) ;

    dwS=options.minimize * WS_MINIMIZE | WS_OVERLAPPEDWINDOW | 
    	((options.vis>=2) ? 0 : WS_VISIBLE); // style
    if (w = FindWindow(CLASSNAME, 0))
    	{
		if (options.vis>2 && !(IsWindowVisible(w))) dwS|=WS_VISIBLE;
		if (NULL!=(hgPL=GlobalAlloc(GPTR | GMEM_SHARE, sizeof(nLfill)+sizeof(WL))))
			{
	    	SendMessage(w,MWM_REPLACE,0,hgPL);	// clobber previous instance
			if (NULL!=(hpt=GlobalLock(hgPL)))
				{
				hmemcpy(&nLfill,hpt,sizeof(nLfill));
				hmemcpy(&WL,hpt+sizeof(nLfill),sizeof(WL));
				GlobalUnlock(hgPL);
		    	if (nLfill) wasnone=FALSE;
				}
	    	GlobalFree(hgPL);
	    	}
		else SendMessage(w,WM_CLOSE,0,0);
		}
	normvis = dwS&WS_VISIBLE ? TRUE : FALSE;
	while (!(my_class = RegisterClass(&myclass)))
		{
		Yield ;
		if (IDCANCEL == MessageBox(0,
			"Can't register class!\n",
			TITLE,
			MB_ICONEXCLAMATION | MB_RETRYCANCEL))
			return 0;
		}
	if (options.full==5 || options.full==6) options.normw=options.normh=1000;
	options.wleft=MulDiv(GetSystemMetrics(SM_CXFULLSCREEN),options.wleft,1000);
	options.wid=MulDiv(GetSystemMetrics(SM_CXFULLSCREEN),options.wid,1000);
	cyMax=GetSystemMetrics(SM_CYFULLSCREEN);
	options.wtop=MulDiv(cyMax,options.wtop,1000);
	cyBorder=GetSystemMetrics(SM_CYBORDER);
	cyCaption=GetSystemMetrics(SM_CYCAPTION);
	cyHScroll=GetSystemMetrics(SM_CYHSCROLL);
	if (options.wmode&1) options.high=cyHScroll+cyCaption;
	else options.high=MulDiv(cyMax,options.high,1000);
	cyFrame=GetSystemMetrics(SM_CYFRAME);
	cxFrame=GetSystemMetrics(SM_CXFRAME);
	window = CreateWindowEx(
		(options.vis==1 || options.vis==4) ? 0 : WS_EX_TOPMOST,
		CLASSNAME,
		TITLE,
		dwS,			// style
		options.wleft,options.wtop,	// position
		options.wid,	// width
		options.list ? options.high+cyCaption : cyCaption,		// height
		0,				// parent
		0,				// menu
		hInstance,		// hinstance
		NULL			// lpParam
		);
	if (!window) 
		{
		MessageBox(0,"Can't create window!\n",TITLE,MB_ICONEXCLAMATION);
		return 0;
		}
	hList = CreateWindow(
		"LISTBOX",
		NULL,
		WS_CHILD | WS_HSCROLL | WS_VSCROLL | WS_VISIBLE | LBS_NOINTEGRALHEIGHT |
		((options.sort==1 || options.sort==4) ? LBS_SORT : 0),
		cxFrame, 0,
		options.wid-cxFrame,	// width
		options.list ? options.high-2*cyFrame : 1, // height
		window,
		1,
		hInst,
		NULL
		);
	if (!hList) options.list=0;
	else if (options.list)
		{
		lpfnOldList = (FARPROC) GetWindowLong (hList, GWL_WNDPROC) ;

		SetWindowLong (hList, GWL_WNDPROC,
		         (LONG) MakeProcInstance ((FARPROC) ListProc, hInst)) ;
		hdc=GetDC(hList);
		if (szFace[0]!='\0')
			{
			lf.lfHeight= -MulDiv(options.lFpt,GetDeviceCaps(hdc,LOGPIXELSY),72);
			lf.lfWeight=options.lFwt;
			lstrcpy(lf.lfFaceName, szFace);
			hfont = CreateFontIndirect(&lf);
			hfontold = SelectObject(hdc, hfont);
			}
		GetTextMetrics(hdc, &tm);
		ReleaseDC(hList,hdc);
		cyChar=tm.tmHeight+tm.tmExternalLeading;
		if (hfontold) PostMessage(hList,WM_SETFONT,hfont,0);
		}
	if (!(timer=SetTimer(window,555,options.time,NULL))) 
		{
		MessageBox(window,"Can't create timer!\n",TITLE,MB_ICONEXCLAMATION);
		PostQuitMessage(0);
		}

	if (options.ddetodo)
		{
		lstrcat(szDDE,"\",,");
		if (options.ddetodo&1) lstrcat(szDDE,"0x0,0x0,,,");
		else lstrcat(szDDE,"0xFFFFFFFF,0x0,,,");
		}

	hMenu = GetSystemMenu(window, FALSE);
	InsertMenu(hMenu,SC_CLOSE,MF_BYCOMMAND,IDM_PAUSE,"&Pause");
	if (options.pops>2)
		{
		InsertMenu(hMenu,SC_CLOSE,MF_BYCOMMAND | MF_CHECKED,IDM_PKILL,"&Kill Popups");
		options.pkill=1;
		}
	if (options.gact == -1)
		InsertMenu(hMenu,SC_CLOSE,MF_BYCOMMAND,IDM_GCOMP,"&GlobalCompact");
	InsertMenu(hMenu,SC_CLOSE,MF_SEPARATOR,0,"");
	lpfnEnum1 = MakeProcInstance ((FARPROC) OPMEnumProc, hInst) ;
	lpfnEnum2 = MakeProcInstance ((FARPROC) CntEnumProc, hInst) ;
	lpfnEnum3 = MakeProcInstance ((FARPROC) PLEnumProc, hInst) ;
	lpfnDdeCallback = MakeProcInstance ((FARPROC)DdeCallback, hInst) ;
	place.length=sizeof(place);

    while (GetMessage(&msg, (HWND) NULL, 0, 0)) 
    	{ 
        TranslateMessage(&msg); 
        DispatchMessage(&msg); 
    	} 

	KillTimer(window,timer);
	GetSystemMenu(window, TRUE);
	FreeProcInstance(lpfnDdeCallback);
	FreeProcInstance (lpfnEnum3);
	FreeProcInstance (lpfnEnum2);
	FreeProcInstance (lpfnEnum1);
	if (hfontold) {hdc=GetDC(hList);SelectObject(hdc, hfontold);
						DeleteObject(hfont); ReleaseDC(hList,hdc);}
	return msg.wParam ;
	}
/*---------------------------------------------------------------------------------*/
