// Note: This program must be compiled with WATCOM C/C++ 11.0
//       and linked with directive "SYSTEM NT"

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <direct.h>
#include <dos.h>

#ifdef __DOS_H
    #define __DOS16__
    #include <dir.h>
#else
    #include <windows.h>
    #include <winbase.h>
    #include <sys\utime.h>
#endif

#define MaxFName 4096
#define BufSize 32768
char CacheDir[MaxFName];
char OutDir[MaxFName];
char OutSubDir[] = "NSCXTR.OUT";
char nameURL[MaxFName + MaxFName];
unsigned char BufData[BufSize];

unsigned int i, j, uintv, quiet_mode = 0, verbose_mode = 0, w_o_prefixes = 0;
unsigned int NoCharsAbove0x7fInFNames = 0;
unsigned long ulngv, flensrc;

   struct utimbuf  utb;
//    FILETIME ft_lpCreationTime  ;
//    FILETIME ft_lpLastAccessTime;
//    FILETIME ft_lpLastWriteTime ;

unsigned char ToSmall[256]= {
/*00*/ 0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
/*10*/ 0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
/*20*/ 0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
/*30*/ 0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
/*40*/ 0x40,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
/*50*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x5B,0x5C,0x5D,0x5E,0x5F,
/*60*/ 0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
/*70*/ 0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
/*80*/ 0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,0x8F,
/*90*/ 0x90,0x91,0x92,0x93,0x94,0x95,0x96,0x97,0x98,0x99,0x9A,0x9B,0x9C,0x9D,0x9E,0x9F,
/*A0*/ 0xA0,0xA1,0xA2,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,
/*B0*/ 0xB0,0xB1,0xB2,0xB3,0xB4,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0xBB,0xBC,0xBD,0xBE,0xBF,
/*C0*/ 0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,
/*D0*/ 0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF,
/*E0*/ 0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,
/*F0*/ 0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xFF
};

void logoAndVersion(void) {
    printf("\n\  NSCXTR: VIT(R) NetScape Cache eXTRactor\n\
  Version 1.2  Copyright (C) VIV 23.02.1999\n\n");
}

void usage(void) {
    logoAndVersion();
    printf("\
  Usage: NSCXTR [switches] CacheDir\n\
  switches:\n\
    -n        disable non-ASCII chars (>0x7f) in filenames (default enable)\n\
    -oOutDir  set output DIR (default is \"NSCXTR.OUT\")\n\
    -p        skip known URL prefixes\n\
    -q        quiet mode output\n\
    -v        verbose output\n\
\n");
    exit(0);
}

void pause(void) {
    #define Esc 0x001B
    unsigned int pausekey = 0;
    fprintf(stderr, "press any key to continue, ESC to exit...");

    while(!pausekey) {
        if(kbhit()) { /* ᬮਬ,    ESCAPE */
            if((pausekey = getch()) == 0)  pausekey = getch() << 8;
            if(pausekey == 0x001B) {
                printf("\n*** Exiting by ESCAPE ***\n");
                exit(255);
            }
        }
    }
    fprintf(stderr, "\r                                         \r");
}

void ChkBackSlInPath(char *DirPath) {
    while(*DirPath != 0) DirPath++;
    if(*--DirPath != '\\') {
        *++DirPath = '\\';
        *++DirPath = 0;
    }
}

TCHAR* StringToLocal(const char *s) {
    static TCHAR LclPth[MaxFName];
    //AnsiToOem(szDirName, szDirName); - in win31
    //if(!CharToOem((CHAR*)s, LclPth)) {
    //    printf("Can't CharToOem(path_string): '%s'\n", s);
    //    pause();
    //};

    // converting string from "DOS text" layout to windows (?):
    if(!OemToChar((CHAR*)s, LclPth)) {
        printf("Can't CharToOem(path_string): '%s'\n", s);
        pause();
    };
    return LclPth;
}

int mk_dir(const char *path) {
    return mkdir(StringToLocal(path));
}

int ch_dir(const char *path) {
    return chdir(StringToLocal(path));
}

FILE *f_open(const char *filename, const char *mode) {
    return fopen(StringToLocal(filename), mode);
}

void copy(FILE *hndlin, FILE *hndlout, char *out, unsigned long len) {
    unsigned long cpy = BufSize;
    unsigned long cur = 0;
    /* copying current InFile to current pointer in OutFile */
    /* copying by portions len = BufSize: */
    for(;;) {
        if(cur == len) return;  /* copy only if needs copy len>0 */
        /* copying last part (len < BufSize): */
        if(cur + BufSize > len) cpy = len - cur;
        for(i = 0; i <= BufSize; ) BufData[i++] = 0x00; /* clear buffer */
        fread(BufData, cpy, 1, hndlin);
        if(!fwrite(BufData, cpy, 1, hndlout)) {
            printf("Error writing file: %s (may be disk full)\n",out);
            exit(-2);
        }
        cur += cpy;
    }
}

int ReadSearchNext(unsigned char b[], FILE *hndlfat) {
    int ret;
    int ctr = 0;
    int ptrInFile = 0;
    unsigned long long0;
    unsigned long long1;

    if(fread(&b[0x00], 8, 1, hndlfat) == NULL) return(0);
//    long0 = *(unsigned long *)&b[0x00];
//    long1 = *(unsigned long *)&b[0x04];
//    // check for unknown data:
//    if(long0 > 0x100 && long1 > 0x100) {
//         long0 = *(unsigned short *)&b[0x00];
//         if(long0 < 0x1000) {
//             // skip unknown data:
//             //printf(">>> Skip 0xE8 bytes at 0x%lX\n", long0 * 0xf, ftell(hndlfat) - 8);
//             //if(fread(&b[0x08], long0 * 0xf - 8, 1, hndlfat) == NULL) return(0);
//             if(fread(&b[0x08], 0xE8 - 0x08, 1, hndlfat) == NULL) return(0);
//             if(fread(&b[0x00], 8, 1, hndlfat) == NULL) return(0);
//         }
//    }
    for(; ; ctr++) {
        if(ctr) {
            //if(ctr == 1) printf(">>> Searching from 0x%lX\n", ftell(hndlfat) - 8);
            b[0x00] = b[0x01];
            b[0x01] = b[0x02];
            b[0x02] = b[0x03];
            b[0x03] = b[0x04];
            b[0x04] = b[0x05];
            b[0x05] = b[0x06];
            b[0x06] = b[0x07];
            if(fread(&b[0x07], 1, 1, hndlfat) == NULL) return(0);
        }
        long0 = *(unsigned long *)&b[0x00];
        long1 = *(unsigned long *)&b[0x04];
        if(long0 > 0x800 || long0 < 4) continue;
        if(long1 > 0x100 || long1 < 1) continue;
        ptrInFile = ftell(hndlfat);
        //printf("AtTmp = %lX\n", ptrInFile - 8);

        if(fread(&b[0x08], long0, 1, hndlfat) == NULL) ret = 0;
        else                                           ret = 1;
        if(
          *(unsigned long *)&b[long0 - 0x04] != 0    ||
          *(unsigned long *)&b[long0       ] > 0x400 ||
          *(unsigned long *)&b[long0       ] < 4     ||
          *(unsigned long *)&b[long0 + 0x04] > 0x100 ||
          *(unsigned long *)&b[long0 + 0x04] < 1     ||
          *(unsigned long *)&b[long0 + 0x04] == 5    ||
          b[0x21] > 0x80 || b[0x21] < 0x20           ||
          b[0x22] > 0x80 || b[0x22] < 0x20           ||
          b[0x23] > 0x80 || b[0x23] < 0x20           ||
          b[0x24] > 0x80 || b[0x24] < 0x20           ||
          b[0x25] > 0x80 || b[0x25] < 0x20           ||
          b[0x26] > 0x80 || b[0x26] < 0x20           ||
          b[0x27] > 0x80 || b[0x27] < 0x20           ||
          b[0x28] > 0x80 || b[0x28] < 0x20
          ) {
            //printf(" 0x04 = %lX\n", *(unsigned long *)&b[long0 + 0x04]);
            //printf(" 0x08 = %lX\n", *(unsigned long *)&b[long0 + 0x08]);
            //printf(" 0x0C = %lX\n", *(unsigned long *)&b[long0 + 0x0C]);
            fseek(hndlfat, ptrInFile, SEEK_SET);
            continue;
        }
        long1 = *(unsigned long *)&b[long0];
        if(fread(&b[long0 + 0x08], long1 - 8, 1, hndlfat) == NULL) return(0);
        if(
          b[long0 + long1 - 0x01] != 0x00 ||
          b[long0 + long1 - 0x02] != 0x00 ||
          b[long0 + long1 - 0x03] != 0x00 ||
          b[long0 + long1 - 0x04] != 0x00 ||
          b[long0 + long1 - 0x05] != 0x00
          ) {
            //printf(" 0x01 = %lX\n", *(unsigned long *)&b[long0 + long1 - 0x01]);
            //printf(" 0x02 = %lX\n", *(unsigned long *)&b[long0 + long1 - 0x02]);
            //printf(" 0x03 = %lX\n", *(unsigned long *)&b[long0 + long1 - 0x03]);
            //printf(" 0x04 = %lX\n", *(unsigned long *)&b[long0 + long1 - 0x04]);
            //printf(" 0x05 = %lX\n", *(unsigned long *)&b[long0 + long1 - 0x05]);
            fseek(hndlfat, ptrInFile, SEEK_SET);
            continue;
        }
        for(long1 -= 0x06; b[long0 + long1] != 0x00; long1--) {
            if(long1 == 8) return(ret); // if all OK (URL string w/o "\0")
        }
        fseek(hndlfat, ptrInFile, SEEK_SET);
        continue;
    }
    //return(ret);
}

int compare(FILE *hndl1, FILE *hndl2) {
    unsigned char c1 = 0, c2 = 0;
    unsigned long len1, len2;
    fseek(hndl1, 0L, SEEK_END);
    fseek(hndl1, 0L, SEEK_SET);
    len1 = ftell(hndl1);
    fseek(hndl2, 0L, SEEK_END);
    fseek(hndl2, 0L, SEEK_SET);
    len2 = ftell(hndl2);
    if(len2 != len1) return(1);
    while(len2--) {
        if(fread(&c1, 1, 1, hndl1) == NULL) return(1);
        if(fread(&c2, 1, 1, hndl2) == NULL) return(1);
        if(c1 != c2) return(1);
    }
    return(0);
}

void ckForFileBeforemk_dir(char *buf) {
    FILE *hndltmp = NULL;
    char buf_[MaxFName];
    if((hndltmp = f_open(buf, "rb")) != NULL) {
        if(verbose_mode) printf("Warning: to mk_dir('%s') renaming existent file to *_ and mk_dir.\n", buf);
        fclose(hndltmp);
        sprintf(buf_, "%s_", buf);
        rename(buf, buf_);
    } else {
        fclose(hndltmp);
    }
}

void copyFile2File(char *inpName, char *outName, unsigned long hdr0time0, unsigned long hdr0time1) {
    FILE *hndlsrc = NULL, *hndlout = NULL;
    unsigned long len;
    char buf[MaxFName];
    int i1 = 0;
    int i0 = 0;
    char c;

    if((hndlsrc = f_open(inpName, "rb")) == NULL) {
        if(verbose_mode) printf("Can't open for read file: '%s' - skip\n", inpName);
        fclose(hndlsrc);
        return;
    } else {
        if(!quiet_mode) printf("URL=%s\n", outName);
    }

    i0 = 0;
    if(
      ToSmall[outName[0]] == 'h' &&
      ToSmall[outName[1]] == 't' &&
      ToSmall[outName[2]] == 't' &&
      ToSmall[outName[3]] == 'p' &&
      ToSmall[outName[4]] == ':' &&
      ToSmall[outName[5]] == '/' &&
      ToSmall[outName[6]] == '/'
      ) {
        if(w_o_prefixes) i0 = 7;
    } else if(
      ToSmall[outName[0]] == 'f' &&
      ToSmall[outName[1]] == 't' &&
      ToSmall[outName[2]] == 'p' &&
      ToSmall[outName[3]] == ':' &&
      ToSmall[outName[4]] == '/' &&
      ToSmall[outName[5]] == '/'
      ) {
        if(w_o_prefixes) i0 = 6;
    } else if(
      ToSmall[outName[0]] == 'w' &&
      ToSmall[outName[1]] == 'y' &&
      ToSmall[outName[2]] == 's' &&
      ToSmall[outName[3]] == 'i' &&
      ToSmall[outName[4]] == 'w' &&
      ToSmall[outName[5]] == 'y' &&
      ToSmall[outName[6]] == 'g' &&
      ToSmall[outName[7]] == ':' &&
      ToSmall[outName[8]] == '/' &&
      ToSmall[outName[9]] == '/'
      ) {
        if(w_o_prefixes) i0 = 10;
    } else {
        printf(" Unknown URL prifix: '%s'\n", outName);
        pause();
    }

    for(i1 = i0, i0 = 0; (c = outName[i1]) != 0; i1++, i0++) {
        buf[i0] = c;
        if(c == '/' || c == '\\') {
            buf[i0] = 0;
            ckForFileBeforemk_dir(buf);
            mk_dir(buf);
            buf[i0] = '\\';
        }
        if((c <  ' ' && c >= 0) ||
           (c <  0 && NoCharsAbove0x7fInFNames) ||
           c == '<' ||
           c == '>' ||
           c == '?' ||
           c == '|' ||
           c == '*' ||
           c == ':') {
            if(verbose_mode) printf(" Renaming char: '%c' to '%%%02x' in '%s'\n", c, c, outName);
            sprintf(&buf[i0], "%%%02x", c&0xff);
            i0++; i0++;
        }
    }
    if(buf[i0 - 1] == '\\') { // if text/html w/o fname: "www.textuality.com\"
        sprintf(&buf[i0], "index.htm");
        i0 += 9;
    }
    buf[i0] = 0;

    if((hndlout = f_open(buf, "rb")) != NULL) {
        if(!compare(hndlsrc, hndlout)) {
            if(verbose_mode) printf(" File '%s' is the same as saved.\n", buf);
            fclose(hndlsrc);
            fclose(hndlout);
            return; // if saved file the same
        }
        printf("Already exist file: '%s'\n", buf);
        len = 0;
        for(; ; len++) {
            fclose(hndlout);
            sprintf(&buf[i0], ".Over%04lX", len);
            if((hndlout = f_open(buf, "rb")) == NULL) break;
            if(!compare(hndlsrc, hndlout)) {
                if(verbose_mode) printf(" File '%s' is the same as saved.\n", buf);
                fclose(hndlsrc);
                fclose(hndlout);
                return; // if saved file the same
            }
        }
        printf("      => saving as: '%s'\n", buf);
        pause();
    }
    fclose(hndlout);

    if((hndlout = f_open(buf, "wb")) == NULL) {
        printf("Can't create file: '%s' - skip\n", buf);
        fclose(hndlout);
        pause();
        return;
    }
    fseek(hndlsrc, 0L, SEEK_END);
    len = ftell(hndlsrc);
    fseek(hndlsrc, 0, SEEK_SET);
    copy(hndlsrc, hndlout, outName, len);


//    ft_lpCreationTime.dwLowDateTime  = hdr0time0;
//    ft_lpCreationTime.dwHighDateTime = hdr0time1;
//    ft_lpLastAccessTime.dwLowDateTime  = hdr0time0;
//    ft_lpLastAccessTime.dwHighDateTime = hdr0time1;
//    ft_lpLastWriteTime.dwLowDateTime  = hdr0time0;
//    ft_lpLastWriteTime.dwHighDateTime = hdr0time1;

//    fclose(hndlout);
//    if(hdr0time0 != 0) hdr0time1 = hdr0time0;
//    // ⠭   ६ ᮧ:
//    if((hndlout = f_open(buf, "rb")) == NULL) {
//        printf("open %s for read to setTimeDate failed\n", buf);
//        pause();
//    }
//    uintv = fileno(hndlout);
//    if(_dos_setftime(uintv, (unsigned short)(hdr0time1 >> 16), (unsigned short)hdr0time1)) {
//        printf("ERROR set date and time %X,%X for fileno=%d file: '%s'", (unsigned short)(hdr0time1 >> 16), (unsigned short)hdr0time1, uintv, buf);
//        pause();
//    }
    fclose(hndlout);
    fclose(hndlsrc);
    // fstat, stat - ansi functions for set ftime , fctl (fcntl), utime.h.
    if(verbose_mode) printf("ModificationTime=0x%X, LastAccessTime=0x%X\n", hdr0time0, hdr0time1);
    if(hdr0time0 == 0) hdr0time0 = hdr0time1; // if saved modtime == 0
    utb.actime  = hdr0time1; // .actime - not used.
    utb.modtime = hdr0time0; // .modtime - "Modification" & "Last access"
    utime(buf, &utb); // Set ceation/modification date & time.
}

void Process(FILE *hndlfat, int CacheDirPtr) {
    unsigned long CurN = 0;
    unsigned long hdr0len;
    unsigned long hdr0type;
    unsigned long hdr0time0; // [0x08] - creation (may be 0)
    unsigned long hdr0time1; // [0x0C]
    unsigned long hdr1len;
    unsigned long hdr1type;
    while(ReadSearchNext(BufData, hndlfat)) {
        CurN++;
        hdr0len = *(unsigned long *)&BufData[0x00];
        hdr0type = *(unsigned long *)&BufData[0x04];
        hdr0time0 = *(unsigned long *)&BufData[0x08];
        hdr0time1 = *(unsigned long *)&BufData[0x0C];
        strcpy((char *)&CacheDir[CacheDirPtr], (char *)&BufData[0x21]);
        if(verbose_mode) printf("%4ld =======================================================================\n", CurN);
        //if(verbose_mode) printf("ParamsAt=0x%lX, ", (unsigned long)ftell(hndlfat) - hdr0len - 8);
        //if(verbose_mode) printf("UrlAt=0x%lX, ", (unsigned long)ftell(hndlfat));
        if(verbose_mode) printf("Type=0x%lX, ", hdr0type);
        if(verbose_mode) printf("File=%s\n", (char *)&BufData[0x21]);
        //if(verbose_mode) printf("URL=%s\n", (char *)&BufData[hdr0len + 8]);
        strcpy(nameURL, (char *)&BufData[hdr0len + 8]);
        hdr1len = *(unsigned long *)&BufData[hdr0len];
        hdr1type = *(unsigned long *)&BufData[hdr0len + 4];
        if(verbose_mode) printf("TypeURL=0x%lX, ", hdr1type);
        if(verbose_mode) printf("LenURL=0x%lX\n", hdr1len);
        if(verbose_mode) printf("URL=%s\n", nameURL);
        copyFile2File(CacheDir, nameURL, hdr0time0, hdr0time1);
    }
}

void getarg(int argc, char *argv[]) {
    while(--argc > 0) {
        argv++;
        if(((*argv)[0] == '-') || ((*argv)[0] == '/')) {/*if switch in cmdln */
            switch((*argv)[1]) {
                case 'o':
                case 'O':
                    strcpy(OutSubDir, &(*argv)[2]);
                    break;
                case 'p':
                case 'P':
                    w_o_prefixes = 1; // w/o known URL prefixes
                    break;
                case 'q':
                case 'Q':
                    quiet_mode = 1; // be quiet
                    break;
                case 'v':
                case 'V':
                    verbose_mode = 1;
                    break;
                case 'n':
                case 'N':
                    NoCharsAbove0x7fInFNames = 1; // default is 0
                    break;
//                case '1':
//                    OutSubDir[0] = 0;
//                    break;
                default:
                    usage();
            }
        } else {
            strcpy((char *)CacheDir, *argv); /* DirName from cmdln */
            continue;
        }
    }
    if(!CacheDir[0]) usage(); // strcpy((char *)CacheDir, "."); // default DirName
}

void main(int argc, char *argv[]) {
    unsigned int CacheDirPtr;
    FILE *hndlfat = NULL;

    getarg(argc, argv);
    if(!quiet_mode) logoAndVersion();
    ChkBackSlInPath(CacheDir);
    getcwd(OutDir, MaxFName);
    ChkBackSlInPath(OutDir);
    for(CacheDirPtr = 0; CacheDir[CacheDirPtr] != 0; CacheDirPtr++) ;

    if(!quiet_mode) printf("Using NetScape Cache dir: \"%s\"\n", CacheDir);
    if(!quiet_mode) printf("Using output dir: \"%s\"\n", OutDir);
    pause();

    strcpy((char *)&CacheDir[CacheDirPtr], "fat.db");
    if((hndlfat=f_open((char *)CacheDir, "rb")) == NULL)
        {printf("Can't open for read file: '%s'\n", CacheDir); exit(-1);}
    fseek(hndlfat, 0x1000, SEEK_SET);

    if(mk_dir(OutSubDir)) {printf("ERROR: can't create DIR '%s' - skipping.\n", OutSubDir); pause(); }
    if(ch_dir(OutSubDir)) {printf("ERROR: can't change DIR '%s' - skipping.\n", OutSubDir); pause(); }

    Process(hndlfat, CacheDirPtr);

    if(chdir("..")) {printf("ERROR: can't change DIR '..'\n"); pause(); }

    if(!quiet_mode) printf("\n\NSCXTR: work completed.\n");
}
