////////////////////////////////////////////////////////////////////////////////
// MODTIME.CPP  by Gregory Kwok <gkwok@jps.net>
// Calculates transfer times at various rates (300bps - 128k ISDN)
// v1.0   24 Sep 1997   First version
// v1.1   25 Sep 1997   Increased maximum size from 200MB to 2000MB
// v1.1   26 Nov 1997   Recompiled with DJGPP 32-bit compiler
////////////////////////////////////////////////////////////////////////////////

// Include files
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Function prototypes
long calcBytes(const char* );
int printSpeed(long , long );

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
int main(int argc, char* argv[])
{
  // Modify this to calculate other rates
  const long Rates[] = { 300, 2400, 9600, 14400, 28800, 33600,
                         40000, 44000, 56000, 64000, 128000 };
  const NumRates = sizeof(Rates) / sizeof(Rates[0]);       // Don't change
  const long MaxMB = 2000;

  long bytes;

  // No arguments give, print usage
  if (argc == 1) {
    puts("\nMODTIME v1.1 \xfe by Gregory Kwok <gkwok@jps.net>\n"
         "  Usage:  modtime [bytes]\n\n"
         "Appending 'K' or 'M' after the number specifies\n"
         "Kilobytes or Megabytes, respectively.");
    return 1;
  }

  bytes = calcBytes(argv[1]);

  // Values > 2000MB cause long ints to overflow when calculating
  if (bytes > MaxMB * 1024L * 1024L || bytes < 0) {
    printf("\nError: cannot calculate values > %ldMB\n"
           "(exactly what are you trying to download?)\n", MaxMB);
    return 2;
  }

  printf("\n  Total bytes:  %ld\n"
         "  Speed (bps)  %6s%8s%8s\n",
         bytes, "Hours", "Minutes", "Seconds");

  // Calculate transfer times for all rates
  for (int i = 0; i < NumRates; i++)
    printSpeed(Rates[i], bytes);

  return 0;
}

////////////////////////////////////////////////////////////////////////////////
// Converts a string ("123", "56K", "42M") to the number of bytes
////////////////////////////////////////////////////////////////////////////////
long calcBytes(const char* str)
{
  long val = 1;
 
  switch (toupper(str[strlen(str) - 1])) {
  case 'M': val *= 1024;
  case 'K': val *= 1024;
  }

  val *= atol(str);
  return val;
}

////////////////////////////////////////////////////////////////////////////////
// Prints H/M/S times for given rate and bytesize
////////////////////////////////////////////////////////////////////////////////
int printSpeed(long bps, long size)
{
  long seconds = (long)((float)(size) / bps * 10.0);
  printf("  %8ld   %6ld%8ld%8ld\n",
         bps,
         (long)((seconds / 60) / 60),
         (long)((seconds / 60) % 60),
         (long)(seconds % 60));
  return bps;
}
